/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.jndi;

import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.jndi.NdJndiEntryRepositoryException;
import com.blazesoft.repository.jndi.NdJndiRepositoryDirectory;
import com.blazesoft.repository.jndi.NdJndiRepositoryEntry;
import com.blazesoft.repository.jndi.NdJndiRepositoryItemData;
import com.blazesoft.repository.jndi.NdStrings;
import com.blazesoft.repository.naming.NdLocation;
import java.text.DateFormat;
import java.util.Date;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;

public class NdJndiRepositoryItem
extends NdJndiRepositoryEntry
implements NdRepositoryItem {
    private static final String WjHzDkR = "innovatorItemContent";
    private static final String WjHAywH = "innovatorLastModified";
    private static final String[] WjHzDlS = new String[]{"innovatorItemContent"};
    private static final String[] WjHAyxI = new String[]{"innovatorItemContent", "innovatorLastModified"};
    private static final String[] WjHAyyJ = new String[]{"innovatorLastModified"};

    NdJndiRepositoryItem(NdJndiRepositoryDirectory ndJndiRepositoryDirectory, NdLocation ndLocation, Object object) {
        super(ndJndiRepositoryDirectory, ndLocation, object);
    }

    public NdRepositoryItemContent getContent() throws NdRepositoryException {
        String string = "";
        try {
            if (this.WjIagGV().getRepositoryType().equals("attribute-based")) {
                Attributes attributes = ((DirContext)this.getRepDirContext()).getAttributes(this.getRepName(), WjHzDlS);
                if (attributes == null) {
                    throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotFindContentAttribute", this.getName()), this);
                }
                string = (String)attributes.get(WjHzDkR).get();
            } else if (this.WjIagGV().getRepositoryType().equals("referenceable-based")) {
                string = ((NdJndiRepositoryItemData)this.getRepEntry()).getItemContent();
            }
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotReadContent", this.getName()), this, (Throwable)exception);
        }
        return new NdRepositoryItemContent(string);
    }

    public void setContent(NdRepositoryItemContent ndRepositoryItemContent) throws NdRepositoryException {
        Object object;
        try {
            this.checkWriteMode();
            if (this.WjIagGV().getRepositoryType().equals("attribute-based")) {
                object = ((DirContext)this.getRepDirContext()).getAttributes(this.getRepName(), WjHAyxI);
                if (object == null) {
                    throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotFindContentAttribute", this.getName()), this);
                }
                object.remove(WjHzDkR);
                object.put(WjHzDkR, ndRepositoryItemContent.getData());
                object.remove(WjHAywH);
                object.put(WjHAywH, DateFormat.getInstance().format(new Date()));
                ((DirContext)this.getRepDirContext()).modifyAttributes(this.getRepName(), 2, (Attributes)object);
            } else if (this.WjIagGV().getRepositoryType().equals("referenceable-based")) {
                ((NdJndiRepositoryItemData)this.getRepEntry()).setItemContent(ndRepositoryItemContent.getData());
                object = this.WjIagGV().getRepositoryEntryFactory().getObjectReference(this.getRepName(), this.getRepDirContext(), this.getRepEntry());
                this.getRepDirContext().rebind(this.getRepName(), object);
            }
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdJndiEntryRepositoryException(NdStrings.WjHzGqJ("CouldNotWriteContent", this.getName()), this, (Throwable)exception);
        }
        object = this.WjIagGV().WjIaedP();
        if (object != null && ((String)object).length() > 0) {
            NdRepositoryEntryAttribute ndRepositoryEntryAttribute = new NdRepositoryEntryAttribute("innovatorLastModifiedUser", (String)object);
            NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = new NdRepositoryEntryAttribute[]{ndRepositoryEntryAttribute};
            this.getContainerDirectory().setRepositoryEntryAttributes(this, ndRepositoryEntryAttributeArray);
        }
    }

    public Date getLastModified() throws NdRepositoryException {
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = NdRepositorySupport.getRepositoryEntryAttributes(this, WjHAyyJ);
        String string = ndRepositoryEntryAttributeArray[0].getAttbValue();
        try {
            return DateFormat.getInstance().parse(string);
        }
        catch (Exception exception) {
            throw new NdRepositoryException(NdStrings.WjHzGqJ("IllegalFormatOfLastModifiedDate", string));
        }
    }

    public void setLastModified(Date date) throws NdRepositoryException {
        try {
            Attributes attributes = ((DirContext)this.getRepDirContext()).getAttributes(this.getRepName(), WjHAyyJ);
            attributes.remove(WjHAywH);
            attributes.put(WjHAywH, DateFormat.getInstance().format(date));
            ((DirContext)this.getRepDirContext()).modifyAttributes(this.getRepName(), 2, attributes);
        }
        catch (NamingException namingException) {
            throw new NdRepositoryException(namingException);
        }
    }

    public boolean isReadable() throws NdRepositoryException {
        return true;
    }

    public boolean isWritable() throws NdRepositoryException {
        return true;
    }
}

