/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.local;

import com.blazesoft.repository.base.NdDefaultRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryExplicitLockManager;
import com.blazesoft.repository.base.NdRepositoryImplicitLock;
import com.blazesoft.repository.base.NdRepositoryImplicitLockManager;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.base.NdRepositoryItemContentReadAuthorizationRequest;
import com.blazesoft.repository.base.NdRepositoryItemContentWriteAuthorizationRequest;
import com.blazesoft.repository.base.NdRepositoryRuntimeException;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdRepositoryVersionHistory;
import com.blazesoft.repository.base.NdRepositoryVersionLabel;
import com.blazesoft.repository.base.NdRepositoryVersionResultSet;
import com.blazesoft.repository.base.NdVersioningRepositoryConnection;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.base.NdWorkspaceDirectory;
import com.blazesoft.repository.base.NdWorkspaceEntry;
import com.blazesoft.repository.base.NdWorkspaceEntryIsDetachedException;
import com.blazesoft.repository.base.NdWorkspaceEvent;
import com.blazesoft.repository.base.NdWorkspaceVersionManager;
import com.blazesoft.repository.config.NdRepositoryVersionManagerConfig;
import com.blazesoft.repository.local.NdAbstractWorkspaceDirectory;
import com.blazesoft.repository.local.NdLocalRepository;
import com.blazesoft.repository.local.NdLocalRepositoryEntryException;
import com.blazesoft.repository.local.NdStrings;
import com.blazesoft.repository.local.NdWorkspaceSupport;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.security.NdSecurityConfig;
import com.blazesoft.util.NdBase64;
import com.blazesoft.util.NdBaseObject;

public abstract class NdAbstractWorkspaceEntry
implements NdWorkspaceEntry {
    static final NdRepositoryItemContent WjIvbTD = new NdRepositoryItemContent("");
    private NdWorkspaceDirectory WjImvMJ;
    private NdRepositoryEntry WjImvNK;
    private boolean WjIqgEH;
    private Boolean WjIDCHK;
    private NdLocation WjIthiY;
    private boolean WjIvbUE;
    private Boolean WjIAczB;

    NdAbstractWorkspaceEntry(NdRepositoryEntry ndRepositoryEntry) {
        this(ndRepositoryEntry, false);
    }

    NdAbstractWorkspaceEntry(NdRepositoryEntry ndRepositoryEntry, boolean bl) {
        this.WjImvNK = ndRepositoryEntry;
        this.WjIrInW(bl);
        this.WjIvbWG(true);
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean isMarkedForDeletion() {
        return this.WjIqgEH;
    }

    public boolean isMarkedForAddition() throws NdRepositoryException {
        if (this.WjIDCHK == null) {
            NdAbstractWorkspaceDirectory ndAbstractWorkspaceDirectory = (NdAbstractWorkspaceDirectory)this.getContainerDirectory();
            NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = ndAbstractWorkspaceDirectory.getRepositoryEntryAttributes(this);
            this.WjIDCHK = Boolean.FALSE;
            for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
                if (!"com.blazesoft.repository.local.locallycreated".equals(ndRepositoryEntryAttributeArray[i].getAttbId())) continue;
                this.WjIAZjB(new Boolean(ndRepositoryEntryAttributeArray[i].getAttbValue()));
                break;
            }
        }
        return this.WjIDCHK == Boolean.TRUE;
    }

    public boolean isProtected() throws NdRepositoryException {
        if (this.WjIAczB == null) {
            NdAbstractWorkspaceDirectory ndAbstractWorkspaceDirectory = (NdAbstractWorkspaceDirectory)this.getContainerDirectory();
            NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = ndAbstractWorkspaceDirectory.getRepositoryEntryAttributes(this);
            this.WjIAczB = Boolean.FALSE;
            for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
                if (!"com.blazesoft.repository.security.protected".equals(ndRepositoryEntryAttributeArray[i].getAttbId())) continue;
                this.WjIAczB = Boolean.valueOf(ndRepositoryEntryAttributeArray[i].getAttbValue());
                break;
            }
        }
        return this.WjIAczB == Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProtected(boolean bl) throws NdRepositoryException {
        this.ensureNotDetached();
        if (bl != this.isProtected()) {
            if (this.WjIAcCE() == null) {
                throw new NdRepositoryException(NdStrings.WjIejXR("NoSecurityConfig", this.getLocation()));
            }
            NdAbstractWorkspaceEntry ndAbstractWorkspaceEntry = (NdAbstractWorkspaceEntry)((Object)this.WjIqgGJ());
            NdLocation ndLocation = this.getLocation();
            ndAbstractWorkspaceEntry.WjIAKqD(ndLocation);
            try {
                this.WjIAcAC(bl);
            }
            finally {
                ndAbstractWorkspaceEntry.WjIAKqE(ndLocation);
            }
        }
    }

    void WjIAcAC(boolean bl) throws NdRepositoryException {
        String string = bl ? "true" : null;
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = new NdRepositoryEntryAttribute[]{new NdRepositoryEntryAttribute("com.blazesoft.repository.security.protected", string)};
        NdRepositoryDirectory ndRepositoryDirectory = this.getContainerDirectory();
        try {
            ndRepositoryDirectory.setRepositoryEntryAttributes(this, ndRepositoryEntryAttributeArray);
            this.WjIAczB = bl ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (NdRepositoryException ndRepositoryException) {
            this.WjIAcBD();
            throw ndRepositoryException;
        }
    }

    void WjIAKqD(NdLocation ndLocation) {
        throw new NdRepositoryRuntimeException(NdStrings.WjIejVP("NotImplemented"));
    }

    void WjIAKqE(NdLocation ndLocation) {
        throw new NdRepositoryRuntimeException(NdStrings.WjIejVP("NotImplemented"));
    }

    public boolean isChangeProtectionLocation(NdLocation ndLocation) {
        throw new NdRepositoryRuntimeException(NdStrings.WjIejVP("NotImplemented"));
    }

    void WjIAcBD() {
        this.WjIAczB = null;
    }

    void WjIDCIL() {
        this.WjIDCHK = null;
    }

    public void reset() {
        this.WjIAcBD();
        this.WjIDCIL();
    }

    void WjIrInW(boolean bl) {
        this.WjIqgEH = bl;
    }

    void WjIAZjB(boolean bl) {
        this.WjIDCHK = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    void WjIrIoX(NdRepositoryEntry ndRepositoryEntry) {
        this.WjImvNK = ndRepositoryEntry;
        this.reset();
    }

    boolean WjIvbVF() {
        return this.WjIvbUE;
    }

    void WjIvbWG(boolean bl) {
        this.WjIvbUE = bl;
    }

    public void ensureNotDetached() throws NdWorkspaceEntryIsDetachedException {
        if (this.WjIvbVF()) {
            throw new NdWorkspaceEntryIsDetachedException(this);
        }
    }

    NdWorkspace WjIqgGJ() {
        return ((NdAbstractWorkspaceEntry)((Object)this.WjImvMJ)).WjIqgGJ();
    }

    public NdRepositoryEntry getPhysicalRepositoryEntry() {
        return this.WjImvNK;
    }

    public NdRepositoryDirectory getContainerDirectory() {
        return this.WjImvMJ;
    }

    public void setContainerDirectory(NdWorkspaceDirectory ndWorkspaceDirectory) {
        this.WjImvMJ = ndWorkspaceDirectory;
        this.WjIvbWG(ndWorkspaceDirectory == null);
    }

    public NdLocation getLocation() throws NdRepositoryException {
        if (this.WjIthiY == null) {
            this.WjIthiY = NdRepositorySupport.getLocation(this);
        }
        return this.WjIthiY;
    }

    public Object getPhysicalDescription() {
        return this.getPhysicalRepositoryEntry().getPhysicalDescription();
    }

    public void lock() throws NdRepositoryException {
        this.ensureNotDetached();
        if (this.WjIqgEH) {
            return;
        }
        NdWorkspace ndWorkspace = NdRepositorySupport.getWorkspace(this);
        NdRepositoryExplicitLockManager ndRepositoryExplicitLockManager = ndWorkspace.getExplicitLockManager();
        if (ndRepositoryExplicitLockManager == null) {
            throw new NdLocalRepositoryEntryException(NdStrings.WjIejXR("NoLockNullExplicitLockManager", this.getName()), this);
        }
        ndRepositoryExplicitLockManager.lockEntry(this);
    }

    public void unlock() throws NdRepositoryException {
        this.ensureNotDetached();
        if (this.WjIqgEH) {
            return;
        }
        NdWorkspace ndWorkspace = NdRepositorySupport.getWorkspace(this);
        NdRepositoryExplicitLockManager ndRepositoryExplicitLockManager = ndWorkspace.getExplicitLockManager();
        if (ndRepositoryExplicitLockManager == null) {
            throw new NdLocalRepositoryEntryException(NdStrings.WjIejXR("NoUnlockNullExplicitLockManager", this.getName()), this);
        }
        ndRepositoryExplicitLockManager.unlockEntry(this);
    }

    NdRepositoryImplicitLock WjImvPM(NdWorkspaceEntry ndWorkspaceEntry) throws NdRepositoryException {
        if (ndWorkspaceEntry.isMarkedForDeletion()) {
            return null;
        }
        NdRepositoryEntry ndRepositoryEntry = ndWorkspaceEntry.getPhysicalRepositoryEntry();
        NdWorkspace ndWorkspace = NdRepositorySupport.getWorkspace(this);
        NdRepositoryImplicitLockManager ndRepositoryImplicitLockManager = ndWorkspace.getImplicitLockManager();
        return ndRepositoryImplicitLockManager != null ? ndRepositoryImplicitLockManager.acquireLock(ndRepositoryEntry) : null;
    }

    void WjImvQN(NdRepositoryImplicitLock ndRepositoryImplicitLock) throws NdRepositoryException {
        NdWorkspace ndWorkspace;
        NdRepositoryImplicitLockManager ndRepositoryImplicitLockManager;
        if (ndRepositoryImplicitLock != null && (ndRepositoryImplicitLockManager = (ndWorkspace = NdRepositorySupport.getWorkspace(this)).getImplicitLockManager()) != null) {
            ndRepositoryImplicitLockManager.releaseLock(ndRepositoryImplicitLock);
        }
    }

    void WjImvRO() throws NdRepositoryException {
        NdWorkspace ndWorkspace = NdRepositorySupport.getWorkspace(this);
        ndWorkspace.getRepositoryAuthorizationManager().checkAuthorizationRequest(new NdRepositoryItemContentReadAuthorizationRequest((NdRepository)ndWorkspace.getPhysicalRepositoryEntry(), (NdRepositoryItem)this.getPhysicalRepositoryEntry()));
    }

    void WjImvSP(NdRepositoryItemContent ndRepositoryItemContent) throws NdRepositoryException {
        NdWorkspace ndWorkspace = NdRepositorySupport.getWorkspace(this);
        ndWorkspace.getRepositoryAuthorizationManager().checkAuthorizationRequest(new NdRepositoryItemContentWriteAuthorizationRequest((NdRepository)ndWorkspace.getPhysicalRepositoryEntry(), (NdRepositoryItem)this.getPhysicalRepositoryEntry(), ndRepositoryItemContent));
    }

    public void cancelCheckOut() throws NdRepositoryException {
        this.ensureNotDetached();
        ((NdWorkspaceDirectory)this.getContainerDirectory()).cancelCheckOut(new NdWorkspaceEntry[]{this}, false, false);
    }

    public void checkIn(String string) throws NdRepositoryException {
        this.ensureNotDetached();
        ((NdWorkspaceDirectory)this.getContainerDirectory()).checkIn(new NdWorkspaceEntry[]{this}, string, false, false);
    }

    public void checkOut() throws NdRepositoryException {
        this.ensureNotDetached();
        ((NdWorkspaceDirectory)this.getContainerDirectory()).checkOut(new NdWorkspaceEntry[]{this}, false, false);
    }

    public void delete() throws NdRepositoryException {
        this.ensureNotDetached();
        ((NdWorkspaceDirectory)this.getContainerDirectory()).delete(new NdWorkspaceEntry[]{this});
    }

    public void cancelDelete() throws NdRepositoryException {
        this.ensureNotDetached();
        ((NdWorkspaceDirectory)this.getContainerDirectory()).cancelDelete(new NdWorkspaceEntry[]{this});
    }

    public void deleteLabel(String string) throws NdRepositoryException {
        this.ensureNotDetached();
        if (this.isMarkedForDeletion()) {
            throw new NdRepositoryException(NdStrings.WjIejYS("OperationNotAllowedOnDeletedItem", "deleteLabel", this.getLocation()));
        }
        NdWorkspace ndWorkspace = NdRepositorySupport.getWorkspace(this);
        if (!ndWorkspace.isVersioned()) {
            throw new NdRepositoryException(NdStrings.WjIejXR("VersioningIsNotEnabled", this.getLocation()));
        }
        NdWorkspaceVersionManager ndWorkspaceVersionManager = ndWorkspace.getWorkspaceVersionManager();
        ndWorkspaceVersionManager.deleteLabel(new NdRepositoryEntry[]{this}, string);
    }

    public NdRepositoryEntryLockInfo getEntryLockInfo() throws NdRepositoryException {
        this.ensureNotDetached();
        NdRepositoryEntryLockInfo ndRepositoryEntryLockInfo = this.WjIvceO();
        if (ndRepositoryEntryLockInfo == null) {
            ndRepositoryEntryLockInfo = this.WjIvbYI();
            NdWorkspace ndWorkspace = NdRepositorySupport.getWorkspace(this);
            if (ndWorkspace.isVersionStatusCached()) {
                this.WjIvcdN(ndRepositoryEntryLockInfo);
            }
        }
        return ndRepositoryEntryLockInfo;
    }

    private NdRepositoryEntryLockInfo WjIvbYI() throws NdRepositoryException {
        NdRepositoryEntryLockInfo ndRepositoryEntryLockInfo;
        NdWorkspace ndWorkspace = NdRepositorySupport.getWorkspace(this);
        if (ndWorkspace.isVersioned()) {
            NdWorkspaceVersionManager ndWorkspaceVersionManager = ndWorkspace.getWorkspaceVersionManager();
            if (ndWorkspaceVersionManager.isServerConnected()) {
                ndRepositoryEntryLockInfo = ndWorkspaceVersionManager.getEntryLockInfos(new NdRepositoryEntry[]{this})[0];
                NdWorkspaceSupport.WjIqirA(this, ndRepositoryEntryLockInfo);
            } else {
                ndRepositoryEntryLockInfo = this.WjIrQpV();
            }
        } else {
            ndRepositoryEntryLockInfo = new NdDefaultRepositoryEntryLockInfo(1, null, this.getLocation());
        }
        return ndRepositoryEntryLockInfo;
    }

    NdRepositoryEntryLockInfo WjIrQpV() throws NdRepositoryException {
        String string = NdRepositorySupport.getAttributeValue(this, "com.blazesoft.repository.local.checkedOut");
        int n = string != null ? (NdBaseObject.areEqual((Object)string, (Object)this.WjIrQrX()) ? 2 : 4) : 1;
        return new NdDefaultRepositoryEntryLockInfo(n, string, this.getLocation());
    }

    public NdRepositoryVersionHistory[] getHistory() throws NdRepositoryException {
        this.ensureNotDetached();
        NdRepositoryVersionHistory[] ndRepositoryVersionHistoryArray = this.WjIvcgQ();
        if (ndRepositoryVersionHistoryArray == null) {
            ndRepositoryVersionHistoryArray = this.WjIvbZJ();
            NdWorkspace ndWorkspace = NdRepositorySupport.getWorkspace(this);
            if (ndWorkspace.isVersionStatusCached()) {
                this.WjIvcfP(ndRepositoryVersionHistoryArray);
            }
        }
        return ndRepositoryVersionHistoryArray;
    }

    private NdRepositoryVersionHistory[] WjIvbZJ() throws NdRepositoryException {
        NdWorkspace ndWorkspace = NdRepositorySupport.getWorkspace(this);
        if (ndWorkspace.isVersioned()) {
            NdWorkspaceVersionManager ndWorkspaceVersionManager = ndWorkspace.getWorkspaceVersionManager();
            if (ndWorkspaceVersionManager.isServerConnected()) {
                return ndWorkspaceVersionManager.getHistories(new NdRepositoryEntry[]{this})[0];
            }
            return new NdRepositoryVersionHistory[0];
        }
        return new NdRepositoryVersionHistory[0];
    }

    public NdRepositoryVersionResultSet getStatusInfo() throws NdRepositoryException {
        this.ensureNotDetached();
        NdRepositoryVersionResultSet ndRepositoryVersionResultSet = this.WjIvccM();
        if (ndRepositoryVersionResultSet == null) {
            ndRepositoryVersionResultSet = this.WjIvcaK();
            NdWorkspace ndWorkspace = NdRepositorySupport.getWorkspace(this);
            if (ndWorkspace.isVersionStatusCached()) {
                this.WjIvcbL(ndRepositoryVersionResultSet);
            }
        }
        return ndRepositoryVersionResultSet;
    }

    private NdRepositoryVersionResultSet WjIvcaK() throws NdRepositoryException {
        NdRepositoryVersionResultSet ndRepositoryVersionResultSet;
        NdWorkspace ndWorkspace = NdRepositorySupport.getWorkspace(this);
        if (ndWorkspace.isVersioned()) {
            NdWorkspaceVersionManager ndWorkspaceVersionManager = ndWorkspace.getWorkspaceVersionManager();
            if (ndWorkspaceVersionManager.isServerConnected()) {
                ndRepositoryVersionResultSet = ndWorkspaceVersionManager.getStatusInfos(new NdWorkspaceEntry[]{this})[0];
                NdWorkspaceSupport.WjIqiqX(this, ndRepositoryVersionResultSet);
            } else {
                ndRepositoryVersionResultSet = this.WjIrQqW();
            }
        } else {
            NdRepositoryVersionResultSet ndRepositoryVersionResultSet2 = new NdRepositoryVersionResultSet();
            ndRepositoryVersionResultSet2.setLocation(this.getLocation());
            ndRepositoryVersionResultSet2.setVersionStatus(1);
            ndRepositoryVersionResultSet2.setSuccessful(true);
            ndRepositoryVersionResultSet = ndRepositoryVersionResultSet2;
        }
        return ndRepositoryVersionResultSet;
    }

    NdRepositoryVersionResultSet WjIrQqW() throws NdRepositoryException {
        NdRepositoryVersionResultSet ndRepositoryVersionResultSet = new NdRepositoryVersionResultSet();
        ndRepositoryVersionResultSet.setLocation(this.getLocation());
        ndRepositoryVersionResultSet.setSuccessful(true);
        if (NdRepositorySupport.getAttributeValue(this, "com.blazesoft.repository.local.locallycreated") != null) {
            if (NdBaseObject.areEqual((Object)this.WjIrQrX(), (Object)NdRepositorySupport.getCreationUserId(this))) {
                ndRepositoryVersionResultSet.setVersionStatus(1);
            } else {
                ndRepositoryVersionResultSet.setVersionStatus(2);
            }
        } else if (NdRepositorySupport.getAttributeValue(this, "com.blazesoft.repository.local.checkedOut") != null) {
            if (NdBaseObject.areEqual((Object)this.WjIrQrX(), (Object)NdRepositorySupport.getCreationUserId(this))) {
                ndRepositoryVersionResultSet.setVersionStatus(3);
            } else {
                ndRepositoryVersionResultSet.setVersionStatus(4);
            }
            ndRepositoryVersionResultSet.setLocallyDeleted(this.WjIqgEH);
        } else {
            ndRepositoryVersionResultSet.setVersionStatus(5);
        }
        NdWorkspaceSupport.WjIveFN(this, ndRepositoryVersionResultSet);
        return ndRepositoryVersionResultSet;
    }

    private String WjIrQrX() {
        NdWorkspace ndWorkspace = NdRepositorySupport.getWorkspace(this);
        NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig = ndWorkspace.getRepositoryConfig().getRepositoryVersionManagerConfig();
        NdVersioningRepositoryConnection ndVersioningRepositoryConnection = ndRepositoryVersionManagerConfig.getVersioningRepositoryConnection();
        return ndVersioningRepositoryConnection.getUser();
    }

    public boolean isItemOutdated() throws NdRepositoryException {
        return NdRepositorySupport.isUpToDate(this.getStatusInfo());
    }

    public void setLabel(String string) throws NdRepositoryException {
        this.ensureNotDetached();
        if (this.isMarkedForDeletion()) {
            throw new NdRepositoryException(NdStrings.WjIejYS("OperationNotAllowedOnDeletedItem", "setLabel", this.getLocation()));
        }
        NdWorkspace ndWorkspace = NdRepositorySupport.getWorkspace(this);
        if (!ndWorkspace.isVersioned()) {
            throw new NdRepositoryException(NdStrings.WjIejXR("VersioningIsNotEnabled", this.getLocation()));
        }
        NdWorkspaceVersionManager ndWorkspaceVersionManager = ndWorkspace.getWorkspaceVersionManager();
        ndWorkspaceVersionManager.setLabel(new NdRepositoryEntry[]{this}, string);
    }

    public NdRepositoryVersionLabel[] getLabels() throws NdRepositoryException {
        this.ensureNotDetached();
        NdWorkspace ndWorkspace = NdRepositorySupport.getWorkspace(this);
        if (ndWorkspace.isVersioned()) {
            NdWorkspaceVersionManager ndWorkspaceVersionManager = ndWorkspace.getWorkspaceVersionManager();
            return ndWorkspaceVersionManager.getLabels(new NdRepositoryEntry[]{this})[0];
        }
        return new NdRepositoryVersionLabel[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws NdRepositoryException {
        this.ensureNotDetached();
        if (this.isMarkedForDeletion()) {
            throw new NdRepositoryException(NdStrings.WjIejYS("OperationNotAllowedOnDeletedItem", "update", this.getLocation()));
        }
        NdWorkspace ndWorkspace = NdRepositorySupport.getWorkspace(this);
        if (!ndWorkspace.isVersioned()) {
            throw new NdRepositoryException(NdStrings.WjIejXR("VersioningIsNotEnabled", this.getLocation()));
        }
        NdWorkspaceVersionManager ndWorkspaceVersionManager = ndWorkspace.getWorkspaceVersionManager();
        NdAbstractWorkspaceDirectory ndAbstractWorkspaceDirectory = (NdAbstractWorkspaceDirectory)((Object)ndWorkspace);
        try {
            ndAbstractWorkspaceDirectory.WjIvyhW();
            ndWorkspaceVersionManager.update(new NdRepositoryEntry[]{this});
        }
        finally {
            this.WjIvxLM();
            ndAbstractWorkspaceDirectory.WjIvyhY(this);
            ndAbstractWorkspaceDirectory.WjIvyhX();
        }
    }

    void WjIvxLM() {
        this.WjIvxLN(this.WjIqgGJ());
    }

    void WjIvxLN(NdWorkspace ndWorkspace) {
        if (ndWorkspace instanceof NdLocalRepository) {
            NdLocalRepository ndLocalRepository = (NdLocalRepository)ndWorkspace;
            ndLocalRepository.WjIvbCY(this, null);
            ndLocalRepository.WjIvbEA(this, null);
            ndLocalRepository.WjIvbEC(this, null);
        }
    }

    public void restore() throws NdRepositoryException {
        this.ensureNotDetached();
        throw new NdRepositoryException(NdStrings.WjIejXR("CannotRestore", this.getLocation()));
    }

    abstract void WjIvcbL(NdRepositoryVersionResultSet var1);

    abstract NdRepositoryVersionResultSet WjIvccM();

    abstract void WjIvcdN(NdRepositoryEntryLockInfo var1);

    abstract NdRepositoryEntryLockInfo WjIvceO();

    abstract void WjIvcfP(NdRepositoryVersionHistory[] var1);

    abstract NdRepositoryVersionHistory[] WjIvcgQ();

    void WjIvchR(NdLocation ndLocation, int n) {
        ((NdAbstractWorkspaceDirectory)((Object)this.WjIqgGJ())).WjIvchR(ndLocation, n);
    }

    void WjIvciS(NdWorkspaceEntry ndWorkspaceEntry, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray, int n) {
        ((NdAbstractWorkspaceDirectory)((Object)this.WjIqgGJ())).WjIvciS(ndWorkspaceEntry, ndRepositoryEntryAttributeArray, n);
    }

    void WjIvcjT(NdWorkspaceEvent ndWorkspaceEvent) {
        ((NdAbstractWorkspaceDirectory)((Object)this.WjIqgGJ())).WjIvcjT(ndWorkspaceEvent);
    }

    NdSecurityConfig WjIAcCE() {
        return ((NdAbstractWorkspaceDirectory)((Object)this.WjIqgGJ())).WjIAcCE();
    }

    public boolean isEncryptionEnabled() {
        return ((NdAbstractWorkspaceDirectory)((Object)this.WjIqgGJ())).isEncryptionEnabled();
    }

    public void setEncryptionEnabled(boolean bl) {
        ((NdAbstractWorkspaceDirectory)((Object)this.WjIqgGJ())).setEncryptionEnabled(bl);
    }

    byte[] WjIAcDF(byte[] byArray) throws NdRepositoryException {
        return ((NdAbstractWorkspaceDirectory)((Object)this.WjIqgGJ())).WjIAcDF(byArray);
    }

    byte[] WjIAcEG(byte[] byArray) throws NdRepositoryException {
        return ((NdAbstractWorkspaceDirectory)((Object)this.WjIqgGJ())).WjIAcEG(byArray);
    }

    NdRepositoryItemContent WjIAcFH(NdRepositoryItemContent ndRepositoryItemContent) throws NdRepositoryException {
        WjIzZaE wjIzZaE = new WjIzZaE(ndRepositoryItemContent);
        byte[] byArray = wjIzZaE.getRawData();
        byte[] byArray2 = this.WjIAcEG(byArray);
        String[] stringArray = NdBase64.encode((byte[])byArray2);
        StringBuffer stringBuffer = new StringBuffer(80 * stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append('\n');
        }
        wjIzZaE.setData(stringBuffer.toString());
        return wjIzZaE;
    }

    NdRepositoryItemContent WjIAcGI(NdRepositoryItemContent ndRepositoryItemContent) throws NdRepositoryException {
        WjIzZaE wjIzZaE = new WjIzZaE(ndRepositoryItemContent);
        String string = wjIzZaE.getData();
        byte[] byArray = NdBase64.decode((String)string);
        wjIzZaE.setRawData(this.WjIAcDF(byArray));
        return wjIzZaE;
    }

    public abstract /* synthetic */ String getName() throws NdRepositoryException;

    protected static class WjIzZaE
    extends NdRepositoryItemContent {
        public WjIzZaE(NdRepositoryItemContent ndRepositoryItemContent) {
            super(ndRepositoryItemContent);
        }

        protected void setData(String string) {
            super.setData(string);
        }

        protected void setRawData(byte[] byArray) {
            super.setRawData(byArray);
        }
    }
}

