/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.memory;

import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryEntryAlreadyExistsException;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryEntryAttributeFilter;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.base.NdRepositoryItemContentDefConverterContext;
import com.blazesoft.repository.memory.NdMemoryRepository;
import com.blazesoft.repository.memory.NdMemoryRepositoryEntry;
import com.blazesoft.repository.memory.NdMemoryRepositoryEntryDoesNotExistException;
import com.blazesoft.repository.memory.NdMemoryRepositoryEntryException;
import com.blazesoft.repository.memory.NdMemoryRepositoryItem;
import com.blazesoft.repository.memory.NdStrings;
import com.blazesoft.repository.memory.WjIjucJ;
import com.blazesoft.repository.memory.WjIjviF;
import com.blazesoft.util.NdHashMap;
import java.util.Enumeration;

public class NdMemoryRepositoryDirectory
extends NdMemoryRepositoryEntry
implements NdRepositoryDirectory,
NdRepositoryEntryAttributeFilter {
    private WjIjviF WjIjsnP;
    private NdHashMap WjIjsnQ = new NdHashMap();

    NdMemoryRepositoryDirectory(NdMemoryRepositoryDirectory ndMemoryRepositoryDirectory, String string) throws NdRepositoryException {
        super(ndMemoryRepositoryDirectory, string, null);
        this.createAttributeSupport();
    }

    NdMemoryRepositoryDirectory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAttributeSupport() throws NdRepositoryException {
        NdMemoryRepositoryDirectory ndMemoryRepositoryDirectory = this;
        synchronized (ndMemoryRepositoryDirectory) {
            if (this.WjIjsnP == null) {
                this.WjIjsnP = new WjIjucJ(this);
            }
        }
    }

    NdRepositoryEntry[] WjIjsnR() throws NdRepositoryException {
        Enumeration enumeration = this.WjIjsnQ.elements();
        NdRepositoryEntry[] ndRepositoryEntryArray = new NdRepositoryEntry[this.WjIjsnQ.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ndRepositoryEntryArray[n++] = (NdRepositoryEntry)enumeration.nextElement();
        }
        return ndRepositoryEntryArray;
    }

    public NdRepositoryEntry[] getRepositoryEntries() throws NdRepositoryException {
        return this.WjIjsnR();
    }

    public NdRepositoryDirectory createRepositoryDirectory(String string) throws NdRepositoryException {
        this.checkWriteMode();
        return new NdMemoryRepositoryDirectory(this, string);
    }

    public void addRepositoryDirectory(NdRepositoryDirectory ndRepositoryDirectory, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        try {
            this.checkWriteMode();
            if (this.WjIjsnQ.containsKey((Object)ndRepositoryDirectory.getName())) {
                throw new NdRepositoryEntryAlreadyExistsException(NdStrings.WjIjtLS("EntryAlreadyExist", ndRepositoryDirectory.getName(), this.getName()));
            }
            this.WjIjsnQ.put((Object)ndRepositoryDirectory.getName(), (Object)ndRepositoryDirectory);
            this.createAttributeSupport();
            if (ndRepositoryEntryAttributeArray != null && ndRepositoryEntryAttributeArray.length > 0) {
                this.WjIjsnP.WjIjviB(ndRepositoryDirectory, ndRepositoryEntryAttributeArray);
            }
            this.WjIjuYE();
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdMemoryRepositoryEntryException(NdStrings.WjIjtKR("CouldNotCreateDirectory", ndRepositoryDirectory.getName()), this, exception);
        }
    }

    public void removeRepositoryDirectory(NdRepositoryDirectory ndRepositoryDirectory) throws NdRepositoryException {
        try {
            this.checkWriteMode();
            if (!this.WjIjsnQ.containsKey((Object)ndRepositoryDirectory.getName())) {
                throw new NdMemoryRepositoryEntryDoesNotExistException(ndRepositoryDirectory.getName(), this);
            }
            this.WjIjsnP.WjIjviE(ndRepositoryDirectory);
            this.WjIjsnQ.remove((Object)ndRepositoryDirectory.getName());
            this.WjIjuYE();
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdMemoryRepositoryEntryException(NdStrings.WjIjtKR("CouldNotRemoveDirectory", ndRepositoryDirectory.getName()), this, exception);
        }
    }

    public NdRepositoryItem createRepositoryItem(String string) throws NdRepositoryException {
        this.checkWriteMode();
        return new NdMemoryRepositoryItem(this, string, null);
    }

    public void addRepositoryItem(NdRepositoryItem ndRepositoryItem, NdRepositoryItemContent ndRepositoryItemContent, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        NdMemoryRepository ndMemoryRepository = this.WjIjuWY();
        try {
            this.checkWriteMode();
            if (this.WjIjsnQ.containsKey((Object)ndRepositoryItem.getName())) {
                throw new NdRepositoryEntryAlreadyExistsException(NdStrings.WjIjtLS("EntryAlreadyExist", ndRepositoryItem.getName(), this.getName()));
            }
            ndRepositoryItemContent.setItemContentConverter(ndMemoryRepository.getRepositoryItemContentConverter());
            ndRepositoryItemContent.setItemContentConverterContext(new NdRepositoryItemContentDefConverterContext(ndMemoryRepository, ndRepositoryItem));
            byte[] byArray = ndRepositoryItemContent.getRawData();
            ((NdMemoryRepositoryItem)ndRepositoryItem).WjIjuYB(byArray);
            this.WjIjsnQ.put((Object)ndRepositoryItem.getName(), (Object)ndRepositoryItem);
            this.createAttributeSupport();
            this.WjIjsnP.WjIjviB(ndRepositoryItem, ndRepositoryEntryAttributeArray);
            this.WjIjuYE();
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdMemoryRepositoryEntryException(NdStrings.WjIjtKR("CouldNotCreateFile", ndRepositoryItem.getName()), this, exception);
        }
    }

    public void removeRepositoryItem(NdRepositoryItem ndRepositoryItem) throws NdRepositoryException {
        try {
            this.checkWriteMode();
            if (!this.WjIjsnQ.containsKey((Object)ndRepositoryItem.getName())) {
                throw new NdMemoryRepositoryEntryDoesNotExistException(ndRepositoryItem.getName(), this);
            }
            this.WjIjsnP.WjIjviE(ndRepositoryItem);
            this.WjIjsnQ.remove((Object)ndRepositoryItem.getName());
            this.WjIjuYE();
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdMemoryRepositoryEntryException(NdStrings.WjIjtKR("CouldNotRemoveFile", ndRepositoryItem.getName()), this, exception);
        }
    }

    public NdRepositoryEntryAttribute[] getRepositoryEntryAttributes(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        this.createAttributeSupport();
        try {
            return this.WjIjsnP.WjIjviD(ndRepositoryEntry);
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdMemoryRepositoryEntryException(NdStrings.WjIjtKR("CouldNotGetEntryAttributes", ndRepositoryEntry.getName()), this, exception);
        }
    }

    public NdRepositoryEntryAttribute[] getFilteredAttributes(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        this.createAttributeSupport();
        try {
            return this.WjIjsnP.getFilteredAttributes(ndRepositoryEntry);
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdMemoryRepositoryEntryException(NdStrings.WjIjtKR("CouldNotGetEntryAttributes", ndRepositoryEntry.getName()), this, exception);
        }
    }

    public void setRepositoryEntryAttributes(NdRepositoryEntry ndRepositoryEntry, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        this.checkWriteMode();
        this.createAttributeSupport();
        try {
            this.WjIjsnP.WjIjviB(ndRepositoryEntry, ndRepositoryEntryAttributeArray);
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdMemoryRepositoryEntryException(NdStrings.WjIjtKR("CouldNotSetEntryAttributes", ndRepositoryEntry.getName()), this, exception);
        }
    }

    public NdRepositoryEntry lookupRepositoryEntry(String string) throws NdRepositoryException {
        return (NdRepositoryEntry)this.WjIjsnQ.get((Object)string);
    }
}

