/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.rmi;

import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryServerStatePicker;
import com.blazesoft.repository.rmi.NdStrings;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.BLOB;

public class NdJdbcOracleServerStatePickerImpl
implements NdRepositoryServerStatePicker {
    private String WjHKmQH;
    private String WjHKmRI;
    private String WjHKmSJ;
    private String WjHKmTK;
    private String WjHKmUL;
    private Connection WjHKmVM;

    public NdJdbcOracleServerStatePickerImpl(Hashtable hashtable) {
        this.WjHKmQH = (String)hashtable.get("JDBC.driver");
        this.WjHKmRI = (String)hashtable.get("JDBC.database.url");
        this.WjHKmSJ = (String)hashtable.get("JDBC.username");
        this.WjHKmTK = (String)hashtable.get("JDBC.password");
        this.WjHKmUL = (String)hashtable.get("JDBC.repository.table");
    }

    public Object getRepositoryServerState() throws NdRepositoryException {
        Object object;
        Object object2 = null;
        try {
            object = Class.forName(this.WjHKmQH);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NdRepositoryException(classNotFoundException);
        }
        try {
            object = DriverManager.getConnection(this.WjHKmRI, this.WjHKmSJ, this.WjHKmTK);
            String string = "SELECT CONTENT FROM " + this.WjHKmUL;
            Statement statement = object.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            InputStream inputStream = null;
            ObjectInputStream objectInputStream = null;
            if (resultSet.next()) {
                try {
                    BLOB bLOB = ((OracleResultSet)resultSet).getBLOB(1);
                    inputStream = bLOB.getBinaryStream();
                }
                catch (Exception exception) {
                    throw new NdRepositoryException(exception);
                }
                if (inputStream != null) {
                    objectInputStream = new ObjectInputStream(inputStream);
                    object2 = objectInputStream.readObject();
                } else {
                    throw new NdRepositoryException(NdStrings.WjHBNjO("CouldNotGetInitialState"));
                }
            }
            statement.close();
            object.close();
        }
        catch (Exception exception) {
            throw new NdRepositoryException(NdStrings.WjHBNjO("GetInitialStateFailed"), exception);
        }
        return object2;
    }
}

