/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.rmi;

import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryServerStateDumper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Hashtable;

public class NdJdbcServerStateDumperImpl
implements NdRepositoryServerStateDumper {
    private String WjHCDHX;
    private String WjHCDHY;
    private String WjHCDHZ;
    private String WjHCDIA;
    private String WjHCDJB;
    private transient Connection WjHCDKC;

    public NdJdbcServerStateDumperImpl(Hashtable hashtable) {
        this.WjHCDHX = (String)hashtable.get("JDBC.driver");
        this.WjHCDHY = (String)hashtable.get("JDBC.database.url");
        this.WjHCDHZ = (String)hashtable.get("JDBC.username");
        this.WjHCDIA = (String)hashtable.get("JDBC.password");
        this.WjHCDJB = (String)hashtable.get("JDBC.repository.table");
    }

    public void dumpRepositoryServerState(Object object) throws NdRepositoryException {
        try {
            if (this.WjHCDKC == null || this.WjHCDKC.isClosed()) {
                this.WjHCDLD();
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            String string = "UPDATE " + this.WjHCDJB + " SET CONTENT = ?";
            PreparedStatement preparedStatement = this.WjHCDKC.prepareStatement(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            preparedStatement.setBinaryStream(1, (InputStream)byteArrayInputStream, byArray.length);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
        catch (SQLException sQLException) {
            throw new NdRepositoryException(sQLException);
        }
    }

    private void WjHCDLD() throws NdRepositoryException {
        try {
            Class.forName(this.WjHCDHX);
            this.WjHCDKC = DriverManager.getConnection(this.WjHCDHY, this.WjHCDHZ, this.WjHCDIA);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NdRepositoryException(classNotFoundException);
        }
        catch (SQLException sQLException) {
            throw new NdRepositoryException(sQLException);
        }
    }

    protected void closeDBConnection() throws NdRepositoryException {
        try {
            this.WjHCDKC.close();
        }
        catch (SQLException sQLException) {
            throw new NdRepositoryException(sQLException);
        }
    }
}

