/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.rmi;

import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.base.NdRepositoryItemContentDefConverterContext;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.rmi.NdRmiEntryRepositoryException;
import com.blazesoft.repository.rmi.NdRmiRepositoryEntry;
import com.blazesoft.repository.rmi.NdRmiRepositoryItem;
import com.blazesoft.repository.rmi.NdRmiRepositoryRemoteEntry;
import com.blazesoft.repository.rmi.NdStrings;
import com.blazesoft.repository.server.NdRepositoryAccessor;
import com.blazesoft.repository.server.NdRepositoryRemoteEntry;
import java.rmi.RemoteException;

public class NdRmiRepositoryDirectory
extends NdRmiRepositoryEntry
implements NdRepositoryDirectory {
    NdRmiRepositoryDirectory(NdRmiRepositoryDirectory ndRmiRepositoryDirectory, String string) {
        super(ndRmiRepositoryDirectory, string);
    }

    NdRmiRepositoryDirectory() {
    }

    public NdRepositoryEntry[] getRepositoryEntries() throws NdRepositoryException {
        NdRepositoryEntry[] ndRepositoryEntryArray;
        this.checkConnection();
        try {
            NdRepositoryRemoteEntry[] ndRepositoryRemoteEntryArray = this.getRmiRepositoryAccessor().getEntries(this.WjIahYJ().WjHBNMX(), this.WjIvJfH());
            ndRepositoryEntryArray = new NdRepositoryEntry[ndRepositoryRemoteEntryArray.length];
            for (int i = 0; i < ndRepositoryRemoteEntryArray.length; ++i) {
                NdRmiRepositoryRemoteEntry ndRmiRepositoryRemoteEntry = (NdRmiRepositoryRemoteEntry)ndRepositoryRemoteEntryArray[i];
                ndRepositoryEntryArray[i] = ndRmiRepositoryRemoteEntry.isDirectory() ? new NdRmiRepositoryDirectory(this, ndRmiRepositoryRemoteEntry.getName()) : new NdRmiRepositoryItem(this, ndRmiRepositoryRemoteEntry.getName());
            }
        }
        catch (RemoteException remoteException) {
            throw new NdRmiEntryRepositoryException(NdStrings.WjHBNjQ("CouldNotGetEntries", this.getName()), this, remoteException);
        }
        return ndRepositoryEntryArray;
    }

    public NdRepositoryDirectory createRepositoryDirectory(NdLocation ndLocation) throws NdRepositoryException {
        String string = this.WjIahYJ().getRepositoryEntryLocationManager().translateLocation(ndLocation);
        return this.createRepositoryDirectory(string);
    }

    public NdRepositoryDirectory createRepositoryDirectory(String string) throws NdRepositoryException {
        this.checkWriteMode();
        return new NdRmiRepositoryDirectory(this, string);
    }

    public void addRepositoryDirectory(NdRepositoryDirectory ndRepositoryDirectory, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        this.checkConnection();
        this.checkWriteMode();
        try {
            this.getRmiRepositoryAccessor().addDirectory(this.WjIahYJ().WjHBNMX(), this.WjIvJfH(), ndRepositoryDirectory.getName(), ndRepositoryEntryAttributeArray);
        }
        catch (RemoteException remoteException) {
            throw new NdRmiEntryRepositoryException(NdStrings.WjHBNjQ("CouldNotCreateDirectory", ndRepositoryDirectory.getName()), this, remoteException);
        }
    }

    public void removeRepositoryDirectory(NdRepositoryDirectory ndRepositoryDirectory) throws NdRepositoryException {
        this.checkConnection();
        this.checkWriteMode();
        try {
            this.getRmiRepositoryAccessor().removeDirectory(this.WjIahYJ().WjHBNMX(), this.WjIvJfH(), ndRepositoryDirectory.getName());
        }
        catch (RemoteException remoteException) {
            throw new NdRmiEntryRepositoryException(NdStrings.WjHBNjQ("CouldNotRemoveDirectory", ndRepositoryDirectory.getName()), this, remoteException);
        }
    }

    public NdRepositoryItem createRepositoryItem(NdLocation ndLocation) throws NdRepositoryException {
        String string = this.WjIahYJ().getRepositoryEntryLocationManager().translateLocation(ndLocation);
        return this.createRepositoryItem(string);
    }

    public NdRepositoryItem createRepositoryItem(String string) throws NdRepositoryException {
        this.checkWriteMode();
        return new NdRmiRepositoryItem(this, string);
    }

    public void addRepositoryItem(NdRepositoryItem ndRepositoryItem, NdRepositoryItemContent ndRepositoryItemContent, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        this.checkConnection();
        this.checkWriteMode();
        try {
            if (ndRepositoryItemContent != null) {
                ndRepositoryItemContent.setItemContentConverter(this.WjIahYJ().getRepositoryItemContentConverter());
                ndRepositoryItemContent.setItemContentConverterContext(new NdRepositoryItemContentDefConverterContext(this.WjIahYJ(), ndRepositoryItem));
            }
            NdRepositoryAccessor ndRepositoryAccessor = this.getRmiRepositoryAccessor();
            ndRepositoryAccessor.addItem(this.WjIahYJ().WjHBNMX(), this.WjIvJfH(), ndRepositoryItem.getName(), ndRepositoryItemContent, ndRepositoryEntryAttributeArray);
        }
        catch (RemoteException remoteException) {
            throw new NdRmiEntryRepositoryException(NdStrings.WjHBNjQ("CouldNotCreateItem", ndRepositoryItem.getName()), this, remoteException);
        }
    }

    public void removeRepositoryItem(NdRepositoryItem ndRepositoryItem) throws NdRepositoryException {
        this.checkConnection();
        this.checkWriteMode();
        NdRepositoryDirectory ndRepositoryDirectory = ndRepositoryItem.getContainerDirectory();
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = ndRepositoryDirectory.getRepositoryEntryAttributes(ndRepositoryItem);
        try {
            this.getRmiRepositoryAccessor().removeItem(this.WjIahYJ().WjHBNMX(), this.WjIvJfH(), ndRepositoryItem.getName());
        }
        catch (RemoteException remoteException) {
            throw new NdRmiEntryRepositoryException(NdStrings.WjHBNjQ("CouldNotRemoveItem", ndRepositoryItem.getName()), this, remoteException);
        }
    }

    public NdRepositoryEntryAttribute[] getRepositoryEntryAttributes(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        this.checkConnection();
        try {
            return this.getRmiRepositoryAccessor().getEntryAttributes(this.WjIahYJ().WjHBNMX(), ((NdRmiRepositoryEntry)ndRepositoryEntry).WjIvJfH());
        }
        catch (RemoteException remoteException) {
            throw new NdRmiEntryRepositoryException(NdStrings.WjHBNjQ("CouldNotGetEntryAttributes", ndRepositoryEntry.getName()), this, remoteException);
        }
    }

    public void setRepositoryEntryAttributes(NdRepositoryEntry ndRepositoryEntry, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        this.checkConnection();
        this.checkWriteMode();
        try {
            this.getRmiRepositoryAccessor().setEntryAttributes(this.WjIahYJ().WjHBNMX(), ((NdRmiRepositoryEntry)ndRepositoryEntry).WjIvJfH(), ndRepositoryEntryAttributeArray);
        }
        catch (RemoteException remoteException) {
            throw new NdRmiEntryRepositoryException(NdStrings.WjHBNjQ("CouldNotSetEntryAttributes", ndRepositoryEntry.getName()), this, remoteException);
        }
    }

    private NdRmiRepositoryRemoteEntry WjIalEY(String string, String string2) throws NdRepositoryException {
        NdRmiRepositoryRemoteEntry ndRmiRepositoryRemoteEntry;
        this.checkConnection();
        try {
            ndRmiRepositoryRemoteEntry = (NdRmiRepositoryRemoteEntry)this.getRmiRepositoryAccessor().lookupEntry(this.WjIahYJ().WjHBNMX(), string, string2);
        }
        catch (RemoteException remoteException) {
            throw new NdRmiEntryRepositoryException(NdStrings.WjHBNjQ("CouldNotGetEntry", string2), this, remoteException);
        }
        return ndRmiRepositoryRemoteEntry;
    }

    public NdRepositoryEntry lookupRepositoryEntry(String string) throws NdRepositoryException {
        if (string.equals("")) {
            return this;
        }
        if (string.equals("/")) {
            return this.WjIahYJ();
        }
        NdRmiRepositoryEntry ndRmiRepositoryEntry = null;
        NdRmiRepositoryRemoteEntry ndRmiRepositoryRemoteEntry = this.WjIalEY(this.WjIvJfH(), string);
        if (ndRmiRepositoryRemoteEntry != null) {
            ndRmiRepositoryEntry = ndRmiRepositoryRemoteEntry.isDirectory() ? new NdRmiRepositoryDirectory(this, string) : new NdRmiRepositoryItem(this, string);
        }
        return ndRmiRepositoryEntry;
    }
}

