/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.rmi;

import com.blazesoft.repository.rmi.NdRmiAccessorFactory;
import com.blazesoft.repository.rmi.NdStrings;
import com.blazesoft.repository.server.NdRepositoryAccessor;
import com.blazesoft.repository.server.NdRepositoryAccessorPoster;
import com.blazesoft.repository.server.NdRepositoryAccessorPosterFactory;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Vector;

public class NdRmiRepositoryServer {
    public static String DEFAULT_RMI_REPOSITORY_SERVER_NAME = "NdRmiRepositoryServer";
    public static String DEFAULT_RMI_REPOSITORY_SERVER_POSTER_NAME = "NdRmiRepositoryServerPoster";
    public static int DEFAULT_PORT = 1099;
    public static int DEFAULT_TIMEOUT = 30;
    public static String DEFAULT_RMI_ACCESSOR_FACTORY_CLASS = "com.blazesoft.repository.rmi.NdDefaultRmiAccessorFactoryImpl";
    public static String DEFAULT_RMI_ACCESSOR_POSTER_FACTORY_CLASS = "com.blazesoft.repository.rmi.NdDefaultRmiAccessorPosterFactoryImpl";
    private static String WjHBObX = DEFAULT_RMI_REPOSITORY_SERVER_NAME;
    private static String WjHCkqY = DEFAULT_RMI_REPOSITORY_SERVER_POSTER_NAME;
    private static int WjHBOdZ = DEFAULT_PORT;
    private static String WjHBTAJ = DEFAULT_RMI_ACCESSOR_FACTORY_CLASS;
    private static String WjHCkrZ = DEFAULT_RMI_ACCESSOR_POSTER_FACTORY_CLASS;

    private static void WjHBOeE() {
        NdRmiRepositoryServer.WjHCksA("usage: NdRmiRepositoryServer\n\t\t[-rmiServerName <server name>]\tspecify a rmi server name\n\t\t[-rmiServerPosterName <server poster name>]\tspecify a rmi server poster name\n\t\t[-port <port>]\tspecify a rmi registry port number\n\t\t[-accessFactoryClass <class name>]\tspecify a rmi repository accessor factory class\n\t\t[-posterFactoryClass <class name>] specify a rmi repository accessor poster factory class\n\t\t[[-AccessorFlag <Accessor Option Value>]]\n\t\t");
        System.exit(-1);
    }

    private static String[] WjHBTCL(String[] stringArray) {
        Vector<String> vector = null;
        Object[] objectArray = null;
        if (stringArray == null || stringArray.length == 0) {
            NdRmiRepositoryServer.WjHBOeE();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("help")) {
                NdRmiRepositoryServer.WjHBOeE();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-rmiServerName")) {
                WjHBObX = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-rmiServerPosterName")) {
                WjHCkqY = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-accessFactoryClass")) {
                WjHBTAJ = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-posterFactoryClass")) {
                WjHCkrZ = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-port")) {
                try {
                    WjHBOdZ = Integer.parseInt(stringArray[++i]);
                }
                catch (Exception exception) {}
                continue;
            }
            if (vector == null) {
                vector = new Vector<String>();
            }
            vector.addElement(stringArray[i]);
        }
        if (vector != null && vector.size() > 0) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        Object object;
        String[] stringArray2 = NdRmiRepositoryServer.WjHBTCL(stringArray);
        NdRmiAccessorFactory ndRmiAccessorFactory = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(WjHBTAJ);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NdRmiRepositoryServer.WjHCksB(classNotFoundException);
        }
        if (clazz != null) {
            try {
                ndRmiAccessorFactory = (NdRmiAccessorFactory)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                NdRmiRepositoryServer.WjHCksB(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                NdRmiRepositoryServer.WjHCksB(illegalAccessException);
            }
        }
        NdRepositoryAccessorPosterFactory ndRepositoryAccessorPosterFactory = null;
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName(WjHCkrZ);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NdRmiRepositoryServer.WjHCksB(classNotFoundException);
        }
        if (clazz2 != null) {
            try {
                ndRepositoryAccessorPosterFactory = (NdRepositoryAccessorPosterFactory)clazz2.newInstance();
            }
            catch (InstantiationException instantiationException) {
                NdRmiRepositoryServer.WjHCksB(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                NdRmiRepositoryServer.WjHCksB(illegalAccessException);
            }
        }
        Registry registry = null;
        NdRepositoryAccessor ndRepositoryAccessor = null;
        NdRepositoryAccessorPoster ndRepositoryAccessorPoster = null;
        try {
            NdRmiRepositoryServer.WjHCksA(NdStrings.WjHBNjO("StartingRmiService") + WjHBOdZ);
            registry = LocateRegistry.createRegistry(WjHBOdZ);
            NdRmiRepositoryServer.WjHCksA(NdStrings.WjHBNjO("RmiServiceStarted"));
            NdRmiRepositoryServer.WjHCksA(NdStrings.WjHBNjO("InitializeRmi"));
            ndRepositoryAccessor = ndRmiAccessorFactory.newRmiAccessorInstance(stringArray2);
            ndRepositoryAccessorPoster = ndRepositoryAccessorPosterFactory.newAccessorPoster(ndRepositoryAccessor);
            registry.rebind(WjHBObX, ndRepositoryAccessor);
            NdRmiRepositoryServer.WjHCksA(NdStrings.WjHBNjO("Ready"));
            registry.rebind(WjHCkqY, ndRepositoryAccessorPoster);
        }
        catch (Exception exception) {
            NdRmiRepositoryServer.WjHCksB(exception);
        }
        int n = 0;
        NdRmiRepositoryServer.WjHCksC();
        try {
            object = new BufferedReader(new InputStreamReader(System.in));
            String string = ((BufferedReader)object).readLine();
            if (string.length() > 0) {
                n = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            while (true) {
                switch (n) {
                    case 1: {
                        object = ndRepositoryAccessorPoster.listRepositories();
                        NdRmiRepositoryServer.WjHCksA("\n------Repository List And Locking Infomation-----");
                        for (int i = 0; i < ((String[])object).length; ++i) {
                            NdRmiRepositoryServer.WjHCksA((String)object[i]);
                        }
                        NdRmiRepositoryServer.WjHCksA("------------end of list------------\n");
                        break;
                    }
                    case 2: {
                        object = ndRepositoryAccessorPoster.listUsers();
                        NdRmiRepositoryServer.WjHCksA("\n------Repository Client List-----");
                        for (int i = 0; i < ((String[])object).length; ++i) {
                            NdRmiRepositoryServer.WjHCksA((String)object[i]);
                        }
                        NdRmiRepositoryServer.WjHCksA("------------end of list------------\n");
                        break;
                    }
                    case 3: {
                        NdRmiRepositoryServer.WjHCksA("Request server to stop.");
                        try {
                            NdRmiRepositoryServer.WjHCksA(NdStrings.WjHBNjO("UnregisterServerObj"));
                            registry.unbind(WjHBObX);
                            registry.unbind(WjHCkqY);
                        }
                        catch (Exception exception) {
                            NdRmiRepositoryServer.WjHCksB(exception);
                        }
                        System.runFinalization();
                        System.gc();
                        System.exit(0);
                        break;
                    }
                }
                NdRmiRepositoryServer.WjHCksC();
                try {
                    object = new BufferedReader(new InputStreamReader(System.in));
                    String string = ((BufferedReader)object).readLine();
                    if (string.length() <= 0) continue;
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            NdRmiRepositoryServer.WjHCksA("poster exception: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    private static void WjHCksA(String string) {
        System.out.println(string);
    }

    private static void WjHCksB(Exception exception) {
        System.out.println("Exception: " + exception.getMessage());
        exception.printStackTrace();
    }

    private static void WjHCksC() {
        NdRmiRepositoryServer.WjHCksA("\n======Innovator Repository Server Management Command-Line Tool======\n\tPlease input an option of (1 - 3), where\n\t\t 1: Repository List and Locking Info.\n\t\t 2: Client List.\n\t\t 3: Stop Repository Control Server and Exit.\n\t\t ");
        NdRmiRepositoryServer.WjHCksD("Your input: ");
    }

    private static void WjHCksD(String string) {
        System.out.print(string);
    }
}

