/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.rmi;

import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryEntryFactory;
import com.blazesoft.repository.base.NdRepositoryEntryFilter;
import com.blazesoft.repository.base.NdRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryRuntimeException;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdRepositoryVersionException;
import com.blazesoft.repository.base.NdRepositoryVersionHistory;
import com.blazesoft.repository.base.NdRepositoryVersionLabel;
import com.blazesoft.repository.base.NdRepositoryVersionResultSet;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.base.NdWorkspaceVersionManager;
import com.blazesoft.repository.base.NdWorkspaceVersionManagerListener;
import com.blazesoft.repository.config.NdRepositoryEntryFilterFactory;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.rmi.NdRmiRepository;
import com.blazesoft.repository.rmi.NdRmiRepositoryEntry;
import com.blazesoft.repository.rmi.NdRmiRepositoryVirtualItem;
import com.blazesoft.repository.rmi.NdStrings;
import com.blazesoft.repository.server.NdRepositoryAccessor;
import java.rmi.RemoteException;
import java.util.Vector;

public class NdRmiRepositoryVersionManager
implements NdWorkspaceVersionManager {
    private NdRepositoryAccessor WjIvLgU = null;
    private Object WjIvLhV = null;
    private Vector WjIvLiW = new Vector();
    private NdRepositoryEntryFactory WjIvLjX;
    private NdRmiRepository WjIvLkY;

    public NdRmiRepositoryVersionManager(NdWorkspace ndWorkspace) {
        this.WjIvLkY = (NdRmiRepository)ndWorkspace.getPhysicalRepositoryEntry();
        this.WjIvLgU = this.WjIvLkY.getRmiRepositoryAccessor();
        this.WjIvLhV = this.WjIvLkY.WjHBNMX();
    }

    protected void setServerAccessor(NdRepositoryAccessor ndRepositoryAccessor) {
        this.WjIvLgU = ndRepositoryAccessor;
    }

    private void WjIvLlZ(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        if (ndRepositoryEntry == null) {
            throw new NdRepositoryVersionException(NdStrings.WjHBNjO("NullEntryIsDetected"));
        }
        NdRepositoryEntry ndRepositoryEntry2 = NdRepositorySupport.getStorageEntry(ndRepositoryEntry);
        if (!(ndRepositoryEntry2 instanceof NdRmiRepositoryEntry)) {
            throw new NdRepositoryVersionException(NdStrings.WjHBNjQ("NonRmiEntryIsDetected", NdRepositorySupport.getAbsolutePath(ndRepositoryEntry)));
        }
    }

    private void WjIvLmA(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        if (ndRepositoryEntryArray != null && ndRepositoryEntryArray.length > 0) {
            Vector<NdRepositoryException> vector = new Vector<NdRepositoryException>();
            for (int i = 0; i < ndRepositoryEntryArray.length; ++i) {
                try {
                    this.WjIvLlZ(ndRepositoryEntryArray[i]);
                    continue;
                }
                catch (NdRepositoryException ndRepositoryException) {
                    vector.addElement(ndRepositoryException);
                }
            }
            if (vector.size() > 0) {
                NdRepositoryException[] ndRepositoryExceptionArray = new NdRepositoryException[vector.size()];
                vector.copyInto((Object[])ndRepositoryExceptionArray);
                throw new NdRepositoryVersionException((Exception[])ndRepositoryExceptionArray, null);
            }
        }
    }

    private NdLocation[] WjIvLmB(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        NdLocation[] ndLocationArray = new NdLocation[ndRepositoryEntryArray.length];
        for (int i = 0; i < ndLocationArray.length; ++i) {
            ndLocationArray[i] = NdRepositorySupport.getLocation(ndRepositoryEntryArray[i]);
        }
        return ndLocationArray;
    }

    public void cancelCheckOut(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.WjIvLmA(ndRepositoryEntryArray);
        try {
            this.WjIvLgU.cancelCheckOut(this.WjIvLhV, this.WjIvLmB(ndRepositoryEntryArray));
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryVersionException(remoteException);
        }
    }

    public void checkIn(NdRepositoryEntry[] ndRepositoryEntryArray, String string) throws NdRepositoryException {
        this.WjIvLmA(ndRepositoryEntryArray);
        try {
            this.WjIvLgU.checkIn(this.WjIvLhV, this.WjIvLmB(ndRepositoryEntryArray), string);
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryVersionException(remoteException);
        }
    }

    public void checkOut(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.WjIvLmA(ndRepositoryEntryArray);
        try {
            this.WjIvLgU.checkOut(this.WjIvLhV, this.WjIvLmB(ndRepositoryEntryArray));
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryVersionException(remoteException);
        }
    }

    public void delete(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.WjIvLmA(ndRepositoryEntryArray);
        try {
            this.WjIvLgU.delete(this.WjIvLhV, this.WjIvLmB(ndRepositoryEntryArray));
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryVersionException(remoteException);
        }
    }

    public void cancelDelete(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.WjIvLmA(ndRepositoryEntryArray);
        try {
            this.WjIvLgU.cancelDelete(this.WjIvLhV, this.WjIvLmB(ndRepositoryEntryArray));
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryVersionException(remoteException);
        }
    }

    public void deleteLabel(NdRepositoryEntry[] ndRepositoryEntryArray, String string) throws NdRepositoryException {
        this.WjIvLmA(ndRepositoryEntryArray);
        try {
            this.WjIvLgU.deleteLabel(this.WjIvLhV, this.WjIvLmB(ndRepositoryEntryArray), string);
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryVersionException(remoteException);
        }
    }

    public NdRepositoryItem getItemByVersion(NdRepositoryItem ndRepositoryItem, String string) throws NdRepositoryException {
        this.WjIvLlZ(ndRepositoryItem);
        NdLocation ndLocation = NdRepositorySupport.getLocation(ndRepositoryItem);
        try {
            NdRmiRepositoryVirtualItem ndRmiRepositoryVirtualItem = (NdRmiRepositoryVirtualItem)this.WjIvLgU.getItemByVersion(this.WjIvLhV, ndLocation, string);
            return this.WjIvLjX.newItem(ndLocation, ndRmiRepositoryVirtualItem.WjIvJQL(), ndRmiRepositoryVirtualItem.WjIvJPK());
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryVersionException(remoteException);
        }
    }

    public void setRepositoryEntryFactory(NdRepositoryEntryFactory ndRepositoryEntryFactory) {
        this.WjIvLjX = ndRepositoryEntryFactory;
        try {
            this.WjIvLgU.setRepositoryEntryFactory(this.WjIvLhV, ndRepositoryEntryFactory.getClass().getName());
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryRuntimeException(remoteException);
        }
    }

    public NdRepositoryEntryLockInfo[] getEntryLockInfos(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.WjIvLmA(ndRepositoryEntryArray);
        try {
            return this.WjIvLgU.getVersionedEntryLockInfos(this.WjIvLhV, this.WjIvLmB(ndRepositoryEntryArray));
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryVersionException(remoteException);
        }
    }

    public NdRepositoryVersionHistory[][] getHistories(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.WjIvLmA(ndRepositoryEntryArray);
        try {
            return this.WjIvLgU.getHistories(this.WjIvLhV, this.WjIvLmB(ndRepositoryEntryArray));
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryVersionException(remoteException);
        }
    }

    public NdRepositoryVersionLabel[][] getLabels(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.WjIvLmA(ndRepositoryEntryArray);
        try {
            return this.WjIvLgU.getLabels(this.WjIvLhV, this.WjIvLmB(ndRepositoryEntryArray));
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryVersionException(remoteException);
        }
    }

    public NdRepositoryVersionResultSet[] getStatusInfos(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.WjIvLmA(ndRepositoryEntryArray);
        try {
            return this.WjIvLgU.getStatusInfos(this.WjIvLhV, this.WjIvLmB(ndRepositoryEntryArray));
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryVersionException(remoteException);
        }
    }

    public boolean isServerConnected() throws NdRepositoryException {
        try {
            return this.WjIvLgU.isServerConnected(this.WjIvLhV);
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryVersionException(remoteException);
        }
    }

    public void setLabel(NdRepositoryEntry[] ndRepositoryEntryArray, String string) throws NdRepositoryException {
        this.WjIvLmA(ndRepositoryEntryArray);
        try {
            this.WjIvLgU.setLabel(this.WjIvLhV, this.WjIvLmB(ndRepositoryEntryArray), string);
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryVersionException(remoteException);
        }
    }

    public void update(NdRepositoryEntry[] ndRepositoryEntryArray) throws NdRepositoryException {
        this.WjIvLmA(ndRepositoryEntryArray);
        try {
            this.WjIvLgU.update(this.WjIvLhV, this.WjIvLmB(ndRepositoryEntryArray));
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryVersionException(remoteException);
        }
    }

    public void addWorkspaceVersionManagerListener(NdWorkspaceVersionManagerListener ndWorkspaceVersionManagerListener) {
        this.WjIvLiW.addElement(ndWorkspaceVersionManagerListener);
    }

    public void removeWorkspaceVersionManagerListener(NdWorkspaceVersionManagerListener ndWorkspaceVersionManagerListener) {
        this.WjIvLiW.removeElement(ndWorkspaceVersionManagerListener);
    }

    public NdRepositoryEntryFilter getEntryFilter() {
        try {
            String string = this.WjIvLgU.getEntryFilterClass(this.WjIvLhV);
            if (string != null && string.length() > 0) {
                NdRepositoryEntryFilterFactory ndRepositoryEntryFilterFactory = new NdRepositoryEntryFilterFactory(string);
                return ndRepositoryEntryFilterFactory.newRepositoryEntryFilter();
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryRuntimeException(remoteException);
        }
    }

    public void enablePersistentConnection(boolean bl) throws NdRepositoryException {
        try {
            this.WjIvLgU.enablePersistentConnection(this.WjIvLhV, bl);
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryException(remoteException);
        }
    }

    public boolean isPersistentConnectionEnabled() {
        try {
            return this.WjIvLgU.isPersistentConnectionEnabled(this.WjIvLhV);
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryRuntimeException(remoteException);
        }
    }

    public String difference(NdRepositoryItem ndRepositoryItem, String string, String string2) throws NdRepositoryException {
        this.WjIvLlZ(ndRepositoryItem);
        try {
            return this.WjIvLgU.difference(this.WjIvLhV, NdRepositorySupport.getLocation(ndRepositoryItem), string, string2);
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryVersionException(remoteException);
        }
    }

    public boolean isFeatureSupported(int n) {
        try {
            return this.WjIvLgU.isFeatureSupported(this.WjIvLhV, n);
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryRuntimeException(remoteException);
        }
    }

    public boolean isVersioned(NdLocation ndLocation, boolean bl) throws NdRepositoryException {
        try {
            return this.WjIvLgU.isVersioned(this.WjIvLhV, ndLocation, bl);
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryException(remoteException);
        }
    }

    public void update(NdLocation ndLocation, boolean bl) throws NdRepositoryException {
        try {
            this.WjIvLgU.update(this.WjIvLhV, ndLocation, bl);
        }
        catch (RemoteException remoteException) {
            throw new NdRepositoryException(remoteException);
        }
    }

    public void openConnection() throws NdRepositoryVersionException {
        this.WjIvLhV = this.WjIvLkY.WjHBNMX();
    }

    public void closeConnection() throws NdRepositoryVersionException {
        this.WjIvLhV = null;
    }
}

