/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm;

import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.objects.dotnet.NdFile;
import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdVersioningRepositoryConnection;
import com.blazesoft.repository.config.NdRepositoryVersionManagerConfig;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.naming.NdLocationFactory;
import com.blazesoft.repository.scm.NdScmServerConnection;
import com.blazesoft.repository.scm.NdStrings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class NdScmSupport {
    public static String getWorkspacePath(NdRepository ndRepository) throws NdRepositoryException {
        try {
            String string = ((File)ndRepository.getPhysicalDescription()).getCanonicalPath();
            if (string.endsWith(File.separator)) {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
    }

    public static String getPhysicalWorkspacePath(NdRepository ndRepository) throws NdRepositoryException {
        int n;
        String string = NdScmSupport.getWorkspacePath(ndRepository);
        NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig = ndRepository.getRepositoryConfig().getRepositoryVersionManagerConfig();
        NdVersioningRepositoryConnection ndVersioningRepositoryConnection = ndRepositoryVersionManagerConfig.getVersioningRepositoryConnection();
        String string2 = null;
        String string3 = null;
        if (ndVersioningRepositoryConnection instanceof NdScmServerConnection) {
            string2 = ((NdScmServerConnection)ndVersioningRepositoryConnection).getRepositoryHomeFolder();
            string3 = ((NdScmServerConnection)ndVersioningRepositoryConnection).getRepositoryName();
        }
        if (string2 != null) {
            int n2 = string.lastIndexOf(string2 = string2.replace('/', File.separatorChar));
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
        } else if (string3 != null && (n = string.lastIndexOf(string3)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String getRepositoryPath(NdRepository ndRepository) throws NdRepositoryException {
        String string = NdScmSupport.getWorkspacePath(ndRepository);
        NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig = ndRepository.getRepositoryConfig().getRepositoryVersionManagerConfig();
        NdVersioningRepositoryConnection ndVersioningRepositoryConnection = ndRepositoryVersionManagerConfig.getVersioningRepositoryConnection();
        String string2 = ndVersioningRepositoryConnection.getRepositoryName();
        String string3 = null;
        if (ndVersioningRepositoryConnection instanceof NdScmServerConnection) {
            string3 = ((NdScmServerConnection)ndVersioningRepositoryConnection).getRepositoryHomeFolder();
        }
        if (string3 == null) {
            string3 = string;
        } else {
            int n = string.lastIndexOf(string3 = string3.replace('/', File.separatorChar));
            if (n != -1) {
                string = string.substring(0, n);
                string3 = string + string3;
            } else {
                string3 = string + string3;
            }
        }
        if (!string3.endsWith(string2) && !new File(string3, "com_blazesoft_repository_config.cfg").exists()) {
            string3 = string3 + File.separator + string2;
        }
        return string3;
    }

    public static File convertLocationToFile(String string, NdLocation ndLocation) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(((Object)ndLocation).toString());
        return new File(stringBuffer.toString());
    }

    public static File[] convertLocationsToFiles(String string, NdLocation[] ndLocationArray) {
        File[] fileArray = new File[ndLocationArray.length];
        for (int i = 0; i < ndLocationArray.length; ++i) {
            fileArray[i] = NdScmSupport.convertLocationToFile(string, ndLocationArray[i]);
        }
        return fileArray;
    }

    public static NdLocation convertFileToLocation(String string, File file) {
        File file2 = new File(string);
        Vector<String> vector = new Vector<String>();
        while (!file2.equals(file)) {
            vector.insertElementAt(file.getName(), 0);
            file = file.getParentFile();
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        if (objectArray.length != 0 && ((String)objectArray[objectArray.length - 1]).endsWith(".innovator_attbs")) {
            Object object = objectArray[objectArray.length - 1];
            int n = ".innovator_attbs".length();
            objectArray[objectArray.length - 1] = object = ((String)object).substring(0, ((String)object).length() - n);
        }
        return NdLocationFactory.createLocation((String[])objectArray, true);
    }

    public static void makeFileWritable(File file) throws IOException {
        if (file.exists() && !file.canWrite()) {
            int n;
            File file2 = file.getParentFile();
            File file3 = File.createTempFile("blaze_scm", null, file2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
            byte[] byArray = new byte[16384];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            bufferedOutputStream.close();
            NdFile ndFile = NdDotNETLib.getFileSupport().getFile(file.getAbsolutePath());
            if (!ndFile.delete()) {
                throw new IOException(NdStrings.WjIAZvM("UnableToDeleteFile", file.getCanonicalPath()));
            }
            file3.renameTo(file);
        }
    }
}

