/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm;

import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryNotSupportedException;
import com.blazesoft.repository.base.NdRepositoryVersionHistory;
import com.blazesoft.repository.base.NdRepositoryVersionLabel;
import com.blazesoft.repository.base.NdRepositoryVersionResultSet;
import com.blazesoft.repository.base.NdVersioningRepositoryConnection;
import com.blazesoft.repository.base.NdVersioningSystemEntry;
import com.blazesoft.repository.base.NdVersioningSystemVersionManager;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.scm.NdScmServerConnection;
import com.blazesoft.repository.scm.NdScmSupport;
import com.blazesoft.repository.scm.NdStrings;
import java.io.File;

public abstract class NdScmVersioningSystemVersionManager
implements NdVersioningSystemVersionManager {
    private NdScmServerConnection WjIAXPN;
    private NdRepository WjIAXPO;
    private String WjIAXPP;
    private boolean WjIAXPQ;

    public NdVersioningSystemEntry[] getServerEntries(NdLocation ndLocation) throws NdRepositoryException {
        if (!this.isEntryVersioned(ndLocation)) {
            return new NdVersioningSystemEntry[0];
        }
        return this.getServerEntriesInternal(this.convertLocationToPhysicalResource(ndLocation));
    }

    public abstract NdVersioningSystemEntry[] getServerEntriesInternal(Object var1) throws NdRepositoryException;

    public NdRepositoryVersionResultSet[] getStatusInfosInternal(Object[] objectArray) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "getStatusInfos");
    }

    public String getContent(NdLocation ndLocation) throws NdRepositoryException {
        return this.getContentInternal(this.convertLocationToPhysicalResource(ndLocation));
    }

    public abstract String getContentInternal(Object var1) throws NdRepositoryException;

    public NdRepositoryEntryAttribute[] getAttributes(NdLocation ndLocation) throws NdRepositoryException {
        return this.getAttributesInternal(this.convertLocationToPhysicalResource(ndLocation));
    }

    public abstract NdRepositoryEntryAttribute[] getAttributesInternal(Object var1) throws NdRepositoryException;

    public NdRepositoryEntryLockInfo[] getEntryLockInfos(NdLocation[] ndLocationArray) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "getEntryLockInfos");
    }

    public NdRepositoryVersionHistory[][] getHistories(NdLocation[] ndLocationArray) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "getHistories");
    }

    public NdRepositoryVersionLabel[][] getLabels(NdLocation[] ndLocationArray) throws NdRepositoryException {
        throw new NdRepositoryNotSupportedException(this.getClass(), "getLabels");
    }

    public NdRepositoryVersionResultSet[] getStatusInfos(NdLocation[] ndLocationArray) throws NdRepositoryException {
        return this.getStatusInfosInternal(ndLocationArray);
    }

    public void setRepository(NdRepository ndRepository) throws NdRepositoryException {
        this.WjIAXPO = ndRepository;
        this.WjIAXPP = this.initializeRepositoryPath(ndRepository);
    }

    public void enablePersistentConnection(boolean bl) throws NdRepositoryException {
        this.WjIAXPQ = bl;
    }

    public NdRepository getRepository() {
        return this.WjIAXPO;
    }

    public NdScmServerConnection getConnection() {
        return this.WjIAXPN;
    }

    protected String initializeRepositoryPath(NdRepository ndRepository) throws NdRepositoryException {
        return NdScmSupport.getRepositoryPath(ndRepository);
    }

    protected void initializeConnection(NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        try {
            this.WjIAXPN = (NdScmServerConnection)ndVersioningRepositoryConnection;
        }
        catch (ClassCastException classCastException) {
            throw new NdRepositoryException(NdStrings.WjIAZtK("NoScmServerConnection"));
        }
    }

    public abstract Object convertLocationToPhysicalResource(NdLocation var1) throws NdRepositoryException;

    protected File convertLocationToFile(NdLocation ndLocation) {
        return NdScmSupport.convertLocationToFile(this.WjIAXPP, ndLocation);
    }

    protected boolean isEntryVersioned(NdLocation ndLocation) throws NdRepositoryException {
        return true;
    }

    protected String getRepositoryPath() {
        return this.WjIAXPP;
    }
}

