/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm.ct;

import com.blazesoft.patterns.NdRegExMatch;
import com.blazesoft.patterns.NdRegExSyntaxException;
import com.blazesoft.patterns.NdRegularExpression;
import com.blazesoft.repository.base.NdRepositoryRuntimeException;
import com.blazesoft.repository.scm.NdDefScmCommand;
import com.blazesoft.repository.scm.ct.NdStrings;
import java.io.File;
import java.util.ArrayList;

public class NdLsCommand
extends NdDefScmCommand {
    public static String CHECKEDOUT = "CHECKEDOUT";
    public static String VIEW_PRIVATE_OBJECT = "view private object";
    private static String WjIBMbI = "@@";
    private static String WjIBMbJ = "Rule:";
    private static String WjIBxxL = "version";
    private static String WjIBxxM = "directory version";
    private static String WjIBxxN = "file element";
    private static String WjIBxxO = "directory element";
    private static String WjIBxxR = "derived object";
    private static String WjIBxxS = "derived object version";
    private static String WjIBxxT = "symbolic link";
    private static NdRegularExpression WjIBxxU;
    private static NdRegularExpression WjIBxxV;
    private static NdRegularExpression WjIBMbK;
    private File WjIBxxW;
    private String WjIBxxX;
    private boolean WjIBxxY;
    private ArrayList WjIBMbL;

    public NdLsCommand(File file, boolean bl) {
        super("ls");
        this.addArgument("-long");
        if (file.isDirectory()) {
            this.addArgument("-d");
        }
        this.WjIBxxY = bl;
        this.WjIBxxW = file;
    }

    public NdLsCommand() {
        super("ls");
        this.addArgument("-long");
    }

    public void parseOutputLine(String string) {
        FileVersionInfo fileVersionInfo = new FileVersionInfo();
        NdRegExMatch ndRegExMatch = WjIBxxV.match(string);
        if (ndRegExMatch.getMatch() != null) {
            fileVersionInfo.type = ndRegExMatch.getSubmatch(0);
            String string2 = ndRegExMatch.getSubmatch(2);
            if (fileVersionInfo.type.equals(VIEW_PRIVATE_OBJECT)) {
                fileVersionInfo.path = string2.trim();
                this.WjIBMbM(fileVersionInfo);
                return;
            }
            String string3 = null;
            String string4 = null;
            int n = string2.lastIndexOf(WjIBMbI);
            if (n != -1) {
                NdRegExMatch ndRegExMatch2;
                int n2 = string2.lastIndexOf(WjIBMbJ);
                if (n2 != -1) {
                    string2 = string2.substring(0, n2).trim();
                }
                string3 = string2.substring(0, n).trim();
                NdRegExMatch ndRegExMatch3 = WjIBMbK.match(string2 = string2.substring(n + WjIBMbI.length()).trim());
                if (ndRegExMatch3.getMatch() != null) {
                    string4 = ndRegExMatch3.getSubmatch(0).trim();
                }
                if ((ndRegExMatch2 = WjIBxxU.match(string2)).getMatch() != null) {
                    fileVersionInfo.type = CHECKEDOUT;
                }
            } else {
                string3 = string2.trim();
            }
            if (this.WjIBxxW == null) {
                fileVersionInfo.path = string3;
                fileVersionInfo.version = string4;
            }
        } else {
            fileVersionInfo.type = NdStrings.WjIBuwS("UnknownType");
        }
        this.WjIBMbM(fileVersionInfo);
    }

    public boolean getIsVersionControlled() {
        FileVersionInfo fileVersionInfo = (FileVersionInfo)this.WjIBMbL.get(0);
        return fileVersionInfo != null && fileVersionInfo.type != null && !fileVersionInfo.type.equals(VIEW_PRIVATE_OBJECT);
    }

    public boolean getIsCheckedout() {
        FileVersionInfo fileVersionInfo = (FileVersionInfo)this.WjIBMbL.get(0);
        return fileVersionInfo != null && fileVersionInfo.type != null && fileVersionInfo.type.equals(CHECKEDOUT);
    }

    public Object getResults() {
        if (this.WjIBxxW != null) {
            if (this.WjIBxxY) {
                boolean bl = this.getIsCheckedout();
                return new Boolean(bl);
            }
            boolean bl = this.getIsVersionControlled();
            return new Boolean(bl);
        }
        return this.WjIBMbL;
    }

    private void WjIBMbM(Object object) {
        if (this.WjIBMbL == null) {
            this.WjIBMbL = new ArrayList();
        }
        this.WjIBMbL.add(object);
    }

    static {
        try {
            WjIBxxU = new NdRegularExpression("(.*?\\" + File.separator + CHECKEDOUT + ")( +from +(.+?))?", null);
            WjIBxxV = new NdRegularExpression("(" + WjIBxxL + "|" + WjIBxxM + "|" + WjIBxxN + "|" + WjIBxxO + "|" + VIEW_PRIVATE_OBJECT + "|" + WjIBxxR + "|" + WjIBxxS + "|" + WjIBxxT + ")" + "( +)(.*)", null);
            WjIBMbK = new NdRegularExpression("(.*?)(\\[.*\\])", null);
        }
        catch (NdRegExSyntaxException ndRegExSyntaxException) {
            throw new NdRepositoryRuntimeException(ndRegExSyntaxException);
        }
    }

    public static class FileVersionInfo {
        public String path;
        public String version;
        public String type;
    }
}

