/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm.subversion;

import com.blazesoft.repository.base.NdDefaultRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryVersionResultSet;
import com.blazesoft.repository.scm.NdFileScmWorkspaceVersionManager;
import com.blazesoft.repository.scm.NdScmServerConnection;
import com.blazesoft.repository.scm.NdScmSupport;
import com.blazesoft.repository.scm.subversion.NdStrings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class NdSvnWorkspaceVersionManager
extends NdFileScmWorkspaceVersionManager {
    private SVNClientManager WjIBbhV;
    private DefaultSVNOptions WjIHJvN;
    private String WjIHJvO;
    private NdScmServerConnection WjISKoJ;

    public NdSvnWorkspaceVersionManager(NdRepository ndRepository) throws NdRepositoryException {
        super(ndRepository);
    }

    public void openConnection(NdScmServerConnection ndScmServerConnection) throws NdRepositoryException {
        this.WjIHJvN = SVNWCUtil.createDefaultOptions((boolean)true);
        this.WjIBbhV = SVNClientManager.newInstance((DefaultSVNOptions)this.WjIHJvN, (String)ndScmServerConnection.getUser(), (String)ndScmServerConnection.getPassword());
        this.WjISKoJ = ndScmServerConnection;
        this.WjIHJvP();
        try {
            final SVNStatus[] sVNStatusArray = new SVNStatus[1];
            ISVNStatusHandler iSVNStatusHandler = new ISVNStatusHandler(){

                public void handleStatus(SVNStatus sVNStatus) {
                    sVNStatusArray[0] = sVNStatus;
                }
            };
            this.WjIBbhV.getStatusClient().doStatus(new File(NdScmSupport.getWorkspacePath(this.getRepository()), "com_blazesoft_repository_config.cfg"), SVNRevision.HEAD, false, true, true, false, false, iSVNStatusHandler);
        }
        catch (SVNException sVNException) {
            throw new NdRepositoryException(sVNException);
        }
    }

    private void WjIHJvP() throws NdRepositoryException {
        try {
            SVNWCAccess sVNWCAccess = SVNWCAccess.newInstance(null);
            File file = new File(NdScmSupport.getWorkspacePath(this.getRepository()));
            if (file.getName().equals(this.getRepositoryName())) {
                SVNAdminArea sVNAdminArea = sVNWCAccess.probeOpen(file.getParentFile(), false, 0);
                SVNEntry sVNEntry = sVNWCAccess.getVersionedEntry(file.getParentFile(), false);
                this.WjIHJvO = sVNEntry.getURL();
                if (sVNAdminArea != null) {
                    sVNWCAccess.closeAdminArea(sVNAdminArea.getRoot());
                }
            }
        }
        catch (SVNException sVNException) {
            throw new NdRepositoryException(sVNException);
        }
    }

    public String getServerUrl() {
        return this.WjIHJvO != null ? this.WjIHJvO : super.getServerUrl();
    }

    public void closeConnection(NdScmServerConnection ndScmServerConnection) throws NdRepositoryException {
        if (this.WjIBbhV != null) {
            this.WjIBbhV.dispose();
            this.WjIBbhV = null;
        }
        this.WjIHJvO = null;
    }

    public void cancelCheckOut(File[] fileArray) throws NdRepositoryException {
        try {
            this.WjIBbhV.getWCClient().doUnlock(fileArray, false);
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) continue;
                fileArray[i].delete();
            }
            this.update(fileArray);
        }
        catch (SVNException sVNException) {
            throw new NdRepositoryException(sVNException);
        }
    }

    public void checkIn(File[] fileArray, String string) throws NdRepositoryException {
        try {
            this.WjIBbhV.getCommitClient().doCommit(fileArray, false, string, null, null, false, true, SVNDepth.fromRecurse((boolean)false));
        }
        catch (SVNException sVNException) {
            throw new NdRepositoryException(sVNException);
        }
    }

    public List doVersionControl(File[] fileArray, String string) throws NdRepositoryException {
        try {
            for (int i = 0; i < fileArray.length; ++i) {
                this.trace("doAdd: " + fileArray[i]);
                this.WjIBbhV.getWCClient().doAdd(fileArray[i], false, false, false, false);
            }
        }
        catch (SVNException sVNException) {
            throw new NdRepositoryException(sVNException);
        }
        return null;
    }

    public boolean isVersioned(File file) throws NdRepositoryException {
        this.trace("isControlled: " + file);
        try {
            if (file.isDirectory()) {
                boolean bl = SVNWCUtil.isVersionedDirectory((File)file);
                this.trace("isControlled: " + file + " " + bl);
                return bl;
            }
            SVNStatus sVNStatus = this.WjIBbhV.getStatusClient().doStatus(file, false);
            boolean bl = sVNStatus.getContentsStatus() != SVNStatusType.STATUS_UNVERSIONED;
            this.trace("isControlled: " + file + " " + bl);
            return bl;
        }
        catch (SVNException sVNException) {
            throw new NdRepositoryException(sVNException);
        }
    }

    public boolean isCheckedOut(File file) throws NdRepositoryException {
        try {
            SVNStatus sVNStatus = this.WjIBbhV.getStatusClient().doStatus(file, false);
            return sVNStatus.getLocalLock() != null;
        }
        catch (SVNException sVNException) {
            throw new NdRepositoryException(sVNException);
        }
    }

    public void checkOut(File[] fileArray) throws NdRepositoryException {
        try {
            for (int i = 0; i < fileArray.length; ++i) {
                this.trace("checkOut: " + fileArray[i]);
            }
            this.WjIBbhV.getWCClient().doLock(fileArray, false, NdStrings.WjIBbNV("CheckoutMessage", this.getUser()));
        }
        catch (SVNException sVNException) {
            this.trace("Error: " + sVNException.getMessage());
            throw new NdRepositoryException(sVNException);
        }
    }

    public void delete(File[] fileArray) throws NdRepositoryException {
        try {
            for (int i = 0; i < fileArray.length; ++i) {
                this.trace("delete: " + fileArray[i]);
                this.WjIBbhV.getWCClient().doDelete(fileArray[i], true, true, false);
            }
        }
        catch (SVNException sVNException) {
            this.trace("Error: " + sVNException.getMessage());
            throw new NdRepositoryException(sVNException);
        }
    }

    public void cancelDelete(File[] fileArray) throws NdRepositoryException {
        try {
            for (int i = 0; i < fileArray.length; ++i) {
                this.trace("cancel-delete: " + fileArray[i]);
                this.WjIBbhV.getWCClient().doRevert(fileArray[i], false);
            }
            this.WjIBbhV.getWCClient().doUnlock(fileArray, false);
        }
        catch (SVNException sVNException) {
            this.trace("Error: " + sVNException.getMessage());
            throw new NdRepositoryException(sVNException);
        }
    }

    public void getEntryLockInfos(File[] fileArray, Map map) throws NdRepositoryException {
        try {
            HashMap hashMap = this.WjIUywJ(fileArray);
            for (int i = 0; i < fileArray.length; ++i) {
                SVNStatus sVNStatus = (SVNStatus)hashMap.get(fileArray[i].getAbsolutePath());
                if (sVNStatus == null) continue;
                NdDefaultRepositoryEntryLockInfo ndDefaultRepositoryEntryLockInfo = (NdDefaultRepositoryEntryLockInfo)map.get(fileArray[i]);
                SVNLock sVNLock = sVNStatus.getLocalLock();
                SVNLock sVNLock2 = sVNStatus.getRemoteLock();
                if (sVNLock != null) {
                    ndDefaultRepositoryEntryLockInfo.setUserId(this.getUser());
                    ndDefaultRepositoryEntryLockInfo.setLockStatus(2);
                    continue;
                }
                if (sVNLock2 == null) continue;
                ndDefaultRepositoryEntryLockInfo.setUserId(sVNLock2.getOwner());
                if (this.getUser().equals(sVNLock2.getOwner())) {
                    ndDefaultRepositoryEntryLockInfo.setLockStatus(3);
                    continue;
                }
                ndDefaultRepositoryEntryLockInfo.setLockStatus(4);
            }
        }
        catch (SVNException sVNException) {
            throw new NdRepositoryException(sVNException);
        }
    }

    public void getHistories(File[] fileArray, Map map) throws NdRepositoryException {
        try {
            for (int i = 0; i < fileArray.length; ++i) {
                this.trace("history-request: " + fileArray[i]);
            }
            String[] stringArray = this.getWorkspacePaths(fileArray);
            for (int i = 0; i < stringArray.length; ++i) {
                this.trace("history-request-paths: " + stringArray[i]);
            }
            SVNURL sVNURL = SVNURL.parseURIEncoded((String)this.getServerUrl());
            this.trace("Svn URL: " + sVNURL.toString());
            final String string = this.WjISKoJ.getRepositoryName();
            final HashMap hashMap = new HashMap();
            final HashMap hashMap2 = new HashMap();
            ISVNLogEntryHandler iSVNLogEntryHandler = new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry sVNLogEntry) {
                    Set set = sVNLogEntry.getChangedPaths().keySet();
                    for (String string2 : set) {
                        int n;
                        ArrayList arrayList = null;
                        NdSvnWorkspaceVersionManager.this.trace("log-path: " + string2);
                        NdSvnWorkspaceVersionManager.this.trace("log-entry: " + sVNLogEntry.getRevision() + ": " + sVNLogEntry.getMessage());
                        if (string2.endsWith(".innovator_attbs")) {
                            n = string2.lastIndexOf(".innovator_attbs");
                            if (set.contains(string2 = string2.substring(0, n))) {
                                NdSvnWorkspaceVersionManager.this.trace("logged-skipped: " + string2);
                                continue;
                            }
                            NdSvnWorkspaceVersionManager.this.trace("logged-as: " + string2);
                        }
                        if ((n = string2.lastIndexOf("/" + string + "/")) > 0) {
                            Vector vector;
                            if (hashMap.get(string2.substring(n)) == null) {
                                vector = new Vector();
                                vector.addElement(string2.substring(0, n));
                                hashMap.put(string2.substring(n), vector);
                            } else {
                                vector = (Vector)hashMap.get(string2.substring(n));
                                if (!vector.contains(string2.substring(0, n))) {
                                    vector.addElement(string2.substring(0, n));
                                    hashMap.put(string2.substring(n), vector);
                                }
                            }
                        }
                        if (hashMap2.containsKey(string2)) {
                            arrayList = (ArrayList)hashMap2.get(string2);
                        } else {
                            arrayList = new ArrayList();
                            hashMap2.put(string2, arrayList);
                        }
                        arrayList.add(sVNLogEntry);
                    }
                }
            };
            try {
                this.WjIBbhV.getLogClient().doLog(fileArray, SVNRevision.HEAD, SVNRevision.create((long)0L), SVNRevision.HEAD, false, true, 100L, iSVNLogEntryHandler);
            }
            catch (SVNException sVNException) {
                ArrayList<SVNRevisionRange> arrayList = new ArrayList<SVNRevisionRange>(1);
                arrayList.add(new SVNRevisionRange(SVNRevision.UNDEFINED, SVNRevision.UNDEFINED));
                this.WjIBbhV.getLogClient().doLog(fileArray, arrayList, SVNRevision.UNDEFINED, false, false, false, 100L, null, iSVNLogEntryHandler);
            }
            SVNRepository sVNRepository = SVNRepositoryFactory.create((SVNURL)sVNURL, null);
            if (sVNRepository.getAuthenticationManager() == null && this.WjISKoJ != null) {
                sVNRepository.setAuthenticationManager(SVNWCUtil.createDefaultAuthenticationManager((String)this.WjISKoJ.getUser(), (String)this.WjISKoJ.getPassword()));
            }
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                this.trace("history-processing-paths: " + stringArray[i]);
                String string2 = sVNRepository.getRepositoryPath(stringArray[i]);
                if (!string2.startsWith("/")) {
                    string2 = "/" + stringArray[i];
                }
                if (!string.equals(this.getRepository().getName()) && string2.startsWith("/" + this.getRepository().getName() + "/")) {
                    string2 = string2.substring(this.getRepository().getName().length() + 1);
                }
                if (string2.indexOf("/" + this.WjISKoJ.getRepositoryName() + "/") < 0) {
                    string2 = "/" + this.WjISKoJ.getRepositoryName() + string2;
                }
                if (string2.endsWith(".innovator_attbs")) {
                    int n = string2.lastIndexOf(".innovator_attbs");
                    string2 = string2.substring(0, n);
                }
                Object[] objectArray = new String[1];
                String string3 = string2;
                int n = string3.lastIndexOf("/" + string + "/");
                if (n > 0) {
                    string3 = string3.substring(n);
                }
                if (!hashMap.isEmpty() && hashMap.get(string3) != null) {
                    object = (Vector)hashMap.get(string3);
                    objectArray = new String[((Vector)object).size()];
                    ((Vector)object).copyInto(objectArray);
                }
                object = string3;
                for (int j = 0; j < objectArray.length; ++j) {
                    if (objectArray[j] != null) {
                        object = (String)objectArray[j] + string3;
                    }
                    ArrayList arrayList = (ArrayList)hashMap2.get(object);
                    ArrayList arrayList2 = (ArrayList)map.get(fileArray[i]);
                    if (arrayList != null && arrayList2 != null) {
                        this.trace("history-found-matches: ");
                        for (SVNLogEntry sVNLogEntry : arrayList) {
                            SVNLogEntryPath sVNLogEntryPath = (SVNLogEntryPath)sVNLogEntry.getChangedPaths().get(object);
                            if (sVNLogEntryPath == null) {
                                String string4 = (String)object + ".innovator_attbs";
                                sVNLogEntryPath = (SVNLogEntryPath)sVNLogEntry.getChangedPaths().get(string4);
                            }
                            char c = sVNLogEntryPath.getType();
                            arrayList2.add(0, this.createVersionHistory("" + sVNLogEntry.getRevision(), sVNLogEntry.getAuthor(), sVNLogEntry.getDate(), sVNLogEntry.getMessage(), c == 'D'));
                        }
                        continue;
                    }
                    this.trace("history-no-match: '" + arrayList + "':'" + arrayList2);
                }
            }
        }
        catch (SVNException sVNException) {
            throw new NdRepositoryException(sVNException);
        }
    }

    HashMap WjIUywJ(File[] fileArray) throws SVNException {
        Object[] objectArray;
        final HashMap hashMap = new HashMap();
        if (fileArray.length == 1) {
            objectArray = new File[]{fileArray[0]};
        } else {
            Vector<File> vector = new Vector<File>();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    if (vector.contains(fileArray[i])) continue;
                    vector.addElement(fileArray[i]);
                    continue;
                }
                if (vector.contains(fileArray[i].getParentFile())) continue;
                vector.addElement(fileArray[i].getParentFile());
            }
            objectArray = new File[vector.size()];
            vector.copyInto(objectArray);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ISVNStatusHandler iSVNStatusHandler = new ISVNStatusHandler(){

                public void handleStatus(SVNStatus sVNStatus) {
                    if (hashMap.get(sVNStatus.getFile().getAbsolutePath()) == null) {
                        hashMap.put(sVNStatus.getFile().getAbsolutePath(), sVNStatus);
                    }
                }
            };
            this.WjIBbhV.getStatusClient().doStatus((File)objectArray[i], SVNRevision.HEAD, true, true, true, false, false, iSVNStatusHandler);
        }
        return hashMap;
    }

    public void getStatusInfos(File[] fileArray, Map map) throws NdRepositoryException {
        try {
            HashMap hashMap = this.WjIUywJ(fileArray);
            for (int i = 0; i < fileArray.length; ++i) {
                SVNStatus sVNStatus = (SVNStatus)hashMap.get(fileArray[i].getAbsolutePath());
                if (sVNStatus == null) continue;
                NdRepositoryVersionResultSet ndRepositoryVersionResultSet = (NdRepositoryVersionResultSet)map.get(fileArray[i]);
                SVNLock sVNLock = sVNStatus.getLocalLock();
                SVNStatusType sVNStatusType = sVNStatus.getContentsStatus();
                SVNStatusType sVNStatusType2 = sVNStatus.getRemoteContentsStatus();
                if (sVNLock != null) {
                    if (sVNStatusType == SVNStatusType.STATUS_MODIFIED) {
                        ndRepositoryVersionResultSet.setVersionStatus(this.belongsToThisUser(this.lookupEntry(ndRepositoryVersionResultSet.getLocation())) ? 3 : 4);
                    } else if (sVNStatusType == SVNStatusType.STATUS_NORMAL) {
                        ndRepositoryVersionResultSet.setVersionStatus(5);
                    }
                    ndRepositoryVersionResultSet.setCurrentVersionId("" + sVNStatus.getCommittedRevision().getNumber());
                    ndRepositoryVersionResultSet.setWorkingVersionId(ndRepositoryVersionResultSet.getCurrentVersionId());
                    continue;
                }
                if (sVNStatusType == SVNStatusType.STATUS_ADDED) {
                    ndRepositoryVersionResultSet.setVersionStatus(this.belongsToThisUser(this.lookupEntry(ndRepositoryVersionResultSet.getLocation())) ? 1 : 2);
                    continue;
                }
                ndRepositoryVersionResultSet.setWorkingVersionId("" + sVNStatus.getCommittedRevision().getNumber());
                if (sVNStatusType2 == SVNStatusType.STATUS_MODIFIED) {
                    ndRepositoryVersionResultSet.setVersionStatus(7);
                    ndRepositoryVersionResultSet.setCurrentVersionId("" + sVNStatus.getRemoteRevision().getNumber());
                    continue;
                }
                if (sVNStatusType2 == SVNStatusType.STATUS_DELETED) {
                    if (sVNStatusType == SVNStatusType.STATUS_NORMAL) {
                        ndRepositoryVersionResultSet.setVersionStatus(7);
                    }
                    ndRepositoryVersionResultSet.setCurrentVersionId("" + sVNStatus.getRemoteRevision().getNumber());
                    ndRepositoryVersionResultSet.setGloballyDeleted(true);
                    continue;
                }
                ndRepositoryVersionResultSet.setVersionStatus(5);
                ndRepositoryVersionResultSet.setCurrentVersionId(ndRepositoryVersionResultSet.getWorkingVersionId());
            }
        }
        catch (SVNException sVNException) {
            throw new NdRepositoryException(sVNException);
        }
    }

    public void update(File[] fileArray) throws NdRepositoryException {
        try {
            for (int i = 0; i < fileArray.length; ++i) {
                long l = this.WjIBbhV.getUpdateClient().doUpdate(fileArray[i], SVNRevision.HEAD, SVNDepth.fromRecurse((boolean)true), false, true);
                this.trace("update: " + fileArray[i].getName() + " to revision: " + l);
            }
        }
        catch (SVNException sVNException) {
            throw new NdRepositoryException(sVNException);
        }
    }

    public void updateLocation(File file, boolean bl) throws NdRepositoryException {
        try {
            this.trace("updateFileLocation: " + file.getPath());
            if (!file.getParentFile().exists()) {
                this.updateLocation(file.getParentFile(), false);
            }
            this.WjIBbhV.getUpdateClient().doUpdate(file, SVNRevision.HEAD, SVNDepth.fromRecurse((boolean)bl), true, true);
        }
        catch (SVNException sVNException) {
            throw new NdRepositoryException(sVNException);
        }
    }

    public String getContentByVersion(File file, String string) throws NdRepositoryException, IOException {
        try {
            long l = new Long(string);
            SVNRevision sVNRevision = SVNRevision.create((long)l);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.WjIBbhV.getWCClient().doGetFileContents(file, SVNRevision.HEAD, sVNRevision, true, (OutputStream)byteArrayOutputStream);
            return new String(byteArrayOutputStream.toByteArray(), "UTF8");
        }
        catch (SVNException sVNException) {
            throw new NdRepositoryException(sVNException);
        }
    }

    static {
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        DAVRepositoryFactory.setup();
    }
}

