/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm.wvcm;

import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.scm.NdScmServerConnection;
import com.blazesoft.repository.scm.wvcm.NdWvcmSupport;
import com.blazesoft.repository.scm.wvcm.NdWvcmVersioningSystemVersionManager;
import java.io.File;
import javax.wvcm.Location;
import javax.wvcm.Resource;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

public class NdFileWvcmVersioningSystemVersionManager
extends NdWvcmVersioningSystemVersionManager {
    public NdFileWvcmVersioningSystemVersionManager(NdScmServerConnection ndScmServerConnection) throws NdRepositoryException {
        super(ndScmServerConnection);
    }

    public Object convertLocationToPhysicalResource(NdLocation ndLocation) throws NdRepositoryException {
        File file = this.convertLocationToFile(ndLocation);
        return this.createFileProxy(file);
    }

    protected Resource createFileProxy(File file) throws NdRepositoryException {
        try {
            return this.createProxy(file);
        }
        catch (WvcmException wvcmException) {
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected Resource createProxy(File file) throws WvcmException {
        Object object = null;
        WorkspaceProvider workspaceProvider = this.createWorkspaceProvider(this.getConnection());
        object = file.isDirectory() ? workspaceProvider.controllableFolder(this.fileToLocation(workspaceProvider, file)) : workspaceProvider.controllableResource(this.fileToLocation(workspaceProvider, file));
        return object;
    }

    protected Location pathToLocation(WorkspaceProvider workspaceProvider, String string) throws WvcmException {
        String string2 = string;
        return workspaceProvider.rootLocation();
    }

    protected Location fileToLocation(WorkspaceProvider workspaceProvider, File file) throws WvcmException {
        return this.pathToLocation(workspaceProvider, file.getAbsolutePath());
    }

    protected WorkspaceProvider createWorkspaceProvider(NdScmServerConnection ndScmServerConnection) throws WvcmException {
        return NdWvcmSupport.getWorkspaceProvider(ndScmServerConnection);
    }
}

