/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm.wvcm;

import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.file.NdFileRepository;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.scm.wvcm.NdStrings;
import com.blazesoft.repository.scm.wvcm.NdWvcmWorkspaceVersionManager;
import java.io.File;
import javax.wvcm.Location;
import javax.wvcm.Resource;
import javax.wvcm.Workspace;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

public class NdFileWvcmWorkspaceVersionManager
extends NdWvcmWorkspaceVersionManager {
    private static final String WjIAVJP = "file://";

    public NdFileWvcmWorkspaceVersionManager(NdRepository ndRepository) throws NdRepositoryException {
        super(ndRepository);
    }

    protected String initializeRepositoryPath(NdRepository ndRepository) throws NdRepositoryException {
        NdRepository ndRepository2 = ndRepository;
        if (ndRepository instanceof NdWorkspace) {
            ndRepository2 = (NdRepository)((NdWorkspace)ndRepository).getPhysicalRepositoryEntry();
        }
        if (ndRepository2 instanceof NdFileRepository) {
            return ((File)ndRepository2.getPhysicalDescription()).getPath();
        }
        return super.initializeRepositoryPath(ndRepository);
    }

    public Object convertEntryToPhysicalResource(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        File file = this.convertLocationToFile(NdRepositorySupport.getLocation(ndRepositoryEntry));
        return this.createFileProxy(file);
    }

    public Object convertAttributesToPhysicalResource(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        File file = this.convertLocationToFile(NdRepositorySupport.getLocation(ndRepositoryEntry));
        File file2 = new File(file.getParentFile(), ndRepositoryEntry.getName() + ".innovator_attbs");
        return this.createFileProxy(file2);
    }

    public Object convertLocationToPhysicalResource(NdLocation ndLocation) throws NdRepositoryException {
        File file = this.convertLocationToFile(ndLocation);
        return this.createFileProxy(file);
    }

    protected Resource createFileProxy(File file) throws NdRepositoryException {
        try {
            if (this.WjIATtL() == null) {
                throw new NdRepositoryException(NdStrings.WjIAVQC("NotConnected"));
            }
            return this.createProxy(file);
        }
        catch (WvcmException wvcmException) {
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected Resource createProxy(File file) throws WvcmException {
        this.trace("createProxy: " + file);
        Object object = null;
        object = file.isDirectory() ? this.WjIATtL().controllableFolder(this.fileToLocation(file)) : this.WjIATtL().controllableResource(this.fileToLocation(file));
        this.trace("Proxy: ", (Resource)object);
        return object;
    }

    public Workspace createWorkspaceProxy(WorkspaceProvider workspaceProvider, String string) throws WvcmException {
        this.trace("ROOTPath: " + string);
        Location location = this.pathToLocation(string);
        this.trace("ROOTLocation: " + location.toString());
        Workspace workspace = workspaceProvider.workspace(location);
        return workspace;
    }

    protected Location pathToLocation(String string) throws WvcmException {
        String string2 = string;
        return this.WjIATtL().location(string2.replace('\\', '/'));
    }

    protected Location fileToLocation(File file) throws WvcmException {
        return this.pathToLocation(file.getAbsolutePath());
    }
}

