/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm.wvcm;

import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryEntryAlreadyExistsException;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryEntryAttributeProvider;
import com.blazesoft.repository.base.NdRepositoryEntryException;
import com.blazesoft.repository.base.NdRepositoryEntryNotFoundException;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.scm.wvcm.NdStrings;
import com.blazesoft.repository.scm.wvcm.NdWvcmRepositoryEntry;
import com.blazesoft.repository.scm.wvcm.NdWvcmRepositoryItem;
import com.blazesoft.util.NdProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.Resource;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

public class NdWvcmRepositoryDirectory
extends NdWvcmRepositoryEntry
implements NdRepositoryDirectory {
    private static final NdRepositoryEntryAttribute[] WjIATTX = new NdRepositoryEntryAttribute[0];

    NdWvcmRepositoryDirectory(NdWvcmRepositoryDirectory ndWvcmRepositoryDirectory, String string, ControllableResource controllableResource) throws NdRepositoryException {
        super(ndWvcmRepositoryDirectory, string, controllableResource);
    }

    NdWvcmRepositoryDirectory() {
    }

    public NdRepositoryEntry[] getRepositoryEntries() throws NdRepositoryException {
        Object[] objectArray;
        try {
            this.WjIAWSM(this.getResource());
            Set set = ((Folder)this.getResource()).getChildMap().keySet();
            Vector<NdRepositoryEntry> vector = new Vector<NdRepositoryEntry>();
            if (!set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    NdRepositoryEntry ndRepositoryEntry;
                    String string = (String)iterator.next();
                    if (string.startsWith(".") || string.endsWith(".innovator_attbs") || (ndRepositoryEntry = this.WjIATTY(string)) == null) continue;
                    vector.addElement(ndRepositoryEntry);
                }
                objectArray = new NdRepositoryEntry[vector.size()];
                if (vector.size() > 0) {
                    vector.copyInto(objectArray);
                }
            } else {
                objectArray = new NdRepositoryEntry[]{};
            }
        }
        catch (Exception exception) {
            throw new NdRepositoryEntryException(NdStrings.WjIAVSE("CouldNotListFiles", this.getName()), this, exception);
        }
        return objectArray;
    }

    public NdRepositoryDirectory createRepositoryDirectory(String string) throws NdRepositoryException {
        return new NdWvcmRepositoryDirectory(this, string, null);
    }

    public void addRepositoryDirectory(NdRepositoryDirectory ndRepositoryDirectory, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        try {
            Folder folder = (Folder)this.getResource();
            if (folder.getChildMap().containsKey(ndRepositoryDirectory.getName())) {
                throw new NdRepositoryEntryAlreadyExistsException(NdStrings.WjIAVTF("EntryAlreadyExist", ndRepositoryDirectory.getName(), this.getName()));
            }
            ControllableFolder controllableFolder = (ControllableFolder)((NdWvcmRepositoryDirectory)ndRepositoryDirectory).getResource();
            if (controllableFolder == null) {
                WorkspaceProvider workspaceProvider = (WorkspaceProvider)this.getResource().provider();
                Location location = this.getResource().location();
                controllableFolder = workspaceProvider.controllableFolder(location.child(ndRepositoryDirectory.getName()));
            }
            controllableFolder = (ControllableFolder)controllableFolder.doCreateResource(null);
            ((NdWvcmRepositoryDirectory)ndRepositoryDirectory).WjIAWSM((ControllableResource)controllableFolder);
            this.WjIAWSM(this.getResource());
            this.saveEntryAttributes(ndRepositoryDirectory, ndRepositoryEntryAttributeArray);
        }
        catch (Exception exception) {
            throw new NdRepositoryEntryException(NdStrings.WjIAVSE("CouldNotCreateDirectory", ndRepositoryDirectory.getName()), this, exception);
        }
    }

    public void removeRepositoryDirectory(NdRepositoryDirectory ndRepositoryDirectory) throws NdRepositoryException {
        ControllableFolder controllableFolder = (ControllableFolder)this.getResource();
        try {
            if (!controllableFolder.getChildMap().containsKey(ndRepositoryDirectory.getName())) {
                throw new NdRepositoryEntryNotFoundException(NdRepositorySupport.getLocation(this).appendExternalComponent(ndRepositoryDirectory.getName()));
            }
            controllableFolder.doUnbindChild(ndRepositoryDirectory.getName(), null);
            controllableFolder.doUnbindChild(ndRepositoryDirectory.getName() + ".innovator_attbs", null);
            ((NdWvcmRepositoryDirectory)ndRepositoryDirectory).WjIAWSM(null);
            this.WjIAWSM(this.getResource());
        }
        catch (Exception exception) {
            throw new NdRepositoryEntryException(NdStrings.WjIAVSE("CouldNotRemoveDirectory", ndRepositoryDirectory.getName()), this, exception);
        }
    }

    public NdRepositoryItem createRepositoryItem(String string) throws NdRepositoryException {
        return new NdWvcmRepositoryItem(this, string, null);
    }

    public void addRepositoryItem(NdRepositoryItem ndRepositoryItem, NdRepositoryItemContent ndRepositoryItemContent, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        try {
            Object object;
            Object object2;
            Folder folder = (Folder)this.getResource();
            if (folder.getChildMap().containsKey(ndRepositoryItem.getName())) {
                throw new NdRepositoryEntryAlreadyExistsException(NdStrings.WjIAVTF("EntryAlreadyExist", ndRepositoryItem.getName(), this.getName()));
            }
            ControllableResource controllableResource = ((NdWvcmRepositoryItem)ndRepositoryItem).getResource();
            if (controllableResource == null) {
                object2 = (WorkspaceProvider)this.getResource().provider();
                object = this.getResource().location();
                controllableResource = object2.controllableResource(object.child(ndRepositoryItem.getName()));
            }
            controllableResource.doCreateResource(null);
            ((NdWvcmRepositoryItem)ndRepositoryItem).WjIAWSM(controllableResource);
            this.WjIAWSM(this.getResource());
            object2 = ndRepositoryItemContent.getRawData();
            object = new ByteArrayInputStream((byte[])object2);
            controllableResource.doWriteContent((InputStream)object, ndRepositoryItem.getName(), null);
            this.saveEntryAttributes(ndRepositoryItem, ndRepositoryEntryAttributeArray);
        }
        catch (Exception exception) {
            throw new NdRepositoryEntryException(NdStrings.WjIAVSE("CouldNotCreateFile", ndRepositoryItem.getName()), this, exception);
        }
    }

    public void removeRepositoryItem(NdRepositoryItem ndRepositoryItem) throws NdRepositoryException {
        try {
            Folder folder = (Folder)this.getResource();
            if (!folder.getChildMap().containsKey(ndRepositoryItem.getName())) {
                throw new NdRepositoryEntryNotFoundException(NdRepositorySupport.getLocation(this).appendExternalComponent(ndRepositoryItem.getName()));
            }
            folder.doUnbindChild(ndRepositoryItem.getName(), null);
            folder.doUnbindChild(ndRepositoryItem.getName() + ".innovator_attbs", null);
            ((NdWvcmRepositoryItem)ndRepositoryItem).WjIAWSM(null);
            this.WjIAWSM(this.getResource());
        }
        catch (Exception exception) {
            throw new NdRepositoryEntryException(NdStrings.WjIAVSE("CouldNotRemoveFile", ndRepositoryItem.getName()), this, exception);
        }
    }

    public NdRepositoryEntryAttribute[] getRepositoryEntryAttributes(NdRepositoryEntry ndRepositoryEntry) throws NdRepositoryException {
        if (ndRepositoryEntry instanceof NdRepositoryEntryAttributeProvider) {
            return ((NdRepositoryEntryAttributeProvider)((Object)ndRepositoryEntry)).getRepositoryEntryAttributes(null);
        }
        return this.loadEntryAttributes(ndRepositoryEntry, null);
    }

    public void setRepositoryEntryAttributes(NdRepositoryEntry ndRepositoryEntry, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        this.saveEntryAttributes(ndRepositoryEntry, ndRepositoryEntryAttributeArray);
    }

    public NdRepositoryEntry lookupRepositoryEntry(String string) throws NdRepositoryException {
        this.WjIAWSM(this.getResource());
        return this.WjIATTY(string);
    }

    NdRepositoryEntry WjIATTY(String string) throws NdRepositoryException {
        try {
            Folder folder = (Folder)this.getResource();
            Map map = folder.getChildMap();
            Resource resource = (Resource)map.get(string);
            if (resource == null) {
                return null;
            }
            NdWvcmRepositoryEntry ndWvcmRepositoryEntry = null;
            Resource resource2 = (Resource)map.get(string + ".innovator_attbs");
            if (resource instanceof ControllableFolder) {
                ndWvcmRepositoryEntry = new NdWvcmRepositoryDirectory(this, string, (ControllableResource)resource);
            } else if (resource instanceof ControllableResource) {
                ndWvcmRepositoryEntry = new NdWvcmRepositoryItem(this, string, (ControllableResource)resource);
            }
            if (ndWvcmRepositoryEntry != null && resource2 != null) {
                ndWvcmRepositoryEntry.WjIAWTN((ControllableResource)resource2);
            }
            return ndWvcmRepositoryEntry;
        }
        catch (WvcmException wvcmException) {
            return null;
        }
    }

    protected void saveEntryAttributes(NdRepositoryEntry ndRepositoryEntry, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        try {
            String string;
            int n;
            Object object;
            WorkspaceProvider workspaceProvider;
            ControllableResource controllableResource = ((NdWvcmRepositoryEntry)ndRepositoryEntry).getAttributeResource();
            if (controllableResource == null) {
                workspaceProvider = (WorkspaceProvider)this.getResource().provider();
                object = this.getResource().location();
                controllableResource = workspaceProvider.controllableResource(object.child(ndRepositoryEntry.getName() + ".innovator_attbs"));
                controllableResource.doCreateResource(null);
                this.WjIAWSM(this.getResource());
                ((NdWvcmRepositoryEntry)ndRepositoryEntry).WjIAWTN(controllableResource);
            }
            if (ndRepositoryEntryAttributeArray == null || ndRepositoryEntryAttributeArray.length == 0) {
                return;
            }
            workspaceProvider = new NdProperties();
            object = new ByteArrayOutputStream();
            controllableResource.doReadContent((OutputStream)object, null);
            byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            workspaceProvider.load((InputStream)byteArrayInputStream);
            for (n = 0; n < ndRepositoryEntryAttributeArray.length; ++n) {
                if (ndRepositoryEntryAttributeArray[n] == null || (string = ndRepositoryEntryAttributeArray[n].getAttbValue()) != null) continue;
                workspaceProvider.remove((Object)ndRepositoryEntryAttributeArray[n].getAttbId());
            }
            for (n = 0; n < ndRepositoryEntryAttributeArray.length; ++n) {
                if (ndRepositoryEntryAttributeArray[n] == null || (string = ndRepositoryEntryAttributeArray[n].getAttbValue()) == null) continue;
                workspaceProvider.put((Object)ndRepositoryEntryAttributeArray[n].getAttbId(), (Object)string);
            }
            object = new ByteArrayOutputStream();
            workspaceProvider.save((OutputStream)object, NdStrings.WjIAVSE("AttbsFileHeader", ndRepositoryEntry.getName()));
            byArray = ((ByteArrayOutputStream)object).toByteArray();
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            controllableResource.doWriteContent((InputStream)byteArrayInputStream, null, null);
        }
        catch (WvcmException wvcmException) {
            throw new NdRepositoryEntryException(NdStrings.WjIAVTF("CouldNotSaveEntryAttbsInAttbsFile", ndRepositoryEntry.getName(), this.getName()), this, wvcmException);
        }
        catch (IOException iOException) {
            throw new NdRepositoryEntryException(NdStrings.WjIAVTF("CouldNotSaveEntryAttbsInAttbsFile", ndRepositoryEntry.getName(), this.getName()), this, iOException);
        }
    }

    protected NdRepositoryEntryAttribute[] loadEntryAttributes(NdRepositoryEntry ndRepositoryEntry, String[] stringArray) throws NdRepositoryException {
        Object[] objectArray;
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>();
        try {
            objectArray = ((NdWvcmRepositoryEntry)ndRepositoryEntry).getAttributeResource();
            if (objectArray == null) {
                return new NdRepositoryEntryAttribute[0];
            }
            NdProperties ndProperties = new NdProperties();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objectArray.doReadContent((OutputStream)byteArrayOutputStream, null);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ndProperties.load((InputStream)byteArrayInputStream);
            if (stringArray == null) {
                Enumeration enumeration = ndProperties.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    vector.addElement(new NdRepositoryEntryAttribute(string, (String)ndProperties.get((Object)string)));
                }
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = (String)ndProperties.get((Object)stringArray[i]);
                    vector.addElement(new NdRepositoryEntryAttribute(stringArray[i], string));
                }
            }
        }
        catch (WvcmException wvcmException) {
            throw new NdRepositoryEntryException(NdStrings.WjIAVTF("CouldNotLoadEntryAttbsInAttbsFile", ndRepositoryEntry.getName(), this.getName()), this, wvcmException);
        }
        catch (IOException iOException) {
            throw new NdRepositoryEntryException(NdStrings.WjIAVTF("CouldNotLoadEntryAttbsInAttbsFile", ndRepositoryEntry.getName(), this.getName()), this, iOException);
        }
        objectArray = new NdRepositoryEntryAttribute[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

