/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm.wvcm;

import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.scm.NdScmServerConnection;
import com.blazesoft.repository.scm.wvcm.NdStrings;
import com.blazesoft.repository.scm.wvcm.NdWvcmRepositoryConnection;
import javax.wvcm.ProviderFactory;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

public class NdWvcmSupport {
    public static ProviderFactory.Callback createProviderCallback(final NdRepositoryConnection ndRepositoryConnection) {
        ProviderFactory.Callback callback = new ProviderFactory.Callback(){

            public ProviderFactory.Callback.Authentication getAuthentication(String string, int n) {
                if (n > 0) {
                    throw new IllegalAccessError(NdStrings.WjIAVSE("AccessFailure", string));
                }
                return new WjIAVZY(new String[]{ndRepositoryConnection.getUser(), ndRepositoryConnection.getPassword()});
            }
        };
        return callback;
    }

    public static WorkspaceProvider getWorkspaceProvider(NdScmServerConnection ndScmServerConnection) throws WvcmException {
        try {
            ProviderFactory.Callback callback = NdWvcmSupport.createProviderCallback(ndScmServerConnection);
            return (WorkspaceProvider)ProviderFactory.createProvider((String)ndScmServerConnection.getScmProvider(), (ProviderFactory.Callback)callback);
        }
        catch (Exception exception) {
            throw new WvcmException(exception.getMessage(), null, WvcmException.ReasonCode.NOT_FOUND, (Throwable)exception);
        }
    }

    public static WorkspaceProvider getWorkspaceProvider(NdWvcmRepositoryConnection ndWvcmRepositoryConnection) throws WvcmException {
        try {
            ProviderFactory.Callback callback = NdWvcmSupport.createProviderCallback(ndWvcmRepositoryConnection);
            return (WorkspaceProvider)ProviderFactory.createProvider((String)ndWvcmRepositoryConnection.getWorkspaceProvider(), (ProviderFactory.Callback)callback);
        }
        catch (Exception exception) {
            throw new WvcmException(exception.getMessage(), null, WvcmException.ReasonCode.NOT_FOUND, (Throwable)exception);
        }
    }

    static class WjIAVZY
    implements ProviderFactory.Callback.Authentication {
        private String[] WjIAVYX;

        WjIAVZY(String[] stringArray) {
            this.WjIAVYX = stringArray;
        }

        public String loginName() {
            return this.WjIAVYX[0];
        }

        public String password() {
            return this.WjIAVYX.length > 1 ? this.WjIAVYX[1] : "";
        }
    }
}

