/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm.wvcm;

import com.blazesoft.repository.base.NdCredentialsProvider;
import com.blazesoft.repository.base.NdRepositoryAuthorizationManager;
import com.blazesoft.repository.base.NdRepositoryDefaultAuthorizationManager;
import com.blazesoft.repository.base.NdRepositoryEntryFilter;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryExplicitLockManager;
import com.blazesoft.repository.base.NdRepositoryImplicitLockManager;
import com.blazesoft.repository.base.NdRepositoryVersionSystemAdmin;
import com.blazesoft.repository.base.NdVersioningRepositoryConnection;
import com.blazesoft.repository.base.NdVersioningSystemVersionManager;
import com.blazesoft.repository.base.NdWorkspaceConnection;
import com.blazesoft.repository.base.NdWorkspaceListener;
import com.blazesoft.repository.base.NdWorkspaceVersionManager;
import com.blazesoft.repository.config.NdRepositoryConfig;
import com.blazesoft.repository.config.NdRepositoryVersionManagerConfig;
import com.blazesoft.repository.config.NdRepositoryVersionManagerFactory;
import com.blazesoft.repository.local.NdLocalRepository;
import com.blazesoft.repository.scm.NdScmServerConnection;
import com.blazesoft.repository.scm.NdScmVersionSystemAdmin;
import com.blazesoft.repository.scm.NdScmWorkspaceVersionManager;
import com.blazesoft.repository.scm.wvcm.NdStrings;
import com.blazesoft.repository.scm.wvcm.NdWvcmRepository;
import com.blazesoft.repository.scm.wvcm.NdWvcmRepositoryConnection;
import com.blazesoft.repository.scm.wvcm.NdWvcmSupport;
import com.blazesoft.repository.scm.wvcm.NdWvcmWorkspaceVersionManager;
import java.util.Iterator;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.Feedback;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Stream;
import javax.wvcm.Workspace;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

public class NdWvcmVersionSystemAdmin
extends NdScmVersionSystemAdmin {
    protected String createTemporaryWorkspaceLocation(NdScmServerConnection ndScmServerConnection) throws NdRepositoryException {
        try {
            WorkspaceProvider workspaceProvider = null;
            Location location = null;
            Location location2 = null;
            Object var5_6 = null;
            workspaceProvider = this.getWorkspaceProvider(ndScmServerConnection);
            location = workspaceProvider.rootLocation();
            location2 = location.child("ws-temp");
            return location2.string();
        }
        catch (WvcmException wvcmException) {
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected void cleanUpTemporaryWorkspace(String string) throws NdRepositoryException {
    }

    protected NdWorkspaceConnection createWorkspaceConnection(String string, String string2, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        try {
            WorkspaceProvider workspaceProvider = this.getWorkspaceProvider((NdScmServerConnection)ndVersioningRepositoryConnection);
            Location location = workspaceProvider.location(string);
            Workspace workspace = workspaceProvider.workspace(location);
            NdWorkspaceConnection ndWorkspaceConnection = this.createWvcmWorkspaceConnection(location, string2, ndVersioningRepositoryConnection);
            ((NdWvcmRepositoryConnection)ndWorkspaceConnection).setWorkspace(workspace);
            return ndWorkspaceConnection;
        }
        catch (WvcmException wvcmException) {
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected NdWorkspaceConnection createWorkspaceConnection(NdWorkspaceConnection ndWorkspaceConnection, String string, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        String string2 = ((NdWvcmRepositoryConnection)ndWorkspaceConnection).getWorkspaceFolder();
        return this.createWorkspaceConnection(string2, string, ndVersioningRepositoryConnection);
    }

    protected NdScmWorkspaceVersionManager createWorkspace(NdWorkspaceConnection ndWorkspaceConnection, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        try {
            return this.createWvcmWorkspace(ndWorkspaceConnection, ndVersioningRepositoryConnection);
        }
        catch (WvcmException wvcmException) {
            throw new NdRepositoryException(wvcmException);
        }
    }

    protected void updateWvcmRepositoryHomeFolder(Workspace workspace, String string) throws WvcmException {
        Stream stream = workspace.getStream();
        if (stream != null) {
            this.trace("Retrieved stream:", (Resource)stream);
            ResourceList resourceList = (ResourceList)this.readProperty((Resource)stream, Stream.VERSION_LIST);
            this.trace("Versions: " + resourceList.size());
            this.trace("Versions: " + resourceList);
            workspace.doUpdate(resourceList, null);
            ResourceList resourceList2 = workspace.provider().resourceList();
            resourceList2.add((Object)stream);
            workspace.doUpdate(resourceList2, null);
            this.browse("after-update", (Folder)workspace);
        }
    }

    protected NdScmWorkspaceVersionManager createWvcmWorkspace(NdWorkspaceConnection ndWorkspaceConnection, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException, WvcmException {
        NdWvcmWorkspaceVersionManager ndWvcmWorkspaceVersionManager;
        Location location;
        NdScmServerConnection ndScmServerConnection = null;
        try {
            ndScmServerConnection = (NdScmServerConnection)ndVersioningRepositoryConnection;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (ndScmServerConnection == null) {
            throw new NdRepositoryException(NdStrings.WjIAVQC("InvalidRepositoryConnection"));
        }
        String string = ndScmServerConnection.getRepositoryHomeFolder();
        String string2 = ndScmServerConnection.getRepositoryName();
        if (string2 == null || string2.length() == 0) {
            throw new NdRepositoryException(NdStrings.WjIAVQC("NoRepositoryNameSpecified"));
        }
        WorkspaceProvider workspaceProvider = this.getWorkspaceProvider(ndScmServerConnection);
        Location location2 = workspaceProvider.rootLocation();
        Workspace workspace = null;
        Location location3 = null;
        if (ndScmServerConnection.getWorkspaceFolder() != null) {
            location3 = workspaceProvider.location(((NdWvcmRepositoryConnection)ndWorkspaceConnection).getWorkspaceFolder());
        } else {
            location3 = workspaceProvider.location(((NdWvcmRepositoryConnection)ndWorkspaceConnection).getWorkspaceFolder());
            workspace = ((NdWvcmRepositoryConnection)ndWorkspaceConnection).getWorkspace();
            this.trace("ExtWorkspace: ", (Resource)workspace);
            if (workspace == null) {
                workspace = workspaceProvider.workspace(location3);
            }
            this.trace("CreateWorkspace: ", (Resource)workspace);
            location = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Workspace.STREAM});
            ndWvcmWorkspaceVersionManager = workspaceProvider.stream(workspaceProvider.rootLocation().child("act").child("trunk"));
            this.trace("Branch: ", (Resource)ndWvcmWorkspaceVersionManager);
            Stream stream = (Stream)ndWvcmWorkspaceVersionManager.doFind(null);
            if (stream == null) {
                try {
                    ndWvcmWorkspaceVersionManager = (Stream)ndWvcmWorkspaceVersionManager.doCreateResource(null);
                }
                catch (WvcmException wvcmException) {
                    this.trace("BranchExp: " + wvcmException.getMessage());
                }
            } else {
                ndWvcmWorkspaceVersionManager = stream;
                this.trace("Existing branch: ", (Resource)ndWvcmWorkspaceVersionManager);
            }
            workspace.setStream((Stream)ndWvcmWorkspaceVersionManager);
            workspace = workspace.doCreateGeneratedResource((Feedback)location);
            ((NdWvcmRepositoryConnection)ndWorkspaceConnection).setWorkspace(workspace);
            this.trace("CreatedWorkspace: ", (Resource)workspace);
            ControllableFolder controllableFolder = this.getWorkspaceRoot(workspace);
            ResourceList resourceList = (ResourceList)this.readProperty((Resource)ndWvcmWorkspaceVersionManager, Stream.VERSION_LIST);
            this.trace("Versions: " + resourceList.size());
        }
        location = location3;
        if (ndScmServerConnection.getRepositoryHomeFolder() != null) {
            this.updateWvcmRepositoryHomeFolder(workspace, ndScmServerConnection.getRepositoryHomeFolder());
        }
        this.updateWvcmRepositoryHomeFolder(workspace, null);
        ndWvcmWorkspaceVersionManager = null;
        if (ndScmServerConnection.getVersionManagerClass() != null) {
            ndWvcmWorkspaceVersionManager = this.createWvcmVersionManager(ndWorkspaceConnection, workspace, ndScmServerConnection.getRepositoryHomeFolder(), this.createVersionManagerConfig(ndScmServerConnection), ndScmServerConnection);
        }
        return ndWvcmWorkspaceVersionManager;
    }

    protected NdWorkspaceConnection createWvcmWorkspaceConnection(Location location, String string, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException {
        NdWvcmRepositoryConnection ndWvcmRepositoryConnection = new NdWvcmRepositoryConnection();
        ndWvcmRepositoryConnection.setWorkspaceFolder(location.toString());
        ndWvcmRepositoryConnection.setRepositoryHomeFolder(string);
        ndWvcmRepositoryConnection.setUser(ndVersioningRepositoryConnection.getUser());
        ndWvcmRepositoryConnection.setPassword(ndVersioningRepositoryConnection.getPassword());
        ndWvcmRepositoryConnection.setWorkspaceProvider(((NdScmServerConnection)ndVersioningRepositoryConnection).getScmProvider());
        return ndWvcmRepositoryConnection;
    }

    protected NdWvcmWorkspaceVersionManager createWvcmVersionManager(NdWorkspaceConnection ndWorkspaceConnection, Workspace workspace, String string, NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig, NdVersioningRepositoryConnection ndVersioningRepositoryConnection) throws NdRepositoryException, WvcmException {
        NdWvcmRepositoryConnection ndWvcmRepositoryConnection = (NdWvcmRepositoryConnection)ndWorkspaceConnection;
        ndWvcmRepositoryConnection.setWorkspace(workspace);
        WjIATjQ wjIATjQ = new WjIATjQ(ndWvcmRepositoryConnection, ndRepositoryVersionManagerConfig);
        NdRepositoryVersionManagerFactory ndRepositoryVersionManagerFactory = ndRepositoryVersionManagerConfig.getRepositoryVersionManagerFactory();
        if (ndRepositoryVersionManagerFactory == null) {
            throw new NdRepositoryException(NdStrings.WjIAVQC("NoVersionManagerFactoryFound"));
        }
        this.trace("Init: " + ndRepositoryVersionManagerFactory.getJavaName());
        NdWorkspaceVersionManager ndWorkspaceVersionManager = (NdWorkspaceVersionManager)ndRepositoryVersionManagerFactory.newWorkspaceVersionManager(wjIATjQ);
        if (!(ndWorkspaceVersionManager instanceof NdWvcmWorkspaceVersionManager)) {
            throw new NdRepositoryException(NdStrings.WjIAVQC("NotWvcmVersionManager"));
        }
        return (NdWvcmWorkspaceVersionManager)ndWorkspaceVersionManager;
    }

    public WorkspaceProvider getWorkspaceProvider(NdScmServerConnection ndScmServerConnection) throws WvcmException {
        return NdWvcmSupport.getWorkspaceProvider(ndScmServerConnection);
    }

    protected ControllableFolder getWorkspaceRoot(Workspace workspace) throws WvcmException {
        return (ControllableFolder)this.readProperty((Resource)workspace, Workspace.CONTROLLABLE_RESOURCE_HOME);
    }

    protected Object readProperty(Resource resource, PropertyNameList.PropertyName propertyName) throws WvcmException {
        Resource resource2 = this.requestProperty(resource, propertyName);
        return resource2.getProperty(propertyName);
    }

    protected Resource requestProperty(Resource resource, PropertyNameList.PropertyName propertyName) throws WvcmException {
        PropertyRequestItem.PropertyRequest propertyRequest = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{propertyName});
        return resource.doReadProperties((Feedback)propertyRequest);
    }

    protected Resource requestProperties(Resource resource, PropertyRequestItem[] propertyRequestItemArray) throws WvcmException {
        PropertyRequestItem.PropertyRequest propertyRequest = new PropertyRequestItem.PropertyRequest(propertyRequestItemArray);
        return resource.doReadProperties((Feedback)propertyRequest);
    }

    protected Resource requestDefaultProperties(Resource resource) throws WvcmException {
        return this.requestProperties(resource, new PropertyRequestItem[]{ControllableResource.IS_CHECKED_OUT, ControllableResource.IS_VERSION_CONTROLLED, Resource.PARENT_LIST});
    }

    public void browse(String string, Folder folder) throws WvcmException {
        ResourceList resourceList = (ResourceList)this.readProperty((Resource)folder, Folder.CHILD_LIST);
        Iterator iterator = resourceList.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (resource instanceof Folder) {
                this.browse(string, (Folder)resource);
            }
            Location location = (Location)this.readProperty(resource, Resource.PATHNAME_LOCATION);
            this.trace(string + "-res: " + resource.location(), resource);
        }
    }

    String WjIAXHG(Resource resource) throws WvcmException {
        Location location = (Location)this.readProperty(resource, Resource.PATHNAME_LOCATION);
        return location.string();
    }

    protected void trace(String string, Resource resource) {
        if (this.isTracingEnabled()) {
            String string2 = null;
            try {
                string2 = this.WjIAXHG(resource);
            }
            catch (WvcmException wvcmException) {
                string2 = resource.toString();
            }
            this.trace(string + "[" + string2 + "]");
        }
    }

    protected void trace(String string, Resource resource, PropertyNameList.PropertyName propertyName) {
        if (this.isTracingEnabled()) {
            String string2 = null;
            Object object = null;
            try {
                string2 = this.WjIAXHG(resource);
                object = this.readProperty(resource, propertyName);
            }
            catch (WvcmException wvcmException) {
                string2 = resource.toString();
                object = wvcmException.getMessage();
            }
            this.trace(string + "[" + string2 + "] " + propertyName.getName() + ": " + object);
        }
    }

    private static class WjIATjQ
    extends NdLocalRepository {
        private NdRepositoryConfig WjIATjP = new NdRepositoryConfig();

        public WjIATjQ(NdWvcmRepositoryConnection ndWvcmRepositoryConnection, NdRepositoryVersionManagerConfig ndRepositoryVersionManagerConfig) throws NdRepositoryException {
            super(new NdWvcmRepository(ndWvcmRepositoryConnection));
            this.WjIATjP.setRepositoryVersionManagerConfig(ndRepositoryVersionManagerConfig);
        }

        public NdRepositoryConfig getRepositoryConfig() {
            return this.WjIATjP;
        }

        public void addWorkspaceListener(NdWorkspaceListener ndWorkspaceListener) {
        }

        public void removeWorkspaceListener(NdWorkspaceListener ndWorkspaceListener) {
        }

        public NdRepositoryAuthorizationManager getRepositoryAuthorizationManager() throws NdRepositoryException {
            return new NdRepositoryDefaultAuthorizationManager();
        }

        public NdRepositoryImplicitLockManager getImplicitLockManager() throws NdRepositoryException {
            return null;
        }

        public NdRepositoryExplicitLockManager getExplicitLockManager() throws NdRepositoryException {
            return null;
        }

        public NdWorkspaceVersionManager getWorkspaceVersionManager() {
            return null;
        }

        public void setWorkspaceVersionManager(NdWorkspaceVersionManager ndWorkspaceVersionManager) {
        }

        public NdRepositoryVersionSystemAdmin getRepositoryVersionSystemAdmin() {
            return null;
        }

        public void setRepositoryVersionSystemAdmin(NdRepositoryVersionSystemAdmin ndRepositoryVersionSystemAdmin) {
        }

        public NdVersioningSystemVersionManager getSystemVersionManager() {
            return null;
        }

        public void setSystemVersionManager(NdVersioningSystemVersionManager ndVersioningSystemVersionManager) {
        }

        public void addEntryFilter(NdRepositoryEntryFilter ndRepositoryEntryFilter) {
        }

        public NdRepositoryEntryFilter[] getEntryFilters() {
            return new NdRepositoryEntryFilter[0];
        }

        public String getWorkspaceUser() {
            return null;
        }

        public boolean isVersioned() {
            return true;
        }

        public boolean isVersionStatusCached() {
            return false;
        }

        public void setVersionStatusCached(boolean bl) {
        }

        public void enablePersistentVersionManagerConnection(boolean bl) throws NdRepositoryException {
        }

        public void setCredentialsProvider(NdCredentialsProvider ndCredentialsProvider) {
        }

        public NdCredentialsProvider getCredentialsProvider() {
            return null;
        }
    }
}

