/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.scm.wvcm.cc;

import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryVersionHistory;
import com.blazesoft.repository.base.NdWorkspaceItem;
import com.blazesoft.repository.base.NdWorkspaceItemLoadingContext;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.scm.NdScmServerConnection;
import com.blazesoft.repository.scm.wvcm.NdFileWvcmWorkspaceVersionManager;
import com.blazesoft.repository.scm.wvcm.NdWvcmPropertyRequestFactory;
import com.blazesoft.repository.scm.wvcm.cc.NdCcRemoteCmd;
import com.blazesoft.repository.scm.wvcm.cc.NdCcSupport;
import com.blazesoft.repository.scm.wvcm.cc.NdStrings;
import com.blazesoft.repository.scm.wvcm.cc.WjIAZeB;
import com.ibm.rational.stp.client.internal.cc.CcSubproviderImpl;
import com.ibm.rational.wvcm.stp.StpLocation;
import com.ibm.rational.wvcm.stp.StpProvider;
import com.ibm.rational.wvcm.stp.cc.CcFile;
import com.ibm.rational.wvcm.stp.cc.CcResource;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.Feedback;
import javax.wvcm.Location;
import javax.wvcm.Provider;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

public class NdCcVersionManager
extends NdFileWvcmWorkspaceVersionManager {
    private Method WjIAZlG;
    private Method WjIAZlH;
    private Method WjIAZlI;

    public NdCcVersionManager(NdRepository ndRepository) throws NdRepositoryException {
        super(ndRepository);
        this.WjIAZlJ();
    }

    private void WjIAZlJ() {
        Class<ControllableResource> clazz;
        Class[] classArray;
        try {
            classArray = new Class[]{Feedback.class};
            clazz = ControllableResource.class;
            this.WjIAZlG = clazz.getMethod("doUncheckout", classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            classArray = new Class[]{Feedback.class};
            clazz = ControllableResource.class;
            this.WjIAZlI = clazz.getMethod("doVersionControl", classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            classArray = new Class[]{Feedback.class};
            clazz = Resource.class;
            this.WjIAZlH = clazz.getMethod("doUnbind", classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public NdWvcmPropertyRequestFactory getPropertyRequestFactory() {
        return new NdWvcmPropertyRequestFactory("com.blazesoft.repository.scm.wvcm.cc.NdCcPropertyReader");
    }

    public WorkspaceProvider createWorkspaceProvider(NdScmServerConnection ndScmServerConnection) throws WvcmException {
        WorkspaceProvider workspaceProvider = super.createWorkspaceProvider(ndScmServerConnection);
        ((StpProvider)workspaceProvider).setDefaultDomain(StpProvider.Domain.CLEAR_CASE);
        ((StpProvider)workspaceProvider).setServerUrl(ndScmServerConnection.getServerUrl());
        return workspaceProvider;
    }

    protected boolean isVersionedInternal(Object object) throws NdRepositoryException {
        try {
            if (object instanceof CcResource) {
                return NdCcSupport.createCopyAreaFile((CcResource)object) != null;
            }
        }
        catch (WvcmException wvcmException) {
            throw new NdRepositoryException(wvcmException);
        }
        return super.isVersionedInternal(object);
    }

    public void checkIn(ResourceList resourceList, String string) throws WvcmException {
        HashMap<Location, ControllableResource> hashMap = new HashMap<Location, ControllableResource>();
        for (ControllableResource controllableResource : resourceList) {
            if (hashMap.containsKey(controllableResource.location())) {
                this.trace("DuplicateCheckin: ", (Resource)controllableResource);
                continue;
            }
            this.doCheckIn(controllableResource, string);
            hashMap.put(controllableResource.location(), controllableResource);
        }
    }

    public List doVersionControl(ResourceList resourceList, String string) throws WvcmException {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        CcResource[] ccResourceArray = new CcResource[resourceList.size()];
        int n = 0;
        for (ControllableResource controllableResource : resourceList) {
            ccResourceArray[n++] = (CcResource)controllableResource;
            Resource resource = this.doVersionControlResource((Resource)controllableResource, string);
            this.trace("doVersionControl: ", (Resource)controllableResource);
            this.trace("doVersionControl-Parent: " + resource.location());
            arrayList.add(resource);
        }
        NdCcRemoteCmd ndCcRemoteCmd = new NdCcRemoteCmd((Provider)this.getProvider());
        ndCcRemoteCmd.mkelem(ccResourceArray, string);
        this.trace("Mkelem on " + resourceList.size() + " items.");
        return arrayList;
    }

    public Resource doVersionControlResource(Resource resource, String string) throws WvcmException {
        ControllableResource controllableResource = (ControllableResource)resource;
        controllableResource.setComment(string);
        Location location = controllableResource.location();
        Location location2 = location.parent();
        ControllableFolder controllableFolder = this.getProvider().controllableFolder(location2);
        return controllableFolder;
    }

    protected void ccDoVersionControl(ControllableResource controllableResource) throws WvcmException {
        try {
            Object[] objectArray = new Object[]{null};
            this.WjIAZlI.invoke((Object)controllableResource, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw NdCcSupport.makeWvcmException(illegalAccessException.getMessage(), null, WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw NdCcSupport.makeWvcmException(invocationTargetException.getMessage(), null, WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION, (Exception)invocationTargetException.getTargetException());
        }
    }

    protected void doCheckIn(ControllableResource controllableResource, String string) throws WvcmException {
        if (controllableResource instanceof WjIAZeB) {
            controllableResource = (ControllableResource)((WjIAZeB)controllableResource).WjIAZcZ();
        }
        controllableResource.setComment(string);
        this.trace("doCheckIn: ", (Resource)controllableResource, ControllableResource.IS_CHECKED_OUT);
        if (!controllableResource.getIsCheckedOut()) {
            this.trace("doCheckIn-Skipped: ", (Resource)controllableResource);
            return;
        }
        controllableResource.doCheckin(new ControllableResource.CheckinFlag[]{ControllableResource.CheckinFlag.CHECKIN_IDENTICAL}, null);
    }

    public void doCancelCheckOut(ControllableResource controllableResource) throws WvcmException {
        if (this.WjIAZlG == null) {
            super.doCancelCheckOut(controllableResource);
        } else {
            try {
                Object[] objectArray = new Object[]{null};
                this.WjIAZlG.invoke((Object)controllableResource, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw NdCcSupport.makeWvcmException(illegalAccessException.getMessage(), null, WvcmException.ReasonCode.CANNOT_MODIFY_VERSION, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw NdCcSupport.makeWvcmException(invocationTargetException.getMessage(), null, WvcmException.ReasonCode.CANNOT_MODIFY_VERSION, (Exception)invocationTargetException.getTargetException());
            }
        }
    }

    public void updateLocation(Resource resource, boolean bl) throws NdRepositoryException {
        this.trace("UpdateLocation requested for ", resource);
        try {
            ResourceList resourceList = this.newResourceList((Provider)this.getProvider());
            resourceList.add((Object)resource);
            this.update(resourceList);
        }
        catch (WvcmException wvcmException) {
            throw new NdRepositoryException(wvcmException);
        }
    }

    public void update(ResourceList resourceList) throws WvcmException {
        for (Resource resource : resourceList) {
            if (resource instanceof CcFile) {
                ((CcFile)resource).doRefresh(null, null);
                continue;
            }
            throw NdCcSupport.makeWvcmException(NdStrings.WjIAVaG("NotControlledResource", resource.location()), null, WvcmException.ReasonCode.CANNOT_MODIFY_VERSION, null);
        }
    }

    public ControllableResource doUnbindResource(ControllableResource controllableResource) throws WvcmException {
        this.trace("CcUnbind: ", (Resource)controllableResource);
        Location location = controllableResource.location();
        Location location2 = location.parent();
        ControllableFolder controllableFolder = this.getProvider().controllableFolder(location2);
        this.trace("Checkout parent for rmname: " + controllableFolder.location());
        controllableFolder = (ControllableFolder)this.readProperties((Resource)controllableFolder);
        if (!controllableFolder.getIsCheckedOut()) {
            this.doCheckOut((ControllableResource)controllableFolder);
        } else {
            this.trace("directory was already checkedout");
        }
        this.trace("remote rmname.");
        NdCcRemoteCmd ndCcRemoteCmd = new NdCcRemoteCmd((Provider)this.getProvider());
        ndCcRemoteCmd.rmname((CcResource)controllableResource, NdStrings.WjIAVaG("RmnameMessage", controllableResource.location().string()));
        return null;
    }

    public void doCancelDelete(ControllableResource controllableResource) throws WvcmException {
        if (controllableResource instanceof CcFile) {
            File file = ((CcFile)controllableResource).clientResourceFile();
            this.trace("CancelDelete client file: " + file);
            if (!file.delete()) {
                this.trace("Error deleting client file: " + file);
            }
        }
    }

    public String getContentByVersion(Resource resource, String string) throws WvcmException, IOException {
        NdCcRemoteCmd ndCcRemoteCmd = new NdCcRemoteCmd((Provider)this.getProvider());
        return ndCcRemoteCmd.getVersion((CcResource)resource, string);
    }

    public ControllableResource _doUnbindResource(ControllableResource controllableResource) throws WvcmException {
        if (this.WjIAZlH == null) {
            return super.doUnbindResource(controllableResource);
        }
        try {
            Object[] objectArray = new Object[]{null};
            this.WjIAZlH.invoke((Object)controllableResource, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw NdCcSupport.makeWvcmException(illegalAccessException.getMessage(), null, WvcmException.ReasonCode.CANNOT_MODIFY_VERSION, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw NdCcSupport.makeWvcmException(invocationTargetException.getMessage(), null, WvcmException.ReasonCode.CANNOT_MODIFY_VERSION, (Exception)invocationTargetException.getTargetException());
        }
        return null;
    }

    protected boolean isResourceModified(ControllableResource controllableResource) throws WvcmException {
        return true;
    }

    protected boolean _isResourceUpToDate(ControllableResource controllableResource) throws WvcmException {
        return true;
    }

    protected String getOwner(Resource resource) throws WvcmException {
        return this.getUser();
    }

    protected Location pathToLocation(String string) throws WvcmException {
        return ((StpProvider)this.getProvider()).pathLocation(StpProvider.Domain.CLEAR_CASE, StpLocation.Namespace.PNAME, string);
    }

    protected Location fileToLocation(File file) throws WvcmException {
        return ((StpProvider)this.getProvider()).filePathLocation(StpProvider.Domain.CLEAR_CASE, file);
    }

    protected Map convertMapFromResourceToLocation(Resource[] resourceArray, Map map) {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < resourceArray.length; ++i) {
            hashMap.put(resourceArray[i].location(), map.get(resourceArray[i]));
        }
        return hashMap;
    }

    protected String toString(Resource resource) throws WvcmException {
        Location location = resource.location();
        return location.string();
    }

    protected ResourceList newResourceList(Provider provider) {
        return ((CcSubproviderImpl)provider).resourceList(new Resource[0]);
    }

    protected NdRepositoryVersionHistory findVersionById(String string, NdRepositoryVersionHistory[] ndRepositoryVersionHistoryArray) {
        if (string.endsWith("/LATEST")) {
            String string2 = string.substring(0, string.lastIndexOf("/"));
            Date date = null;
            int n = 0;
            for (int i = 0; i < ndRepositoryVersionHistoryArray.length; ++i) {
                if (!ndRepositoryVersionHistoryArray[i].getVersionId().startsWith(string2)) continue;
                if (date == null) {
                    date = ndRepositoryVersionHistoryArray[i].getTimestamp();
                    n = i;
                    continue;
                }
                if (!ndRepositoryVersionHistoryArray[i].getTimestamp().after(date)) continue;
                date = ndRepositoryVersionHistoryArray[i].getTimestamp();
                n = i;
            }
            if (date != null) {
                return ndRepositoryVersionHistoryArray[n];
            }
        }
        return null;
    }

    protected NdRepositoryVersionHistory[] getAncestralHistories(NdWorkspaceItemLoadingContext ndWorkspaceItemLoadingContext, NdWorkspaceItem ndWorkspaceItem, NdLocation ndLocation) throws NdRepositoryException {
        String string = ndWorkspaceItemLoadingContext.getReferenceEntryVersion();
        String string2 = string.substring(0, string.lastIndexOf("/"));
        NdRepositoryVersionHistory[][] ndRepositoryVersionHistoryArray = this.getHistories(new NdRepositoryEntry[]{ndWorkspaceItem}, true, string2);
        if (ndRepositoryVersionHistoryArray != null && ndRepositoryVersionHistoryArray.length == 1) {
            return ndRepositoryVersionHistoryArray[0];
        }
        return null;
    }
}

