/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.server;

import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.server.NdRepositoryAccessor;
import com.blazesoft.repository.server.NdRepositoryAccessorFactory;
import com.blazesoft.repository.server.NdRepositoryAccessorPoster;
import com.blazesoft.repository.server.NdRepositoryAccessorPosterFactory;
import com.blazesoft.repository.server.NdStrings;
import com.blazesoft.repository.server.config.NdRepositoryServerConfig;
import com.blazesoft.repository.server.config.NdRepositoryServerConfigLoader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class NdRepositoryServer {
    public static String DEFAULT_REPOSITORY_SERVER_NAME = "NdRepositoryServer";
    public static String DEFAULT_REPOSITORY_SERVER_POSTER_NAME = "NdRepositoryServerPoster";
    public static String DEFAULT_PORT = "1099";
    public static int DEFAULT_TIMEOUT = 30;
    public static String DEFAULT_ACCESSOR_FACTORY_CLASS = "com.blazesoft.repository.rmi.NdDefaultRmiAccessorFactoryImpl";
    public static String DEFAULT_ACCESSOR_POSTER_FACTORY_CLASS = "com.blazesoft.repository.rmi.NdDefaultRmiAccessorPosterFactoryImpl";
    private static String WjHCllV;
    private static String WjHCllW;
    private static String WjHIvsB;
    private static String WjHCllY;
    private static String WjHCllZ;
    private static String WjHClmA;
    private static boolean WjHClnB;
    private static boolean WjHCloC;
    private static String WjHClpD;

    private static void WjHClqE() {
        NdRepositoryServer.WjHClsG("usage: NdRepositoryServer\n\t\t[-serverConfiguration <server configuration file path>]\tspecify a repository server configuration file path\n\t\t[-password]\tset a server password.\n\t\t[-initialState]\tserver will start from an initial state.\n\t\t[-help]\tDisplay usage information.\n");
        System.exit(-1);
    }

    private static void WjHClrF(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            NdRepositoryServer.WjHClqE();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-help")) {
                NdRepositoryServer.WjHClqE();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-serverConfiguration")) {
                WjHClmA = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-initialStateFile")) {
                WjHClnB = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-initialStateDatabase")) {
                WjHCloC = true;
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            WjHClpD = stringArray[++i];
        }
        if (WjHClmA == null) {
            NdRepositoryServer.WjHClqE();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        NdRepositoryServer.WjHClrF(stringArray);
        NdRepositoryServerConfig ndRepositoryServerConfig = null;
        NdRepositoryServerConfigLoader ndRepositoryServerConfigLoader = NdRepositoryServerConfigLoader.getRepositoryServerConfigLoader();
        try {
            ndRepositoryServerConfig = ndRepositoryServerConfigLoader.load(WjHClmA);
        }
        catch (NdRepositoryException ndRepositoryException) {
            NdRepositoryServer.WjHCltH((Exception)((Object)ndRepositoryException));
        }
        if (ndRepositoryServerConfig != null) {
            if (WjHClnB) {
                ndRepositoryServerConfig.setInitialStateFile(WjHClnB);
            } else if (WjHCloC) {
                ndRepositoryServerConfig.setInitialStateDatabase(WjHCloC);
            }
            if (WjHClpD != null) {
                ndRepositoryServerConfig.setPassword(WjHClpD);
            }
            if ((WjHIvsB = String.valueOf(ndRepositoryServerConfig.getServerPort())) == null) {
                WjHIvsB = DEFAULT_PORT;
            }
            if ((WjHCllV = ndRepositoryServerConfig.getServerName()) == null || WjHCllV.length() <= 0) {
                WjHCllV = DEFAULT_REPOSITORY_SERVER_NAME;
            }
            if ((WjHCllW = ndRepositoryServerConfig.getServerPosterName()) == null || WjHCllW.length() <= 0) {
                WjHCllW = DEFAULT_REPOSITORY_SERVER_POSTER_NAME;
            }
        }
        int n = Integer.valueOf(WjHIvsB);
        String string = "rmi://localhost:" + WjHIvsB + "/" + WjHCllV;
        try {
            object2 = (NdRepositoryAccessor)Naming.lookup(string);
            if (object2 != null) {
                NdRepositoryServer.WjHClsG(NdStrings.WjHCkDM("ServerAlreadyExist", string));
                System.exit(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = null;
        WjHCllY = ndRepositoryServerConfig.getServerAccessorFactory();
        if (WjHCllY == null) {
            WjHCllY = DEFAULT_ACCESSOR_FACTORY_CLASS;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(WjHCllY);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NdRepositoryServer.WjHCltH(classNotFoundException);
        }
        if (clazz != null) {
            try {
                object2 = (NdRepositoryAccessorFactory)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                NdRepositoryServer.WjHCltH(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                NdRepositoryServer.WjHCltH(illegalAccessException);
            }
        }
        NdRepositoryAccessorPosterFactory ndRepositoryAccessorPosterFactory = null;
        WjHCllZ = ndRepositoryServerConfig.getServerAccessorPosterFactory();
        if (WjHCllZ == null) {
            WjHCllZ = DEFAULT_ACCESSOR_POSTER_FACTORY_CLASS;
        }
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName(WjHCllZ);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NdRepositoryServer.WjHCltH(classNotFoundException);
        }
        if (clazz2 != null) {
            try {
                ndRepositoryAccessorPosterFactory = (NdRepositoryAccessorPosterFactory)clazz2.newInstance();
            }
            catch (InstantiationException instantiationException) {
                NdRepositoryServer.WjHCltH(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                NdRepositoryServer.WjHCltH(illegalAccessException);
            }
        }
        Registry registry = null;
        NdRepositoryAccessor ndRepositoryAccessor = null;
        NdRepositoryAccessorPoster ndRepositoryAccessorPoster = null;
        try {
            ndRepositoryAccessor = object2.newAccessorInstance(ndRepositoryServerConfig);
            ndRepositoryAccessorPoster = ndRepositoryAccessorPosterFactory.newAccessorPoster(ndRepositoryAccessor);
        }
        catch (Exception exception) {
            NdRepositoryServer.WjHCltH(exception);
        }
        NdRepositoryServer.WjHClsG(NdStrings.WjHCkDK("StartingRmiService") + WjHIvsB);
        try {
            registry = LocateRegistry.getRegistry(n);
            try {
                registry.rebind(WjHCllV, ndRepositoryAccessor);
            }
            catch (ConnectException connectException) {
                registry = LocateRegistry.createRegistry(n);
                registry.rebind(WjHCllV, ndRepositoryAccessor);
            }
            NdRepositoryServer.WjHClsG(NdStrings.WjHCkDK("Ready"));
            registry.rebind(WjHCllW, ndRepositoryAccessorPoster);
        }
        catch (Exception exception) {
            NdRepositoryServer.WjHCltH(exception);
            System.exit(1);
        }
        NdRepositoryServer.WjHClsG(NdStrings.WjHCkDK("RmiServiceStarted"));
        NdRepositoryServer.WjHClsG(NdStrings.WjHCkDK("InitializeRmi"));
        int n2 = 0;
        NdRepositoryServer.WjHCluI();
        try {
            object = new BufferedReader(new InputStreamReader(System.in));
            String string2 = ((BufferedReader)object).readLine();
            if (string2.length() > 0) {
                n2 = Integer.parseInt(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            while (true) {
                switch (n2) {
                    case 1: {
                        object = ndRepositoryAccessorPoster.listRepositories();
                        NdRepositoryServer.WjHClsG("\n------Repository List And Locking Infomation-----");
                        for (int i = 0; i < ((String[])object).length; ++i) {
                            NdRepositoryServer.WjHClsG((String)object[i]);
                        }
                        NdRepositoryServer.WjHClsG("------------end of list------------\n");
                        break;
                    }
                    case 2: {
                        object = ndRepositoryAccessorPoster.listUsers();
                        NdRepositoryServer.WjHClsG("\n------Repository Client List-----");
                        for (int i = 0; i < ((String[])object).length; ++i) {
                            NdRepositoryServer.WjHClsG((String)object[i]);
                        }
                        NdRepositoryServer.WjHClsG("------------end of list------------\n");
                        break;
                    }
                    case 3: {
                        String string3;
                        BufferedReader bufferedReader;
                        object = "";
                        boolean bl = false;
                        NdRepositoryServer.WjHClsG("\nPlease enter the repository key:");
                        try {
                            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(System.in));
                            object = bufferedReader2.readLine();
                            if (((String)object).length() > 0) {
                                object = ((String)object).trim();
                                bl = ndRepositoryAccessorPoster.isRepositoryExisted((String)object);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (bl) {
                            NdRepositoryServer.WjHClsG("\nPlease enter server password:");
                            boolean bl2 = false;
                            try {
                                bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                                string3 = bufferedReader.readLine();
                                if (string3.length() > 0) {
                                    string3 = string3.trim();
                                    bl2 = ndRepositoryAccessorPoster.serverPasswordAuthentication(string3);
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            if (bl2) {
                                ndRepositoryAccessorPoster.releaseLocksByRepositoryKey((String)object);
                                NdRepositoryServer.WjHClsG("***All locks with repository key \"" + (String)object + "\" have been released.\n");
                                break;
                            }
                            NdRepositoryServer.WjHClsG("***Wrong repository server password.\n");
                            break;
                        }
                        NdRepositoryServer.WjHClsG("***The repository key \"" + (String)object + "\" is not existed in the repository server.\n");
                        break;
                    }
                    case 4: {
                        String string3;
                        BufferedReader bufferedReader;
                        object = "";
                        boolean bl = false;
                        NdRepositoryServer.WjHClsG("\nPlease enter the user Id:");
                        try {
                            BufferedReader bufferedReader3 = new BufferedReader(new InputStreamReader(System.in));
                            object = bufferedReader3.readLine();
                            if (((String)object).length() > 0) {
                                object = ((String)object).trim();
                                bl = ndRepositoryAccessorPoster.isUserExisted((String)object);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (bl) {
                            NdRepositoryServer.WjHClsG("\nPlease enter server password:");
                            boolean bl3 = false;
                            try {
                                bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                                string3 = bufferedReader.readLine();
                                if (string3.length() > 0) {
                                    string3 = string3.trim();
                                    bl3 = ndRepositoryAccessorPoster.serverPasswordAuthentication(string3);
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            if (bl3) {
                                ndRepositoryAccessorPoster.releaseLocksByUserId((String)object);
                                NdRepositoryServer.WjHClsG("***All locks with User Id\"" + (String)object + "\" have been released.\n");
                                break;
                            }
                            NdRepositoryServer.WjHClsG("***Wrong repository server password.\n");
                            break;
                        }
                        NdRepositoryServer.WjHClsG("***The user Id \"" + (String)object + "\" could nor be found in the repository server.\n");
                        break;
                    }
                    case 5: {
                        NdRepositoryServer.WjHClsG("Request server to stop.");
                        try {
                            NdRepositoryServer.WjHClsG(NdStrings.WjHCkDK("UnregisterServerObj"));
                            registry.unbind(WjHCllV);
                            registry.unbind(WjHCllW);
                        }
                        catch (Exception exception) {
                            NdRepositoryServer.WjHCltH(exception);
                        }
                        System.runFinalization();
                        System.gc();
                        System.exit(0);
                        break;
                    }
                }
                NdRepositoryServer.WjHCluI();
                try {
                    object = new BufferedReader(new InputStreamReader(System.in));
                    String string4 = ((BufferedReader)object).readLine();
                    if (string4.length() <= 0) continue;
                    n2 = Integer.parseInt(string4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            NdRepositoryServer.WjHClsG("poster exception: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    private static void WjHClsG(String string) {
        System.out.println(string);
    }

    private static void WjHCltH(Exception exception) {
        System.out.println("Exception: " + exception.getMessage());
        exception.printStackTrace();
    }

    private static void WjHCluI() {
        NdRepositoryServer.WjHClsG("\n======Innovator Repository Server Management Command-Line Tool======\n\tPlease input an option of (1 - 5), where\n\t\t 1: Repository List and Locking Info.\n\t\t 2: Client List.\n\t\t 3: Release locks by repository key.\n\t\t 4: Release locks by client user Id.\n\t\t 5: Stop Repository Control Server and Exit.\n\t\t ");
        NdRepositoryServer.WjHClvJ("Your input: ");
    }

    private static void WjHClvJ(String string) {
        System.out.print(string);
    }

    static {
        WjHClnB = false;
        WjHCloC = false;
    }
}

