/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.tools;

import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryFactory;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdRepositoryVersionSystemAdmin;
import com.blazesoft.repository.base.NdVersioningRepositoryConnection;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.base.NdWorkspaceEntry;
import com.blazesoft.repository.config.NdRepositoryConfig;
import com.blazesoft.repository.config.NdRepositoryConfigLoader;
import com.blazesoft.repository.config.NdRepositoryConfigWriter;
import com.blazesoft.repository.jdbc.NdJdbcRepository;
import com.blazesoft.repository.jdbc.NdJdbcRepositoryConnection;
import com.blazesoft.repository.tools.NdRepositoryFactoryUtil;
import com.blazesoft.repository.tools.NdRepositoryUtilBase;
import com.blazesoft.repository.tools.NdStrings;
import com.blazesoft.util.WjHzAhT;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

public class NdJdbcRepositoryUtil
extends NdRepositoryUtilBase
implements NdRepositoryFactoryUtil {
    private static final String WjIsCkI = "-createTable";
    private static final String WjIvkWJ = "java com.blazesoft.repository.tools.NdJdbcRepositoryUtil";
    private static final String WjIvkWK = "NdRomAdminUtil";
    private String WjIsClJ = null;
    private Connection WjHGySW = null;
    private String WjHGyTX = null;
    private String WjHGyUY = null;
    private String WjHGyVZ = null;
    private String WjHGyWA = null;
    private String WjHGyWB = null;
    private String WjHGyWC = null;
    private String WjHGyWD = null;
    private String WjHGyWE = " (id, dirId, isItem, name, shortDesc, itemType)";
    private String WjHGyWF = " VALUES (?, ?, ?, ?, ?, ?)";
    String[] WjHGyWG = new String[]{" (id VARCHAR(40) NOT NULL PRIMARY KEY, ", "dirId VARCHAR(40) NOT NULL, ", "isItem ", "BIT", " NULL, name VARCHAR(255) NOT NULL, ", "shortDesc VARCHAR(255) NULL, ", "itemType VARCHAR(255) NULL, ", "templateRef VARCHAR(255) NULL, itemDeletedFlag VARCHAR(255) NULL, itemCreationId VARCHAR(255) NULL,", "lastModified ", "TIMESTAMP", " NULL, contentLength ", "INTEGER", " NULL, itemContent ", "LONGBINARY", ")"};
    String[] WjIFCxL = new String[]{" (id VARCHAR(40) NOT NULL PRIMARY KEY, ", "dirId VARCHAR(40) NOT NULL, ", "isItem ", "BIT", ", name VARCHAR(255) NOT NULL, ", "shortDesc VARCHAR(255), ", "itemType VARCHAR(255), ", "templateRef VARCHAR(255), itemDeletedFlag VARCHAR(255), itemCreationId VARCHAR(255),", "lastModified ", "TIMESTAMP", ", contentLength ", "INTEGER", ", itemContent ", "LONGBINARY", ")"};
    private String WjHGyWH = null;
    private boolean WjHJYZV = false;
    private boolean WjIsCmK = false;
    private boolean WjIvBcS = false;
    int WjHGyWJ = 3;
    int WjHGyWK = 9;
    int WjHGyWL = 11;
    int WjHGyWM = 13;

    private Hashtable WjHJVRH(NdJdbcRepositoryConnection ndJdbcRepositoryConnection) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (ndJdbcRepositoryConnection.getJdbcDriver() != null) {
            hashtable.put("JDBC.driver", ndJdbcRepositoryConnection.getJdbcDriver());
        }
        if (ndJdbcRepositoryConnection.getJdbcUrl() != null) {
            hashtable.put("JDBC.database.url", ndJdbcRepositoryConnection.getJdbcUrl());
        }
        if (ndJdbcRepositoryConnection.getJdbcTable() != null) {
            hashtable.put("JDBC.repository.table", ndJdbcRepositoryConnection.getJdbcTable());
        }
        if (ndJdbcRepositoryConnection.getJdbcDriver() != null) {
            hashtable.put("JDBC.driver", ndJdbcRepositoryConnection.getJdbcDriver());
        }
        if (ndJdbcRepositoryConnection.getUser() != null) {
            hashtable.put("JDBC.username", ndJdbcRepositoryConnection.getUser());
        }
        if (ndJdbcRepositoryConnection.getPassword() != null) {
            hashtable.put("JDBC.password", ndJdbcRepositoryConnection.getPassword());
        }
        if (ndJdbcRepositoryConnection.getRepositoryName() != null) {
            hashtable.put("com.blazesoft.repository.base.repositoryname", ndJdbcRepositoryConnection.getRepositoryName());
        }
        if (ndJdbcRepositoryConnection.getJdbcAccessor() != null) {
            hashtable.put("JDBC.accessor.class", ndJdbcRepositoryConnection.getJdbcAccessor());
        }
        return hashtable;
    }

    protected String createJdbcRepositoryEntry(String string, Hashtable hashtable, boolean bl) throws NdRepositoryException {
        return this.createJdbcRepositoryEntry(string, hashtable, bl, false);
    }

    protected String createJdbcRepositoryEntry(String string, Hashtable hashtable, boolean bl, boolean bl2) throws NdRepositoryException {
        if (string != null) {
            this.WjHGyTX = string;
        }
        this.WjHGyVZ = null;
        this.WjHGyWA = null;
        this.WjHGyWB = null;
        this.WjHGyWD = null;
        this.WjHGyUY = (String)hashtable.get("JDBC.driver");
        this.WjHGyVZ = (String)hashtable.get("JDBC.database.url");
        this.WjHGyWA = (String)hashtable.get("JDBC.username");
        this.WjHGyWB = (String)hashtable.get("JDBC.password");
        this.WjHGyWC = (String)hashtable.get("JDBC.repository.table");
        this.WjHGyWD = (String)hashtable.get("com.blazesoft.repository.base.repositoryname");
        if (this.WjHGyUY == null || this.WjHGyVZ == null || this.WjHGyWC == null || this.WjHGyWD == null) {
            throw new NdRepositoryException(NdStrings.WjHIIrJ("FailedToCreateJDBCRepositoryParameterMissing"));
        }
        NdRepositoryConfig ndRepositoryConfig = null;
        String string2 = (String)hashtable.get("com.blazesoft.repository.config.path");
        if (string2 != null && string2.length() > 0) {
            ndRepositoryConfig = NdRepositoryConfigLoader.getDefaultRepositoryConfigLoader().load(string2);
            if (ndRepositoryConfig == null) {
                throw new NdRepositoryException(NdStrings.WjHIIrL("CouldNotLoadRepositoryConfigurationAt", string2));
            }
            boolean bl3 = this.hasNoneBlazeVersioning(ndRepositoryConfig.getRepositoryVersionManagerConfig());
            if (bl3) {
                ndRepositoryConfig.setRepositoryVersionManagerConfig(null);
                throw new NdRepositoryException(NdStrings.WjHIIrJ("JdbcRepositoryRequiresBVSVersioning"));
            }
        }
        try {
            this.WjHGyWN();
            if (!this.WjHJYZV) {
                this.WjIsCnL(bl);
                if (bl2) {
                    return "";
                }
            }
            this.WjHGyWQ();
            this.WjHGyWO();
        }
        catch (Exception exception) {
            throw new NdRepositoryException(exception);
        }
        String string3 = (String)hashtable.get("com.blazesoft.repository.base.repositoryclass");
        if (string3 == null) {
            hashtable.put("com.blazesoft.repository.base.repositoryclass", "com.blazesoft.repository.jdbc.NdJdbcRepository");
        }
        NdRepository ndRepository = NdRepositoryFactory.newRepository(hashtable);
        ndRepository.openConnection(1);
        if (ndRepositoryConfig != null) {
            ndRepository.setRepositoryConfig(ndRepositoryConfig);
        }
        ndRepository.closeConnection();
        return this.WjHGyWH;
    }

    protected void changeJdbcRepositoryConfig(Hashtable hashtable, boolean bl) throws NdRepositoryException {
        String string = (String)hashtable.get("com.blazesoft.repository.config.path");
        String string2 = (String)hashtable.get("com.blazesoft.repository.base.repositoryclass");
        if (string2 == null) {
            hashtable.put("com.blazesoft.repository.base.repositoryclass", "com.blazesoft.repository.jdbc.NdJdbcRepository");
        }
        if (string != null && string.length() > 0) {
            NdRepositoryConfig ndRepositoryConfig = NdRepositoryConfigLoader.getDefaultRepositoryConfigLoader().load(string);
            if (ndRepositoryConfig == null) {
                throw new NdRepositoryException(NdStrings.WjHIIrL("CouldNotLoadJdbcRepositoryConfigurationAt", string));
            }
            NdWorkspace ndWorkspace = (NdWorkspace)NdRepositoryFactory.newRepository(hashtable);
            ndWorkspace.openConnection(1);
            this.validateConfigChanges(ndWorkspace, ndRepositoryConfig, bl);
            if (this.isItemContentConverterChanged()) {
                this.changeItemContentConverter(ndWorkspace);
            }
            boolean bl2 = ndWorkspace.isVersioned();
            ndWorkspace.setRepositoryConfig(ndRepositoryConfig);
            ndWorkspace.closeConnection();
            ndWorkspace = (NdWorkspace)NdRepositoryFactory.newRepository(hashtable);
            ndWorkspace.openConnection(1);
            boolean bl3 = ndWorkspace.isVersioned();
            ndWorkspace.closeConnection();
            if (!bl2 && bl3) {
                this.WjHGyWT(hashtable);
                ndWorkspace = (NdWorkspace)NdRepositoryFactory.newRepository(hashtable);
                ndWorkspace.openConnection(1);
                this.initializeVersioning(ndWorkspace);
                ndWorkspace.closeConnection();
            }
            if (bl2) {
                if (this.isDropVersionHistory()) {
                    this.cleanVersionHistory(ndWorkspace);
                } else if (this.isReleaseVersionLocks()) {
                    // empty if block
                }
            }
        }
    }

    protected void getJdbcRepositoryConfig(Hashtable hashtable) throws NdRepositoryException {
        String string = (String)hashtable.get("com.blazesoft.repository.config.path");
        String string2 = (String)hashtable.get("com.blazesoft.repository.base.repositoryclass");
        if (string2 == null) {
            hashtable.put("com.blazesoft.repository.base.repositoryclass", "com.blazesoft.repository.jdbc.NdJdbcRepository");
        }
        if (string != null && string.length() > 0) {
            NdJdbcRepository ndJdbcRepository = (NdJdbcRepository)NdRepositoryFactory.newRepository(hashtable);
            ndJdbcRepository.openConnection(1);
            NdRepositoryConfig ndRepositoryConfig = ndJdbcRepository.getRepositoryConfig();
            if (ndRepositoryConfig == null) {
                throw new NdRepositoryException("No JDBC repository configuration could be extracted from the target JDBC repository");
            }
            NdRepositoryConfigWriter ndRepositoryConfigWriter = NdRepositoryConfigWriter.getDefaultRepositoryConfigWriter();
            ndRepositoryConfigWriter.save(string, ndRepositoryConfig);
        }
    }

    protected void listCheckouts(Hashtable hashtable) throws NdRepositoryException {
        String string = (String)hashtable.get("com.blazesoft.checkedout.entry.path");
        String string2 = (String)hashtable.get("com.blazesoft.checkedout.user.id");
        hashtable.remove("com.blazesoft.checkedout.entry.path");
        hashtable.remove("com.blazesoft.checkedout.user.id");
        hashtable.put("com.blazesoft.repository.base.repositoryclass", "com.blazesoft.repository.jdbc.NdJdbcRepository");
        NdWorkspaceEntry ndWorkspaceEntry = null;
        NdWorkspace ndWorkspace = (NdWorkspace)NdRepositoryFactory.newRepository(hashtable);
        ndWorkspace.openConnection(1);
        if (!ndWorkspace.isVersioned()) {
            System.out.println("***Error: The target repository is not a versioned repository.");
            System.exit(-1);
        } else if (string != null && string.length() > 0) {
            ndWorkspaceEntry = (NdWorkspaceEntry)NdRepositorySupport.lookupEntry((NdRepositoryDirectory)ndWorkspace, string);
            if (ndWorkspaceEntry == null) {
                System.out.println("***Error: Could not find entry '" + string + "' in the target repository.");
                System.exit(-1);
            }
        } else {
            ndWorkspaceEntry = ndWorkspace;
        }
        this.listCheckedOutItemInfos(ndWorkspaceEntry, string2);
    }

    protected void cancelCheckouts(Hashtable hashtable) throws NdRepositoryException {
        NdVersioningRepositoryConnection ndVersioningRepositoryConnection = null;
        String string = (String)hashtable.get("com.blazesoft.checkedout.entry.path");
        String string2 = (String)hashtable.get("com.blazesoft.checkedout.user.id");
        hashtable.remove("com.blazesoft.checkedout.entry.path");
        hashtable.remove("com.blazesoft.checkedout.user.id");
        hashtable.put("com.blazesoft.repository.base.repositoryclass", "com.blazesoft.repository.jdbc.NdJdbcRepository");
        NdRepositoryEntry ndRepositoryEntry = null;
        NdWorkspace ndWorkspace = (NdWorkspace)NdRepositoryFactory.newRepository(hashtable);
        ndWorkspace.openConnection(1);
        NdRepositoryVersionSystemAdmin ndRepositoryVersionSystemAdmin = ndWorkspace.getRepositoryVersionSystemAdmin();
        if (ndRepositoryVersionSystemAdmin == null) {
            System.out.println("***Error: The target repository is not a versioned repository.");
            System.exit(-1);
        } else {
            ndVersioningRepositoryConnection = ndWorkspace.getRepositoryConfig().getRepositoryVersionManagerConfig().getVersioningRepositoryConnection();
            if (string != null && string.length() > 0) {
                ndRepositoryEntry = NdRepositorySupport.lookupEntry((NdRepositoryDirectory)ndWorkspace, string);
                if (ndRepositoryEntry == null) {
                    System.out.println("***Error: Could not find entry '" + string + "' in the target repository.");
                    System.exit(-1);
                }
            } else {
                ndRepositoryEntry = ndWorkspace;
            }
        }
        this.cancelCheckouts(ndRepositoryVersionSystemAdmin, ndRepositoryEntry, string2, ndVersioningRepositoryConnection);
    }

    private void WjHGyWN() throws Exception {
        Class.forName(this.WjHGyUY);
        this.WjHGySW = DriverManager.getConnection(this.WjHGyVZ, this.WjHGyWA, this.WjHGyWB);
        if (this.WjHGySW == null) {
            throw new Exception(NdStrings.WjHIIrL("FailedConnectingToDatabase", this.WjHGyVZ));
        }
    }

    private void WjHGyWO() throws Exception {
        this.WjHGySW.close();
    }

    private boolean WjIsCnL(boolean bl) throws Exception {
        Object object;
        String string = "DROP TABLE " + this.WjHGyWC;
        Statement statement = this.WjHGySW.createStatement();
        boolean bl2 = true;
        if (bl) {
            try {
                statement.execute(string);
            }
            catch (SQLException sQLException) {}
        } else {
            object = this.WjHGySW.getMetaData();
            ResultSet resultSet = object.getTables(null, null, null, new String[]{"TABLE"});
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string2 = resultSet.getString(3);
                    if (!this.WjHGyWC.equalsIgnoreCase(string2)) continue;
                    String string3 = "SELECT NAME FROM " + this.WjHGyWC + " WHERE itemType = ?";
                    PreparedStatement preparedStatement = this.WjHGySW.prepareStatement(string3);
                    preparedStatement.setString(1, "Repository");
                    try {
                        ResultSet resultSet2 = preparedStatement.executeQuery();
                        while (resultSet2 != null && resultSet2.next()) {
                            String string4 = resultSet2.getString(1);
                            if (!this.WjHGyWD.equalsIgnoreCase(string4)) continue;
                            throw new NdRepositoryException("The repository '" + this.WjHGyWD + "' already exists in the database table " + this.WjHGyWC);
                        }
                    }
                    catch (SQLException sQLException) {
                        throw new NdRepositoryException("A database table with name '" + this.WjHGyWC + "' has been found in the database.", sQLException);
                    }
                    bl2 = false;
                    break;
                }
                resultSet.close();
            }
        }
        if (bl2) {
            try {
                object = this.WjHGyWR();
                statement.execute((String)object);
                statement.close();
            }
            catch (SQLException sQLException) {
                throw new NdRepositoryException("Create table failed for vendor \"" + this.WjHGyTX + "\"", sQLException);
            }
        }
        return bl2;
    }

    private void WjIvBcT() throws Exception {
        String string;
        Statement statement = this.WjHGySW.createStatement();
        try {
            string = "Create unique index idx_id_" + this.WjHGyWC + " on " + this.WjHGyWC + " (id)";
            statement.execute(string);
            System.out.println("unique idx_id_" + this.WjHGyWC + " index has been created in table " + "'" + this.WjHGyWC + "'");
        }
        catch (SQLException sQLException) {
            System.out.println("Failed to create idx_id_" + this.WjHGyWC + " index because " + sQLException.getMessage());
        }
        try {
            string = "Create index idx_dirid_" + this.WjHGyWC + " on " + this.WjHGyWC + " (dirid)";
            statement.execute(string);
            System.out.println("idx_dirid_" + this.WjHGyWC + " index has been created in table " + "'" + this.WjHGyWC + "'");
        }
        catch (SQLException sQLException) {
            System.out.println("Failed to create idx_dirid_" + this.WjHGyWC + " index because " + sQLException.getMessage());
        }
        statement.close();
    }

    private void WjIsCoM() throws Exception {
        if (this.WjHGyWC == null || this.WjHGyWC.length() == 0) {
            System.out.println("Error: Missing table name argument.");
            NdJdbcRepositoryUtil.WjIsCpN();
        }
        if (this.WjHGyVZ == null || this.WjHGyVZ.length() == 0) {
            System.out.println("Error: Missing url argument.");
            NdJdbcRepositoryUtil.WjIsCpN();
        }
        if (this.WjHGyUY == null || this.WjHGyUY.length() == 0) {
            System.out.println("Error: Missing driver argument.");
            NdJdbcRepositoryUtil.WjIsCpN();
        }
        this.WjHGyWD = "";
        this.WjHGyWN();
        boolean bl = this.WjIsCnL(this.WjIsCmK);
        if (bl) {
            System.out.println("The database table " + this.WjHGyWC + " has been created successfully.");
        } else {
            System.out.println("The database table " + this.WjHGyWC + " already exists.");
        }
        if (this.WjIvBcS) {
            this.WjIvBcT();
        }
    }

    private void WjHGyWQ() throws Exception {
        String string = "SELECT id FROM " + this.WjHGyWC + " WHERE dirId=? and isItem=? and name=? and itemType=?";
        PreparedStatement preparedStatement = this.WjHGySW.prepareStatement(string);
        preparedStatement.setString(1, "no parent");
        preparedStatement.setBoolean(2, false);
        preparedStatement.setString(3, this.WjHGyWD);
        preparedStatement.setString(4, "Repository");
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            throw new Exception("Repository or workspace " + this.WjHGyWD + " already exists.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(this.WjHGyWC);
        stringBuffer.append(this.WjHGyWE);
        stringBuffer.append(this.WjHGyWF);
        PreparedStatement preparedStatement2 = this.WjHGySW.prepareStatement(stringBuffer.toString());
        WjHzAhT wjHzAhT = new WjHzAhT(null);
        this.WjHGyWH = wjHzAhT.WjHzAhS(WjHzAhT.WjHzAhP);
        preparedStatement2.setString(1, this.WjHGyWH);
        preparedStatement2.setString(2, "no parent");
        preparedStatement2.setBoolean(3, false);
        preparedStatement2.setString(4, this.WjHGyWD);
        preparedStatement2.setString(5, "top rep desc");
        preparedStatement2.setString(6, "Repository");
        preparedStatement2.executeUpdate();
        preparedStatement2.close();
    }

    private String WjHGyWR() {
        if (this.WjHGyTX == null) {
            this.WjHGyTX = this.WjHGyVZ.startsWith("jdbc:db2") ? "ibm" : (this.WjHGyVZ.startsWith("jdbc:oracle") ? "oracle" : (this.WjHGyVZ.startsWith("jdbc:sybase") ? "sybase" : (this.WjHGyVZ.startsWith("jdbc:informix") ? "informix" : (this.WjHGyVZ.indexOf("mssql") > 0 || this.WjHGyVZ.indexOf("microsoft") > 0 ? "microsoft" : (this.WjHGyVZ.indexOf("hsql") > 0 ? "hsql" : (this.WjHGyUY.indexOf("microsoft") > 0 || this.WjHGyUY.indexOf("com.ms.") >= 0 ? "microsoft" : "odbc"))))));
        }
        if (this.WjHGyTX.equalsIgnoreCase("ibm") || this.WjHGyTX.equalsIgnoreCase("db2")) {
            this.WjHGyWG = this.WjIFCxL;
            this.WjHGyWG[this.WjHGyWJ] = "SMALLINT";
            this.WjHGyWG[this.WjHGyWK] = "TIMESTAMP";
            this.WjHGyWG[this.WjHGyWM] = "BLOB";
        } else if (this.WjHGyTX.equalsIgnoreCase("oracle")) {
            this.WjHGyWG[this.WjHGyWJ] = "NUMBER(1)";
            this.WjHGyWG[this.WjHGyWK] = "DATE";
            this.WjHGyWG[this.WjHGyWL] = "NUMBER(10)";
            this.WjHGyWG[this.WjHGyWM] = "BLOB";
        } else if (this.WjHGyTX.equalsIgnoreCase("informix")) {
            this.WjHGyWG[this.WjHGyWJ] = "SMALLINT";
            this.WjHGyWG[this.WjHGyWK] = "DATETIME YEAR TO FRACTION";
            this.WjHGyWG[this.WjHGyWM] = "BYTE";
        } else if (this.WjHGyTX.equalsIgnoreCase("sybase") || this.WjHGyTX.equalsIgnoreCase("microsoft")) {
            this.WjHGyWG[this.WjHGyWK] = "DATETIME";
            this.WjHGyWG[this.WjHGyWM] = "IMAGE";
        } else if (this.WjHGyTX.equalsIgnoreCase("hsql")) {
            this.WjHGyWG[this.WjHGyWM] = "LONGVARBINARY";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE ");
        stringBuffer.append(this.WjHGyWC);
        for (int i = 0; i < this.WjHGyWG.length; ++i) {
            stringBuffer.append(this.WjHGyWG[i]);
        }
        return stringBuffer.toString();
    }

    private static void WjIsCpN() {
        String string = NdDotNETLib.isDotNETSupportEnabled() ? WjIvkWK : WjIvkWJ;
        System.out.println("usage: " + string + "\n\t -createTable\n\t" + "[-vendor <database vendor>]\n\t -driver <driver>\n\t -url <url>\n\t [-user <user>]\n\t " + "[-password <password>]\n\t -table <table name>\n\t [-createIndices] : creates indices for the id and the dirId columns\n\t [-f]  :  force to create a new table with the given table name");
        System.exit(-1);
    }

    private void WjIsCqO(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0 || stringArray[0].equalsIgnoreCase("help") || stringArray[0].equalsIgnoreCase("-help") || stringArray[0].equalsIgnoreCase("-h")) {
            NdJdbcRepositoryUtil.WjIsCpN();
            System.exit(-1);
        }
        int n = stringArray.length;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-driver")) {
                if (i + 1 > n || stringArray[i + 1] == null || stringArray[i + 1].startsWith("-")) continue;
                this.WjHGyUY = stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-vendor")) {
                if (i + 1 > n || stringArray[i + 1] == null || stringArray[i + 1].startsWith("-")) continue;
                this.WjHGyTX = stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-url")) {
                if (i + 1 > n || stringArray[i + 1] == null || stringArray[i + 1].startsWith("-")) continue;
                this.WjHGyVZ = stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-user")) {
                if (i + 1 > n || stringArray[i + 1] == null || stringArray[i + 1].startsWith("-")) continue;
                this.WjHGyWA = stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-password")) {
                if (i + 1 > n || stringArray[i + 1] == null || stringArray[i + 1].startsWith("-")) continue;
                this.WjHGyWB = stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-table")) {
                if (i + 1 > n || stringArray[i + 1] == null || stringArray[i + 1].startsWith("-")) continue;
                this.WjHGyWC = stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(WjIsCkI)) {
                this.WjIsClJ = WjIsCkI;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-f")) {
                this.WjIsCmK = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-createIndices")) {
                this.WjIvBcS = true;
                continue;
            }
            System.out.println("unknown: " + stringArray[i]);
            NdJdbcRepositoryUtil.WjIsCpN();
        }
    }

    private void WjHGyWT(Hashtable hashtable) throws NdRepositoryException {
        String string = (String)hashtable.get("JDBC.driver");
        String string2 = (String)hashtable.get("JDBC.database.url");
        String string3 = (String)hashtable.get("JDBC.repository.table");
        String string4 = (String)hashtable.get("JDBC.username");
        String string5 = (String)hashtable.get("JDBC.password");
        boolean bl = false;
        boolean bl2 = false;
        try {
            Class.forName(string);
            Connection connection = DriverManager.getConnection(string2, string4, string5);
            Statement statement = connection.createStatement();
            String string6 = "select * from " + string3;
            ResultSet resultSet = statement.executeQuery(string6);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            for (int i = 1; i < resultSetMetaData.getColumnCount() + 1; ++i) {
                if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("itemDeletedFlag")) {
                    bl2 = true;
                }
                if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("itemCreationId")) {
                    bl = true;
                }
                if (!bl2 || !bl) continue;
                return;
            }
            resultSet.close();
            String string7 = "ALTER TABLE " + string3 + " Add ";
            if (!bl2) {
                string7 = string7 + "itemDeletedFlag VARCHAR(255)";
            }
            if (!bl) {
                string7 = string7 + ", itemCreationId VARCHAR(255)";
            }
            statement.execute(string7);
            statement.close();
        }
        catch (SQLException sQLException) {
            throw new NdRepositoryException(sQLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NdRepositoryException(classNotFoundException);
        }
    }

    public void createRepository(NdRepositoryConnection ndRepositoryConnection, NdRepositoryConfig ndRepositoryConfig, String string, String string2, NdRepositoryConnection ndRepositoryConnection2) throws NdRepositoryException {
        if (ndRepositoryConfig == null && string2 == null) {
            throw new NdRepositoryException("Could not create repository without repository configuration content");
        }
        this.WjHJYZV = true;
        NdJdbcRepositoryConnection ndJdbcRepositoryConnection = (NdJdbcRepositoryConnection)ndRepositoryConnection;
        String string3 = null;
        if (ndRepositoryConfig != null) {
            string3 = NdRepositoryConfigWriter.getDefaultRepositoryConfigWriter().save(ndRepositoryConfig);
        }
        Hashtable hashtable = this.WjHJVRH(ndJdbcRepositoryConnection);
        this.createJdbcRepositoryEntry(null, hashtable, false);
        NdJdbcRepository ndJdbcRepository = new NdJdbcRepository(ndRepositoryConnection);
        ndJdbcRepository.openConnection(1);
        if (string3 != null) {
            ndJdbcRepository.setRepositoryConfig(ndRepositoryConfig);
        }
        ndJdbcRepository.closeConnection();
        this.WjHJYZV = false;
    }

    public void createWorkspace(NdRepositoryConnection ndRepositoryConnection, String string) throws NdRepositoryException {
        this.WjHJYZV = true;
        NdJdbcRepositoryConnection ndJdbcRepositoryConnection = (NdJdbcRepositoryConnection)ndRepositoryConnection;
        Hashtable hashtable = this.WjHJVRH(ndJdbcRepositoryConnection);
        this.createJdbcRepositoryEntry(null, hashtable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWorkspace(NdRepositoryConnection ndRepositoryConnection) throws NdRepositoryException {
        NdJdbcRepositoryConnection ndJdbcRepositoryConnection = (NdJdbcRepositoryConnection)ndRepositoryConnection;
        NdJdbcRepository ndJdbcRepository = new NdJdbcRepository(ndJdbcRepositoryConnection);
        ndJdbcRepository.openConnection(1);
        this.WjIamZG(ndJdbcRepository);
        ndJdbcRepository.closeConnection();
        try {
            Connection connection;
            String string = ndJdbcRepositoryConnection.getJdbcDriver();
            Class.forName(string);
            String string2 = ndJdbcRepositoryConnection.getJdbcUrl();
            String string3 = ndJdbcRepositoryConnection.getUser();
            String string4 = ndJdbcRepositoryConnection.getPassword();
            Connection connection2 = connection = DriverManager.getConnection(string2, string3, string4);
            synchronized (connection2) {
                String string5 = ndJdbcRepositoryConnection.getJdbcTable();
                ndJdbcRepository.openConnection(1);
                String string6 = (String)ndJdbcRepository.getKey();
                String string7 = "DELETE FROM " + string5 + " WHERE id=?";
                PreparedStatement preparedStatement = connection.prepareStatement(string7);
                preparedStatement.setString(1, string6);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                String string8 = "DELETE FROM " + string5 + " WHERE dirid=?";
                PreparedStatement preparedStatement2 = connection.prepareStatement(string8);
                preparedStatement2.setString(1, string6);
                preparedStatement2.executeUpdate();
                preparedStatement2.close();
                connection.close();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NdRepositoryException(classNotFoundException);
        }
        catch (SQLException sQLException) {
            throw new NdRepositoryException(sQLException);
        }
    }

    public void processCommand(String[] stringArray) throws Exception {
        this.WjIsCqO(stringArray);
        if (this.WjIsClJ == null || this.WjIsClJ.length() == 0) {
            System.out.println("Error: an utility command must be specified.");
            NdJdbcRepositoryUtil.WjIsCpN();
        }
        if (this.WjIsClJ.equals(WjIsCkI)) {
            this.WjIsCoM();
        }
    }

    public static void main(String[] stringArray) {
        NdJdbcRepositoryUtil ndJdbcRepositoryUtil = new NdJdbcRepositoryUtil();
        try {
            ndJdbcRepositoryUtil.processCommand(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

