/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.tools;

import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntry;
import com.blazesoft.repository.base.NdRepositoryEntryLocationManager;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryFactory;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdRepositoryVersionSystemAdmin;
import com.blazesoft.repository.base.NdVersioningRepositoryConnection;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.base.NdWorkspaceDirectory;
import com.blazesoft.repository.base.NdWorkspaceEntry;
import com.blazesoft.repository.config.NdRepositoryConfig;
import com.blazesoft.repository.config.NdRepositoryConfigWriter;
import com.blazesoft.repository.config.legacy.NdBaseRepositoryConfig;
import com.blazesoft.repository.config.legacy.NdBaseRepositoryConfigLoader;
import com.blazesoft.repository.config.legacy.NdBaseRepositoryConfigWriter;
import com.blazesoft.repository.jndi.NdJndiLdapRepository;
import com.blazesoft.repository.jndi.NdJndiLdapRepositoryConnection;
import com.blazesoft.repository.jndi.NdJndiLdapRepositoryEntryLocationManager;
import com.blazesoft.repository.jndi.NdJndiRepository;
import com.blazesoft.repository.jndi.NdJndiRepositoryItem;
import com.blazesoft.repository.jndi.NdLdapRepositoryConfig;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.tools.NdRepositoryFactoryUtil;
import com.blazesoft.repository.tools.NdRepositoryUtilBase;
import com.blazesoft.util.NdIOUtil;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class NdJndiLdapRepositoryUtil
extends NdRepositoryUtilBase
implements NdRepositoryFactoryUtil {
    private String WjHGyGQ = "com.sun.jndi.ldap.LdapCtxFactory";
    private InitialDirContext WjHGyHR = null;
    private String WjHGyIS;
    private String WjHGyJT;
    private String WjHGyKU;
    private String WjHGyLV;
    private NdRepositoryEntryLocationManager WjHKCmF = null;
    private NdLocation WjHKCmG = null;
    private NdLdapRepositoryConfig WjHGyOY;

    private void WjHGyQC() throws Exception {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.security.principal", this.WjHGyJT);
        hashtable.put("java.naming.security.credentials", this.WjHGyKU);
        if (this.WjHGyGQ == null) {
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        } else {
            hashtable.put("java.naming.factory.initial", this.WjHGyGQ);
        }
        hashtable.put("java.naming.provider.url", this.WjHGyIS);
        this.WjHGyHR = new InitialDirContext(hashtable);
        this.WjHKCmF = new NdJndiLdapRepositoryEntryLocationManager();
        this.WjHKCmG = this.WjHKCmF.translatePhysicalLocation(this.WjHGyLV);
    }

    private void WjHGyQD() throws Exception {
        String[] stringArray = this.WjHKCmG.getComponents();
        DirContext dirContext = this.WjHGyHR;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            BasicAttributes basicAttributes = new BasicAttributes(true);
            BasicAttribute basicAttribute = new BasicAttribute("objectclass");
            basicAttribute.add("top");
            basicAttribute.add("innovatorEntry");
            basicAttribute.add("innovatorDirectory");
            basicAttribute.add("innovatorRepository");
            basicAttributes.put(basicAttribute);
            basicAttributes.put("innovatorClass", "Repository");
            basicAttributes.put("innovatorName", string);
            NdLocation ndLocation = this.WjHKCmF.translatePhysicalLocation(string);
            dirContext = dirContext.createSubcontext(this.WjHKCmF.translateLocation(ndLocation), (Attributes)basicAttributes);
        }
    }

    private void WjIekLL(NdRepository ndRepository, String string) throws NdRepositoryException {
        NdJndiRepositoryItem ndJndiRepositoryItem = (NdJndiRepositoryItem)ndRepository.createRepositoryItem("_com_blazesoft_repository_config_object");
        NdRepositoryItemContent ndRepositoryItemContent = new NdRepositoryItemContent(string);
        ndRepository.addRepositoryItem(ndJndiRepositoryItem, ndRepositoryItemContent, null);
    }

    protected void createLdapRepository(String string, Hashtable hashtable) throws NdRepositoryException {
        this.WjHGyIS = null;
        this.WjHGyJT = null;
        this.WjHGyKU = null;
        this.WjHGyLV = null;
        this.WjHGyIS = (String)hashtable.get("java.naming.provider.url");
        this.WjHGyJT = (String)hashtable.get("java.naming.security.principal");
        this.WjHGyKU = (String)hashtable.get("java.naming.security.credentials");
        this.WjHGyLV = (String)hashtable.get("com.blazesoft.repository.base.repositoryname");
        if (string != null && string.length() != 0) {
            this.WjHGyGQ = string;
        }
        hashtable.put("java.naming.factory.initial", this.WjHGyGQ);
        if (this.WjHGyIS == null || this.WjHGyJT == null || this.WjHGyKU == null || this.WjHGyLV == null) {
            throw new NdRepositoryException("Failed to create a LDAP repository. One or more followed parameters may not be specified: url; user; password and repository name");
        }
        try {
            this.WjHGyQC();
            this.WjHGyQD();
        }
        catch (Exception exception) {
            throw new NdRepositoryException(exception);
        }
    }

    protected void changeLdapRepositoryConfig(String string, Hashtable hashtable, boolean bl) throws NdRepositoryException {
        this.WjHGyOY = null;
        String string2 = (String)hashtable.get("com.blazesoft.repository.config.path");
        String string3 = (String)hashtable.get("com.blazesoft.repository.base.repositoryclass");
        if (string3 == null) {
            hashtable.put("com.blazesoft.repository.base.repositoryclass", "com.blazesoft.repository.jndi.NdJndiLdapRepository");
        }
        this.WjHGyGQ = string;
        hashtable.put("java.naming.factory.initial", this.WjHGyGQ);
        String string4 = null;
        if (string2 != null && string2.length() > 0) {
            Object object;
            NdBaseRepositoryConfig ndBaseRepositoryConfig = NdBaseRepositoryConfigLoader.getDefaultRepositoryConfigLoader().load(string2);
            if (ndBaseRepositoryConfig != null) {
                this.WjHGyOY = (NdLdapRepositoryConfig)ndBaseRepositoryConfig.getRepositoryConfig();
                object = new File(string2);
                try {
                    string4 = new String(NdIOUtil.readFile((String)((File)object).getCanonicalPath()), "UTF8");
                }
                catch (IOException iOException) {
                    throw new NdRepositoryException(iOException);
                }
            } else {
                throw new NdRepositoryException("Could not load a base repository configuration from " + string2);
            }
            if (this.WjHGyOY == null) {
                throw new NdRepositoryException("Could not extract a LDAP repository configuration from " + string2);
            }
            object = (NdWorkspace)NdRepositoryFactory.newRepository(hashtable);
            object.openConnection(1);
            if (this.isItemContentConverterChanged()) {
                System.out.println("***Message: No item content converter changes will be made. This is not supported in a JNDI repository for this release.");
            }
            boolean bl2 = object.isVersioned();
            this.WjIekLL((NdRepository)object, string4);
            object.closeConnection();
            object = (NdWorkspace)NdRepositoryFactory.newRepository(hashtable);
            object.openConnection(1);
            boolean bl3 = object.isVersioned();
            if (!bl2 && bl3) {
                this.initializeVersioning((NdWorkspaceDirectory)object);
            }
            if (bl2) {
                if (this.isDropVersionHistory()) {
                    this.cleanVersionHistory((NdRepository)object);
                } else if (this.isReleaseVersionLocks()) {
                    // empty if block
                }
            }
        }
    }

    protected void getLdapRepositoryConfig(String string, Hashtable hashtable) throws NdRepositoryException {
        block7: {
            this.WjHGyOY = null;
            String string2 = (String)hashtable.get("com.blazesoft.repository.config.path");
            String string3 = (String)hashtable.get("com.blazesoft.repository.base.repositoryclass");
            if (string3 == null) {
                hashtable.put("com.blazesoft.repository.base.repositoryclass", "com.blazesoft.repository.jndi.NdJndiLdapRepository");
            }
            this.WjHGyGQ = string;
            hashtable.put("java.naming.factory.initial", this.WjHGyGQ);
            if (string2 != null && string2.length() > 0) {
                try {
                    NdJndiRepository ndJndiRepository = (NdJndiRepository)NdRepositoryFactory.newRepository(hashtable);
                    ndJndiRepository.openConnection(1);
                    DirContext dirContext = (DirContext)ndJndiRepository.getRepEntry();
                    if (dirContext != null) {
                        String[] stringArray = new String[]{"innovatorItemContent"};
                        String string4 = ndJndiRepository.getRepositoryEntryLocationManager().translateLocation(ndJndiRepository.getRepositoryEntryLocationManager().translatePhysicalLocation("_com_blazesoft_repository_config_object"));
                        Attributes attributes = dirContext.getAttributes(string4, stringArray);
                        NdBaseRepositoryConfig ndBaseRepositoryConfig = null;
                        if (attributes == null) break block7;
                        String string5 = (String)attributes.get("innovatorItemContent").get();
                        if (string5 != null && string5.length() > 0) {
                            StringBuffer stringBuffer = new StringBuffer(string5);
                            ndBaseRepositoryConfig = NdBaseRepositoryConfigLoader.getDefaultRepositoryConfigLoader().load(stringBuffer);
                            if (ndBaseRepositoryConfig != null) {
                                NdBaseRepositoryConfigWriter ndBaseRepositoryConfigWriter = NdBaseRepositoryConfigWriter.getDefaultRepositoryConfigWriter();
                                ndBaseRepositoryConfigWriter.save(string2, ndBaseRepositoryConfig);
                                break block7;
                            }
                            throw new NdRepositoryException("Failed to get dirContext of the ldap repository " + ndJndiRepository.getName());
                        }
                        throw new NdRepositoryException("Failed to get dirContext of the ldap repository " + ndJndiRepository.getName());
                    }
                    throw new NdRepositoryException("Failed to get dirContext of the ldap repository " + ndJndiRepository.getName());
                }
                catch (Exception exception) {
                    throw new NdRepositoryException(exception);
                }
            }
        }
    }

    protected void listCheckouts(Hashtable hashtable) throws NdRepositoryException {
        String string = (String)hashtable.get("com.blazesoft.checkedout.entry.path");
        String string2 = (String)hashtable.get("com.blazesoft.checkedout.user.id");
        hashtable.remove("com.blazesoft.checkedout.entry.path");
        hashtable.remove("com.blazesoft.checkedout.user.id");
        hashtable.put("com.blazesoft.repository.base.repositoryclass", "com.blazesoft.repository.jndi.NdJndiLdapRepository");
        hashtable.put("java.naming.factory.initial", this.WjHGyGQ);
        NdWorkspaceEntry ndWorkspaceEntry = null;
        NdWorkspace ndWorkspace = (NdWorkspace)NdRepositoryFactory.newRepository(hashtable);
        ndWorkspace.openConnection(1);
        if (!ndWorkspace.isVersioned()) {
            System.out.println("***Error: The target repository is not a versioned repository.");
            System.exit(-1);
        } else if (string != null && string.length() > 0) {
            ndWorkspaceEntry = (NdWorkspaceEntry)NdRepositorySupport.lookupEntry((NdRepositoryDirectory)ndWorkspace, string);
            if (ndWorkspaceEntry == null) {
                System.out.println("***Error: Could not find entry '" + string + "' in the target repository.");
                System.exit(-1);
            }
        } else {
            ndWorkspaceEntry = ndWorkspace;
        }
        this.listCheckedOutItemInfos(ndWorkspaceEntry, string2);
    }

    protected void cancelCheckouts(Hashtable hashtable) throws NdRepositoryException {
        NdVersioningRepositoryConnection ndVersioningRepositoryConnection = null;
        String string = (String)hashtable.get("com.blazesoft.checkedout.entry.path");
        String string2 = (String)hashtable.get("com.blazesoft.checkedout.user.id");
        hashtable.remove("com.blazesoft.checkedout.entry.path");
        hashtable.remove("com.blazesoft.checkedout.user.id");
        hashtable.put("com.blazesoft.repository.base.repositoryclass", "com.blazesoft.repository.jndi.NdJndiLdapRepository");
        hashtable.put("java.naming.factory.initial", this.WjHGyGQ);
        NdRepositoryEntry ndRepositoryEntry = null;
        NdWorkspace ndWorkspace = (NdWorkspace)NdRepositoryFactory.newRepository(hashtable);
        ndWorkspace.openConnection(1);
        NdRepositoryVersionSystemAdmin ndRepositoryVersionSystemAdmin = ndWorkspace.getRepositoryVersionSystemAdmin();
        if (ndRepositoryVersionSystemAdmin == null) {
            System.out.println("***Error: The target repository is not a versioned repository.");
            System.exit(-1);
        } else {
            ndVersioningRepositoryConnection = ndWorkspace.getRepositoryConfig().getRepositoryVersionManagerConfig().getVersioningRepositoryConnection();
            if (string != null && string.length() > 0) {
                ndRepositoryEntry = NdRepositorySupport.lookupEntry((NdRepositoryDirectory)ndWorkspace, string);
                if (ndRepositoryEntry == null) {
                    System.out.println("***Error: Could not find entry '" + string + "' in the target repository.");
                    System.exit(-1);
                }
            } else {
                ndRepositoryEntry = ndWorkspace;
            }
        }
        this.cancelCheckouts(ndRepositoryVersionSystemAdmin, ndRepositoryEntry, string2, ndVersioningRepositoryConnection);
    }

    public void createRepository(NdRepositoryConnection ndRepositoryConnection, NdRepositoryConfig ndRepositoryConfig, String string, String string2, NdRepositoryConnection ndRepositoryConnection2) throws NdRepositoryException {
        if (ndRepositoryConfig == null && string2 == null) {
            throw new NdRepositoryException("Could not create repository without repository configuration content");
        }
        String string3 = null;
        if (ndRepositoryConfig != null) {
            string3 = NdRepositoryConfigWriter.getDefaultRepositoryConfigWriter().save(ndRepositoryConfig);
        }
        NdJndiLdapRepositoryConnection ndJndiLdapRepositoryConnection = (NdJndiLdapRepositoryConnection)ndRepositoryConnection;
        Hashtable hashtable = ndJndiLdapRepositoryConnection.getLdapConnectionArgs();
        this.createLdapRepository(ndJndiLdapRepositoryConnection.getInitialContextFactory(), hashtable);
        NdJndiLdapRepository ndJndiLdapRepository = new NdJndiLdapRepository(ndJndiLdapRepositoryConnection);
        ndJndiLdapRepository.openConnection(1);
        if (string3 != null) {
            ndJndiLdapRepository.setRepositoryConfig(ndRepositoryConfig);
        }
        ndJndiLdapRepository.closeConnection();
    }

    public void createWorkspace(NdRepositoryConnection ndRepositoryConnection, String string) throws NdRepositoryException {
        NdJndiLdapRepositoryConnection ndJndiLdapRepositoryConnection = (NdJndiLdapRepositoryConnection)ndRepositoryConnection;
        Hashtable hashtable = ndJndiLdapRepositoryConnection.getLdapConnectionArgs();
        this.createLdapRepository(ndJndiLdapRepositoryConnection.getInitialContextFactory(), hashtable);
    }

    public void deleteWorkspace(NdRepositoryConnection ndRepositoryConnection) throws NdRepositoryException {
        NdJndiLdapRepositoryConnection ndJndiLdapRepositoryConnection = (NdJndiLdapRepositoryConnection)ndRepositoryConnection;
        NdJndiLdapRepository ndJndiLdapRepository = new NdJndiLdapRepository(ndJndiLdapRepositoryConnection);
        ndJndiLdapRepository.openConnection(1);
        this.WjIamZG(ndJndiLdapRepository);
        Hashtable hashtable = ndJndiLdapRepositoryConnection.getLdapConnectionArgs();
        try {
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            String string = "dsnInnovatorComponent=" + ndJndiLdapRepositoryConnection.getRepositoryName();
            DirContext dirContext = (DirContext)initialDirContext.lookup(string);
            NamingEnumeration<Binding> namingEnumeration = dirContext.listBindings(ndJndiLdapRepository.getRepName());
            while (namingEnumeration.hasMoreElements()) {
                Binding binding = (Binding)namingEnumeration.nextElement();
                String string2 = binding.getName();
                dirContext.unbind(string2);
            }
            initialDirContext.destroySubcontext(string);
        }
        catch (NamingException namingException) {
            throw new NdRepositoryException(namingException);
        }
    }
}

