/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.url;

import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.url.NdStrings;
import com.blazesoft.repository.url.NdUrlEntryRepositoryException;
import com.blazesoft.repository.url.NdUrlRepositoryDirectory;
import com.blazesoft.repository.url.NdUrlRepositoryEntry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Date;

public class NdUrlRepositoryItem
extends NdUrlRepositoryEntry
implements NdRepositoryItem {
    NdUrlRepositoryItem(NdUrlRepositoryDirectory ndUrlRepositoryDirectory, NdLocation ndLocation) {
        super(ndUrlRepositoryDirectory, ndLocation);
    }

    protected BufferedReader getReader(URL uRL, String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), string));
        return bufferedReader;
    }

    public NdRepositoryItemContent getContent() throws NdRepositoryException {
        String string;
        try {
            String string2;
            BufferedReader bufferedReader = this.getReader(this.getURL(), "UTF-8");
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append('\n');
            }
            bufferedReader.close();
            string = stringBuffer.toString();
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw ndRepositoryException;
        }
        catch (Exception exception) {
            throw new NdUrlEntryRepositoryException(NdStrings.WjHBryC("CouldNotReadContent", this.getName()), this, exception);
        }
        return new NdRepositoryItemContent(string);
    }

    public void setContent(NdRepositoryItemContent ndRepositoryItemContent) throws NdRepositoryException {
        throw new NdUrlEntryRepositoryException(NdStrings.WjHBryC("UnsupportedItemContentSet", this), this);
    }

    public Date getLastModified() throws NdRepositoryException {
        try {
            URL uRL = this.getURL();
            return new Date(uRL.openConnection().getLastModified());
        }
        catch (Exception exception) {
            throw new NdRepositoryException(exception);
        }
    }

    public void setLastModified(Date date) throws NdRepositoryException {
        throw new NdRepositoryException();
    }

    public boolean isReadable() throws NdRepositoryException {
        return true;
    }

    public boolean isWritable() throws NdRepositoryException {
        return false;
    }
}

