/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.zip;

import com.blazesoft.repository.base.NdRepository;
import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdRepositoryEntryLocationManager;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItemContentConverter;
import com.blazesoft.repository.base.NdRepositoryListener;
import com.blazesoft.repository.config.NdRepositoryConfig;
import com.blazesoft.repository.config.NdRepositoryConfigLoader;
import com.blazesoft.repository.config.NdRepositoryConfigWriter;
import com.blazesoft.repository.config.NdRepositoryItemContentConverterFactory;
import com.blazesoft.repository.zip.NdStrings;
import com.blazesoft.repository.zip.NdZipRepositoryConnection;
import com.blazesoft.repository.zip.NdZipRepositoryDirectory;
import com.blazesoft.repository.zip.NdZipRepositoryEntryAccessor;
import com.blazesoft.repository.zip.NdZipRepositoryEntryLocationManager;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import java.util.zip.ZipEntry;

public class NdZipRepository
extends NdZipRepositoryDirectory
implements NdRepository {
    private NdZipRepositoryConnection WjInJlN;
    private NdZipRepositoryEntryLocationManager WjInJmO;
    private int WjInJnP;
    private boolean WjInJoQ;
    private Vector WjInJpR;
    private NdRepositoryConfig WjInJqS = null;
    private NdZipRepositoryEntryAccessor WjInJrT;
    private NdRepositoryItemContentConverter WjInJsU;

    public NdZipRepository(NdRepositoryConnection ndRepositoryConnection) throws NdRepositoryException {
        this.WjInJlN = (NdZipRepositoryConnection)ndRepositoryConnection;
        if (ndRepositoryConnection.getRepositoryName() == null || ndRepositoryConnection.getRepositoryName().length() == 0) {
            throw new NdRepositoryException(NdStrings.WjInMYR("CouldNotFindRepositoryNameInZipRepositoryConnection"));
        }
        this.WjInJFJ(ndRepositoryConnection.getRepositoryName());
        this.WjInJFK(new ZipEntry(ndRepositoryConnection.getRepositoryName() + "/"));
        this.WjInJrT = new NdZipRepositoryEntryAccessor(this.WjInJlN.getZipFilePath());
        this.WjInJuW();
        this.WjInJoQ = false;
    }

    NdZipRepository WjInJFI() {
        return this;
    }

    NdZipRepositoryEntryAccessor WjInJtV() {
        return this.WjInJrT;
    }

    private void WjInJuW() throws NdRepositoryException {
        byte[] byArray = this.WjInJrT.WjInLaX(this.WjInJlN.getRepositoryName() + "/" + "com_blazesoft_repository_config.cfg");
        String string = new String(byArray);
        this.WjInJqS = NdRepositoryConfigLoader.getDefaultRepositoryConfigLoader(this.WjInJlN.getClassLoadingContext()).load(new StringBuffer(string));
    }

    private void WjInJvX() throws NdRepositoryException {
        NdRepositoryItemContentConverterFactory ndRepositoryItemContentConverterFactory = null;
        if (this.WjInJqS != null) {
            ndRepositoryItemContentConverterFactory = this.WjInJqS.getRepositoryItemContentConverterFactory();
        }
        this.WjInJsU = ndRepositoryItemContentConverterFactory != null ? (NdRepositoryItemContentConverter)ndRepositoryItemContentConverterFactory.newRepositoryItemContentConverter() : null;
        if (this.WjInJsU != null) {
            this.WjInJsU.openConnection(this);
        }
    }

    String WjInJwY() {
        return this.WjInJlN.getUser();
    }

    public void openConnection(int n) throws NdRepositoryException {
        this.WjInJnP = n;
        this.WjInJrT.WjInLaT(n);
        if (this.WjInJsU == null) {
            this.WjInJvX();
        }
        this.WjInJoQ = true;
    }

    public void closeConnection() throws NdRepositoryException {
        if (this.WjInJoQ) {
            this.WjInJrT.WjInLaU();
            this.WjInJoQ = false;
        }
    }

    public int getRepositoryMode() {
        return this.WjInJnP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepositoryListener(NdRepositoryListener ndRepositoryListener) {
        NdZipRepository ndZipRepository = this;
        synchronized (ndZipRepository) {
            if (this.WjInJpR == null) {
                this.WjInJpR = new Vector();
            }
            this.WjInJpR.addElement(ndRepositoryListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepositoryListener(NdRepositoryListener ndRepositoryListener) {
        NdZipRepository ndZipRepository = this;
        synchronized (ndZipRepository) {
            if (this.WjInJpR != null) {
                this.WjInJpR.removeElement(ndRepositoryListener);
            }
        }
    }

    public NdRepositoryEntryLocationManager getRepositoryEntryLocationManager() {
        if (this.WjInJmO == null) {
            String string = this.WjInJlN.getZipFilePath();
            this.WjInJmO = new NdZipRepositoryEntryLocationManager(string);
        }
        return this.WjInJmO;
    }

    public NdRepositoryItemContentConverter getRepositoryItemContentConverter() {
        return this.WjInJsU;
    }

    public void setRepositoryItemContentConverter(NdRepositoryItemContentConverter ndRepositoryItemContentConverter) {
        this.WjInJsU = ndRepositoryItemContentConverter;
    }

    public NdRepositoryConfig getRepositoryConfig() {
        return this.WjInJqS;
    }

    public NdRepositoryConnection getRepositoryConnection() {
        return this.WjInJlN;
    }

    public void setRepositoryConfig(NdRepositoryConfig ndRepositoryConfig) throws NdRepositoryException {
        byte[] byArray;
        String string = NdRepositoryConfigWriter.getDefaultRepositoryConfigWriter().save(ndRepositoryConfig);
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NdRepositoryException(unsupportedEncodingException);
        }
        byte[][] byArrayArray = new byte[][]{byArray};
        String string2 = this.getName() + "/" + "com_blazesoft_repository_config.cfg";
        this.WjInJrT.WjInLaS(new String[]{string2}, byArrayArray, this.WjInJqS == null);
        this.WjInJqS = ndRepositoryConfig;
    }
}

