/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.zip;

import com.blazesoft.repository.base.NdRepositoryAdmin;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdWorkspaceConnection;
import com.blazesoft.repository.config.NdRepositoryConfig;
import com.blazesoft.repository.config.NdRepositoryConfigWriter;
import com.blazesoft.repository.tools.NdRepositoryUtil;
import com.blazesoft.repository.zip.NdStrings;
import com.blazesoft.repository.zip.NdZipRepositoryConnection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class NdZipRepositoryAdmin
implements NdRepositoryAdmin {
    public void createWorkspace(NdWorkspaceConnection ndWorkspaceConnection, NdRepositoryConfig ndRepositoryConfig) throws NdRepositoryException {
        if (ndWorkspaceConnection == null || !(ndWorkspaceConnection instanceof NdZipRepositoryConnection)) {
            throw new NdRepositoryException(NdStrings.WjInMYR("AZipRepositoryConnectionIsRequiredForZipRepositoryWorkspaceCreation"));
        }
        NdZipRepositoryConnection ndZipRepositoryConnection = (NdZipRepositoryConnection)ndWorkspaceConnection;
        File file = new File(ndZipRepositoryConnection.getZipFilePath());
        if (file.exists()) {
            throw new NdRepositoryException(NdStrings.WjInMYT("FailedToCreateZipRepositoryWorkspaceBecauseFileAlreadyExists", file.getAbsolutePath()));
        }
        String string = NdRepositoryConfigWriter.getDefaultRepositoryConfigWriter().save(ndRepositoryConfig);
        byte[] byArray = string.getBytes();
        String string2 = ndZipRepositoryConnection.getRepositoryName() + "/" + "com_blazesoft_repository_config.cfg";
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            CRC32 cRC32 = new CRC32();
            cRC32.reset();
            cRC32.update(byArray, 0, byArray.length);
            ZipEntry zipEntry = new ZipEntry(string2);
            zipEntry.setCrc(cRC32.getValue());
            zipEntry.setSize(byArray.length);
            zipEntry.setMethod(0);
            try {
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(byArray, 0, byArray.length);
                zipOutputStream.closeEntry();
                ((FilterOutputStream)zipOutputStream).flush();
                zipOutputStream.close();
            }
            catch (IOException iOException) {
                throw new NdRepositoryException(iOException);
            }
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
    }

    public void removeWorkspace(NdWorkspaceConnection ndWorkspaceConnection) throws NdRepositoryException {
        String string = ((NdZipRepositoryConnection)ndWorkspaceConnection).getZipFilePath();
        NdRepositoryUtil.deleteDirectoryOrFile(string);
    }
}

