/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.zip;

import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.zip.NdStrings;
import com.blazesoft.repository.zip.NdZipRepositoryDirectory;
import com.blazesoft.repository.zip.NdZipRepositoryEntry;
import com.blazesoft.repository.zip.NdZipRepositoryItem;
import com.blazesoft.util.NdIOUtil;
import com.blazesoft.util.NdProperties;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class NdZipRepositoryEntryAccessor {
    private ZipOutputStream WjInLaK;
    private String WjInLaL;
    private int WjInLaM;
    private boolean WjInLaN;
    private ZipFile WjInLaO;

    NdZipRepositoryEntryAccessor(String string) throws NdRepositoryException {
        this.WjInLaL = string;
        try {
            this.WjInLaO = new ZipFile(string);
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
    }

    private byte[] WjInLaQ(NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
            NdRepositoryEntryAttribute ndRepositoryEntryAttribute = ndRepositoryEntryAttributeArray[i];
            stringBuffer.append(ndRepositoryEntryAttribute.getAttbId());
            stringBuffer.append("=");
            if (ndRepositoryEntryAttribute.getAttbValue() != null) {
                stringBuffer.append(ndRepositoryEntryAttribute.getAttbValue());
            }
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString().getBytes();
    }

    private void WjInLaR(String[] stringArray) throws NdRepositoryException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);
        try {
            Object object;
            Enumeration<? extends ZipEntry> enumeration = this.WjInLaO.entries();
            while (enumeration.hasMoreElements()) {
                byte[] byArray;
                boolean bl = false;
                object = enumeration.nextElement();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!((ZipEntry)object).getName().equals(stringArray[i])) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                if (((ZipEntry)object).getSize() > 0L) {
                    InputStream inputStream = this.WjInLaO.getInputStream((ZipEntry)object);
                    byArray = NdIOUtil.readAllBytes((InputStream)inputStream, (int)((int)(((ZipEntry)object).getSize() != -1L ? ((ZipEntry)object).getSize() : 4096L)));
                    inputStream.close();
                } else {
                    byArray = new byte[]{};
                }
                CRC32 cRC32 = new CRC32();
                cRC32.reset();
                cRC32.update(byArray, 0, byArray.length);
                ZipEntry zipEntry = new ZipEntry(((ZipEntry)object).getName());
                zipEntry.setCrc(cRC32.getValue());
                zipEntry.setSize(byArray.length);
                zipEntry.setMethod(0);
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(byArray, 0, byArray.length);
                zipOutputStream.closeEntry();
            }
            this.WjInLaO.close();
            File file = new File(this.WjInLaL);
            ((FilterOutputStream)zipOutputStream).flush();
            zipOutputStream.close();
            object = byteArrayOutputStream.toByteArray();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write((byte[])object);
            fileOutputStream.close();
            this.WjInLaO = new ZipFile(file);
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
    }

    void WjInLaS(String[] stringArray, byte[][] byArray, boolean bl) throws NdRepositoryException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);
        byte[] byArray2 = new byte[]{};
        try {
            Object object;
            Object object2;
            Enumeration<? extends ZipEntry> enumeration = this.WjInLaO.entries();
            while (enumeration.hasMoreElements()) {
                boolean bl2 = true;
                ZipEntry zipEntry = enumeration.nextElement();
                if (!bl) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!zipEntry.getName().equals(stringArray[i])) continue;
                        byArray2 = byArray[i];
                        bl2 = false;
                        break;
                    }
                }
                if (bl2) {
                    if (zipEntry.getSize() > 0L) {
                        InputStream inputStream = this.WjInLaO.getInputStream(zipEntry);
                        byArray2 = NdIOUtil.readAllBytes((InputStream)inputStream, (int)((int)(zipEntry.getSize() != -1L ? zipEntry.getSize() : 4096L)));
                        inputStream.close();
                    } else {
                        byArray2 = new byte[]{};
                    }
                }
                object2 = new CRC32();
                ((CRC32)object2).reset();
                ((CRC32)object2).update(byArray2, 0, byArray2.length);
                object = new ZipEntry(zipEntry.getName());
                ((ZipEntry)object).setCrc(((CRC32)object2).getValue());
                ((ZipEntry)object).setSize(byArray2.length);
                ((ZipEntry)object).setMethod(0);
                zipOutputStream.putNextEntry((ZipEntry)object);
                zipOutputStream.write(byArray2, 0, byArray2.length);
                zipOutputStream.closeEntry();
            }
            if (bl) {
                for (int i = 0; i < stringArray.length; ++i) {
                    object2 = stringArray[i];
                    object = new ZipEntry((String)object2);
                    ((ZipEntry)object).setSize(byArray[i].length);
                    if (byArray[i].length > 0) {
                        CRC32 cRC32 = new CRC32();
                        cRC32.reset();
                        cRC32.update(byArray[i], 0, byArray[i].length);
                        ((ZipEntry)object).setCrc(cRC32.getValue());
                        ((ZipEntry)object).setMethod(0);
                    }
                    zipOutputStream.putNextEntry((ZipEntry)object);
                    zipOutputStream.write(byArray[i], 0, byArray[i].length);
                    zipOutputStream.closeEntry();
                }
            }
            this.WjInLaO.close();
            ((FilterOutputStream)zipOutputStream).flush();
            zipOutputStream.close();
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            object2 = new File(this.WjInLaL);
            object = new FileOutputStream((File)object2);
            ((FileOutputStream)object).write(byArray3);
            ((FileOutputStream)object).close();
            this.WjInLaO = new ZipFile((File)object2);
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
    }

    void WjInLaT(int n) throws NdRepositoryException {
        this.WjInLaM = n;
        try {
            this.WjInLaO = new ZipFile(this.WjInLaL);
            if (n == 1) {
                this.WjInLaK = new ZipOutputStream(new FileOutputStream(this.WjInLaL, true));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NdRepositoryException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
    }

    void WjInLaU() throws NdRepositoryException {
        if (this.WjInLaN) {
            try {
                this.WjInLaO.close();
                if (this.WjInLaK != null) {
                    this.WjInLaK.close();
                    this.WjInLaK = null;
                }
            }
            catch (IOException iOException) {
                throw new NdRepositoryException(iOException);
            }
            this.WjInLaN = false;
        }
    }

    private NdProperties WjInLaV(NdZipRepositoryEntry ndZipRepositoryEntry) throws NdRepositoryException {
        String string;
        Object object;
        ZipEntry zipEntry = (ZipEntry)ndZipRepositoryEntry.getPhysicalDescription();
        if (ndZipRepositoryEntry instanceof NdRepositoryDirectory) {
            object = zipEntry.getName();
            string = ((String)object).substring(0, ((String)object).length() - 1) + ".innovator_attbs";
        } else {
            string = zipEntry.getName() + ".innovator_attbs";
        }
        object = this.WjInLaO.getEntry(string);
        NdProperties ndProperties = new NdProperties();
        if (object != null) {
            try {
                InputStream inputStream = this.WjInLaO.getInputStream((ZipEntry)object);
                byte[] byArray = ((ZipEntry)object).getSize() > 0L ? NdIOUtil.readAllBytes((InputStream)inputStream, (int)((int)(((ZipEntry)object).getSize() != -1L ? ((ZipEntry)object).getSize() : 4096L))) : new byte[]{};
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ndProperties.load((InputStream)byteArrayInputStream);
                ((InputStream)byteArrayInputStream).close();
            }
            catch (IOException iOException) {
                throw new NdRepositoryException(iOException);
            }
        }
        return ndProperties;
    }

    ZipEntry WjInLaW(String string) throws NdRepositoryException {
        return this.WjInLaO.getEntry(string);
    }

    byte[] WjInLaX(String string) throws NdRepositoryException {
        byte[] byArray;
        try {
            ZipEntry zipEntry = this.WjInLaO.getEntry(string);
            InputStream inputStream = this.WjInLaO.getInputStream(zipEntry);
            byArray = zipEntry.getSize() > 0L ? NdIOUtil.readAllBytes((InputStream)inputStream, (int)((int)(zipEntry.getSize() != -1L ? zipEntry.getSize() : 4096L))) : new byte[]{};
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new NdRepositoryException(iOException);
        }
        return byArray;
    }

    ZipEntry[] WjInLaY(String string) {
        Object object;
        Cloneable cloneable;
        Vector<Cloneable> vector = new Vector<Cloneable>();
        Enumeration<ZipEntry> enumeration = this.WjInLaO.entries();
        while (enumeration.hasMoreElements()) {
            cloneable = enumeration.nextElement();
            object = ((ZipEntry)cloneable).getName();
            if (!object.startsWith(string) || object.endsWith(".innovator_attbs") || object.endsWith("com_blazesoft_repository_config.cfg")) continue;
            vector.addElement(cloneable);
        }
        cloneable = new Vector();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n;
            String string2;
            object = enumeration.nextElement();
            String string3 = object.getName();
            if (string3.indexOf(string) < 0 || (string2 = string3.substring(string.length())).length() == 0 || (n = string2.indexOf("/")) != string2.length() - 1 && n >= 0) continue;
            ((Vector)cloneable).addElement(object);
        }
        object = new ZipEntry[((Vector)cloneable).size()];
        ((Vector)cloneable).copyInto((Object[])object);
        return object;
    }

    void WjInLaZ(NdZipRepositoryDirectory ndZipRepositoryDirectory, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        this.checkWriteMode();
        String[] stringArray = new String[2];
        byte[][] byArrayArray = new byte[2][];
        String string = ((ZipEntry)ndZipRepositoryDirectory.getContainerDirectory().getPhysicalDescription()).getName();
        byArrayArray[0] = new byte[0];
        String string2 = string + ndZipRepositoryDirectory.getName();
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        ndZipRepositoryDirectory.WjInJFK(new ZipEntry(string2));
        stringArray[0] = string2;
        stringArray[1] = string + ndZipRepositoryDirectory.getName() + ".innovator_attbs";
        byArrayArray[1] = this.WjInLaQ(ndRepositoryEntryAttributeArray);
        this.WjInLaS(stringArray, byArrayArray, true);
    }

    void WjInLbA(NdZipRepositoryItem ndZipRepositoryItem, NdRepositoryItemContent ndRepositoryItemContent, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        this.checkWriteMode();
        String[] stringArray = new String[2];
        byte[][] byArrayArray = new byte[2][];
        String string = ((ZipEntry)ndZipRepositoryItem.getContainerDirectory().getPhysicalDescription()).getName();
        stringArray[0] = string + ndZipRepositoryItem.getName();
        ndZipRepositoryItem.WjInJFK(new ZipEntry(stringArray[0]));
        byArrayArray[0] = ndRepositoryItemContent.getRawData();
        stringArray[1] = string + ndZipRepositoryItem.getName() + ".innovator_attbs";
        byArrayArray[1] = this.WjInLaQ(ndRepositoryEntryAttributeArray);
        this.WjInLaS(stringArray, byArrayArray, true);
    }

    void WjInLcB(NdZipRepositoryDirectory ndZipRepositoryDirectory) throws NdRepositoryException {
        this.checkWriteMode();
        ZipEntry zipEntry = (ZipEntry)ndZipRepositoryDirectory.getPhysicalDescription();
        String string = zipEntry.getName();
        String string2 = string + ".innovator_attbs";
        this.WjInLaR(new String[]{string, string2});
    }

    void WjInLdC(NdZipRepositoryItem ndZipRepositoryItem) throws NdRepositoryException {
        this.checkWriteMode();
        ZipEntry zipEntry = (ZipEntry)ndZipRepositoryItem.getPhysicalDescription();
        String string = zipEntry.getName();
        String string2 = string + ".innovator_attbs";
        this.WjInLaR(new String[]{string, string2});
    }

    NdRepositoryEntryAttribute[] WjInLeD(NdZipRepositoryEntry ndZipRepositoryEntry) throws NdRepositoryException {
        Object[] objectArray;
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>();
        NdProperties ndProperties = this.WjInLaV(ndZipRepositoryEntry);
        Enumeration enumeration = ndProperties.keys();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            String string = ndProperties.getProperty((String)objectArray);
            NdRepositoryEntryAttribute ndRepositoryEntryAttribute = new NdRepositoryEntryAttribute((String)objectArray, string);
            vector.addElement(ndRepositoryEntryAttribute);
        }
        objectArray = new NdRepositoryEntryAttribute[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    void WjInLfE(NdZipRepositoryEntry ndZipRepositoryEntry, NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray) throws NdRepositoryException {
        Object object;
        String string;
        Object object2;
        this.checkWriteMode();
        ZipEntry zipEntry = (ZipEntry)ndZipRepositoryEntry.getPhysicalDescription();
        if (ndZipRepositoryEntry instanceof NdRepositoryDirectory) {
            object2 = zipEntry.getName();
            string = ((String)object2).substring(0, ((String)object2).length() - 1) + ".innovator_attbs";
        } else {
            string = zipEntry.getName() + ".innovator_attbs";
        }
        object2 = this.WjInLaO.getEntry(string);
        boolean bl = object2 == null;
        Vector<NdRepositoryEntryAttribute> vector = new Vector<NdRepositoryEntryAttribute>();
        if (!bl) {
            String string2;
            String string3;
            object = this.WjInLaV(ndZipRepositoryEntry);
            for (int i = 0; i < ndRepositoryEntryAttributeArray.length; ++i) {
                if (ndRepositoryEntryAttributeArray[i] == null) continue;
                string3 = ndRepositoryEntryAttributeArray[i].getAttbId();
                string2 = ndRepositoryEntryAttributeArray[i].getAttbValue();
                if (string2 == null) {
                    object.remove(ndRepositoryEntryAttributeArray[i].getAttbId());
                    continue;
                }
                object.put(string3, string2);
            }
            Enumeration enumeration = object.keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                string2 = object.getProperty(string3);
                NdRepositoryEntryAttribute ndRepositoryEntryAttribute = new NdRepositoryEntryAttribute(string3, string2);
                vector.addElement(ndRepositoryEntryAttribute);
            }
            ndRepositoryEntryAttributeArray = new NdRepositoryEntryAttribute[vector.size()];
            vector.copyInto(ndRepositoryEntryAttributeArray);
        }
        object = new byte[][]{this.WjInLaQ(ndRepositoryEntryAttributeArray)};
        if (bl) {
            this.WjInLaS(new String[]{string}, (byte[][])object, true);
        } else {
            this.WjInLaS(new String[]{string}, (byte[][])object, false);
        }
    }

    NdZipRepositoryEntry WjInLgF(String string, NdZipRepositoryDirectory ndZipRepositoryDirectory) {
        NdZipRepositoryEntry ndZipRepositoryEntry = null;
        ZipEntry zipEntry = (ZipEntry)ndZipRepositoryDirectory.getPhysicalDescription();
        String string2 = zipEntry.getName();
        ZipEntry zipEntry2 = this.WjInLaO.getEntry(string2 + string + "/");
        if (zipEntry2 == null) {
            zipEntry2 = this.WjInLaO.getEntry(string2 + string);
        }
        if (zipEntry2 != null) {
            ndZipRepositoryEntry = zipEntry2.isDirectory() ? new NdZipRepositoryDirectory(ndZipRepositoryDirectory, string, zipEntry2) : new NdZipRepositoryItem(ndZipRepositoryDirectory, string, zipEntry2);
        }
        return ndZipRepositoryEntry;
    }

    protected void checkWriteMode() throws NdRepositoryException {
        if (this.WjInLaM != 1) {
            throw new NdRepositoryException(NdStrings.WjInMYT("WriteModeError", String.valueOf(this.WjInLaM)));
        }
    }
}

