/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.zip;

import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryItem;
import com.blazesoft.repository.base.NdRepositoryItemContent;
import com.blazesoft.repository.base.NdRepositoryItemContentDefConverterContext;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.zip.NdStrings;
import com.blazesoft.repository.zip.NdZipRepositoryDirectory;
import com.blazesoft.repository.zip.NdZipRepositoryEntry;
import com.blazesoft.repository.zip.NdZipRepositoryEntryAccessor;
import java.text.DateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;

public class NdZipRepositoryItem
extends NdZipRepositoryEntry
implements NdRepositoryItem {
    NdZipRepositoryItem(NdZipRepositoryDirectory ndZipRepositoryDirectory, String string, ZipEntry zipEntry) {
        super(ndZipRepositoryDirectory, string, zipEntry);
    }

    public NdRepositoryItemContent getContent() throws NdRepositoryException {
        NdZipRepositoryEntryAccessor ndZipRepositoryEntryAccessor = this.WjInJFI().WjInJtV();
        ZipEntry zipEntry = (ZipEntry)this.getPhysicalDescription();
        byte[] byArray = ndZipRepositoryEntryAccessor.WjInLaX(zipEntry.getName());
        NdRepositoryItemContent ndRepositoryItemContent = new NdRepositoryItemContent(byArray);
        ndRepositoryItemContent.setItemContentConverter(this.WjInJFI().getRepositoryItemContentConverter());
        ndRepositoryItemContent.setItemContentConverterContext(new NdRepositoryItemContentDefConverterContext(this.WjInJFI(), this));
        return ndRepositoryItemContent;
    }

    public void setContent(NdRepositoryItemContent ndRepositoryItemContent) throws NdRepositoryException {
        ndRepositoryItemContent.setItemContentConverter(this.WjInJFI().getRepositoryItemContentConverter());
        ndRepositoryItemContent.setItemContentConverterContext(new NdRepositoryItemContentDefConverterContext(this.WjInJFI(), this));
        NdZipRepositoryEntryAccessor ndZipRepositoryEntryAccessor = this.WjInJFI().WjInJtV();
        ZipEntry zipEntry = (ZipEntry)this.getPhysicalDescription();
        byte[][] byArrayArray = new byte[][]{ndRepositoryItemContent.getRawData()};
        ndZipRepositoryEntryAccessor.WjInLaS(new String[]{zipEntry.getName()}, byArrayArray, false);
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = new NdRepositoryEntryAttribute[]{new NdRepositoryEntryAttribute("innovatorLastModified", DateFormat.getInstance().format(new Date()))};
        this.getContainerDirectory().setRepositoryEntryAttributes(this, ndRepositoryEntryAttributeArray);
    }

    public Date getLastModified() throws NdRepositoryException {
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = NdRepositorySupport.getRepositoryEntryAttributes(this, new String[]{"innovatorLastModified"});
        String string = ndRepositoryEntryAttributeArray[0].getAttbValue();
        try {
            return DateFormat.getInstance().parse(string);
        }
        catch (Exception exception) {
            throw new NdRepositoryException(NdStrings.WjInMYT("IllegalFormatOfLastModifiedDate", string));
        }
    }

    public void setLastModified(Date date) throws NdRepositoryException {
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = new NdRepositoryEntryAttribute[]{new NdRepositoryEntryAttribute("innovatorLastModified", DateFormat.getInstance().format(date))};
        this.getContainerDirectory().setRepositoryEntryAttributes(this, ndRepositoryEntryAttributeArray);
    }

    public boolean isReadable() throws NdRepositoryException {
        return true;
    }

    public boolean isWritable() throws NdRepositoryException {
        return true;
    }
}

