/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.rma;

import com.blazesoft.repository.base.NdRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepositoryVersionResultSet;
import com.blazesoft.rma.NdRMAException;
import com.blazesoft.rma.NdRmaEntry;
import com.blazesoft.rma.NdRmaEntryExcludeTemplatesFilter;
import com.blazesoft.rma.NdRmaEntryExcludeTransientQueriesFilter;
import com.blazesoft.rma.NdRmaEntryExclusionFilter;
import com.blazesoft.rma.NdRmaEntryVersioningInfo;
import com.blazesoft.rma.NdRmaFile;
import com.blazesoft.rma.NdRmaRepository;
import com.blazesoft.rma.NdRmaSession;
import com.blazesoft.rma.NdRmaSessionProperties;
import com.blazesoft.rma.NdRmaSessionSupport;
import com.blazesoft.rma.NdStrings;
import com.blazesoft.rma.WjISOcI;
import java.util.ArrayList;
import java.util.Date;

public class NdRmaPageListOfFiles {
    public FileEntry[] fileEntries;
    private boolean WjISJlT = false;
    private boolean WjISJmU = false;
    private NdRmaEntryExclusionFilter WjISTxX;
    private boolean WjISJoW = false;

    public NdRmaPageListOfFiles(NdRmaSession ndRmaSession, NdRmaEntry ndRmaEntry) throws NdRMAException {
        int n;
        NdRmaEntry[] ndRmaEntryArray;
        NdRmaSessionProperties ndRmaSessionProperties = ndRmaSession.getSessionProperties();
        this.WjISJlT = ndRmaSessionProperties.shouldShowAllInstanceFiles();
        this.WjISJmU = ndRmaSessionProperties.shouldIncludeSystemDirectories();
        this.WjISJoW = ndRmaSessionProperties.shouldShowTemplateFiles();
        this.WjISTxX = new NdRmaEntryExcludeTransientQueriesFilter();
        if (!this.WjISJoW) {
            ndRmaEntryArray = new NdRmaEntryExcludeTemplatesFilter();
            this.WjISTxX = new WjISOcI(this.WjISTxX, (NdRmaEntryExclusionFilter)ndRmaEntryArray);
        }
        if ((ndRmaEntryArray = NdRmaSessionSupport.getChildEntries(ndRmaEntry, this.WjISJmU, this.WjISTxX)) == null) {
            throw new NdRMAException(NdStrings.WjHGLmY("ProjectOrDirectoryEntryExpected"));
        }
        int n2 = ndRmaEntryArray.length;
        ArrayList<NdRmaEntry> arrayList = new ArrayList<NdRmaEntry>();
        if (this.WjISJlT) {
            for (n = 0; n < n2; ++n) {
                arrayList.add(ndRmaEntryArray[n]);
            }
        } else {
            for (n = 0; n < n2; ++n) {
                if (NdRmaSessionSupport.isNew(ndRmaEntryArray[n]) || !NdRmaSessionSupport.isEditableFile(ndRmaEntryArray[n]) && !NdRmaSessionSupport.isDirectory(ndRmaEntryArray[n]) && (!this.WjISJoW || !NdRmaSessionSupport.isTemplateFile(ndRmaEntryArray[n]))) continue;
                arrayList.add(ndRmaEntryArray[n]);
            }
        }
        int n3 = n = arrayList.size() > 0 ? 1 : 0;
        if (n != 0) {
            boolean bl = NdRmaSessionSupport.containsInstanceEntry(arrayList.toArray());
            boolean bl2 = ndRmaSession.getRepository().isVersionControlled();
            boolean bl3 = bl;
            boolean bl4 = bl && bl2;
            boolean bl5 = bl && bl2;
            boolean bl6 = bl;
            this.fileEntries = new FileEntry[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                String string;
                Date date;
                boolean bl7;
                this.fileEntries[i] = new FileEntry();
                FileEntry fileEntry = this.fileEntries[i];
                NdRmaEntry ndRmaEntry2 = (NdRmaEntry)arrayList.get(i);
                NdRmaEntryVersioningInfo ndRmaEntryVersioningInfo = null;
                NdRepositoryVersionResultSet ndRepositoryVersionResultSet = null;
                NdRepositoryEntryLockInfo ndRepositoryEntryLockInfo = null;
                if (bl2 && ndRmaEntry2 instanceof NdRmaFile) {
                    ndRmaEntryVersioningInfo = ndRmaEntry2.getVersioningInfo();
                    ndRepositoryVersionResultSet = ndRmaEntryVersioningInfo.getVersioningStatusInfo();
                    ndRepositoryEntryLockInfo = ndRmaEntryVersioningInfo.getVersioningLockInfo();
                }
                boolean bl8 = NdRmaSessionSupport.isEditableFile(ndRmaEntry2);
                boolean bl9 = bl7 = NdRmaSessionSupport.isDirectory(ndRmaEntry2);
                boolean bl10 = bl7 && this.WjISJpX(ndRmaEntry2);
                boolean bl11 = bl8 || bl9 && bl10;
                fileEntry.hasChildren = new Boolean(bl9 && bl10).toString();
                fileEntry.isDirectory = new Boolean(bl7).toString();
                fileEntry.fileLocationAsString = ((Object)ndRmaEntry2.getLocation()).toString();
                fileEntry.isEditable = new Boolean(bl8).toString();
                fileEntry.displayPath = ndRmaEntry2.getDisplayPath();
                fileEntry.displayNameAsLink = new Boolean(bl8).toString();
                fileEntry.name = ndRmaEntry2.getDisplayName();
                fileEntry.displayNameAsText = new Boolean(!bl8).toString();
                if (!bl11 && bl7) {
                    fileEntry.nameTitle = !bl10 ? NdStrings.WjHGLmY("EmptyProjectDirectory") : NdStrings.WjHGLmY("UnableToListDirectoryContents");
                }
                fileEntry.isLocallyModifiedByThisUser = new Boolean(NdRmaSessionSupport.isLocallyModifiedByThisUser(ndRmaEntry2)).toString();
                fileEntry.isDeleted = new Boolean(NdRmaSessionSupport.isDeleted(ndRmaEntry2)).toString();
                if (!bl7) {
                    fileEntry.schemaType = ndRmaEntry2.getType();
                    fileEntry.schemaSubType = ndRmaEntry2.getSubType();
                    fileEntry.contentType = ndRmaEntry2.getContentType();
                } else {
                    fileEntry.schemaType = -1;
                    fileEntry.schemaSubType = 0;
                    fileEntry.contentType = 0;
                }
                if (fileEntry.schemaType == 305) {
                    fileEntry.displayNameAsLink = "false";
                }
                if (bl3 && bl8 && ndRepositoryVersionResultSet != null && ndRepositoryEntryLockInfo != null) {
                    int n4 = ndRepositoryVersionResultSet.getVersionStatus();
                    int n5 = ndRepositoryEntryLockInfo.getLockStatus();
                    if (ndRepositoryVersionResultSet.isLocallyDeleted() && n5 != 4) {
                        fileEntry.statusCode = "noWriteAccess";
                    } else if (n4 == 1) {
                        fileEntry.statusCode = "locallyCreatedByThisUser";
                    } else if (n4 == 2 || n5 == 4) {
                        fileEntry.statusCode = "noEditPrivilege";
                    } else if (n5 == 3) {
                        fileEntry.statusCode = "editPrivilegeOtherSession";
                    } else if (n5 == 1) {
                        fileEntry.statusCode = "notLocked";
                    } else if (n5 == 2) {
                        fileEntry.statusCode = "editPrivilege";
                    }
                }
                if (bl4 && ndRepositoryVersionResultSet != null) {
                    String string2 = ndRepositoryVersionResultSet.getWorkingVersionId();
                    if (string2 == null) {
                        fileEntry.version = NdStrings.WjHGLmY("New");
                        if (fileEntry.statusCode == "locallyCreatedByThisUser") {
                            fileEntry.isNew = "true";
                        }
                    } else {
                        fileEntry.version = string2;
                    }
                }
                if (bl5 && ndRepositoryEntryLockInfo != null) {
                    fileEntry.owner = ndRepositoryEntryLockInfo.getUserId();
                    if (fileEntry.owner == null && ndRepositoryVersionResultSet.getVersionStatus() == 2) {
                        fileEntry.owner = ndRepositoryVersionResultSet.getCreationUserId();
                    }
                }
                if (!bl6 || !NdRmaSessionSupport.isFile(ndRmaEntry2) || (date = ((NdRmaFile)ndRmaEntry2).getLastModifiedDate()) == null) continue;
                NdRmaRepository ndRmaRepository = ndRmaEntry2.getProject().getRepository();
                fileEntry.lastModified = string = ndRmaRepository.formatDateForDisplay(date);
            }
        }
    }

    private boolean WjISJpX(NdRmaEntry ndRmaEntry) throws NdRMAException {
        NdRmaEntry[] ndRmaEntryArray = NdRmaSessionSupport.getChildEntries(ndRmaEntry, this.WjISJmU, this.WjISTxX);
        if (ndRmaEntryArray.length == 0) {
            return false;
        }
        if (this.WjISJlT) {
            return true;
        }
        for (int i = 0; i < ndRmaEntryArray.length; ++i) {
            if (!NdRmaSessionSupport.isEditableFile(ndRmaEntryArray[i]) && !NdRmaSessionSupport.isDirectory(ndRmaEntryArray[i]) && (!this.WjISJoW || !NdRmaSessionSupport.isTemplateFile(ndRmaEntryArray[i]))) continue;
            return true;
        }
        return false;
    }

    public class FileEntry {
        public String fileLocationAsString = "";
        public String isEditable = "";
        public String displayNameAsText = "";
        public String nameTitle = "";
        public String name = "";
        public String displayNameAsLink = "";
        public String statusCode = "";
        public String version = "";
        public String owner = "";
        public String lastModified = "";
        public String hasChildren = "";
        public int schemaType;
        public int schemaSubType;
        public int contentType;
        public String isDirectory = "";
        public String isNew = "false";
        public String isLocallyModifiedByThisUser = "";
        public String isDeleted = "";
        public String[] displayPath = null;
    }
}

