/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.rma;

import com.blazesoft.repository.base.NdRepositoryConnection;
import com.blazesoft.repository.base.NdRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryVersionResultSet;
import com.blazesoft.repository.config.NdRepositoryConfig;
import com.blazesoft.repository.config.legacy.NdFileCVSServerConnection;
import com.blazesoft.repository.file.NdFileRepositoryConnection;
import com.blazesoft.repository.jdbc.NdJdbcRepositoryConnection;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.naming.NdLocationFactory;
import com.blazesoft.repository.tools.NdRepositoryUtil;
import com.blazesoft.repository.url.NdUrlRepositoryConnection;
import com.blazesoft.rma.NdRMAException;
import com.blazesoft.rma.NdRmaDirectory;
import com.blazesoft.rma.NdRmaEditableFile;
import com.blazesoft.rma.NdRmaEntry;
import com.blazesoft.rma.NdRmaEntryExcludeDeletedFilter;
import com.blazesoft.rma.NdRmaEntryExclusionFilter;
import com.blazesoft.rma.NdRmaEntryFilterManager;
import com.blazesoft.rma.NdRmaEntryVersioningInfo;
import com.blazesoft.rma.NdRmaEntryVersioningOperations;
import com.blazesoft.rma.NdRmaFile;
import com.blazesoft.rma.NdRmaInstance;
import com.blazesoft.rma.NdRmaInstanceFile;
import com.blazesoft.rma.NdRmaProject;
import com.blazesoft.rma.NdRmaQueryInstance;
import com.blazesoft.rma.NdRmaQueryTemplate;
import com.blazesoft.rma.NdRmaRepository;
import com.blazesoft.rma.NdRmaSession;
import com.blazesoft.rma.NdRmaSessionConstants;
import com.blazesoft.rma.NdRmaSubProject;
import com.blazesoft.rma.NdRmaTemplate;
import com.blazesoft.rma.NdRmaTemplateFile;
import com.blazesoft.rma.NdRmaView;
import com.blazesoft.rma.NdRmaViewSupport;
import com.blazesoft.rma.NdStrings;
import com.blazesoft.rma.WjISKnB;
import com.blazesoft.rma.WjIvcwR;
import com.blazesoft.rma.WjIveRB;
import com.blazesoft.rma.WjIvenF;
import com.blazesoft.rma.WjIvhFP;
import com.blazesoft.rma.WjIvhJR;
import com.blazesoft.util.NdIOUtil;
import com.blazesoft.util.NdItemSorter;
import com.blazesoft.util.NdSystemProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class NdRmaSessionSupport
extends NdRmaViewSupport
implements NdRmaSessionConstants {
    public static int getEntryType(NdRmaEntry ndRmaEntry) {
        int n = 0;
        if (NdRmaSessionSupport.isProject(ndRmaEntry)) {
            n = 1;
        } else if (NdRmaSessionSupport.isDirectory(ndRmaEntry)) {
            n = 2;
        } else if (NdRmaSessionSupport.isInstanceFile(ndRmaEntry)) {
            n = 3;
        } else if (NdRmaSessionSupport.isTemplateFile(ndRmaEntry)) {
            n = 4;
        }
        return n;
    }

    public static NdRmaDirectory getEntryAsDirectory(NdRmaEntry ndRmaEntry) throws NdRMAException {
        if (!NdRmaSessionSupport.isDirectory(ndRmaEntry)) {
            throw new NdRMAException(NdStrings.WjHGLoA("EntryCannotBeReturnedAsRequestedType", "getEntryAsDirectory()"));
        }
        return (NdRmaDirectory)ndRmaEntry;
    }

    public static NdRmaInstance getEntryAsInstance(NdRmaEntry ndRmaEntry) throws NdRMAException {
        if (!NdRmaSessionSupport.isInstanceFile(ndRmaEntry)) {
            throw new NdRMAException(NdStrings.WjHGLoA("EntryCannotBeReturnedAsRequestedType", "getEntryAsInstance()"));
        }
        return ((NdRmaInstanceFile)ndRmaEntry).getInstance();
    }

    public static NdRmaQueryInstance getEntryAsQueryInstance(NdRmaEntry ndRmaEntry) throws NdRMAException {
        if (!NdRmaSessionSupport.isQueryInstance(ndRmaEntry)) {
            throw new NdRMAException(NdStrings.WjHGLoA("EntryCannotBeReturnedAsRequestedType", "getEntryAsQueryInstance()"));
        }
        return (NdRmaQueryInstance)NdRmaSessionSupport.getEntryAsInstance(ndRmaEntry);
    }

    public static NdRmaEditableFile getEntryAsEditableFile(NdRmaEntry ndRmaEntry) throws NdRMAException {
        if (!NdRmaSessionSupport.isEditableFile(ndRmaEntry)) {
            throw new NdRMAException(NdStrings.WjHGLoA("EntryCannotBeReturnedAsRequestedType", "getEntryAsEditableFile()"));
        }
        return (NdRmaEditableFile)ndRmaEntry;
    }

    public static NdRmaTemplate getEntryAsTemplate(NdRmaEntry ndRmaEntry) throws NdRMAException {
        if (!NdRmaSessionSupport.isTemplateFile(ndRmaEntry)) {
            throw new NdRMAException(NdStrings.WjHGLoA("EntryCannotBeReturnedAsRequestedType", "getEntryAsTemplate()"));
        }
        return ((NdRmaTemplateFile)ndRmaEntry).getTemplate();
    }

    public static NdRmaEntry getEntryByPath(NdRmaSession ndRmaSession, String string) throws NdRMAException {
        NdRmaEntry ndRmaEntry = null;
        if (NdRmaSessionSupport.isValueSignificant(string)) {
            NdRmaProject ndRmaProject = ndRmaSession.getProject();
            NdLocation ndLocation = NdLocationFactory.createLocation(string);
            ndRmaEntry = ndLocation.equals(ndRmaProject.getLocation()) ? ndRmaProject : ndRmaProject.lookupEntryByLocation(ndLocation);
        }
        return ndRmaEntry;
    }

    public static int getRepositoryVersioningType(NdRmaRepository ndRmaRepository) {
        NdRepositoryConfig ndRepositoryConfig = ((WjIvenF)ndRmaRepository).WjJanaC();
        int n = 0;
        if (ndRepositoryConfig.getRepositoryVersionManagerConfig() != null) {
            String string = ndRepositoryConfig.getRepositoryVersionManagerConfig().getRepositoryVersionManagerFactory().getJavaName();
            if ("com.blazesoft.repository.generic.version.NdNativeRepositoryVersionManager".equals(string)) {
                n = 1;
            } else if ("com.blazesoft.repository.file.NdFileCVSWorkspaceVersionManager".equals(string)) {
                n = 2;
            } else if ("com.blazesoft.repository.scm.subversion.NdSvnWorkspaceVersionManager".equals(string)) {
                n = 3;
            } else if ("com.blazesoft.repository.scm.wvcm.cc.NdCcVersionManager".equals(string)) {
                n = 4;
            }
        }
        return n;
    }

    public static int getRepositoryType(NdRmaRepository ndRmaRepository) {
        NdRepositoryConnection ndRepositoryConnection = ndRmaRepository.getRepositoryConnection();
        int n = 0;
        if (ndRepositoryConnection instanceof NdFileRepositoryConnection) {
            n = 1;
        } else if (ndRepositoryConnection instanceof NdFileCVSServerConnection) {
            n = 2;
        } else if (ndRepositoryConnection instanceof NdJdbcRepositoryConnection) {
            n = 3;
        } else if (ndRepositoryConnection instanceof NdUrlRepositoryConnection) {
            n = 5;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NdRmaEntry[] getChildEntries(NdRmaEntry ndRmaEntry, boolean bl, NdRmaEntryExclusionFilter ndRmaEntryExclusionFilter) throws NdRMAException {
        NdRmaProject ndRmaProject;
        NdRmaEntry[] ndRmaEntryArray = null;
        NdRmaProject ndRmaProject2 = ndRmaProject = ndRmaEntry.getProject();
        synchronized (ndRmaProject2) {
            NdRmaEntryFilterManager ndRmaEntryFilterManager = ndRmaProject.getEntryFilterManager();
            if (ndRmaEntryExclusionFilter != null) {
                ndRmaEntryFilterManager.setSecondaryEntryExclusionFilter(ndRmaEntryExclusionFilter);
            }
            try {
                if (NdRmaSessionSupport.isProject(ndRmaEntry)) {
                    ndRmaEntryArray = ((NdRmaProject)ndRmaEntry).getDirectories(bl);
                } else if (NdRmaSessionSupport.isDirectory(ndRmaEntry)) {
                    ndRmaEntryArray = ((NdRmaDirectory)ndRmaEntry).getEntries();
                }
                Object var8_7 = null;
                if (ndRmaEntryExclusionFilter != null) {
                    ndRmaEntryFilterManager.setSecondaryEntryExclusionFilter(null);
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (ndRmaEntryExclusionFilter != null) {
                    ndRmaEntryFilterManager.setSecondaryEntryExclusionFilter(null);
                }
                throw throwable;
            }
        }
        return ndRmaEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NdRmaQueryTemplate[] getAllQueryTemplates(NdRmaProject ndRmaProject) throws NdRMAException {
        NdRmaQueryTemplate[] ndRmaQueryTemplateArray = null;
        NdRmaProject ndRmaProject2 = ndRmaProject;
        synchronized (ndRmaProject2) {
            NdRmaEntryFilterManager ndRmaEntryFilterManager = ndRmaProject.getEntryFilterManager();
            NdRmaEntryExcludeDeletedFilter ndRmaEntryExcludeDeletedFilter = new NdRmaEntryExcludeDeletedFilter();
            ndRmaEntryFilterManager.setSecondaryEntryExclusionFilter(ndRmaEntryExcludeDeletedFilter);
            try {
                ndRmaQueryTemplateArray = ndRmaProject.getAllQueryTemplates(true);
                Object var6_5 = null;
                ndRmaEntryFilterManager.setSecondaryEntryExclusionFilter(null);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                ndRmaEntryFilterManager.setSecondaryEntryExclusionFilter(null);
                throw throwable;
            }
        }
        return ndRmaQueryTemplateArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NdRmaQueryInstance[] getAllQueryInstances(NdRmaProject ndRmaProject) throws NdRMAException {
        NdRmaQueryInstance[] ndRmaQueryInstanceArray = null;
        NdRmaProject ndRmaProject2 = ndRmaProject;
        synchronized (ndRmaProject2) {
            NdRmaEntryFilterManager ndRmaEntryFilterManager = ndRmaProject.getEntryFilterManager();
            NdRmaEntryExcludeDeletedFilter ndRmaEntryExcludeDeletedFilter = new NdRmaEntryExcludeDeletedFilter();
            ndRmaEntryFilterManager.setSecondaryEntryExclusionFilter(ndRmaEntryExcludeDeletedFilter);
            try {
                ndRmaQueryInstanceArray = ndRmaProject.getAllQueryInstances(true);
                Object var6_5 = null;
                ndRmaEntryFilterManager.setSecondaryEntryExclusionFilter(null);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                ndRmaEntryFilterManager.setSecondaryEntryExclusionFilter(null);
                throw throwable;
            }
        }
        return ndRmaQueryInstanceArray;
    }

    public static NdRmaEntry[] sortEntries(NdRmaEntry[] ndRmaEntryArray, int n, boolean bl) throws NdRMAException {
        Object object;
        int n2 = ndRmaEntryArray.length;
        if (n2 < 2) {
            return ndRmaEntryArray;
        }
        Object[] objectArray = new Object[n2];
        block5: for (int i = 0; i < n2; ++i) {
            object = ndRmaEntryArray[i];
            switch (n) {
                case 0: {
                    objectArray[i] = object.getDisplayName();
                    continue block5;
                }
                case 1: {
                    objectArray[i] = NdRmaSessionSupport.getDisplayPathAsString((NdRmaEntry)object);
                    continue block5;
                }
                case 2: {
                    if (NdRmaSessionSupport.isFile((NdRmaEntry)object)) {
                        objectArray[i] = ((NdRmaFile)object).getLastModifiedDate();
                        continue block5;
                    }
                    objectArray[i] = null;
                    continue block5;
                }
                default: {
                    throw new NdRMAException(NdStrings.WjHGLmY("UnknownEntrySortByValue"));
                }
            }
        }
        NdItemSorter ndItemSorter = new NdItemSorter(objectArray, true);
        if (!bl) {
            ndItemSorter.reverseOrder();
        }
        object = ndItemSorter.getSortedIndexes();
        Vector<NdRmaEntry> vector = new Vector<NdRmaEntry>();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Object object2 = object[i];
            NdRmaEntry ndRmaEntry = ndRmaEntryArray[object2];
            if (!NdRmaSessionSupport.isDirectory(ndRmaEntry)) {
                vector.addElement(ndRmaEntry);
                continue;
            }
            vector.insertElementAt(ndRmaEntry, n3++);
        }
        Object[] objectArray2 = new NdRmaEntry[n2];
        vector.copyInto(objectArray2);
        return objectArray2;
    }

    public static void promoteEntry(NdRmaEntry ndRmaEntry) throws NdRMAException {
        if (!NdRmaSessionSupport.isInstanceVersion(ndRmaEntry)) {
            return;
        }
        NdRmaEntryVersioningOperations ndRmaEntryVersioningOperations = ndRmaEntry.getVersioningOperations();
        ndRmaEntryVersioningOperations.promote();
    }

    public static boolean isProject(NdRmaEntry ndRmaEntry) {
        return ndRmaEntry instanceof NdRmaProject;
    }

    public static boolean isSubProject(NdRmaEntry ndRmaEntry) {
        return ndRmaEntry instanceof NdRmaSubProject;
    }

    public static boolean isDirectory(NdRmaEntry ndRmaEntry) {
        return ndRmaEntry instanceof NdRmaDirectory;
    }

    public static boolean isInstanceFile(NdRmaEntry ndRmaEntry) {
        return ndRmaEntry instanceof NdRmaInstanceFile;
    }

    public static boolean isInstanceVersion(NdRmaEntry ndRmaEntry) throws NdRMAException {
        NdRmaEntryVersioningInfo ndRmaEntryVersioningInfo = ndRmaEntry.getVersioningInfo();
        if (ndRmaEntryVersioningInfo == null) {
            return false;
        }
        NdRepositoryVersionResultSet ndRepositoryVersionResultSet = ndRmaEntryVersioningInfo.getVersioningStatusInfo();
        return ndRepositoryVersionResultSet != null && NdRmaSessionSupport.isValueSignificant(ndRepositoryVersionResultSet.getWorkingVersionId());
    }

    public static boolean isQueryInstance(NdRmaEntry ndRmaEntry) {
        if (!NdRmaSessionSupport.isInstanceFile(ndRmaEntry)) {
            return false;
        }
        return ndRmaEntry.getType() == 54;
    }

    public static boolean isTransientQueryInstance(NdRmaEntry ndRmaEntry) {
        if (!NdRmaSessionSupport.isQueryInstance(ndRmaEntry)) {
            return false;
        }
        NdRmaQueryInstance ndRmaQueryInstance = (NdRmaQueryInstance)((NdRmaInstanceFile)ndRmaEntry).getInstance();
        return ndRmaQueryInstance.isTransient();
    }

    public static boolean isInstanceStoredSeparatelyFile(NdRmaEntry ndRmaEntry) {
        return ndRmaEntry instanceof WjIveRB;
    }

    public static boolean isSubInstanceStoredSeparately(NdRmaEntry ndRmaEntry) {
        boolean bl = false;
        if (NdRmaSessionSupport.isInstanceStoredSeparatelyFile(ndRmaEntry)) {
            WjIveRB wjIveRB = (WjIveRB)ndRmaEntry;
            bl = wjIveRB.isStoredSeparately();
        }
        return bl;
    }

    public static boolean isTemplateFile(NdRmaEntry ndRmaEntry) {
        return ndRmaEntry instanceof NdRmaTemplateFile;
    }

    public static boolean isQueryTemplate(NdRmaEntry ndRmaEntry) {
        return ndRmaEntry instanceof NdRmaQueryTemplate;
    }

    public static boolean isFile(NdRmaEntry ndRmaEntry) {
        return ndRmaEntry instanceof NdRmaFile;
    }

    public static boolean isEditableFile(NdRmaEntry ndRmaEntry) {
        return ndRmaEntry instanceof NdRmaEditableFile;
    }

    public static String getRepositoryLocationAsString(NdRmaRepository ndRmaRepository) {
        NdRepositoryConnection ndRepositoryConnection = ndRmaRepository.getRepositoryConnection();
        String string = null;
        if (ndRepositoryConnection instanceof NdFileRepositoryConnection) {
            NdFileRepositoryConnection ndFileRepositoryConnection = (NdFileRepositoryConnection)ndRepositoryConnection;
            string = ndFileRepositoryConnection.getRepositoryFolder();
        } else if (ndRepositoryConnection instanceof NdFileCVSServerConnection) {
            NdFileCVSServerConnection ndFileCVSServerConnection = (NdFileCVSServerConnection)ndRepositoryConnection;
            string = ndFileCVSServerConnection.getRepositoryFolder();
        } else if (ndRepositoryConnection instanceof NdJdbcRepositoryConnection) {
            NdJdbcRepositoryConnection ndJdbcRepositoryConnection = (NdJdbcRepositoryConnection)ndRepositoryConnection;
            string = ndJdbcRepositoryConnection.getJdbcUrl();
        } else if (ndRepositoryConnection instanceof NdUrlRepositoryConnection) {
            NdUrlRepositoryConnection ndUrlRepositoryConnection = (NdUrlRepositoryConnection)ndRepositoryConnection;
            string = ndUrlRepositoryConnection.getBaseLocation();
        }
        return string;
    }

    public static boolean containsInstanceEntry(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!NdRmaSessionSupport.isInstanceFile((NdRmaEntry)objectArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasQueryResults(NdRmaEntry ndRmaEntry) throws NdRMAException {
        boolean bl = false;
        if (ndRmaEntry != null && NdRmaSessionSupport.isQueryInstance(ndRmaEntry)) {
            bl = NdRmaSessionSupport.getEntryAsQueryInstance(ndRmaEntry).hasQueryResults();
        }
        return bl;
    }

    public static String localizedText(String string) {
        return NdStrings.WjHGLmY(string);
    }

    public static String localizedText(String string, Object object) {
        return NdStrings.WjHGLoA(string, object);
    }

    public static String localizedText(String string, Object[] objectArray) {
        return NdStrings.WjHGLnZ(string, objectArray);
    }

    public static boolean isValueSignificant(String string) {
        return string != null && string.trim().length() > 0;
    }

    public static boolean isValueSignificant(Object[] objectArray) {
        return objectArray != null && objectArray.length > 0;
    }

    public static void setDefaultCVSPasswordFileLocation(String string) {
        String string2 = NdSystemProperties.getSystemProperty((String)"nd.app_dir");
        if (string2 != null && string2.trim().length() == 0) {
            NdSystemProperties.setSystemProperty((String)"nd.app_dir", (String)string);
        }
    }

    public static InputStream getResourceAsStream(String string) {
        ByteArrayInputStream byteArrayInputStream;
        try {
            byte[] byArray = NdIOUtil.readAllBytes((InputStream)new FileInputStream(string));
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        catch (IOException iOException) {
            byteArrayInputStream = null;
        }
        return byteArrayInputStream;
    }

    public static boolean isAbsolutePath(String string) {
        File file = new File(string);
        return file.isAbsolute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateUniqueDisplayName(String string, NdRmaProject ndRmaProject) throws NdRMAException {
        NdRmaDirectory[] ndRmaDirectoryArray;
        String string2 = string;
        NdRmaProject ndRmaProject2 = ndRmaProject;
        synchronized (ndRmaProject2) {
            WjISKnB wjISKnB = (WjISKnB)ndRmaProject.getEntryFilterManager();
            wjISKnB.WjISKlV();
            try {
                ndRmaDirectoryArray = ndRmaProject.getAllDirectories(false);
                Object var7_7 = null;
                wjISKnB.WjISKlW();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                wjISKnB.WjISKlW();
                throw throwable;
            }
        }
        for (int i = 0; i < ndRmaDirectoryArray.length; ++i) {
            string2 = NdRmaSessionSupport.generateUniqueDisplayName(string2, ndRmaDirectoryArray[i]);
        }
        return string2;
    }

    public static String generateUniqueDisplayName(String string, NdRmaEntry ndRmaEntry) throws NdRMAException {
        NdRmaQueryInstance ndRmaQueryInstance;
        NdRmaDirectory ndRmaDirectory = null;
        if (NdRmaSessionSupport.isQueryInstance(ndRmaEntry) && (ndRmaQueryInstance = NdRmaSessionSupport.getEntryAsQueryInstance(ndRmaEntry)).isTransient()) {
            WjIvhFP wjIvhFP = (WjIvhFP)ndRmaQueryInstance.getFile();
            ndRmaDirectory = wjIvhFP.WjIUXVI();
        }
        if (ndRmaDirectory == null) {
            ndRmaDirectory = ndRmaEntry.getParentDirectory();
        }
        return NdRmaSessionSupport.generateUniqueDisplayName(string, ndRmaDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateUniqueDisplayName(String string, NdRmaDirectory ndRmaDirectory) throws NdRMAException {
        NdRmaEntry[] ndRmaEntryArray;
        NdRmaProject ndRmaProject;
        String string2;
        String string3 = string2 = string.trim();
        for (int i = string3.length() - 1; i >= 0; --i) {
            if (NdRmaSessionSupport.isInt(string3.substring(i, i + 1))) continue;
            string3 = string3.substring(0, i + 1);
            break;
        }
        NdRmaProject ndRmaProject2 = ndRmaProject = ndRmaDirectory.getProject();
        synchronized (ndRmaProject2) {
            WjISKnB wjISKnB = (WjISKnB)ndRmaProject.getEntryFilterManager();
            wjISKnB.WjISKlV();
            try {
                ndRmaEntryArray = ndRmaDirectory.getEntries();
                Object var9_11 = null;
                wjISKnB.WjISKlW();
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                wjISKnB.WjISKlW();
                throw throwable;
            }
        }
        boolean bl = true;
        int n = 1;
        block6: do {
            bl = true;
            for (int i = 0; i < ndRmaEntryArray.length; ++i) {
                if (!ndRmaEntryArray[i].getDisplayName().equalsIgnoreCase(string2)) continue;
                bl = false;
                string2 = string3 + String.valueOf(n++);
                continue block6;
            }
        } while (!bl);
        return string2;
    }

    public static String getDisplayPathAsString(NdRmaEntry ndRmaEntry) throws NdRMAException {
        String string = "";
        if (!NdRmaSessionSupport.isTransientQueryInstance(ndRmaEntry)) {
            String[] stringArray = ndRmaEntry.getDisplayPath();
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + stringArray[i] + "/";
            }
            if (string.length() > 0) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static boolean canBeCheckedOutByThisUser(NdRmaEntry ndRmaEntry) throws NdRMAException {
        if (!ndRmaEntry.getProject().getRepository().isVersionControlled()) {
            return false;
        }
        NdRmaEntryVersioningInfo ndRmaEntryVersioningInfo = ndRmaEntry.getVersioningInfo();
        if (ndRmaEntryVersioningInfo == null) {
            return false;
        }
        NdRepositoryEntryLockInfo ndRepositoryEntryLockInfo = ndRmaEntryVersioningInfo.getVersioningLockInfo();
        if (ndRepositoryEntryLockInfo == null || NdRmaSessionSupport.isNew(ndRmaEntry)) {
            return false;
        }
        return ndRepositoryEntryLockInfo.getLockStatus() == 1;
    }

    public static boolean canBeCheckedInByThisUser(NdRmaEntry ndRmaEntry) throws NdRMAException {
        if (!ndRmaEntry.getProject().getRepository().isVersionControlled()) {
            return false;
        }
        NdRmaEntryVersioningInfo ndRmaEntryVersioningInfo = ndRmaEntry.getVersioningInfo();
        if (ndRmaEntryVersioningInfo == null) {
            return false;
        }
        NdRepositoryVersionResultSet ndRepositoryVersionResultSet = ndRmaEntryVersioningInfo.getVersioningStatusInfo();
        if (ndRepositoryVersionResultSet == null) {
            return false;
        }
        NdRepositoryEntryLockInfo ndRepositoryEntryLockInfo = ndRmaEntryVersioningInfo.getVersioningLockInfo();
        return ndRepositoryEntryLockInfo.getLockStatus() == 2 || ndRepositoryVersionResultSet.getVersionStatus() == 1;
    }

    public static boolean canBeLocallyModifiedByThisUser(NdRmaEntry ndRmaEntry) throws NdRMAException {
        if (!ndRmaEntry.getProject().getRepository().isVersionControlled()) {
            return true;
        }
        NdRmaEntryVersioningInfo ndRmaEntryVersioningInfo = ndRmaEntry.getVersioningInfo();
        if (ndRmaEntryVersioningInfo == null) {
            return false;
        }
        NdRepositoryVersionResultSet ndRepositoryVersionResultSet = ndRmaEntryVersioningInfo.getVersioningStatusInfo();
        if (ndRepositoryVersionResultSet == null) {
            return false;
        }
        NdRepositoryEntryLockInfo ndRepositoryEntryLockInfo = ndRmaEntryVersioningInfo.getVersioningLockInfo();
        return ndRepositoryEntryLockInfo.getLockStatus() == 2 && ndRepositoryEntryLockInfo.getLockStatus() != 3 || ndRepositoryVersionResultSet.getVersionStatus() == 1;
    }

    public static boolean isLocallyCheckedOutByThisUser(NdRmaEntry ndRmaEntry) throws NdRMAException {
        if (!ndRmaEntry.getProject().getRepository().isVersionControlled()) {
            return false;
        }
        NdRmaEntryVersioningInfo ndRmaEntryVersioningInfo = ndRmaEntry.getVersioningInfo();
        if (ndRmaEntryVersioningInfo == null) {
            return false;
        }
        NdRepositoryEntryLockInfo ndRepositoryEntryLockInfo = ndRmaEntryVersioningInfo.getVersioningLockInfo();
        if (ndRepositoryEntryLockInfo == null) {
            return false;
        }
        return ndRepositoryEntryLockInfo.getLockStatus() == 2 && ndRepositoryEntryLockInfo.getLockStatus() != 3;
    }

    public static boolean isNotCheckedOut(NdRmaEntry ndRmaEntry) throws NdRMAException {
        if (!ndRmaEntry.getProject().getRepository().isVersionControlled()) {
            return false;
        }
        NdRmaEntryVersioningInfo ndRmaEntryVersioningInfo = ndRmaEntry.getVersioningInfo();
        if (ndRmaEntryVersioningInfo == null) {
            return false;
        }
        NdRepositoryEntryLockInfo ndRepositoryEntryLockInfo = ndRmaEntryVersioningInfo.getVersioningLockInfo();
        if (ndRepositoryEntryLockInfo == null) {
            return false;
        }
        return ndRepositoryEntryLockInfo.getLockStatus() == 1;
    }

    public static void reload(NdRmaEntry ndRmaEntry) throws NdRMAException {
        if (!NdRmaSessionSupport.isFile(ndRmaEntry)) {
            return;
        }
        ((NdRmaFile)ndRmaEntry).reloadContent();
    }

    public static boolean isModified(NdRmaEntry ndRmaEntry) {
        if (!NdRmaSessionSupport.isEditableFile(ndRmaEntry)) {
            return false;
        }
        return ((NdRmaEditableFile)ndRmaEntry).isModified();
    }

    public static boolean isNew(NdRmaEntry ndRmaEntry) {
        if (!NdRmaSessionSupport.isFile(ndRmaEntry)) {
            return false;
        }
        return ((NdRmaFile)ndRmaEntry).isNew();
    }

    public static boolean isDeleted(NdRmaEntry ndRmaEntry) throws NdRMAException {
        NdRmaEntryVersioningInfo ndRmaEntryVersioningInfo;
        boolean bl = false;
        if (NdRmaSessionSupport.isFile(ndRmaEntry)) {
            bl = ((NdRmaFile)ndRmaEntry).isLogicallyDeleted();
        }
        if ((ndRmaEntryVersioningInfo = ndRmaEntry.getVersioningInfo()) == null) {
            return bl;
        }
        NdRepositoryVersionResultSet ndRepositoryVersionResultSet = ndRmaEntryVersioningInfo.getVersioningStatusInfo();
        boolean bl2 = ndRepositoryVersionResultSet != null && ndRepositoryVersionResultSet.isLocallyDeleted();
        return bl || bl2;
    }

    public static boolean isLocallyModifiedByThisUser(NdRmaEntry ndRmaEntry) throws NdRMAException {
        NdRmaEntryVersioningInfo ndRmaEntryVersioningInfo = ndRmaEntry.getVersioningInfo();
        if (ndRmaEntryVersioningInfo == null) {
            return false;
        }
        NdRepositoryVersionResultSet ndRepositoryVersionResultSet = ndRmaEntryVersioningInfo.getVersioningStatusInfo();
        return ndRepositoryVersionResultSet != null && ndRepositoryVersionResultSet.getVersionStatus() == 3;
    }

    public static boolean isLocallyCreatedByThisUser(NdRmaEntry ndRmaEntry) throws NdRMAException {
        NdRmaEntryVersioningInfo ndRmaEntryVersioningInfo = ndRmaEntry.getVersioningInfo();
        if (ndRmaEntryVersioningInfo == null) {
            return false;
        }
        NdRepositoryVersionResultSet ndRepositoryVersionResultSet = ndRmaEntryVersioningInfo.getVersioningStatusInfo();
        return ndRepositoryVersionResultSet != null && ndRepositoryVersionResultSet.getVersionStatus() == 1;
    }

    public static boolean isInt(String string) {
        boolean bl = true;
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public static boolean shouldPromptToSave(NdRmaEntry ndRmaEntry) {
        boolean bl = NdRmaSessionSupport.isInstanceFile(ndRmaEntry);
        boolean bl2 = NdRmaSessionSupport.isSubInstanceStoredSeparately(ndRmaEntry);
        boolean bl3 = NdRmaSessionSupport.isNew(ndRmaEntry);
        boolean bl4 = NdRmaSessionSupport.isModified(ndRmaEntry);
        boolean bl5 = NdRmaSessionSupport.isTransientQueryInstance(ndRmaEntry);
        return !(!bl && !bl2 || !bl3 && !bl4 || bl5);
    }

    protected static void deleteDirectoryOrFile(String string) throws NdRMAException {
        try {
            NdRepositoryUtil.deleteDirectoryOrFile(string);
        }
        catch (NdRepositoryException ndRepositoryException) {
            throw new NdRMAException((Throwable)((Object)ndRepositoryException));
        }
    }

    public static void handleImplicitCheckOut(NdRmaEntry ndRmaEntry) throws NdRMAException {
        if (ndRmaEntry == null || NdRmaSessionSupport.isLocallyCreatedByThisUser(ndRmaEntry)) {
            return;
        }
        NdRmaEntryVersioningOperations ndRmaEntryVersioningOperations = ndRmaEntry.getVersioningOperations();
        if (ndRmaEntryVersioningOperations != null && NdRmaSessionSupport.isInstanceFile(ndRmaEntry)) {
            if (NdRmaSessionSupport.isLocallyCheckedOutByThisUser(ndRmaEntry)) {
                ndRmaEntryVersioningOperations.cancelCheckOut();
            }
            ndRmaEntryVersioningOperations.checkOut();
        }
    }

    public static void handleImplicitCheckIn(NdRmaEntry ndRmaEntry, String string) throws NdRMAException {
        if (ndRmaEntry == null) {
            return;
        }
        NdRmaEntryVersioningOperations ndRmaEntryVersioningOperations = ndRmaEntry.getVersioningOperations();
        if (ndRmaEntryVersioningOperations != null) {
            ndRmaEntryVersioningOperations.checkIn(string);
        }
    }

    public static void handleImplicitCancelCheckOut(NdRmaEntry ndRmaEntry) throws NdRMAException {
        if (ndRmaEntry == null || NdRmaSessionSupport.isLocallyCreatedByThisUser(ndRmaEntry)) {
            return;
        }
        NdRmaEntryVersioningOperations ndRmaEntryVersioningOperations = ndRmaEntry.getVersioningOperations();
        if (ndRmaEntryVersioningOperations != null && NdRmaSessionSupport.isLocallyCheckedOutByThisUser(ndRmaEntry)) {
            ndRmaEntryVersioningOperations.cancelCheckOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NdRmaQueryInstance[] getSearchQueryInstancesUnfiltered(NdRmaProject ndRmaProject, boolean bl) throws NdRMAException {
        NdRmaProject ndRmaProject2 = ndRmaProject;
        synchronized (ndRmaProject2) {
            WjISKnB wjISKnB = (WjISKnB)ndRmaProject.getEntryFilterManager();
            wjISKnB.WjISKlY().WjISPUG();
            NdRmaEntryExcludeDeletedFilter ndRmaEntryExcludeDeletedFilter = new NdRmaEntryExcludeDeletedFilter();
            wjISKnB.setSecondaryEntryExclusionFilter(ndRmaEntryExcludeDeletedFilter);
            try {
                NdRmaQueryInstance[] ndRmaQueryInstanceArray = ndRmaProject.getSearchQueryInstances(bl);
                Object var7_6 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                return ndRmaQueryInstanceArray;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NdRmaQueryInstance[] getComparisonQueryInstancesUnfiltered(NdRmaProject ndRmaProject, boolean bl) throws NdRMAException {
        NdRmaProject ndRmaProject2 = ndRmaProject;
        synchronized (ndRmaProject2) {
            WjISKnB wjISKnB = (WjISKnB)ndRmaProject.getEntryFilterManager();
            wjISKnB.WjISKlY().WjISPUG();
            NdRmaEntryExcludeDeletedFilter ndRmaEntryExcludeDeletedFilter = new NdRmaEntryExcludeDeletedFilter();
            wjISKnB.setSecondaryEntryExclusionFilter(ndRmaEntryExcludeDeletedFilter);
            try {
                NdRmaQueryInstance[] ndRmaQueryInstanceArray = ndRmaProject.getComparisonQueryInstances(bl);
                Object var7_6 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                return ndRmaQueryInstanceArray;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NdRmaQueryInstance[] getVerificationQueryInstancesUnfiltered(NdRmaProject ndRmaProject, boolean bl) throws NdRMAException {
        NdRmaProject ndRmaProject2 = ndRmaProject;
        synchronized (ndRmaProject2) {
            WjISKnB wjISKnB = (WjISKnB)ndRmaProject.getEntryFilterManager();
            wjISKnB.WjISKlY().WjISPUG();
            NdRmaEntryExcludeDeletedFilter ndRmaEntryExcludeDeletedFilter = new NdRmaEntryExcludeDeletedFilter();
            wjISKnB.setSecondaryEntryExclusionFilter(ndRmaEntryExcludeDeletedFilter);
            try {
                NdRmaQueryInstance[] ndRmaQueryInstanceArray = ndRmaProject.getVerificationQueryInstances(bl);
                Object var7_6 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                return ndRmaQueryInstanceArray;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NdRmaQueryTemplate[] getSearchQueryTemplatesUnfiltered(NdRmaProject ndRmaProject, boolean bl) throws NdRMAException {
        NdRmaProject ndRmaProject2 = ndRmaProject;
        synchronized (ndRmaProject2) {
            WjISKnB wjISKnB = (WjISKnB)ndRmaProject.getEntryFilterManager();
            wjISKnB.WjISKlY().WjISPUG();
            NdRmaEntryExcludeDeletedFilter ndRmaEntryExcludeDeletedFilter = new NdRmaEntryExcludeDeletedFilter();
            wjISKnB.setSecondaryEntryExclusionFilter(ndRmaEntryExcludeDeletedFilter);
            try {
                NdRmaQueryTemplate[] ndRmaQueryTemplateArray = ndRmaProject.getSearchQueryTemplates(bl);
                for (int i = 0; i < ndRmaQueryTemplateArray.length; ++i) {
                    ((WjIvcwR)ndRmaQueryTemplateArray[i]).WjIZpyG();
                }
                NdRmaQueryTemplate[] ndRmaQueryTemplateArray2 = ndRmaQueryTemplateArray;
                Object var8_8 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                return ndRmaQueryTemplateArray2;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NdRmaQueryTemplate[] getComparisonQueryTemplatesUnfiltered(NdRmaProject ndRmaProject, boolean bl) throws NdRMAException {
        NdRmaProject ndRmaProject2 = ndRmaProject;
        synchronized (ndRmaProject2) {
            WjISKnB wjISKnB = (WjISKnB)ndRmaProject.getEntryFilterManager();
            wjISKnB.WjISKlY().WjISPUG();
            NdRmaEntryExcludeDeletedFilter ndRmaEntryExcludeDeletedFilter = new NdRmaEntryExcludeDeletedFilter();
            wjISKnB.setSecondaryEntryExclusionFilter(ndRmaEntryExcludeDeletedFilter);
            try {
                NdRmaQueryTemplate[] ndRmaQueryTemplateArray = ndRmaProject.getComparisonQueryTemplates(bl);
                for (int i = 0; i < ndRmaQueryTemplateArray.length; ++i) {
                    ((WjIvcwR)ndRmaQueryTemplateArray[i]).WjIZpyG();
                }
                NdRmaQueryTemplate[] ndRmaQueryTemplateArray2 = ndRmaQueryTemplateArray;
                Object var8_8 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                return ndRmaQueryTemplateArray2;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NdRmaQueryTemplate[] getVerificationQueryTemplatesUnfiltered(NdRmaProject ndRmaProject, boolean bl) throws NdRMAException {
        NdRmaProject ndRmaProject2 = ndRmaProject;
        synchronized (ndRmaProject2) {
            WjISKnB wjISKnB = (WjISKnB)ndRmaProject.getEntryFilterManager();
            wjISKnB.WjISKlY().WjISPUG();
            NdRmaEntryExcludeDeletedFilter ndRmaEntryExcludeDeletedFilter = new NdRmaEntryExcludeDeletedFilter();
            wjISKnB.setSecondaryEntryExclusionFilter(ndRmaEntryExcludeDeletedFilter);
            try {
                NdRmaQueryTemplate[] ndRmaQueryTemplateArray = ndRmaProject.getVerificationQueryTemplates(bl);
                for (int i = 0; i < ndRmaQueryTemplateArray.length; ++i) {
                    ((WjIvcwR)ndRmaQueryTemplateArray[i]).WjIZpyG();
                }
                NdRmaQueryTemplate[] ndRmaQueryTemplateArray2 = ndRmaQueryTemplateArray;
                Object var8_8 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                return ndRmaQueryTemplateArray2;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NdRmaTemplate[] getFilterTemplatesUnfiltered(NdRmaProject ndRmaProject, boolean bl) throws NdRMAException {
        NdRmaProject ndRmaProject2 = ndRmaProject;
        synchronized (ndRmaProject2) {
            WjISKnB wjISKnB = (WjISKnB)ndRmaProject.getEntryFilterManager();
            wjISKnB.WjISKlY().WjISPUG();
            NdRmaEntryExcludeDeletedFilter ndRmaEntryExcludeDeletedFilter = new NdRmaEntryExcludeDeletedFilter();
            wjISKnB.setSecondaryEntryExclusionFilter(ndRmaEntryExcludeDeletedFilter);
            try {
                NdRmaTemplate[] ndRmaTemplateArray = ndRmaProject.getFilterTemplates(bl);
                for (int i = 0; i < ndRmaTemplateArray.length; ++i) {
                    ((WjIvhJR)ndRmaTemplateArray[i]).WjIZpyG();
                }
                NdRmaTemplate[] ndRmaTemplateArray2 = ndRmaTemplateArray;
                Object var8_8 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                return ndRmaTemplateArray2;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NdRmaEntry lookupEntryByLocationUnfiltered(NdRmaProject ndRmaProject, NdLocation ndLocation) throws NdRMAException {
        NdRmaProject ndRmaProject2 = ndRmaProject;
        synchronized (ndRmaProject2) {
            WjISKnB wjISKnB = (WjISKnB)ndRmaProject.getEntryFilterManager();
            wjISKnB.WjISKlY().WjISPUG();
            NdRmaEntryExcludeDeletedFilter ndRmaEntryExcludeDeletedFilter = new NdRmaEntryExcludeDeletedFilter();
            wjISKnB.setSecondaryEntryExclusionFilter(ndRmaEntryExcludeDeletedFilter);
            try {
                NdRmaEntry ndRmaEntry = ndRmaProject.lookupEntryByLocation(ndLocation);
                if (ndRmaEntry instanceof NdRmaTemplateFile) {
                    ((WjIvhJR)((NdRmaTemplateFile)ndRmaEntry).getTemplate()).WjIZpyG();
                }
                NdRmaEntry ndRmaEntry2 = ndRmaEntry;
                Object var8_7 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                return ndRmaEntry2;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NdRmaEntry[] getEntriesUnfiltered(NdRmaDirectory ndRmaDirectory) throws NdRMAException {
        NdRmaProject ndRmaProject;
        NdRmaProject ndRmaProject2 = ndRmaProject = ndRmaDirectory.getProject();
        synchronized (ndRmaProject2) {
            WjISKnB wjISKnB = (WjISKnB)ndRmaProject.getEntryFilterManager();
            wjISKnB.WjISKlY().WjISPUG();
            NdRmaEntryExcludeDeletedFilter ndRmaEntryExcludeDeletedFilter = new NdRmaEntryExcludeDeletedFilter();
            wjISKnB.setSecondaryEntryExclusionFilter(ndRmaEntryExcludeDeletedFilter);
            try {
                NdRmaEntry[] ndRmaEntryArray = ndRmaDirectory.getEntries();
                for (int i = 0; i < ndRmaEntryArray.length; ++i) {
                    if (!(ndRmaEntryArray[i] instanceof NdRmaTemplateFile)) continue;
                    ((WjIvhJR)((NdRmaTemplateFile)ndRmaEntryArray[i]).getTemplate()).WjIZpyG();
                }
                NdRmaEntry[] ndRmaEntryArray2 = ndRmaEntryArray;
                Object var8_8 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                return ndRmaEntryArray2;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                wjISKnB.WjISKlY().WjISPVH();
                wjISKnB.setSecondaryEntryExclusionFilter(null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeView(NdRmaSession ndRmaSession, String string) throws NdRMAException {
        NdRmaView ndRmaView = ndRmaSession.getView(string);
        if (ndRmaView != null) {
            NdRmaEntry ndRmaEntry = ndRmaView.getViewEntry();
            if (ndRmaEntry instanceof NdRmaInstanceFile) {
                NdRmaInstance ndRmaInstance;
                if (ndRmaView.getViewProperties().isImplicitlyVersioned()) {
                    NdRmaSessionSupport.handleImplicitCancelCheckOut(ndRmaEntry);
                }
                if (ndRmaView.getParentView() != null && ndRmaView.getParentView().getViewProperties().isImplicitlyVersioned()) {
                    NdRmaSessionSupport.handleImplicitCancelCheckOut(ndRmaView.getParentView().getViewEntry());
                }
                if ((ndRmaInstance = NdRmaSessionSupport.getEntryAsInstance(ndRmaEntry)).isQueryInstance()) {
                    NdRmaQueryInstance ndRmaQueryInstance = (NdRmaQueryInstance)ndRmaInstance;
                    if (ndRmaQueryInstance.isTransient()) {
                        NdRmaView ndRmaView2 = ndRmaView;
                        synchronized (ndRmaView2) {
                            ndRmaQueryInstance.deleteTransientQueryInstance();
                            ndRmaView.setViewEntry(null);
                        }
                    }
                } else if (((NdRmaInstanceFile)ndRmaEntry).isFileVersion()) {
                    ndRmaInstance.dispose();
                }
            }
            ndRmaSession.closeAllViews(string);
        }
    }
}

