/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.template.engine.provider;

import com.blazesoft.objects.dotnet.NdDotNETLib;
import com.blazesoft.objects.java.NdCalendar;
import com.blazesoft.objects.java.NdTime;
import com.blazesoft.template.engine.NdArgumentValidationException;
import com.blazesoft.template.engine.NdArgumentValidator;
import com.blazesoft.template.engine.NdProviderArgDescriptor;
import com.blazesoft.template.engine.NdProviderArgInfo;
import com.blazesoft.template.engine.NdProviderContext;
import com.blazesoft.template.engine.NdProviderStaticArg;
import com.blazesoft.template.engine.NdProvidesDefaultValue;
import com.blazesoft.template.engine.NdTemplateException;
import com.blazesoft.template.engine.NdUnsupportedProviderArgException;
import com.blazesoft.template.engine.provider.NdDesignProvider;
import com.blazesoft.template.engine.provider.NdDesignProviderArg;
import com.blazesoft.template.engine.provider.NdDesignProviderSelectableArg;
import com.blazesoft.template.engine.provider.NdRangeProvider;
import com.blazesoft.template.engine.provider.NdStrings;
import com.blazesoft.template.engine.provider.NdValueConversionException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class NdLocalizedTimeProvider
extends NdRangeProvider
implements NdProvidesDefaultValue,
NdDesignProvider,
NdArgumentValidator,
NdProviderArgInfo {
    private static final String WjHBgMY = "output-format";
    private static final String WjHBgNZ = "short";
    private static final String WjHBgOA = "medium";
    private static final String WjHBgOB = "long";
    private static final String WjHBgOC = "full";
    private static Calendar WjHBgOD = NdCalendar.safeCalendarGetInstance((TimeZone)NdCalendar.safeTimeZoneGetDefault(), (Locale)NdProviderContext.getPersistentLocale());
    private static NdCalendar WjHBgOE;
    private static SimpleDateFormat WjHBgOF;
    private static SimpleDateFormat WjHBgOG;
    private static SimpleDateFormat WjHBgOH;
    private static Locale WjHBgOI;
    private static DateFormat WjHBgOJ;
    private static DateFormat WjHBgOK;
    private static DateFormat WjHBgOL;
    private static DateFormat WjHBgOM;
    private static DateFormat WjHBgON;
    private static DateFormat WjHBgOO;
    private static DateFormat WjHBgOP;
    private static DateFormat WjHBgOQ;
    private static Hashtable WjHBZlN;
    private int WjHBgOR;
    static /* synthetic */ Class class$com$blazesoft$objects$java$NdTime;

    public NdProviderArgDescriptor getDescriptor(String string) throws NdTemplateException {
        NdProviderArgDescriptor ndProviderArgDescriptor = (NdProviderArgDescriptor)WjHBZlN.get(string);
        if (ndProviderArgDescriptor == null) {
            throw new NdUnsupportedProviderArgException(NdStrings.WjHzHJN("InvalidArgumentName", string, this.getClass().getName()));
        }
        return ndProviderArgDescriptor;
    }

    public String getProviderType(NdProviderContext ndProviderContext) {
        return "Localized time provider";
    }

    public void reset(NdProviderContext ndProviderContext) throws NdTemplateException {
        super.reset(ndProviderContext);
        this.WjHBgOR = 2;
    }

    public void setArgs(NdProviderContext ndProviderContext, NdProviderStaticArg[] ndProviderStaticArgArray) throws NdTemplateException {
        super.setArgs(ndProviderContext, ndProviderStaticArgArray);
        for (int i = 0; i < ndProviderStaticArgArray.length; ++i) {
            String string;
            String string2 = ndProviderStaticArgArray[i].getName();
            if (!string2.equals(WjHBgMY) || (string = ndProviderStaticArgArray[i].getValue()) == null) continue;
            if (string.equalsIgnoreCase(WjHBgNZ)) {
                this.WjHBgOR = 3;
                continue;
            }
            if (string.equalsIgnoreCase(WjHBgOA)) {
                this.WjHBgOR = 2;
                continue;
            }
            if (string.equalsIgnoreCase(WjHBgOB)) {
                this.WjHBgOR = 1;
                continue;
            }
            if (string.equalsIgnoreCase(WjHBgOC)) {
                this.WjHBgOR = 0;
                continue;
            }
            throw new NdTemplateException(NdStrings.WjHzHIM("InvalidLocalizedTimeFormatType", string2));
        }
    }

    private Date WjHBgOS(String string, String string2) throws NdTemplateException {
        Date date = this.WjHBgOY(string2.trim());
        if (date == null) {
            throw new NdTemplateException(NdStrings.WjHzHJN("InvalidLocalizedTimeConstraint", string, string2));
        }
        return date;
    }

    private boolean WjHBphJ(Date date, NdProviderContext ndProviderContext) throws NdTemplateException {
        Date date2;
        String string = this.getLowerBound(ndProviderContext);
        Date date3 = string != null ? this.WjHBgOS("lower-bound", string) : null;
        String string2 = this.getUpperBound(ndProviderContext);
        Date date4 = date2 = string2 != null ? this.WjHBgOS("upper-bound", string2) : null;
        if (string2 == null && string != null) {
            date2 = this.WjHBgOY("12:00:00 AM");
            WjHBgOD.setTime(date2);
            WjHBgOD.add(10, 24);
            date2 = WjHBgOD.getTime();
        } else if (string == null && string2 != null) {
            date3 = this.WjHBgOY("12:00:00 AM");
        }
        if (date3 != null && date2 != null) {
            boolean bl;
            if (date2.before(date3)) {
                WjHBgOD.setTime(date2);
                WjHBgOD.add(10, 24);
                date2 = WjHBgOD.getTime();
            }
            boolean bl2 = bl = !date.before(date3) && !date.after(date2);
            if (!bl) {
                WjHBgOD.setTime(date);
                WjHBgOD.add(10, 24);
                date = WjHBgOD.getTime();
                bl = !date.before(date3) && !date.after(date2);
            }
            return bl;
        }
        return true;
    }

    private Date WjHBgOU(String string, DateFormat dateFormat) throws ParseException {
        if (dateFormat == null) {
            throw new ParseException(string, 0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        WjHBgOD.setTime(new Date());
        stringBuffer.append(WjHBgOD.get(2) + 1);
        stringBuffer.append('/');
        stringBuffer.append(WjHBgOD.get(5));
        stringBuffer.append('/');
        stringBuffer.append(WjHBgOD.get(1));
        stringBuffer.append(' ');
        stringBuffer.append(string);
        String string2 = stringBuffer.toString();
        if (NdDotNETLib.isDotNETSupportEnabled() && string2.endsWith(" GMT")) {
            string2 = string2 + "+00:00";
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = NdCalendar.safeParse((DateFormat)dateFormat, (String)string2, (ParsePosition)parsePosition);
        if (parsePosition.getIndex() == 0 || parsePosition.getIndex() != string2.length()) {
            throw new ParseException("Unparseable date: \"" + string2 + "\"", parsePosition.getIndex());
        }
        return date;
    }

    private String WjHBgOV(String string, DateFormat dateFormat, DateFormat dateFormat2) throws ParseException {
        Date date = this.WjHBgOU(string, dateFormat);
        return NdCalendar.safeFormat((DateFormat)dateFormat2, (Date)date);
    }

    private String WjHBgOW(String string) throws NdTemplateException {
        DateFormat dateFormat = DateFormat.getTimeInstance(this.WjHBgOR, NdProviderContext.getDisplayLocale());
        dateFormat.setTimeZone(NdCalendar.safeTimeZoneGetDefault());
        try {
            try {
                string = this.WjHBgOV(string, WjHBgOF, dateFormat);
            }
            catch (ParseException parseException) {
                string = this.WjHBgOV(string, WjHBgOH, dateFormat);
            }
        }
        catch (ParseException parseException) {
            throw new NdTemplateException(NdStrings.WjHzHJN("InvalidLocalizedTimeInLocale", string, NdProviderContext.getDisplayLocale()));
        }
        return string;
    }

    private String WjHBgOX(String string, Locale locale) throws NdTemplateException {
        try {
            if (locale != NdProviderContext.getPersistentLocale()) {
                SimpleDateFormat simpleDateFormat = NdCalendar.safeNewSimpleDateFormat((String)"HH:mm:ss z", (Locale)locale);
                simpleDateFormat.setTimeZone(NdCalendar.safeTimeZoneGetDefault());
                try {
                    string = this.WjHBgOV(string, WjHBgOF, simpleDateFormat);
                }
                catch (ParseException parseException) {
                    string = this.WjHBgOV(string, WjHBgOH, simpleDateFormat);
                }
            }
        }
        catch (ParseException parseException) {
            throw new NdTemplateException(NdStrings.WjHzHJN("InvalidLocalizedTimeInLocale", string, locale));
        }
        return string;
    }

    public String convertToContentValue(NdProviderContext ndProviderContext, String string) throws NdTemplateException {
        if (!this.validateInstantiationValue(ndProviderContext, string)) {
            this.valueFailsRangeConstraint("Localized Time", string);
        }
        return this.WjHBgOX(string, ndProviderContext.getContentLocale());
    }

    public Object convertToDisplayValue(NdProviderContext ndProviderContext, String string) throws NdTemplateException {
        return this.WjHBgOW(string);
    }

    public String convertFromDisplayValue(NdProviderContext ndProviderContext, Object object) throws NdTemplateException {
        try {
            String string;
            Date date;
            Locale locale = ndProviderContext.getDisplayLocale();
            if (locale != WjHBgOI) {
                NdLocalizedTimeProvider.WjHBgOZ(locale);
                WjHBgOI = locale;
            }
            if ((date = this.WjHBgOY(string = (String)object)) == null) {
                throw new NdValueConversionException(NdStrings.WjHzHIM("InvalidLocalizedTimeValue", object));
            }
            return NdCalendar.safeFormat((DateFormat)WjHBgOG, (Date)date);
        }
        catch (ClassCastException classCastException) {
            throw new NdValueConversionException(NdStrings.WjHzHIM("InvalidLocalizedTimeValue", object != null ? object.toString() : NdStrings.WjHzHGK("Null")));
        }
    }

    private Date WjHBgOY(String string) {
        String string2 = string.trim();
        if (WjHBgOI == null) {
            NdLocalizedTimeProvider.WjHBgOZ(Locale.getDefault());
            WjHBgOI = Locale.getDefault();
        }
        try {
            Date date = this.WjHBgOU(string2, WjHBgOM);
            return date;
        }
        catch (ParseException parseException) {
            try {
                Date date = this.WjHBgOU(string2, WjHBgOL);
                return date;
            }
            catch (ParseException parseException2) {
                try {
                    Date date = this.WjHBgOU(string2, WjHBgOK);
                    return date;
                }
                catch (ParseException parseException3) {
                    try {
                        Date date = this.WjHBgOU(string2, WjHBgOJ);
                        return date;
                    }
                    catch (ParseException parseException4) {
                        try {
                            Date date = this.WjHBgOU(string2, WjHBgOO);
                            return date;
                        }
                        catch (ParseException parseException5) {
                            try {
                                Date date = this.WjHBgOU(string2, WjHBgON);
                                return date;
                            }
                            catch (ParseException parseException6) {
                                try {
                                    Date date = this.WjHBgOU(string2, WjHBgOQ);
                                    return date;
                                }
                                catch (ParseException parseException7) {
                                    try {
                                        Date date = this.WjHBgOU(string2, WjHBgOP);
                                        return date;
                                    }
                                    catch (ParseException parseException8) {
                                        return null;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static void WjHBgOZ(Locale locale) {
        TimeZone timeZone = NdCalendar.safeTimeZoneGetDefault();
        WjHBgOJ = NdLocalizedTimeProvider.WjHBgPA(DateFormat.getTimeInstance(3, locale), locale, timeZone);
        WjHBgOJ.setLenient(false);
        WjHBgOK = NdLocalizedTimeProvider.WjHBgPA(DateFormat.getTimeInstance(2, locale), locale, timeZone);
        WjHBgOK.setLenient(false);
        WjHBgOL = NdLocalizedTimeProvider.WjHBgPA(DateFormat.getTimeInstance(1, locale), locale, timeZone);
        WjHBgOL.setLenient(false);
        WjHBgOM = NdLocalizedTimeProvider.WjHBgPA(DateFormat.getTimeInstance(0, locale), locale, timeZone);
        WjHBgOM.setLenient(false);
    }

    private static SimpleDateFormat WjHBgPA(DateFormat dateFormat, Locale locale, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat = null;
        if (dateFormat instanceof SimpleDateFormat) {
            String string = "M/d/yyyy " + ((SimpleDateFormat)dateFormat).toPattern();
            simpleDateFormat = NdCalendar.safeNewSimpleDateFormat((String)string, (Locale)locale);
            simpleDateFormat.setTimeZone(timeZone);
        }
        return simpleDateFormat;
    }

    public Object convertToJavaObject(NdProviderContext ndProviderContext, String string) throws NdTemplateException {
        NdTime ndTime;
        try {
            ndTime = WjHBgOE.time(string.trim());
        }
        catch (ParseException parseException) {
            throw new NdTemplateException(NdStrings.WjHzHIM("InvalidLocalizedTimeValue", string));
        }
        return ndTime;
    }

    public String convertFromJavaObject(NdProviderContext ndProviderContext, Object object) throws NdTemplateException {
        try {
            Date date = ((NdTime)object).getJavaDate();
            return NdCalendar.safeFormat((DateFormat)WjHBgOG, (Date)date);
        }
        catch (Exception exception) {
            throw new NdTemplateException(NdStrings.WjHzHIM("InvalidLocalizedTimeValue", object != null ? object.toString() : NdStrings.WjHzHGK("Null")));
        }
    }

    public Class getValueClass(NdProviderContext ndProviderContext) {
        return class$com$blazesoft$objects$java$NdTime == null ? (class$com$blazesoft$objects$java$NdTime = NdLocalizedTimeProvider.class$("com.blazesoft.objects.java.NdTime")) : class$com$blazesoft$objects$java$NdTime;
    }

    public boolean validateInstantiationValue(NdProviderContext ndProviderContext, String string) throws NdTemplateException {
        if (string == null) {
            return false;
        }
        if (!ndProviderContext.getValidate()) {
            return true;
        }
        try {
            Date date = this.WjHBgOU(string, WjHBgOF);
            return this.WjHBphJ(date, ndProviderContext);
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public int compareValues(String string, String string2, NdProviderContext ndProviderContext) throws NdTemplateException {
        Date date;
        Date date2;
        try {
            date2 = this.WjHBgOY(string);
            if (date2 == null) {
                date2 = this.WjHBgOU(string, WjHBgOF);
            }
            if ((date = this.WjHBgOY(string2)) == null) {
                date = this.WjHBgOU(string2, WjHBgOF);
            }
        }
        catch (ParseException parseException) {
            throw new NdTemplateException(parseException);
        }
        long l = date2.getTime();
        long l2 = date.getTime();
        if (l == l2) {
            return 0;
        }
        return l > l2 ? 1 : -1;
    }

    public String provideDefaultValue(NdProviderContext ndProviderContext) throws NdTemplateException {
        String string;
        String string2 = this.getLowerBound(ndProviderContext);
        Date date = string2 != null ? this.WjHBgOS("lower-bound", string2) : ((string = this.getUpperBound(ndProviderContext)) != null ? this.WjHBgOS("upper-bound", string) : new Date());
        return NdCalendar.safeFormat((DateFormat)WjHBgOG, (Date)date);
    }

    public String[] provideUniqueDefaultValues(NdProviderContext ndProviderContext, int n) throws NdTemplateException {
        int n2;
        boolean bl;
        Date date;
        Date date2;
        Vector<String> vector = new Vector<String>();
        String string = this.getLowerBound(ndProviderContext);
        String string2 = this.getUpperBound(ndProviderContext);
        if (string != null && string2 != null) {
            Date date3 = this.WjHBgOS("lower-bound", string);
            Date date4 = this.WjHBgOS("upper-bound", string2);
            WjHBgOD.setTime(date3);
            WjHBgOD.add(13, n);
            date2 = WjHBgOD.getTime();
            if (date2.getTime() > date4.getTime()) {
                date2 = date4;
            }
            date = date3;
            bl = true;
            n2 = 1;
        } else if (string != null) {
            date = this.WjHBgOS("lower-bound", string);
            date2 = null;
            bl = true;
            n2 = 1;
        } else if (string2 != null) {
            date = this.WjHBgOS("upper-bound", string2);
            date2 = null;
            bl = false;
            n2 = -1;
        } else {
            date = new Date();
            date2 = null;
            bl = true;
            n2 = 1;
        }
        WjHBgOD.setTime(date);
        for (int i = 0; !(i >= n || date2 != null && (bl && date2.getTime() > WjHBgOD.getTime().getTime() || !bl && date2.getTime() < WjHBgOD.getTime().getTime())); ++i) {
            vector.addElement(NdCalendar.safeFormat((DateFormat)WjHBgOG, (Date)WjHBgOD.getTime()));
            WjHBgOD.add(13, n2);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void validateArgument(String string, String string2) throws NdArgumentValidationException {
        if (string.equals("lower-bound") || string.equals("upper-bound")) {
            try {
                this.WjHBgOS(string, string2);
            }
            catch (NdTemplateException ndTemplateException) {
                throw new NdArgumentValidationException(string, string2, ndTemplateException.getMessage());
            }
        } else if (!(!string.equals(WjHBgMY) || string2.equals(WjHBgNZ) || string2.equals(WjHBgOA) || string2.equals(WjHBgOB) || string2.equals(WjHBgOC))) {
            throw new NdArgumentValidationException(string, string2, NdStrings.WjHzHJN("LocalizedTimeProviderArgIsInvalid", string, string2));
        }
    }

    public void validateAllArguments(String[] stringArray, String[] stringArray2) throws NdArgumentValidationException {
        int n = -1;
        int n2 = -1;
        Date date = null;
        Date date2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            this.validateArgument(stringArray[i], stringArray2[i]);
            if (stringArray[i].equals("lower-bound")) {
                n = i;
                date = this.WjHBgOY(stringArray2[i]);
                continue;
            }
            if (!stringArray[i].equals("upper-bound")) continue;
            n2 = i;
            date2 = this.WjHBgOY(stringArray2[i]);
        }
        if (n != -1 && n2 != -1 && date.getTime() > date2.getTime()) {
            String[] stringArray3 = new String[]{stringArray[n], stringArray[n2]};
            String[] stringArray4 = new String[]{stringArray2[n], stringArray2[n2]};
            throw new NdArgumentValidationException(stringArray3, stringArray4, NdStrings.WjHzHGK("LocalizedTimeProviderInvalidLowerLimit"));
        }
    }

    public String getDisplayName(NdProviderContext ndProviderContext) throws NdTemplateException {
        return NdStrings.WjHzHGK("LocalizedTimeProviderDisplayName");
    }

    public String getDescription(NdProviderContext ndProviderContext) throws NdTemplateException {
        return NdStrings.WjHzHGK("LocalizedTimeProviderDescription");
    }

    public String getDisplayKey(NdProviderContext ndProviderContext) throws NdTemplateException {
        return "LocalizedTimeProvider";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdDesignProviderArg[] getArgumentDescriptors(NdProviderContext ndProviderContext) throws NdTemplateException {
        String string;
        String string2;
        String string3;
        String string4;
        NdDesignProviderArg[] ndDesignProviderArgArray = this.getRangeArgumentDescriptors(7);
        NdDesignProviderSelectableArg ndDesignProviderSelectableArg = new NdDesignProviderSelectableArg(WjHBgMY);
        ndDesignProviderSelectableArg.setDisplayName(NdStrings.WjHzHGK("LocalizedTimeFormatArgDisplayName"));
        ndDesignProviderSelectableArg.setDescription(NdStrings.WjHzHGK("LocalizedTimeFormatArgDescription"));
        ndDesignProviderSelectableArg.setChoices(new String[]{WjHBgNZ, WjHBgOA, WjHBgOB, WjHBgOC});
        ndDesignProviderSelectableArg.setDefaultValue(WjHBgOA);
        Date date = new Date();
        if (NdCalendar.isJSHARP_CALENDAR_LOCK_Needed) {
            Object object = NdCalendar.JSHARP_CALENDAR_LOCK;
            synchronized (object) {
                string4 = NdStrings.WjHzHIM("LocalizedTimeProviderDisplayFormatShort", DateFormat.getTimeInstance(3, Locale.getDefault()).format(date));
                string3 = NdStrings.WjHzHIM("LocalizedTimeProviderDisplayFormatMedium", DateFormat.getTimeInstance(2, Locale.getDefault()).format(date));
                string2 = NdStrings.WjHzHIM("LocalizedTimeProviderDisplayFormatLong", DateFormat.getTimeInstance(1, Locale.getDefault()).format(date));
                string = NdStrings.WjHzHIM("LocalizedTimeProviderDisplayFormatFull", DateFormat.getTimeInstance(0, Locale.getDefault()).format(date));
            }
        } else {
            string4 = NdStrings.WjHzHIM("LocalizedTimeProviderDisplayFormatShort", DateFormat.getTimeInstance(3, Locale.getDefault()).format(date));
            string3 = NdStrings.WjHzHIM("LocalizedTimeProviderDisplayFormatMedium", DateFormat.getTimeInstance(2, Locale.getDefault()).format(date));
            string2 = NdStrings.WjHzHIM("LocalizedTimeProviderDisplayFormatLong", DateFormat.getTimeInstance(1, Locale.getDefault()).format(date));
            string = NdStrings.WjHzHIM("LocalizedTimeProviderDisplayFormatFull", DateFormat.getTimeInstance(0, Locale.getDefault()).format(date));
        }
        ndDesignProviderSelectableArg.setDisplayChoices(new String[]{string4, string3, string2, string});
        return new NdDesignProviderArg[]{ndDesignProviderArgArray[0], ndDesignProviderArgArray[1], ndDesignProviderSelectableArg};
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        WjHBgOD.setLenient(false);
        WjHBgOE = new NdCalendar(NdCalendar.safeTimeZoneGetDefault(), NdProviderContext.getPersistentLocale(), 1);
        WjHBgOE.setLenient(false);
        TimeZone timeZone = NdCalendar.safeTimeZoneGetDefault();
        WjHBgON = NdCalendar.safeNewSimpleDateFormat((String)"M/d/yyyy H:mm:ss", (Locale)Locale.US);
        WjHBgON.setTimeZone(timeZone);
        WjHBgON.setLenient(false);
        WjHBgOO = NdCalendar.safeNewSimpleDateFormat((String)"M/d/yyyy H:mm:ss z", (Locale)Locale.US);
        WjHBgOO.setTimeZone(timeZone);
        WjHBgOO.setLenient(false);
        WjHBgOP = NdCalendar.safeNewSimpleDateFormat((String)"M/d/yyyy H:mm", (Locale)Locale.US);
        WjHBgOP.setTimeZone(timeZone);
        WjHBgOP.setLenient(false);
        WjHBgOQ = NdCalendar.safeNewSimpleDateFormat((String)"M/d/yyyy H:mm z", (Locale)Locale.US);
        WjHBgOQ.setTimeZone(timeZone);
        WjHBgOQ.setLenient(false);
        TimeZone timeZone2 = TimeZone.getTimeZone("GMT");
        Locale locale = NdProviderContext.getPersistentLocale();
        WjHBgOF = NdCalendar.safeNewSimpleDateFormat((String)"M/d/yyyy HH:mm:ss z", (Locale)locale);
        WjHBgOF.setTimeZone(timeZone2);
        WjHBgOF.setLenient(false);
        WjHBgOG = NdCalendar.safeNewSimpleDateFormat((String)"HH:mm:ss z", (Locale)locale);
        WjHBgOG.setTimeZone(timeZone2);
        WjHBgOG.setLenient(false);
        WjHBgOH = NdCalendar.safeNewSimpleDateFormat((String)"M/d/yyyy H:mm:ss", (Locale)locale);
        WjHBgOH.setTimeZone(NdCalendar.safeTimeZoneGetDefault());
        WjHBZlN = new Hashtable(11, 1.0f);
        WjHBZlN.put(WjHBgMY, new NdProviderArgDescriptor(NdProviderArgDescriptor.SINGLE_VALUE, false));
        NdRangeProvider.addArgDescriptors(WjHBZlN);
    }
}

