/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.template.engine.provider;

import com.blazesoft.objects.java.NdCurrencyManager;
import com.blazesoft.objects.java.NdMoneyAmount;
import com.blazesoft.template.engine.NdArgumentValidationException;
import com.blazesoft.template.engine.NdArgumentValidator;
import com.blazesoft.template.engine.NdProviderArgDescriptor;
import com.blazesoft.template.engine.NdProviderArgInfo;
import com.blazesoft.template.engine.NdProviderContext;
import com.blazesoft.template.engine.NdProvidesDefaultValue;
import com.blazesoft.template.engine.NdTemplateException;
import com.blazesoft.template.engine.NdTemplateManager;
import com.blazesoft.template.engine.NdUnsupportedProviderArgException;
import com.blazesoft.template.engine.provider.NdDesignProvider;
import com.blazesoft.template.engine.provider.NdDesignProviderArg;
import com.blazesoft.template.engine.provider.NdItemTypeProvider;
import com.blazesoft.template.engine.provider.NdRangeProvider;
import com.blazesoft.template.engine.provider.NdStrings;
import com.blazesoft.template.engine.provider.NdValueConversionException;
import com.blazesoft.util.NdComparable;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class NdMoneyProvider
extends NdRangeProvider
implements NdProvidesDefaultValue,
NdDesignProvider,
NdArgumentValidator,
NdItemTypeProvider,
NdProviderArgInfo {
    private static Hashtable WjHBYSY = new Hashtable(11, 1.0f);
    private NdMoneyAmount WjHzFTE;
    private NdMoneyAmount WjHzFUF;
    private NdCurrencyManager WjHzFVG;
    private DecimalFormatSymbols WjHAEXL;
    private boolean WjHzFWH;
    static /* synthetic */ Class class$com$blazesoft$objects$java$NdMoneyAmount;

    public NdProviderArgDescriptor getDescriptor(String string) throws NdTemplateException {
        NdProviderArgDescriptor ndProviderArgDescriptor = (NdProviderArgDescriptor)WjHBYSY.get(string);
        if (ndProviderArgDescriptor == null) {
            throw new NdUnsupportedProviderArgException(NdStrings.WjHzHJN("InvalidArgumentName", string, this.getClass().getName()));
        }
        return ndProviderArgDescriptor;
    }

    public String getProviderType(NdProviderContext ndProviderContext) {
        return "Money provider";
    }

    public void reset(NdProviderContext ndProviderContext) throws NdTemplateException {
        super.reset(ndProviderContext);
        if (this.WjHzFVG == null) {
            Locale locale;
            WjHDfYS wjHDfYS;
            NdTemplateManager ndTemplateManager = ndProviderContext.getTemplateManager();
            WjHDfWE wjHDfWE = (WjHDfWE)ndTemplateManager.getProperty(wjHDfYS = new WjHDfYS(locale = NdProviderContext.getPersistentLocale()));
            if (wjHDfWE == null) {
                this.WjHzFVG = new NdCurrencyManager(NdProviderContext.getPersistentLocale());
                this.WjHAEXL = new DecimalFormatSymbols(NdProviderContext.getPersistentLocale());
                wjHDfWE = new WjHDfWE(this.WjHzFVG, this.WjHAEXL);
                ndTemplateManager.setProperty(wjHDfYS, wjHDfWE);
                this.WjHzFVG.setFormatMode(1);
            } else {
                this.WjHzFVG = wjHDfWE.WjHDfUC();
                this.WjHAEXL = wjHDfWE.WjHDfVD();
            }
        }
        this.WjHzFWH = false;
    }

    private NdMoneyAmount WjHzFXI(String string, String string2) throws NdTemplateException {
        NdMoneyAmount ndMoneyAmount;
        try {
            ndMoneyAmount = this.WjHzFVG.parse(string2.trim());
        }
        catch (ParseException parseException) {
            throw new NdTemplateException(parseException, NdStrings.WjHzHJN("InvalidMoneyConstraint", string, string2));
        }
        return ndMoneyAmount;
    }

    private void WjHBoRH(NdProviderContext ndProviderContext) throws NdTemplateException {
        String string = this.getUpperBound(ndProviderContext);
        String string2 = this.getLowerBound(ndProviderContext);
        this.WjHzFTE = string2 != null ? this.WjHzFXI("lower-bound", string2) : null;
        this.WjHzFUF = string != null ? this.WjHzFXI("upper-bound", string) : null;
        this.WjHzFWH = true;
    }

    private boolean WjHBoSI(NdMoneyAmount ndMoneyAmount, NdProviderContext ndProviderContext) throws NdTemplateException {
        if (!this.WjHzFWH) {
            this.WjHBoRH(ndProviderContext);
        }
        if (this.WjHzFTE != null && ndMoneyAmount.compareTo((NdComparable)this.WjHzFTE) < 0) {
            return false;
        }
        return this.WjHzFUF == null || ndMoneyAmount.compareTo((NdComparable)this.WjHzFUF) <= 0;
    }

    private String WjHABJN(String string, Locale locale) throws ParseException {
        NdMoneyAmount ndMoneyAmount = this.WjHzFVG.parse(string.trim());
        NdCurrencyManager ndCurrencyManager = new NdCurrencyManager(locale);
        return ndMoneyAmount.toString(ndCurrencyManager);
    }

    private String WjHABKO(String string, Locale locale) throws ParseException {
        NdMoneyAmount ndMoneyAmount = this.WjHzFVG.parse(string.trim());
        NdCurrencyManager ndCurrencyManager = new NdCurrencyManager(locale);
        ndCurrencyManager.setFormatMode(1);
        return ndMoneyAmount.toString(ndCurrencyManager);
    }

    public String convertToContentValue(NdProviderContext ndProviderContext, String string) throws NdTemplateException {
        boolean bl;
        ParseException parseException = null;
        try {
            bl = this.WjHATZE(ndProviderContext, string);
        }
        catch (ParseException parseException2) {
            bl = false;
            parseException = parseException2;
        }
        if (!bl) {
            if (parseException == null) {
                this.valueFailsRangeConstraint("Money", string);
            } else {
                this.valueFailsRangeConstraint("Money", string, parseException);
            }
        }
        Locale locale = ndProviderContext.getContentLocale();
        try {
            DecimalFormatSymbols decimalFormatSymbols = this.WjHAEXL;
            if (locale != ndProviderContext.getPersistentLocale()) {
                string = this.WjHABKO(string, locale);
                decimalFormatSymbols = new DecimalFormatSymbols(locale);
            }
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = string.toCharArray();
            char c = this.WjHAEXL.getGroupingSeparator();
            char c2 = this.WjHAEXL.getDecimalSeparator();
            char c3 = decimalFormatSymbols.getDecimalSeparator();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == c2) {
                    stringBuffer.append(c3);
                    continue;
                }
                if (cArray[i] == c) continue;
                stringBuffer.append(cArray[i]);
            }
            string = stringBuffer.toString();
        }
        catch (ParseException parseException3) {
            throw new NdTemplateException(parseException3, NdStrings.WjHzHJN("InvalidMoneyInLocale", string, locale.toString()));
        }
        return string;
    }

    public Object convertToDisplayValue(NdProviderContext ndProviderContext, String string) throws NdTemplateException {
        String string2 = string;
        Locale locale = ndProviderContext.getDisplayLocale();
        try {
            if (locale != null) {
                string2 = this.WjHABJN(string, locale);
            }
        }
        catch (ParseException parseException) {
            throw new NdTemplateException(parseException, NdStrings.WjHzHJN("InvalidMoneyInLocale", string, locale.toString()));
        }
        return string2;
    }

    public String convertFromDisplayValue(NdProviderContext ndProviderContext, Object object) throws NdTemplateException {
        try {
            Locale locale = ndProviderContext.getDisplayLocale();
            NdCurrencyManager ndCurrencyManager = this.WjHzFVG;
            if (locale != null) {
                ndCurrencyManager = new NdCurrencyManager(locale);
            }
            NdMoneyAmount ndMoneyAmount = ndCurrencyManager.parse(((String)object).trim());
            return ndMoneyAmount.toString(this.WjHzFVG);
        }
        catch (ClassCastException classCastException) {
            throw new NdValueConversionException(NdStrings.WjHzHIM("InvalidMoneyValue", object != null ? object.toString() : NdStrings.WjHzHGK("Null")));
        }
        catch (ParseException parseException) {
            throw new NdValueConversionException(parseException, NdStrings.WjHzHIM("InvalidMoneyValue", object));
        }
    }

    public Object convertToJavaObject(NdProviderContext ndProviderContext, String string) throws NdTemplateException {
        NdMoneyAmount ndMoneyAmount;
        try {
            ndMoneyAmount = this.WjHzFVG.parse(string.trim());
        }
        catch (ParseException parseException) {
            throw new NdTemplateException(parseException, NdStrings.WjHzHIM("InvalidMoneyValue", string));
        }
        return ndMoneyAmount;
    }

    public String convertFromJavaObject(NdProviderContext ndProviderContext, Object object) throws NdTemplateException {
        String string;
        try {
            string = ((NdMoneyAmount)object).toString(this.WjHzFVG);
        }
        catch (Exception exception) {
            throw new NdTemplateException(NdStrings.WjHzHIM("InvalidMoneyValue", object != null ? object.toString() : NdStrings.WjHzHGK("Null")));
        }
        return string;
    }

    public Class getValueClass(NdProviderContext ndProviderContext) {
        return class$com$blazesoft$objects$java$NdMoneyAmount == null ? (class$com$blazesoft$objects$java$NdMoneyAmount = NdMoneyProvider.class$("com.blazesoft.objects.java.NdMoneyAmount")) : class$com$blazesoft$objects$java$NdMoneyAmount;
    }

    public boolean validateInstantiationValue(NdProviderContext ndProviderContext, String string) throws NdTemplateException {
        if (string == null) {
            return false;
        }
        if (!ndProviderContext.getValidate()) {
            return true;
        }
        try {
            return this.WjHATZE(ndProviderContext, string);
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    private boolean WjHATZE(NdProviderContext ndProviderContext, String string) throws ParseException, NdTemplateException {
        NdMoneyAmount ndMoneyAmount = this.WjHzFVG.parse(string.trim());
        return this.WjHBoSI(ndMoneyAmount, ndProviderContext);
    }

    public int compareValues(String string, String string2, NdProviderContext ndProviderContext) throws NdTemplateException {
        NdMoneyAmount ndMoneyAmount;
        NdMoneyAmount ndMoneyAmount2;
        try {
            ndMoneyAmount2 = this.WjHzFVG.parse(string.trim());
            ndMoneyAmount = this.WjHzFVG.parse(string2.trim());
        }
        catch (ParseException parseException) {
            throw new NdTemplateException(parseException);
        }
        return ndMoneyAmount2.compareTo((NdComparable)ndMoneyAmount);
    }

    public String provideDefaultValue(NdProviderContext ndProviderContext) throws NdTemplateException {
        String string = super.provideDefaultValue(ndProviderContext);
        if (string == null) {
            string = "1.0 USD";
        }
        return string;
    }

    public String[] provideUniqueDefaultValues(NdProviderContext ndProviderContext, int n) throws NdTemplateException {
        if (!this.WjHzFWH) {
            this.WjHBoRH(ndProviderContext);
        }
        try {
            boolean bl;
            NdMoneyAmount ndMoneyAmount;
            NdMoneyAmount ndMoneyAmount2;
            NdMoneyAmount ndMoneyAmount3;
            String string = this.getUpperBound(ndProviderContext);
            String string2 = this.getLowerBound(ndProviderContext);
            NdMoneyAmount ndMoneyAmount4 = this.WjHzFVG.parse(String.valueOf(n) + " USD");
            if (string2 != null && string != null) {
                ndMoneyAmount3 = ndMoneyAmount4.multiply((Number)new Integer(n - 1));
                ndMoneyAmount2 = this.WjHzFTE.add(ndMoneyAmount3);
                if (ndMoneyAmount2.compareTo((NdComparable)this.WjHzFUF) > 0) {
                    ndMoneyAmount2 = this.WjHzFUF;
                }
                ndMoneyAmount = this.WjHzFTE;
                bl = true;
            } else if (string2 != null) {
                ndMoneyAmount = this.WjHzFTE;
                ndMoneyAmount2 = null;
                bl = true;
            } else if (string != null) {
                ndMoneyAmount = this.WjHzFUF;
                ndMoneyAmount2 = null;
                bl = false;
            } else {
                ndMoneyAmount = this.WjHzFVG.parse(String.valueOf(0) + " USD");
                ndMoneyAmount2 = null;
                bl = true;
            }
            ndMoneyAmount3 = ndMoneyAmount;
            Vector<String> vector = new Vector<String>();
            for (int i = 0; !(i >= n || ndMoneyAmount2 != null && (bl && ndMoneyAmount3.compareTo((NdComparable)ndMoneyAmount2) > 0 || !bl && ndMoneyAmount3.compareTo((NdComparable)ndMoneyAmount2) < 0)); ++i) {
                vector.addElement(ndMoneyAmount3.toString(this.WjHzFVG));
                ndMoneyAmount3 = bl ? ndMoneyAmount3.add(ndMoneyAmount4) : ndMoneyAmount3.subtract(ndMoneyAmount4);
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (ParseException parseException) {
            throw new NdTemplateException(parseException, NdStrings.WjHzHGK("ErrorGeneratingUniqueDefaultMoney"));
        }
    }

    public void validateArgument(String string, String string2) throws NdArgumentValidationException {
        if (string.equals("lower-bound") || string.equals("upper-bound")) {
            try {
                this.WjHzFXI(string, string2);
            }
            catch (NdTemplateException ndTemplateException) {
                throw new NdArgumentValidationException(string, string2, ndTemplateException.getMessage());
            }
        }
    }

    public void validateAllArguments(String[] stringArray, String[] stringArray2) throws NdArgumentValidationException {
        int n = -1;
        int n2 = -1;
        NdMoneyAmount ndMoneyAmount = null;
        NdMoneyAmount ndMoneyAmount2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            this.validateArgument(stringArray[i], stringArray2[i]);
            if (stringArray[i].equals("lower-bound")) {
                n = i;
                try {
                    ndMoneyAmount = this.WjHzFVG.parse(stringArray2[i].trim());
                }
                catch (ParseException parseException) {}
                continue;
            }
            if (!stringArray[i].equals("upper-bound")) continue;
            n2 = i;
            try {
                ndMoneyAmount2 = this.WjHzFVG.parse(stringArray2[i].trim());
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (n != -1 && n2 != -1 && ndMoneyAmount.compareTo(ndMoneyAmount2) > 0) {
            String[] stringArray3 = new String[]{stringArray[n], stringArray[n2]};
            String[] stringArray4 = new String[]{stringArray2[n], stringArray2[n2]};
            throw new NdArgumentValidationException(stringArray3, stringArray4, NdStrings.WjHzHGK("MoneyProviderInvalidLowerLimit"));
        }
    }

    public String getDisplayName(NdProviderContext ndProviderContext) throws NdTemplateException {
        return NdStrings.WjHzHGK("MoneyProviderDisplayName");
    }

    public String getDescription(NdProviderContext ndProviderContext) throws NdTemplateException {
        return NdStrings.WjHzHGK("MoneyProviderDescription");
    }

    public String getDisplayKey(NdProviderContext ndProviderContext) throws NdTemplateException {
        return "MoneyProvider";
    }

    public NdDesignProviderArg[] getArgumentDescriptors(NdProviderContext ndProviderContext) throws NdTemplateException {
        return this.getRangeArgumentDescriptors(3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        NdRangeProvider.addArgDescriptors(WjHBYSY);
    }

    private static class WjHDfWE {
        NdCurrencyManager WjHDfSA;
        DecimalFormatSymbols WjHDfTB;

        WjHDfWE(NdCurrencyManager ndCurrencyManager, DecimalFormatSymbols decimalFormatSymbols) {
            this.WjHDfSA = ndCurrencyManager;
            this.WjHDfTB = decimalFormatSymbols;
        }

        NdCurrencyManager WjHDfUC() {
            return this.WjHDfSA;
        }

        DecimalFormatSymbols WjHDfVD() {
            return this.WjHDfTB;
        }
    }

    private static class WjHDfYS {
        Locale WjHDfXR;

        WjHDfYS(Locale locale) {
            this.WjHDfXR = locale;
        }

        public int hashCode() {
            return this.WjHDfXR.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof WjHDfYS) {
                WjHDfYS wjHDfYS = (WjHDfYS)object;
                return this.WjHDfXR.equals(wjHDfYS.WjHDfXR);
            }
            return false;
        }
    }
}

