/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.template.repository.deploy;

import com.blazesoft.objects.java.NdCalendar;
import com.blazesoft.objects.java.NdDate;
import com.blazesoft.template.engine.NdProviderContext;
import com.blazesoft.template.repository.NdRomException;
import com.blazesoft.template.repository.deploy.NdAbstractFilterExpressionEvaluator;
import com.blazesoft.template.repository.deploy.NdStrings;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class NdDateFilterExpressionEvaluator
extends NdAbstractFilterExpressionEvaluator {
    private static final int[] WjIpHhT = new int[]{301, 311, 322, 342, 362, 382};
    private boolean WjIpHiU;
    public static final String INTERNAL_DATE_FORMAT = "d-MMM-yyyy";

    public NdDateFilterExpressionEvaluator(boolean bl) {
        this.WjIpHiU = bl;
    }

    public NdDateFilterExpressionEvaluator() {
        this(false);
    }

    private boolean WjIpHjV(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance(NdProviderContext.getPersistentLocale());
        Calendar calendar2 = Calendar.getInstance(NdProviderContext.getPersistentLocale());
        calendar.setTime(date);
        calendar2.setTime(date2);
        boolean bl = calendar.get(6) == calendar2.get(6) && calendar.get(1) == calendar2.get(1);
        return bl;
    }

    private boolean WjIpHkW(Date date, Date date2) {
        return this.WjIpHiU ? date.equals(date2) : this.WjIpHjV(date, date2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Date WjIRmnC(Object object, String string) throws NdRomException {
        if (object == null) throw new NdRomException(NdStrings.WjHNgeR("DateFilterExpressionConfiguredWithNullArgument", string));
        if (object instanceof Date) {
            return (Date)object;
        }
        if (!(object instanceof String)) throw new NdRomException(NdStrings.WjHNgfS("DateFilterExpressionConfiguredWithNonDateArgument", string, object));
        try {
            return NdDateFilterExpressionEvaluator.convertStringToJavaDate(NdDateFilterExpressionEvaluator.createDateConversionCalendar(), (String)object);
        }
        catch (NdRomException ndRomException) {
            throw new NdRomException(NdStrings.WjHNgfS("DateFilterExpressionConfiguredWithNonDateArgument", string, object), (Throwable)((Object)ndRomException));
        }
    }

    protected int[] getValidOperators() {
        return WjIpHhT;
    }

    protected boolean isEqualsOperator(int n) {
        return n == 301;
    }

    protected boolean evaluateScalar(Object object, Object object2, int n) throws NdRomException {
        boolean bl = false;
        Date date = this.WjIRmnC(object, NdStrings.WjHNgcP("ActualValue"));
        Date date2 = this.WjIRmnC(object2, NdStrings.WjHNgcP("ConfiguredValue"));
        switch (n) {
            case 301: {
                bl = this.WjIpHkW(date, date2);
                break;
            }
            case 311: {
                bl = !this.WjIpHkW(date, date2);
                break;
            }
            case 322: {
                bl = !this.WjIpHkW(date, date2) && date.before(date2);
                break;
            }
            case 342: {
                bl = !this.WjIpHkW(date, date2) && date.after(date2);
                break;
            }
            case 362: {
                bl = date.before(date2) || this.WjIpHkW(date, date2);
                break;
            }
            case 382: {
                bl = date.after(date2) || this.WjIpHkW(date, date2);
                break;
            }
        }
        return bl;
    }

    public static NdCalendar createDateConversionCalendar() {
        NdCalendar ndCalendar = new NdCalendar(NdCalendar.safeTimeZoneGetDefault(), NdProviderContext.getPersistentLocale(), 1);
        ndCalendar.setDefaultDateFormat(INTERNAL_DATE_FORMAT);
        ndCalendar.setLenient(false);
        return ndCalendar;
    }

    public static Date convertStringToJavaDate(NdCalendar ndCalendar, String string) throws NdRomException {
        Date date = null;
        if (string != null) {
            String string2 = string.trim();
            try {
                date = ndCalendar.date(string2, INTERNAL_DATE_FORMAT).getJavaDate();
            }
            catch (ParseException parseException) {
                try {
                    date = DateFormat.getInstance().parse(string2);
                }
                catch (ParseException parseException2) {
                    throw new NdRomException(NdStrings.WjHNgcP("InvalidDateString"), parseException2);
                }
            }
        }
        return date;
    }

    public static String convertJavaDateToString(NdCalendar ndCalendar, Date date) {
        NdDate ndDate = new NdDate(ndCalendar, date);
        return ndDate.toString();
    }

    public boolean isStrict() {
        return this.WjIpHiU;
    }
}

