/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.template.repository.deploy;

import com.blazesoft.template.repository.NdPromDirectory;
import com.blazesoft.template.repository.NdPromItem;
import com.blazesoft.template.repository.NdPromProject;
import com.blazesoft.template.repository.NdRomConnectionContext;
import com.blazesoft.template.repository.NdRomException;
import com.blazesoft.template.repository.deploy.NdAbstractPromExtractor;
import com.blazesoft.template.repository.deploy.NdPromDefaultItemExtractor;
import com.blazesoft.template.repository.deploy.NdPromEntityExtractionException;
import com.blazesoft.template.repository.deploy.NdPromEntityExtractor;
import com.blazesoft.template.repository.deploy.NdPromEntityFilter;
import com.blazesoft.template.repository.deploy.NdPromEntityTypeSubTypeFilter;
import com.blazesoft.template.repository.deploy.NdPromResolvedEntityException;
import com.blazesoft.template.repository.deploy.NdRomExtractorConfig;
import com.blazesoft.template.repository.deploy.NdStrings;
import com.blazesoft.template.repository.objects.NdPromEntity;
import com.blazesoft.template.repository.objects.NdPromInstance;
import com.blazesoft.template.repository.objects.group.NdPromGroup;
import com.blazesoft.template.repository.objects.group.NdPromGroupItem;
import com.blazesoft.template.repository.objects.rules.NdPromSrlRuleset;
import com.blazesoft.template.repository.objects.rules.NdPromSrlRulesetItem;
import com.blazesoft.template.repository.query.NdRomQuery;
import com.blazesoft.template.repository.query.NdRomQueryResultItem;
import com.blazesoft.template.repository.query.NdRomQueryResultSet;
import com.blazesoft.template.repository.security.NdRomAuthorizationRequestFactory;
import com.blazesoft.template.repository.util.NdPromProjectUtil;
import com.blazesoft.template.repository.util.NdRomSchemaSupport;
import com.blazesoft.util.NdSystemProperties;
import java.util.Vector;

public class NdPromDefaultEntityExtractor
extends NdAbstractPromExtractor
implements NdPromEntityExtractor {
    public static final int DEPTH_TOP = 0;
    public static final int DEPTH_GROUPS = 1;
    public static final int DEPTH_RULESETS = 2;
    private static final int WjIccsZ = 1;
    private NdPromDefaultItemExtractor WjHNUHB;
    private NdPromEntityFilter WjHVBFQ;
    private NdPromEntityFilter WjHVBGR;
    private int WjImqSS;
    private boolean WjIKIIO;
    private Vector WjIKIIP;
    static /* synthetic */ Class class$com$blazesoft$template$repository$objects$NdPromEntity;

    public NdPromDefaultEntityExtractor(NdRomExtractorConfig ndRomExtractorConfig, NdRomConnectionContext ndRomConnectionContext) throws NdRomException {
        this(ndRomExtractorConfig, ndRomConnectionContext, 1);
    }

    public NdPromDefaultEntityExtractor(NdRomExtractorConfig ndRomExtractorConfig, NdRomConnectionContext ndRomConnectionContext, int n) throws NdRomException {
        super(ndRomExtractorConfig, ndRomConnectionContext);
        this.construct(this.getSchemaSupport());
        this.WjImqSS = n;
    }

    public NdPromDefaultEntityExtractor(NdRomSchemaSupport ndRomSchemaSupport) {
        super(ndRomSchemaSupport);
        this.construct(ndRomSchemaSupport);
    }

    public void reportUnextractedItems() {
        if (!NdSystemProperties.isProviderFastEntityInfoExtractionDisabled()) {
            this.WjIKIIO = true;
        }
    }

    public NdPromItem[] getUnextractedItems() {
        Object[] objectArray = new NdPromItem[]{};
        if (this.WjIKIIP != null) {
            objectArray = new NdPromItem[this.WjIKIIP.size()];
            this.WjIKIIP.copyInto(objectArray);
        }
        return objectArray;
    }

    protected void construct(NdRomSchemaSupport ndRomSchemaSupport) {
        this.WjHNUHB = new NdPromDefaultItemExtractor(ndRomSchemaSupport);
        if (this.getExtractorConfig() != null && this.getExtractorConfig().getPromItemFilterConfig() != null) {
            this.WjHNUHB.setExtractorConfig(this.getExtractorConfig());
        }
        this.WjHVBFQ = this.WjHVBGR = new NdPromEntityTypeSubTypeFilter(0, -1);
        this.WjImqSS = 1;
    }

    public NdPromEntity[] extract(NdPromProject ndPromProject) throws NdRomException {
        if (this.WjIKIIO) {
            this.WjIKIIP = new Vector();
        }
        if (this.getQueryConfig() != null) {
            if (this.getQueryManager() == null) {
                throw new NdRomException(NdStrings.WjHNgcP("CannotFindQueryManager"));
            }
            NdRomQuery ndRomQuery = this.lookupQuery(this.getQueryConfig());
            NdRomQueryResultSet ndRomQueryResultSet = this.executeQuery(ndRomQuery, ndPromProject);
            NdPromEntity[] ndPromEntityArray = this.getEntitiesFromResultSet(ndRomQuery.getName(), ndRomQueryResultSet);
            return this.filterEntities(ndPromProject, ndPromEntityArray);
        }
        NdPromEntityFilter ndPromEntityFilter = this.getEntityFilter(ndPromProject);
        if (ndPromEntityFilter != null) {
            this.setFilter(ndPromEntityFilter);
        }
        return this.extractEntities(ndPromProject);
    }

    protected NdPromEntity[] extractEntities(NdPromProject ndPromProject) throws NdRomException {
        NdPromItem[] ndPromItemArray = this.WjHNUHB.extract(ndPromProject);
        return this.WjHNvHE(ndPromItemArray);
    }

    public NdPromEntity[] extract(NdPromDirectory ndPromDirectory) throws NdRomException {
        NdPromItem[] ndPromItemArray = this.WjHNUHB.extract(ndPromDirectory);
        return this.WjHNvHE(ndPromItemArray);
    }

    public NdPromEntity[] extract(NdPromItem ndPromItem) throws NdRomException {
        return this.WjHNvHE(new NdPromItem[]{ndPromItem});
    }

    protected NdPromEntity[] getEntitiesFromResultSet(String string, NdRomQueryResultSet ndRomQueryResultSet) throws NdRomException {
        NdRomQueryResultItem[] ndRomQueryResultItemArray = ndRomQueryResultSet.getResults();
        int n = ndRomQueryResultItemArray.length;
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < n; ++i) {
            int n2;
            NdPromEntity[] ndPromEntityArray;
            Object object = ndRomQueryResultItemArray[i].getResultObject();
            if (object instanceof NdPromEntity) {
                vector.addElement(object);
                continue;
            }
            if (object instanceof NdPromItem) {
                ndPromEntityArray = this.extract((NdPromItem)object);
                for (n2 = 0; n2 < ndPromEntityArray.length; ++n2) {
                    vector.addElement(ndPromEntityArray[n2]);
                }
                continue;
            }
            if (object instanceof NdPromDirectory) {
                ndPromEntityArray = this.extract((NdPromDirectory)object);
                for (n2 = 0; n2 < ndPromEntityArray.length; ++n2) {
                    vector.addElement(ndPromEntityArray[n2]);
                }
                continue;
            }
            throw new NdRomException(NdStrings.WjHNggT("ErrorQueryResultType", object, string, (class$com$blazesoft$template$repository$objects$NdPromEntity == null ? (class$com$blazesoft$template$repository$objects$NdPromEntity = NdPromDefaultEntityExtractor.class$("com.blazesoft.template.repository.objects.NdPromEntity")) : class$com$blazesoft$template$repository$objects$NdPromEntity).getName()));
        }
        Object[] objectArray = new NdPromEntity[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected NdPromEntity[] filterEntities(NdPromProject ndPromProject, NdPromEntity[] ndPromEntityArray) throws NdRomException {
        NdPromEntityFilter ndPromEntityFilter = this.getEntityFilter(ndPromProject);
        if (ndPromEntityFilter == null) {
            return ndPromEntityArray;
        }
        Vector<NdPromEntity> vector = new Vector<NdPromEntity>(ndPromEntityArray.length);
        for (int i = 0; i < ndPromEntityArray.length; ++i) {
            if (!ndPromEntityFilter.isEntityIncluded(ndPromEntityArray[i])) continue;
            vector.addElement(ndPromEntityArray[i]);
        }
        Object[] objectArray = new NdPromEntity[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private NdPromEntity[] WjHNvHE(NdPromItem[] ndPromItemArray) throws NdRomException {
        Vector vector = new Vector(ndPromItemArray.length);
        Vector<NdRomException> vector2 = new Vector<NdRomException>();
        boolean bl = NdSystemProperties.isProviderEntityExtractionDisabled();
        for (int i = 0; i < ndPromItemArray.length; ++i) {
            if (!this.isFailOnUnauthorizedContent() && !ndPromItemArray[i].isOperationAuthorized(NdRomAuthorizationRequestFactory.newPromItemContentReadRequest(ndPromItemArray[i]))) continue;
            try {
                Object[] objectArray;
                NdPromEntity ndPromEntity = null;
                int n = NdPromProjectUtil.getContentType(ndPromItemArray[i]);
                if (n == 1) {
                    if (this.WjIKIIO && (bl || !ndPromItemArray[i].isItemStorageContentLoaded())) {
                        this.WjIKIIP.addElement(ndPromItemArray[i]);
                    } else {
                        ndPromEntity = (NdPromEntity)ndPromItemArray[i].getItemContent();
                    }
                } else {
                    if (n != 3) continue;
                    try {
                        if (this.WjIKIIO && (bl || !ndPromItemArray[i].isItemStorageContentLoaded())) {
                            this.WjIKIIP.addElement(ndPromItemArray[i]);
                        } else {
                            ndPromEntity = ((NdPromInstance)ndPromItemArray[i].getItemContent()).getResolvedEntity();
                        }
                    }
                    catch (NdPromResolvedEntityException ndPromResolvedEntityException) {
                        this.processResolvedEntityException(ndPromResolvedEntityException, ndPromItemArray[i]);
                        continue;
                    }
                    if (ndPromEntity == null) continue;
                }
                if (ndPromEntity == null) continue;
                this.addFilteredEntity(ndPromEntity, vector);
                if (ndPromEntity instanceof NdPromGroup && this.WjImqSS >= 1) {
                    objectArray = ((NdPromGroup)ndPromEntity).getGroupItems();
                    this.addFilteredGroupItems((NdPromGroupItem[])objectArray, vector);
                }
                if (!(ndPromEntity instanceof NdPromSrlRuleset) || this.WjImqSS < 2) continue;
                objectArray = ((NdPromSrlRuleset)ndPromEntity).getSrlRulesetItems();
                this.addFilteredRulesetItems((NdPromSrlRulesetItem[])objectArray, vector);
                continue;
            }
            catch (NdRomException ndRomException) {
                vector2.addElement(ndRomException);
            }
        }
        Object[] objectArray = new NdPromEntity[vector.size()];
        vector.copyInto(objectArray);
        if (vector2.size() != 0) {
            throw new NdPromEntityExtractionException(ndPromItemArray, (NdPromEntity[])objectArray, vector2);
        }
        return objectArray;
    }

    protected void processResolvedEntityException(NdPromResolvedEntityException ndPromResolvedEntityException, NdPromItem ndPromItem) throws NdPromResolvedEntityException {
        if (!this.WjIKIIO) {
            throw ndPromResolvedEntityException;
        }
        this.WjIKIIP.addElement(ndPromItem);
    }

    protected void addFilteredRulesetItems(NdPromSrlRulesetItem[] ndPromSrlRulesetItemArray, Vector vector) throws NdRomException {
        for (int i = 0; i < ndPromSrlRulesetItemArray.length; ++i) {
            if (!(ndPromSrlRulesetItemArray[i] instanceof NdPromEntity)) continue;
            this.addFilteredEntity((NdPromEntity)((Object)ndPromSrlRulesetItemArray[i]), vector);
        }
    }

    protected void addFilteredGroupItems(NdPromGroupItem[] ndPromGroupItemArray, Vector vector) throws NdRomException {
        for (int i = 0; i < ndPromGroupItemArray.length; ++i) {
            NdPromGroupItem ndPromGroupItem = ndPromGroupItemArray[i];
            if (!(ndPromGroupItem instanceof NdPromEntity)) continue;
            this.addFilteredEntity((NdPromEntity)((Object)ndPromGroupItem), vector);
            if (!(ndPromGroupItem instanceof NdPromSrlRuleset) || this.WjImqSS < 2) continue;
            NdPromSrlRulesetItem[] ndPromSrlRulesetItemArray = ((NdPromSrlRuleset)ndPromGroupItem).getSrlRulesetItems();
            this.addFilteredRulesetItems(ndPromSrlRulesetItemArray, vector);
        }
    }

    protected void addFilteredEntity(NdPromEntity ndPromEntity, Vector vector) throws NdRomException {
        if (this.WjHVBFQ.isEntityIncluded(ndPromEntity)) {
            vector.addElement(ndPromEntity);
        }
    }

    public void setFilter(NdPromEntityFilter ndPromEntityFilter) {
        this.WjHVBFQ = ndPromEntityFilter;
    }

    public void resetFilter() {
        this.setFilter(this.WjHVBGR);
    }

    public void setBreadth(int n) {
        this.WjHNUHB.setBreadth(n);
    }

    public void resetBreadth() {
        this.WjHNUHB.resetBreadth();
    }

    public NdPromDefaultItemExtractor getItemExtractor() {
        return this.WjHNUHB;
    }

    public void setTraverseGroups(boolean bl) {
        if (bl) {
            this.setSearchDepth(1);
        } else {
            this.setSearchDepth(0);
        }
    }

    public void resetTraverseGroups() {
        this.resetSearchDepth();
    }

    public void setDepth(int n) {
        this.setSearchDepth(n);
    }

    public void resetDepth() {
        this.resetSearchDepth();
    }

    public void setSearchDepth(int n) {
        this.WjImqSS = n;
    }

    public void resetSearchDepth() {
        this.setSearchDepth(1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

