/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.template.repository.deploy;

import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.template.engine.NdTemplateException;
import com.blazesoft.template.engine.NdUnresolvedContentHandler;
import com.blazesoft.template.repository.NdPromEntry;
import com.blazesoft.template.repository.NdPromItem;
import com.blazesoft.template.repository.NdPromProject;
import com.blazesoft.template.repository.NdRomEntry;
import com.blazesoft.template.repository.NdRomException;
import com.blazesoft.template.repository.NdRomItem;
import com.blazesoft.template.repository.deploy.NdPromEntityFilter;
import com.blazesoft.template.repository.deploy.NdPromEntityFilterConfig;
import com.blazesoft.template.repository.deploy.NdPromItemFilter;
import com.blazesoft.template.repository.deploy.NdPromItemFilterConfig;
import com.blazesoft.template.repository.deploy.NdPromProjectFilterContext;
import com.blazesoft.template.repository.deploy.NdRomExtractor;
import com.blazesoft.template.repository.deploy.NdRomExtractorConfig;
import com.blazesoft.template.repository.deploy.NdRomExtractorConfigLoader;
import com.blazesoft.template.repository.deploy.NdStrings;
import com.blazesoft.template.repository.objects.NdPromInstance;
import com.blazesoft.template.repository.objects.xml.NdPromXmlEntity;
import com.blazesoft.template.repository.util.NdRomSchemaSupport;

public class NdRomExtractorUtil {
    public static NdRomExtractor getExtractorFromLocation(NdPromProject ndPromProject, NdLocation ndLocation) throws NdRomException {
        NdPromEntry ndPromEntry;
        NdRomExtractor ndRomExtractor = null;
        if (ndLocation != null && (ndPromEntry = ndPromProject.lookupEntryByAbsoluteLocation(ndLocation)) instanceof NdPromItem && ((NdPromItem)ndPromEntry).getItemContent() instanceof NdPromInstance) {
            NdPromInstance ndPromInstance = (NdPromInstance)((NdPromItem)ndPromEntry).getItemContent();
            ndRomExtractor = NdRomExtractorUtil.getExtractorFromInstance(ndPromProject, ndPromInstance);
        }
        return ndRomExtractor;
    }

    public static NdRomExtractor getExtractorFromInstance(NdPromProject ndPromProject, NdPromInstance ndPromInstance) throws NdRomException {
        if (ndPromInstance.getType() != 56) {
            throw new NdRomException(NdStrings.WjHNgcP("CannotGetFilterFromNonFilterInstance"));
        }
        NdRomExtractorConfig ndRomExtractorConfig = NdRomExtractorUtil.getExtractorConfigFromInstance(ndPromProject, ndPromInstance);
        NdRomExtractor ndRomExtractor = ndRomExtractorConfig.getRomExtractorFactory().newExtractor(ndRomExtractorConfig, ndPromProject.getRomConnectionContext());
        return ndRomExtractor;
    }

    public static NdRomExtractorConfig getExtractorConfigFromLocation(NdPromProject ndPromProject, NdLocation ndLocation) throws NdRomException {
        NdPromEntry ndPromEntry;
        NdRomExtractorConfig ndRomExtractorConfig = null;
        if (ndLocation != null && (ndPromEntry = ndPromProject.lookupEntryByAbsoluteLocation(ndLocation)) instanceof NdPromItem && ((NdPromItem)ndPromEntry).getItemContent() instanceof NdPromInstance) {
            NdPromInstance ndPromInstance = (NdPromInstance)((NdPromItem)ndPromEntry).getItemContent();
            ndRomExtractorConfig = NdRomExtractorUtil.getExtractorConfigFromInstance(ndPromProject, ndPromInstance);
        }
        return ndRomExtractorConfig;
    }

    public static NdRomExtractorConfig getExtractorConfigFromInstance(NdPromProject ndPromProject, NdPromInstance ndPromInstance) throws NdRomException {
        NdRomExtractorConfig ndRomExtractorConfig;
        if (ndPromInstance.getType() == 56) {
            NdPromXmlEntity ndPromXmlEntity = (NdPromXmlEntity)ndPromInstance.getResolvedEntityContent();
            try {
                String string = ndPromXmlEntity.getXmlContentSection().generate(NdUnresolvedContentHandler.IGNORE);
                ndRomExtractorConfig = NdRomExtractorConfigLoader.getDefaultRomExtractorConfigLoader().load(new StringBuffer(string));
            }
            catch (NdTemplateException ndTemplateException) {
                throw new NdRomException(NdStrings.WjHNgcP("ErrorGettingFilterContent"));
            }
        } else {
            throw new NdRomException(NdStrings.WjHNgcP("CannotGetFilterFromNonFilterInstance"));
        }
        return ndRomExtractorConfig;
    }

    public static NdPromItemFilter getItemFilterFromExtractorConfig(NdPromProject ndPromProject, NdRomExtractorConfig ndRomExtractorConfig) {
        NdPromItemFilter ndPromItemFilter = null;
        NdPromItemFilterConfig ndPromItemFilterConfig = ndRomExtractorConfig.getPromItemFilterConfig();
        if (ndPromItemFilterConfig != null && ndPromItemFilterConfig.getRomExtractorFilterFactory() != null) {
            ndPromItemFilter = (NdPromItemFilter)ndPromItemFilterConfig.getRomExtractorFilterFactory().newExtractorFilter(ndPromItemFilterConfig, new NdPromProjectFilterContext(ndPromProject, 1));
        }
        return ndPromItemFilter;
    }

    public static NdPromEntityFilter getEntityFilterFromExtractorConfig(NdPromProject ndPromProject, NdRomExtractorConfig ndRomExtractorConfig) {
        NdPromEntityFilter ndPromEntityFilter = null;
        NdPromEntityFilterConfig ndPromEntityFilterConfig = ndRomExtractorConfig.getPromEntityFilterConfig();
        if (ndPromEntityFilterConfig != null && ndPromEntityFilterConfig.getRomExtractorFilterFactory() != null) {
            ndPromEntityFilter = (NdPromEntityFilter)ndPromEntityFilterConfig.getRomExtractorFilterFactory().newExtractorFilter(ndPromEntityFilterConfig, new NdPromProjectFilterContext(ndPromProject, 0));
        }
        return ndPromEntityFilter;
    }

    public static boolean isEntryFilter(NdPromProject ndPromProject, NdRomEntry ndRomEntry) {
        boolean bl = false;
        NdRomSchemaSupport ndRomSchemaSupport = new NdRomSchemaSupport(ndPromProject.getRomConnectionContext().getSchemaManager());
        bl = ndRomEntry instanceof NdRomItem && ndRomSchemaSupport.getType((NdRomItem)ndRomEntry) == 56;
        return bl;
    }
}

