/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.template.repository.util;

import com.blazesoft.repository.base.NdRepositoryEntryAttribute;
import com.blazesoft.repository.base.NdRepositoryEntryLockInfo;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdWorkspaceDirectory;
import com.blazesoft.repository.base.NdWorkspaceEntry;
import com.blazesoft.repository.base.NdWorkspaceEntryIsDetachedException;
import com.blazesoft.repository.base.NdWorkspaceItem;
import com.blazesoft.repository.local.NdAbstractWorkspaceEntry;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.repository.naming.NdLocationFactory;
import com.blazesoft.template.engine.NdInstantiation;
import com.blazesoft.template.engine.NdInstantiationElement;
import com.blazesoft.template.engine.NdInstantiationException;
import com.blazesoft.template.engine.NdSourceInfo;
import com.blazesoft.template.engine.NdSourceInfoCollector;
import com.blazesoft.template.engine.NdStructuredInstance;
import com.blazesoft.template.engine.NdTemplateException;
import com.blazesoft.template.engine.source.NdInstantiationSourceInfo;
import com.blazesoft.template.repository.NdPromEntry;
import com.blazesoft.template.repository.NdPromItem;
import com.blazesoft.template.repository.NdPromProject;
import com.blazesoft.template.repository.NdRomEntry;
import com.blazesoft.template.repository.NdRomException;
import com.blazesoft.template.repository.objects.NdPromEntity;
import com.blazesoft.template.repository.objects.NdPromInstance;
import com.blazesoft.template.repository.objects.WjHKOpN;
import com.blazesoft.template.repository.objects.group.NdPromGroup;
import com.blazesoft.template.repository.objects.group.NdPromGroupItem;
import com.blazesoft.template.repository.util.NdStrings;
import com.blazesoft.template.repository.util.WjHUSwX;
import com.blazesoft.util.NdBaseObject;
import java.util.Vector;

public class NdPromInstanceUtil {
    public static boolean hasExternalSubInstance(NdPromInstance ndPromInstance) throws NdRomException {
        try {
            NdSourceInfo[] ndSourceInfoArray = NdSourceInfoCollector.collect(ndPromInstance);
            if (ndSourceInfoArray != null && ndSourceInfoArray.length > 0) {
                return true;
            }
        }
        catch (NdInstantiationException ndInstantiationException) {
            throw new NdRomException((Throwable)((Object)ndInstantiationException));
        }
        return false;
    }

    public static boolean isEntryExternalSubInstance(NdRomEntry ndRomEntry) throws NdRomException {
        NdRepositoryEntryAttribute[] ndRepositoryEntryAttributeArray = ndRomEntry.getEntryAttributes(new String[]{"isSeparateStoredSubInstance"});
        return ndRepositoryEntryAttributeArray != null && ndRepositoryEntryAttributeArray.length == 1 && ndRepositoryEntryAttributeArray[0] != null && Boolean.TRUE.toString().equalsIgnoreCase(ndRepositoryEntryAttributeArray[0].getAttbValue());
    }

    public static boolean isSubInstanceExternal(NdStructuredInstance ndStructuredInstance) throws NdRomException {
        try {
            return ndStructuredInstance.getSourceInfo() != null;
        }
        catch (NdTemplateException ndTemplateException) {
            throw new NdRomException((Throwable)((Object)ndTemplateException));
        }
    }

    public static NdPromEntity getResolvedEntity(NdStructuredInstance ndStructuredInstance) throws NdRomException {
        NdPromEntity ndPromEntity;
        NdInstantiation ndInstantiation = ndStructuredInstance.getInstantiation();
        if (ndInstantiation instanceof NdPromInstance && (ndPromEntity = ((NdPromInstance)ndInstantiation).getResolvedEntity()) instanceof NdPromGroup) {
            NdPromGroupItem[] ndPromGroupItemArray = ((NdPromGroup)ndPromEntity).getGroupItems();
            for (int i = 0; i < ndPromGroupItemArray.length; ++i) {
                if (WjHKOpN.WjIFFvM((NdPromEntity)((Object)ndPromGroupItemArray[i])) != ndStructuredInstance) continue;
                return (NdPromEntity)((Object)ndPromGroupItemArray[i]);
            }
        }
        return null;
    }

    public static NdPromItem lookupPromItemForSubInstance(NdStructuredInstance ndStructuredInstance) throws NdRomException {
        NdInstantiationSourceInfo ndInstantiationSourceInfo;
        NdPromInstance ndPromInstance = (NdPromInstance)ndStructuredInstance.getInstantiation();
        if (ndPromInstance == null) {
            throw new NdRomException(NdStrings.WjHNtbG("SubInstanceNotAttached", ndStructuredInstance.getDisplayPath()));
        }
        NdPromItem ndPromItem = ndPromInstance.getItem();
        if (ndPromItem == null) {
            throw new NdRomException(NdStrings.WjHNtbG("CouldNotLocateInstance", ndPromInstance.getDisplayName()));
        }
        NdPromProject ndPromProject = ndPromItem.getProject();
        try {
            ndInstantiationSourceInfo = (NdInstantiationSourceInfo)ndStructuredInstance.getSourceInfo();
        }
        catch (NdTemplateException ndTemplateException) {
            throw new NdRomException((Throwable)((Object)ndTemplateException));
        }
        if (ndInstantiationSourceInfo == null) {
            throw new NdRomException(NdStrings.WjHNtbG("SubInstanceIsNotStoredSeparately", ndStructuredInstance.getDisplayPath()));
        }
        NdLocation ndLocation = ndInstantiationSourceInfo.getRepositoryLocation();
        return (NdPromItem)ndPromProject.lookupEntryByAbsoluteLocation(ndLocation);
    }

    public static void saveSubInstance(NdStructuredInstance ndStructuredInstance) throws NdRomException {
        NdPromItem ndPromItem = NdPromInstanceUtil.lookupPromItemForSubInstance(ndStructuredInstance);
        NdPromInstance ndPromInstance = (NdPromInstance)ndPromItem.getItemContent();
        ndStructuredInstance.populateInstantiation(ndPromInstance);
        ndPromItem.save();
    }

    public static void checkInSubInstance(NdStructuredInstance ndStructuredInstance, String string) throws NdRomException {
        try {
            NdInstantiationSourceInfo ndInstantiationSourceInfo = (NdInstantiationSourceInfo)ndStructuredInstance.getSourceInfo();
            if (ndInstantiationSourceInfo != null) {
                NdPromInstanceUtil.saveSubInstance(ndStructuredInstance);
                NdPromItem ndPromItem = NdPromInstanceUtil.lookupPromItemForSubInstance(ndStructuredInstance);
                WjHUSwX.WjIdmwC(ndPromItem, string);
            }
        }
        catch (NdTemplateException ndTemplateException) {
            throw new NdRomException((Throwable)((Object)ndTemplateException));
        }
    }

    public static void checkOutSubInstance(NdStructuredInstance ndStructuredInstance) throws NdRomException {
        try {
            NdInstantiationSourceInfo ndInstantiationSourceInfo = (NdInstantiationSourceInfo)ndStructuredInstance.getSourceInfo();
            if (ndInstantiationSourceInfo != null) {
                NdPromItem ndPromItem = NdPromInstanceUtil.lookupPromItemForSubInstance(ndStructuredInstance);
                WjHUSwX.WjIdmwD(ndPromItem);
                ndStructuredInstance.loadFromSource();
            }
        }
        catch (NdTemplateException ndTemplateException) {
            throw new NdRomException((Throwable)((Object)ndTemplateException));
        }
    }

    public static void cancelCheckOutSubInstance(NdStructuredInstance ndStructuredInstance) throws NdRomException {
        try {
            NdInstantiationSourceInfo ndInstantiationSourceInfo = (NdInstantiationSourceInfo)ndStructuredInstance.getSourceInfo();
            if (ndInstantiationSourceInfo != null) {
                NdPromItem ndPromItem = NdPromInstanceUtil.lookupPromItemForSubInstance(ndStructuredInstance);
                WjHUSwX.WjIdmwE(ndPromItem);
                ndStructuredInstance.loadFromSource();
            }
        }
        catch (NdTemplateException ndTemplateException) {
            throw new NdRomException((Throwable)((Object)ndTemplateException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NdInstantiationElement getStructuredInstanceForExternalPromInstance(NdPromItem ndPromItem) {
        try {
            NdPromProject ndPromProject;
            NdPromProject ndPromProject2 = ndPromProject = ndPromItem.getProject();
            synchronized (ndPromProject2) {
                NdPromEntry ndPromEntry = NdPromInstanceUtil.getParentOfExternalInstance(ndPromItem);
                NdPromInstance ndPromInstance = (NdPromInstance)((NdPromItem)ndPromEntry).getItemContent();
                NdSourceInfo[] ndSourceInfoArray = NdSourceInfoCollector.collect(ndPromInstance);
                if (ndSourceInfoArray != null && ndSourceInfoArray.length > 0) {
                    NdLocation ndLocation = ndPromItem.getLocation();
                    for (int i = 0; i < ndSourceInfoArray.length; ++i) {
                        NdSourceInfo ndSourceInfo = ndSourceInfoArray[i];
                        NdLocation ndLocation2 = ndSourceInfo.getRepositoryLocation();
                        if (ndLocation2 == null || !ndLocation2.equals(ndLocation)) continue;
                        String string = ndSourceInfo.getPath();
                        return ndPromInstance.lookup(string);
                    }
                }
            }
        }
        catch (NdRomException ndRomException) {
        }
        catch (NdInstantiationException ndInstantiationException) {
            // empty catch block
        }
        return null;
    }

    public static String getDisplayPathForExternalPromInstance(NdPromItem ndPromItem, boolean bl) throws NdRomException {
        NdInstantiationElement ndInstantiationElement;
        String string = "";
        NdPromEntry ndPromEntry = NdPromInstanceUtil.getParentOfExternalInstance(ndPromItem);
        if (ndPromEntry != null) {
            string = string + WjHUSwX.WjIdmnR(ndPromEntry);
        }
        if ((ndInstantiationElement = NdPromInstanceUtil.getStructuredInstanceForExternalPromInstance(ndPromItem)) != null) {
            string = string + "." + ndInstantiationElement.getDisplayPath();
        }
        if (bl) {
            string = string + "/" + ndPromItem.getDisplayName();
        }
        return string;
    }

    public static NdPromEntry getParentOfExternalInstance(NdPromItem ndPromItem) throws NdRomException {
        String[] stringArray = ndPromItem.getParentDirectory().getLocation().getComponents();
        String string = stringArray[stringArray.length - 1];
        string = string.substring("__Items for__".length());
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length - 1);
        stringArray2[stringArray.length - 1] = string;
        NdLocation ndLocation = NdLocationFactory.createLocation(stringArray2, true);
        NdPromEntry ndPromEntry = ndPromItem.getProject().lookupEntryByAbsoluteLocation(ndLocation);
        return ndPromEntry;
    }

    public static NdPromItem[] getExternalInstanceItems(NdPromInstance ndPromInstance) throws NdRomException {
        Object[] objectArray;
        NdPromProject ndPromProject = ndPromInstance.getProject();
        Vector<NdPromEntry> vector = new Vector<NdPromEntry>();
        try {
            objectArray = NdSourceInfoCollector.collect(ndPromInstance);
            for (int i = 0; i < objectArray.length; ++i) {
                NdLocation ndLocation;
                if (!(objectArray[i] instanceof NdInstantiationSourceInfo) || (ndLocation = ((NdInstantiationSourceInfo)objectArray[i]).getRepositoryLocation()) == null) continue;
                vector.addElement(ndPromProject.lookupEntryByAbsoluteLocation(ndLocation));
            }
        }
        catch (NdInstantiationException ndInstantiationException) {
            throw new NdRomException((Throwable)((Object)ndInstantiationException));
        }
        objectArray = new NdPromItem[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void checkInExternalInstances(NdPromInstance ndPromInstance, String string) throws NdRomException {
        Object object;
        Vector<NdWorkspaceItem> vector = new Vector<NdWorkspaceItem>();
        NdWorkspaceDirectory ndWorkspaceDirectory = null;
        NdPromItem[] ndPromItemArray = NdPromInstanceUtil.getExternalInstanceItems(ndPromInstance);
        for (int i = 0; i < ndPromItemArray.length; ++i) {
            try {
                NdWorkspaceItem ndWorkspaceItem = (NdWorkspaceItem)ndPromItemArray[i].getWorkspaceEntry();
                object = ndWorkspaceItem.getEntryLockInfo();
                if (!NdRepositorySupport.isCheckedOutByThisUser((NdRepositoryEntryLockInfo)object)) continue;
                vector.addElement(ndWorkspaceItem);
                if (ndWorkspaceDirectory != null) continue;
                ndWorkspaceDirectory = (NdWorkspaceDirectory)ndWorkspaceItem.getContainerDirectory();
                continue;
            }
            catch (NdRepositoryException ndRepositoryException) {
                throw new NdRomException((Throwable)((Object)ndRepositoryException));
            }
        }
        Object[] objectArray = new NdWorkspaceEntry[vector.size()];
        vector.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            object = (NdAbstractWorkspaceEntry)objectArray[i];
            if (object == null) continue;
            try {
                ((NdAbstractWorkspaceEntry)object).ensureNotDetached();
                continue;
            }
            catch (NdWorkspaceEntryIsDetachedException ndWorkspaceEntryIsDetachedException) {
                throw new NdRomException((Throwable)((Object)ndWorkspaceEntryIsDetachedException));
            }
        }
        if (ndWorkspaceDirectory != null) {
            try {
                ndWorkspaceDirectory.checkIn((NdWorkspaceEntry[])objectArray, string, false, false);
            }
            catch (NdRepositoryException ndRepositoryException) {
                throw new NdRomException((Throwable)((Object)ndRepositoryException));
            }
        }
    }

    public static NdPromInstance getInstanceSection(NdPromInstance ndPromInstance, String string) throws NdRomException {
        NdPromInstance ndPromInstance2;
        if (string.equals("0") || string.equals("0")) {
            ndPromInstance2 = ndPromInstance;
        } else if (string.equals("2")) {
            ndPromInstance2 = (NdPromInstance)ndPromInstance.getInstanceManagementProperties();
        } else if (string.equals("3")) {
            ndPromInstance2 = (NdPromInstance)ndPromInstance.getItem().getEntryManagementProperties();
        } else {
            throw NdBaseObject.internalError((String)("Unexpected instance section " + string));
        }
        return ndPromInstance2;
    }
}

