/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.cfa.spatial.NdBasis;
import com.blazesoft.verifier.cfa.spatial.NdComboShape;
import com.blazesoft.verifier.cfa.spatial.NdConvexShape;
import com.blazesoft.verifier.cfa.spatial.NdDisjointShape;
import com.blazesoft.verifier.cfa.spatial.NdShape;
import com.blazesoft.verifier.cfa.spatial.NdShapeException;
import com.blazesoft.verifier.cfa.spatial.NdShapeVisitor;
import java.util.ArrayList;
import java.util.List;

public class NdArrayDisjointShape
implements NdDisjointShape {
    private final List WjIwJPC;
    private final NdBasis WjIwJQD;

    public NdArrayDisjointShape(NdBasis ndBasis) {
        NdBaseObject.advAssertNonNull((Object)ndBasis);
        this.WjIwJPC = new ArrayList();
        this.WjIwJQD = ndBasis;
    }

    public NdArrayDisjointShape(NdConvexShape ndConvexShape) {
        NdBaseObject.advAssertNonNull((Object)ndConvexShape);
        NdBaseObject.advAssert((!ndConvexShape.isEmptySet() ? 1 : 0) != 0);
        this.WjIwJPC = new ArrayList();
        this.WjIwJPC.add(ndConvexShape);
        this.WjIwJQD = ndConvexShape.getBasis();
    }

    public NdArrayDisjointShape(List list) {
        this.WjIwJPC = new ArrayList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            NdConvexShape ndConvexShape = (NdConvexShape)list.get(i);
            if (ndConvexShape.isEmptySet()) continue;
            this.WjIwJPC.add(ndConvexShape);
        }
        NdBaseObject.advAssert((this.WjIwJPC.size() > 0 ? 1 : 0) != 0);
        this.WjIwJQD = ((NdConvexShape)this.WjIwJPC.get(0)).getBasis();
    }

    public NdDisjointShape duplicate() {
        NdArrayDisjointShape ndArrayDisjointShape = this.WjIwJPC.size() > 0 ? new NdArrayDisjointShape(this.WjIwJPC) : new NdArrayDisjointShape(this.WjIwJQD);
        return ndArrayDisjointShape;
    }

    public List getDisjoints() {
        return this.WjIwJPC;
    }

    public void addDisjoint(NdConvexShape ndConvexShape) {
        NdBaseObject.advAssertNonNull((Object)ndConvexShape);
        if (!ndConvexShape.isEmptySet()) {
            this.WjIwJPC.add(ndConvexShape);
        }
    }

    public boolean isEmpty() {
        return this.WjIwJPC.size() == 0;
    }

    public boolean isUniverse() {
        return this.WjIwJPC.size() == 1 && ((NdComboShape)this.WjIwJPC.get(0)).isUniversum();
    }

    public Object accept(NdShapeVisitor ndShapeVisitor, Object object) throws NdShapeException {
        return null;
    }

    public NdBasis getBasis() {
        return this.WjIwJQD;
    }

    public NdShape[] getElements() {
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.WjIwJPC.size() == 0) {
            stringBuffer.append("no convexes");
        } else {
            int n = this.WjIwJPC.size();
            for (int i = 0; i < n; ++i) {
                NdConvexShape ndConvexShape = (NdConvexShape)this.WjIwJPC.get(i);
                stringBuffer.append(ndConvexShape.toAnalyticalString()).append("\n");
            }
        }
        return stringBuffer.toString();
    }
}

