/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial;

import com.blazesoft.test.NdAssert;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.cfa.spatial.NdBasis;
import com.blazesoft.verifier.cfa.spatial.NdBasisImpl;
import com.blazesoft.verifier.cfa.spatial.NdConvexBuilder;
import com.blazesoft.verifier.cfa.spatial.NdConvexShape;
import com.blazesoft.verifier.cfa.spatial.NdHyperCube;
import com.blazesoft.verifier.cfa.spatial.NdShape;
import com.blazesoft.verifier.cfa.spatial.NdShapeException;
import com.blazesoft.verifier.cfa.spatial.NdShapeVisitor;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntervalConstraint;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdImplicitDef;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedraException;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedron;
import com.blazesoft.verifier.predicate.NdTopLevelPredicate;
import com.blazesoft.verifier.predicate.WjIDdTC;
import java.util.ArrayList;

public class NdComboShape
implements NdConvexShape {
    private final boolean WjIwLPK;
    private final boolean WjIwLQL;
    public final NdHyperCube cube;
    public final NdPolyhedron polyhedron;
    public final NdBasis basis;
    private final NdTopLevelPredicate WjIGebT;

    private NdComboShape(boolean bl, boolean bl2, NdTopLevelPredicate ndTopLevelPredicate) {
        this.WjIwLPK = bl;
        this.WjIwLQL = bl2;
        this.basis = new NdBasisImpl(1);
        this.cube = null;
        this.polyhedron = null;
        this.WjIGebT = ndTopLevelPredicate;
    }

    private NdComboShape(NdBasis ndBasis, boolean bl, boolean bl2, NdTopLevelPredicate ndTopLevelPredicate) {
        this.WjIwLPK = bl;
        this.WjIwLQL = bl2;
        this.basis = ndBasis;
        this.cube = null;
        this.polyhedron = null;
        this.WjIGebT = ndTopLevelPredicate;
    }

    public NdComboShape(NdHyperCube ndHyperCube, NdPolyhedron ndPolyhedron) {
        this(ndHyperCube, ndPolyhedron, null);
    }

    public NdComboShape(NdHyperCube ndHyperCube, NdPolyhedron ndPolyhedron, NdTopLevelPredicate ndTopLevelPredicate) {
        NdBaseObject.advAssertNonNull((Object)ndHyperCube);
        NdBaseObject.advAssertNonNull((Object)ndPolyhedron);
        this.WjIGebT = ndTopLevelPredicate;
        this.basis = ndHyperCube.getBasis();
        NdBasisImpl.LinearBasis linearBasis = (NdBasisImpl.LinearBasis)ndPolyhedron.getBasis();
        int n = linearBasis.getDimension();
        ArrayList<NdIntervalConstraint> arrayList = new ArrayList<NdIntervalConstraint>();
        for (int i = 0; i < n; ++i) {
            WjIDdTC wjIDdTC = linearBasis.getVariable(i);
            NdIntervalConstraint ndIntervalConstraint = ndHyperCube.getConstraint(wjIDdTC);
            if (ndIntervalConstraint == null) continue;
            arrayList.add(ndIntervalConstraint);
        }
        if (arrayList.size() > 0) {
            WjIDdTC[] wjIDdTCArray = new WjIDdTC[arrayList.size()];
            for (int i = 0; i < wjIDdTCArray.length; ++i) {
                wjIDdTCArray[i] = ((NdIntervalConstraint)arrayList.get(i)).getVariable();
            }
            ndHyperCube = ndHyperCube.removeIntervals(wjIDdTCArray);
            NdImplicitDef ndImplicitDef = NdConvexBuilder.intervalsToLinearConstraints(linearBasis, arrayList);
            try {
                ndPolyhedron = ndPolyhedron.addConstraints(ndImplicitDef);
            }
            catch (NdPolyhedraException ndPolyhedraException) {
                NdAssert.fail();
            }
            this.polyhedron = ndPolyhedron;
        } else {
            this.polyhedron = (NdPolyhedron)ndPolyhedron.cloneMe();
        }
        this.cube = ndHyperCube;
        this.WjIwLPK = false;
        this.WjIwLQL = this.polyhedron.isEmptySet() && this.cube.isEmptySet();
    }

    public NdComboShape(NdHyperCube ndHyperCube) {
        this(ndHyperCube, (NdTopLevelPredicate)null);
    }

    public NdComboShape(NdHyperCube ndHyperCube, NdTopLevelPredicate ndTopLevelPredicate) {
        NdBaseObject.advAssertNonNull((Object)ndHyperCube);
        this.cube = ndHyperCube;
        this.basis = ndHyperCube.getBasis();
        this.polyhedron = null;
        this.WjIGebT = ndTopLevelPredicate;
        this.WjIwLPK = false;
        this.WjIwLQL = false;
    }

    public NdComboShape(NdPolyhedron ndPolyhedron) {
        this(ndPolyhedron, (NdTopLevelPredicate)null);
    }

    public NdComboShape(NdPolyhedron ndPolyhedron, NdTopLevelPredicate ndTopLevelPredicate) {
        NdBaseObject.advAssertNonNull((Object)ndPolyhedron);
        this.polyhedron = (NdPolyhedron)ndPolyhedron.cloneMe();
        this.basis = ndPolyhedron.getBasis().getComboBasis();
        this.cube = null;
        this.WjIGebT = ndTopLevelPredicate;
        this.WjIwLPK = false;
        this.WjIwLQL = false;
    }

    void WjIAwMM() {
        if (this.cube != null) {
            this.cube.WjIAyxB(true);
        }
        if (this.polyhedron != null) {
            this.polyhedron.setImmutable();
        }
    }

    public boolean isUniversum() {
        return this.WjIwLPK;
    }

    public boolean isEmptySet() {
        return this.WjIwLQL;
    }

    public NdTopLevelPredicate getTestCondition() {
        return this.WjIGebT;
    }

    public static NdComboShape makeEmptyShape() {
        return new NdComboShape(false, true, null);
    }

    public static NdComboShape makeEmptyShape(NdTopLevelPredicate ndTopLevelPredicate) {
        return new NdComboShape(false, true, ndTopLevelPredicate);
    }

    public static NdComboShape makeUniversum() {
        return new NdComboShape(true, false, null);
    }

    public static NdComboShape makeUniversum(NdTopLevelPredicate ndTopLevelPredicate) {
        return new NdComboShape(true, false, ndTopLevelPredicate);
    }

    public static NdComboShape makeUniversum(NdBasis ndBasis) {
        return NdComboShape.makeUniversum(ndBasis, null);
    }

    public static NdComboShape makeUniversum(NdBasis ndBasis, NdTopLevelPredicate ndTopLevelPredicate) {
        return new NdComboShape(ndBasis, true, false, ndTopLevelPredicate);
    }

    public NdConvexShape intersect(NdConvexShape ndConvexShape) throws NdShapeException {
        NdComboShape ndComboShape;
        NdComboShape ndComboShape2 = (NdComboShape)ndConvexShape;
        if (ndConvexShape.isEmptySet()) {
            ndComboShape = (NdComboShape)ndConvexShape;
        } else if (this.isEmptySet()) {
            ndComboShape = this;
        } else if (this.WjIwLPK) {
            ndComboShape = ndComboShape2;
        } else if (ndComboShape2.WjIwLPK) {
            ndComboShape = this;
        } else {
            NdHyperCube ndHyperCube = null;
            if (ndConvexShape.getBasis() != this.basis) {
                NdBaseObject.advAssert((boolean)ndConvexShape.getBasis().equals(this.basis));
            }
            if (this.cube == null) {
                if (ndComboShape2.cube != null) {
                    ndHyperCube = (NdHyperCube)ndComboShape2.cube.cloneMe();
                }
            } else {
                ndHyperCube = ndComboShape2.cube == null ? (NdHyperCube)this.cube.cloneMe() : (NdHyperCube)this.cube.intersect(ndComboShape2.cube);
            }
            NdPolyhedron ndPolyhedron = null;
            if (this.polyhedron == null) {
                if (ndComboShape2.polyhedron != null) {
                    ndPolyhedron = (NdPolyhedron)ndComboShape2.polyhedron.cloneMe();
                }
            } else {
                ndPolyhedron = ndComboShape2.polyhedron == null ? (NdPolyhedron)this.polyhedron.cloneMe() : (NdPolyhedron)this.polyhedron.intersect(ndComboShape2.polyhedron);
            }
            if (ndHyperCube == null) {
                ndComboShape = ndPolyhedron.isEmptySet() ? NdComboShape.makeEmptyShape() : new NdComboShape(ndPolyhedron);
            } else if (ndPolyhedron == null) {
                ndComboShape = ndHyperCube.isEmptySet() ? NdComboShape.makeEmptyShape() : new NdComboShape(ndHyperCube);
            } else if (ndHyperCube.isEmptySet() || ndPolyhedron.isEmptySet()) {
                ndComboShape = NdComboShape.makeEmptyShape();
            } else {
                ndComboShape = new NdComboShape(ndHyperCube, ndPolyhedron);
                if (ndComboShape.cube.isEmptySet() || ndComboShape.polyhedron.isEmptySet()) {
                    ndComboShape = NdComboShape.makeEmptyShape();
                }
            }
        }
        return ndComboShape;
    }

    public NdConvexShape transpose(NdBasis ndBasis) throws NdShapeException {
        NdAssert.fail((String)"Use spatialEngine.transpose(combo)");
        return null;
    }

    public NdConvexShape projection(WjIDdTC[] wjIDdTCArray) throws NdShapeException {
        NdComboShape ndComboShape = null;
        NdHyperCube ndHyperCube = null;
        NdPolyhedron ndPolyhedron = null;
        boolean bl = this.cube != null ? (ndHyperCube = (NdHyperCube)this.cube.projection(wjIDdTCArray)) != NdHyperCube.EMPTY_SET : false;
        boolean bl2 = this.polyhedron != null ? !(ndPolyhedron = (NdPolyhedron)this.polyhedron.projection(wjIDdTCArray)).isEmptySet() : false;
        ndComboShape = bl && bl2 ? new NdComboShape(ndHyperCube, ndPolyhedron) : (bl ? new NdComboShape(ndHyperCube) : (bl2 ? new NdComboShape(ndPolyhedron) : NdComboShape.makeEmptyShape()));
        return ndComboShape;
    }

    public Object accept(NdShapeVisitor ndShapeVisitor, Object object) throws NdShapeException {
        return ndShapeVisitor.visit(this, object);
    }

    public NdShape[] getElements() {
        boolean bl;
        int n = 0;
        boolean bl2 = bl = this.polyhedron != null && !this.polyhedron.isEmptySet() && !this.polyhedron.isUniversum();
        if (this.cube != null) {
            ++n;
        }
        if (bl) {
            ++n;
        }
        NdShape[] ndShapeArray = new NdShape[n];
        n = 0;
        if (this.cube != null) {
            ndShapeArray[n++] = this.cube;
        }
        if (bl) {
            ndShapeArray[n] = this.polyhedron;
        }
        return ndShapeArray;
    }

    public boolean isValid() {
        boolean bl = false;
        if (this.cube != null) {
            bl = this.cube.isValid();
        }
        if (this.polyhedron != null) {
            bl = this.polyhedron.isValid();
        }
        return bl;
    }

    public boolean isDegenerate() {
        return this.cube != null && this.cube.isDegenerate();
    }

    public boolean isContinuous() {
        return false;
    }

    public NdConvexShape cloneMe() {
        return this;
    }

    public String toAnalyticalString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isUniversum()) {
            stringBuffer.append("Universum");
        } else if (this.isEmptySet()) {
            stringBuffer.append("Empty");
        } else {
            if (this.cube != null && !this.cube.isDegenerate()) {
                stringBuffer.append(this.cube.toAnalyticalString());
            }
            if (this.polyhedron != null && !this.polyhedron.isUniversum() && !this.polyhedron.isEmptySet()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" and ");
                }
                if (this.cube != null) {
                    stringBuffer.append(this.polyhedron.getSortedConstraints().toAnalyticalString(((NdBasisImpl)this.basis).getLinearView()));
                } else {
                    stringBuffer.append(this.polyhedron.getSortedConstraints().toAnalyticalString(((NdBasisImpl)this.basis).getLinearView()));
                }
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toAnalyticalString();
    }

    public NdBasis getBasis() {
        return this.basis.getComboBasis();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null) {
            if (this == object) {
                bl = true;
            } else {
                NdComboShape ndComboShape = (NdComboShape)object;
                bl = this.cube == null ? ndComboShape.cube == null : this.cube.equals(ndComboShape.cube);
                if (bl) {
                    bl = this.polyhedron == null ? ndComboShape.polyhedron == null : this.polyhedron.equals(ndComboShape.polyhedron);
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        if (this.cube != null) {
            n = this.cube.hashCode();
        }
        if (this.polyhedron != null) {
            n |= this.polyhedron.hashCode();
        }
        return n;
    }
}

