/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.NdVerificationStatusMessage;
import com.blazesoft.verifier.NdVerifierCallback;
import com.blazesoft.verifier.cfa.NdBranchAnnotation;
import com.blazesoft.verifier.cfa.spatial.NdArrayDisjointShape;
import com.blazesoft.verifier.cfa.spatial.NdBasis;
import com.blazesoft.verifier.cfa.spatial.NdBasisImpl;
import com.blazesoft.verifier.cfa.spatial.NdComboShape;
import com.blazesoft.verifier.cfa.spatial.NdConvexBuilder;
import com.blazesoft.verifier.cfa.spatial.NdConvexPartitioner;
import com.blazesoft.verifier.cfa.spatial.NdConvexShape;
import com.blazesoft.verifier.cfa.spatial.NdDisjointBasesDomain;
import com.blazesoft.verifier.cfa.spatial.NdDisjointShape;
import com.blazesoft.verifier.cfa.spatial.NdDisjunct;
import com.blazesoft.verifier.cfa.spatial.NdHyperCube;
import com.blazesoft.verifier.cfa.spatial.NdOverlap;
import com.blazesoft.verifier.cfa.spatial.NdShape;
import com.blazesoft.verifier.cfa.spatial.NdShapeException;
import com.blazesoft.verifier.cfa.spatial.NdShapeVisitor;
import com.blazesoft.verifier.cfa.spatial.NdSpatialEngine;
import com.blazesoft.verifier.cfa.spatial.NdVarCollector;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntervalGrid;
import com.blazesoft.verifier.cfa.spatial.intervals.NdSingleInterval;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedron;
import com.blazesoft.verifier.normalization.NdBranchPreprocessor;
import com.blazesoft.verifier.normalization.NdFormulaNormalizerImpl;
import com.blazesoft.verifier.normalization.NdNormalizationNotSupportedException;
import com.blazesoft.verifier.predicate.NdConstantLogical;
import com.blazesoft.verifier.predicate.NdFormula;
import com.blazesoft.verifier.predicate.NdFormulaException;
import com.blazesoft.verifier.predicate.NdFormulaVisitor;
import com.blazesoft.verifier.predicate.NdNotSupportedFormulaException;
import com.blazesoft.verifier.predicate.NdOperator;
import com.blazesoft.verifier.predicate.NdRelationalPredicate;
import com.blazesoft.verifier.predicate.NdTopLevelPredicate;
import com.blazesoft.verifier.predicate.WjIDdTC;
import com.blazesoft.verifier.prom.NdPromAstNode;
import com.blazesoft.verifier.prom.NdVerificationContext;
import com.blazesoft.verifier.prom.NdVerifierAdapter;
import com.blazesoft.verifier.util.NdVerifierLog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class NdSpatialEngineImpl
implements NdSpatialEngine {
    public static final String NAME = "Spatial Engine";
    private final NdVerificationContext WjIwMpG;
    private long WjIwMqH = 1000000L;
    private NdConvexPartitioner WjIwWdN;
    private NdConvexBuilder WjIwMuL;

    public NdSpatialEngineImpl(NdVerificationContext ndVerificationContext) {
        this.WjIwMpG = ndVerificationContext;
        this.WjIwWdN = new NdConvexPartitioner(ndVerificationContext);
        this.WjIwMuL = new NdConvexBuilder(ndVerificationContext);
    }

    private void WjIwMvM(NdFormulaVisitor ndFormulaVisitor, NdShape ndShape, NdFormula ndFormula) throws NdFormulaException {
        if (ndFormula.WjICXwO()) {
            NdFormula[] ndFormulaArray = ndFormula.WjICXxP();
            for (int i = 0; i < ndFormulaArray.length; ++i) {
                this.WjIwMvM(ndFormulaVisitor, ndShape, ndFormulaArray[i]);
            }
        }
        ndFormula.WjICXvN(ndFormulaVisitor, ndShape);
    }

    private void WjIwMwN(NdShapeVisitor ndShapeVisitor, NdShape ndShape, NdShape ndShape2) throws NdShapeException {
        NdShape[] ndShapeArray = ndShape2.getElements();
        for (int i = 0; i < ndShapeArray.length; ++i) {
            this.WjIwMwN(ndShapeVisitor, ndShape, ndShapeArray[i]);
        }
        ndShape2.accept(ndShapeVisitor, ndShape);
    }

    private final boolean WjIJywX(NdVerifierCallback ndVerifierCallback) {
        boolean bl = !ndVerifierCallback.fireStatusUpdate(NdVerificationStatusMessage.makeInProgress(NdVerifierAdapter.NAME, 0.0));
        Thread.yield();
        return bl;
    }

    public NdDisjointShape createUniverseShape() {
        return new NdArrayDisjointShape(NdComboShape.makeUniversum());
    }

    public NdDisjointShape createUniverseShape(NdBasis ndBasis) {
        return new NdArrayDisjointShape(NdComboShape.makeUniversum(ndBasis));
    }

    public NdDisjointShape createEmptyShape() {
        return new NdArrayDisjointShape(NdComboShape.makeEmptyShape());
    }

    public NdDisjointBasesDomain createDisjointBaseDomain(NdBranchPreprocessor ndBranchPreprocessor, NdBranchAnnotation[] ndBranchAnnotationArray, int n, List list) {
        NdVarCollector ndVarCollector = new NdVarCollector();
        NdFormulaNormalizerImpl ndFormulaNormalizerImpl = new NdFormulaNormalizerImpl(this.WjIwMpG);
        NdDisjointBasesDomain ndDisjointBasesDomain = new NdDisjointBasesDomain();
        try {
            for (int i = 0; i < ndBranchAnnotationArray.length; ++i) {
                Iterator iterator;
                Object object;
                NdTopLevelPredicate ndTopLevelPredicate = ndBranchAnnotationArray[i].getTestCondition();
                if (ndTopLevelPredicate.WjIDeqW == NdConstantLogical.WjIDczI || ((NdPromAstNode)ndTopLevelPredicate.WjICXEW()).getId() == 20) continue;
                if (NdVerifierLog.isTraceEnabled(NAME)) {
                    NdVerifierLog.trace(NAME, "[analyzeDisjuncts: Normalization]");
                    NdVerifierLog.trace(NAME, "Test Condition " + ndTopLevelPredicate.toString() + " is normalized to:");
                }
                Object object2 = ndBranchPreprocessor == null ? ndTopLevelPredicate : ndBranchPreprocessor.preprocessBranch(ndBranchAnnotationArray[i]);
                if (ndTopLevelPredicate.WjIDeqW != NdConstantLogical.WjIDcyH && ndTopLevelPredicate.WjIDeqW != NdConstantLogical.WjIDczI) {
                    try {
                        object2 = object = (NdTopLevelPredicate)ndFormulaNormalizerImpl.toDNF((NdFormula)object2, this.WjIwMqH, true, true);
                    }
                    catch (NdNotSupportedFormulaException ndNotSupportedFormulaException) {
                        if (!NdVerifierLog.isTraceEnabled(NAME)) continue;
                        NdVerifierLog.trace(NAME, "Ignored not supported formula " + ndTopLevelPredicate);
                        continue;
                    }
                    catch (NdNormalizationNotSupportedException ndNormalizationNotSupportedException) {
                        if (NdVerifierLog.isTraceEnabled(NAME)) {
                            NdVerifierLog.trace(NAME, "Formula is too big for normalization: " + ndNormalizationNotSupportedException);
                        }
                        list.add(ndNormalizationNotSupportedException);
                        continue;
                    }
                }
                object = ((NdTopLevelPredicate)object2).WjIDeuG();
                if (NdVerifierLog.isTraceEnabled(NAME)) {
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        NdVerifierLog.trace(NAME, "        '" + iterator.next() + "'");
                    }
                }
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object object3;
                    NdFormula ndFormula = (NdFormula)iterator.next();
                    if (ndFormula != NdConstantLogical.WjIDcyH && ndFormula != NdConstantLogical.WjIDczI && ndFormula.WjICXAS()) {
                        ndFormula = new NdRelationalPredicate(this.WjIwMpG, NdOperator.WjICYSH, ndFormula, NdConstantLogical.WjIDcyH);
                    }
                    NdDisjunct ndDisjunct = new NdDisjunct(ndTopLevelPredicate, ndFormula);
                    WjIwJpM wjIwJpM = ndBranchPreprocessor != null ? ((object3 = (NdDisjointShape)ndBranchPreprocessor.getDomain()) != null ? new WjIwJpM(object3.getBasis()) : new WjIwJpM(1000)) : new WjIwJpM(1000);
                    ndVarCollector.reset();
                    this.WjIwMvM(ndVarCollector, wjIwJpM, ndFormula);
                    object3 = wjIwJpM.getBasis();
                    ndDisjointBasesDomain.addConstraint((NdBasis)object3, ndDisjunct);
                }
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdVerifierLog.logError(NAME, "Error normalization predicate " + ndFormulaException.WjICXSM() + ": " + ndFormulaException.getMessage(), (Throwable)((Object)ndFormulaException));
            if (NdVerifierLog.isTraceEnabled(NAME)) {
                ndFormulaException.printStackTrace();
            }
            NdBaseObject.advAssert((boolean)false);
        }
        return ndDisjointBasesDomain;
    }

    public NdDisjointBasesDomain createDisjointBaseDomain(NdTopLevelPredicate[] ndTopLevelPredicateArray, int n) throws NdFormulaException {
        NdVarCollector ndVarCollector = new NdVarCollector();
        NdFormulaNormalizerImpl ndFormulaNormalizerImpl = new NdFormulaNormalizerImpl(this.WjIwMpG);
        NdDisjointBasesDomain ndDisjointBasesDomain = new NdDisjointBasesDomain();
        try {
            for (int i = 0; i < ndTopLevelPredicateArray.length; ++i) {
                Iterator iterator;
                Object object;
                if (ndTopLevelPredicateArray[i].WjIDeqW == NdConstantLogical.WjIDczI) continue;
                if (NdVerifierLog.isTraceEnabled(NAME)) {
                    NdVerifierLog.trace(NAME, "[analyzeDisjuncts: Normalization]");
                    NdVerifierLog.trace(NAME, "Test Condition " + ndTopLevelPredicateArray[i].toString() + " is normalized to:");
                }
                Object object2 = ndTopLevelPredicateArray[i];
                if (ndTopLevelPredicateArray[i].WjIDeqW != NdConstantLogical.WjIDcyH && ndTopLevelPredicateArray[i].WjIDeqW != NdConstantLogical.WjIDczI) {
                    object2 = object = (NdTopLevelPredicate)ndFormulaNormalizerImpl.toDNF((NdFormula)object2, this.WjIwMqH, true, true);
                }
                object = ((NdTopLevelPredicate)object2).WjIDeuG();
                if (NdVerifierLog.isTraceEnabled(NAME)) {
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        NdVerifierLog.trace(NAME, "        '" + iterator.next() + "'");
                    }
                }
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    NdFormula ndFormula = (NdFormula)iterator.next();
                    if (ndFormula != NdConstantLogical.WjIDcyH && ndFormula != NdConstantLogical.WjIDczI && ndFormula.WjICXAS()) {
                        ndFormula = new NdRelationalPredicate(this.WjIwMpG, NdOperator.WjICYSH, ndFormula, NdConstantLogical.WjIDcyH);
                    }
                    NdDisjunct ndDisjunct = new NdDisjunct(ndTopLevelPredicateArray[i], ndFormula);
                    WjIwJpM wjIwJpM = new WjIwJpM(1000);
                    ndVarCollector.reset();
                    this.WjIwMvM(ndVarCollector, wjIwJpM, ndFormula);
                    NdBasis ndBasis = wjIwJpM.getBasis();
                    ndDisjointBasesDomain.addConstraint(ndBasis, ndDisjunct);
                }
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdVerifierLog.logError(NAME, "Error normalization predicate " + ndFormulaException.WjICXSM() + ": " + ndFormulaException.getMessage(), (Throwable)((Object)ndFormulaException));
            if (NdVerifierLog.isTraceEnabled(NAME)) {
                ndFormulaException.printStackTrace();
            }
            NdBaseObject.advAssert((boolean)false);
        }
        return ndDisjointBasesDomain;
    }

    public NdBasis createDomainBasis(NdBranchPreprocessor ndBranchPreprocessor, NdBranchAnnotation[] ndBranchAnnotationArray, int n, List list) {
        NdVarCollector ndVarCollector = new NdVarCollector();
        WjIwJpM wjIwJpM = new WjIwJpM(1000);
        try {
            for (int i = 0; i < ndBranchAnnotationArray.length; ++i) {
                NdTopLevelPredicate ndTopLevelPredicate = ndBranchAnnotationArray[i].getTestCondition();
                if (ndTopLevelPredicate.WjIDeqW == NdConstantLogical.WjIDcyH || ndTopLevelPredicate.WjIDeqW == NdConstantLogical.WjIDczI || ((NdPromAstNode)ndTopLevelPredicate.WjICXEW()).getId() == 20) continue;
                if (NdVerifierLog.isTraceEnabled(NAME)) {
                    NdVerifierLog.trace(NAME, "[analyzeDisjuncts: Normalization]");
                    NdVerifierLog.trace(NAME, "Test Condition " + ndTopLevelPredicate.toString() + " is normalized to:");
                }
                NdTopLevelPredicate ndTopLevelPredicate2 = ndBranchPreprocessor.preprocessBranch(ndBranchAnnotationArray[i]);
                ndVarCollector.reset();
                this.WjIwMvM(ndVarCollector, wjIwJpM, ndTopLevelPredicate2);
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdVerifierLog.logError(NAME, "Error normalization predicate " + ndFormulaException.WjICXSM() + ": " + ndFormulaException.getMessage(), (Throwable)((Object)ndFormulaException));
            if (NdVerifierLog.isTraceEnabled(NAME)) {
                ndFormulaException.printStackTrace();
            }
            NdBaseObject.advAssert((boolean)false);
        }
        return wjIwJpM.getBasis();
    }

    public NdBasis createDomainBasis(NdFormula[] ndFormulaArray) {
        NdVarCollector ndVarCollector = new NdVarCollector();
        WjIwJpM wjIwJpM = new WjIwJpM(1000);
        try {
            for (int i = 0; i < ndFormulaArray.length; ++i) {
                NdFormula ndFormula = ndFormulaArray[i];
                if (ndFormula == NdConstantLogical.WjIDcyH || ndFormula == NdConstantLogical.WjIDczI) continue;
                if (NdVerifierLog.isTraceEnabled(NAME)) {
                    NdVerifierLog.trace(NAME, "[analyzeDisjuncts: Normalization]");
                    NdVerifierLog.trace(NAME, "Test Condition " + ndFormula.toString() + " is normalized to:");
                }
                ndVarCollector.reset();
                this.WjIwMvM(ndVarCollector, wjIwJpM, ndFormula);
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdVerifierLog.logError(NAME, "Error normalization predicate " + ndFormulaException.WjICXSM() + ": " + ndFormulaException.getMessage(), (Throwable)((Object)ndFormulaException));
            if (NdVerifierLog.isTraceEnabled(NAME)) {
                ndFormulaException.printStackTrace();
            }
            NdBaseObject.advAssert((boolean)false);
        }
        return wjIwJpM.getBasis();
    }

    private NdDisjointShape WjIwMxO(NdBasis ndBasis) {
        NdIntervalGrid ndIntervalGrid = new NdIntervalGrid((NdBasisImpl)ndBasis);
        int n = ndBasis.getDimension();
        for (int i = 0; i < n; ++i) {
            WjIDdTC wjIDdTC = ndBasis.getVariable(i);
            ndIntervalGrid.insertUniverseInterval(wjIDdTC);
        }
        List list = ndIntervalGrid.prepareCoverages(null);
        return new NdArrayDisjointShape(list);
    }

    private NdDisjointShape WjILkMZ(NdDisjointBasesDomain ndDisjointBasesDomain, List list, List list2) throws NdFormulaException {
        NdArrayDisjointShape ndArrayDisjointShape;
        if (ndDisjointBasesDomain.basisIterator().hasNext()) {
            NdBasisImpl ndBasisImpl = (NdBasisImpl)ndDisjointBasesDomain.basisIterator().next();
            Set set = ndDisjointBasesDomain.getAllTestPredicates();
            if (set.size() > 0) {
                ArrayList<NdConvexShape> arrayList = new ArrayList<NdConvexShape>();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    NdTopLevelPredicate ndTopLevelPredicate = (NdTopLevelPredicate)iterator.next();
                    List list3 = ndDisjointBasesDomain.getDisjunctsByTestPredicate(ndTopLevelPredicate);
                    int n = 0;
                    int n2 = list3.size();
                    for (int i = 0; i < n2; ++i) {
                        NdConvexShape ndConvexShape;
                        NdDisjunct ndDisjunct = (NdDisjunct)list3.get(i);
                        if (ndDisjunct.disjunct == NdConstantLogical.WjIDcyH) {
                            ndConvexShape = NdComboShape.makeUniversum(ndBasisImpl, ndDisjunct.testCondition);
                            arrayList.add(ndConvexShape);
                        } else if (ndDisjunct.disjunct == NdConstantLogical.WjIDczI) {
                            if (list2 != null) {
                                list2.add(ndDisjunct.testCondition);
                            }
                        } else {
                            ndConvexShape = this.createConvexShape(ndBasisImpl, ndDisjunct.disjunct, ndDisjunct.testCondition);
                            if (ndConvexShape.isEmptySet()) {
                                ++n;
                            } else {
                                arrayList.add(ndConvexShape);
                            }
                        }
                        if (n != list3.size()) continue;
                        if (list != null) {
                            list.add(ndTopLevelPredicate);
                            continue;
                        }
                        throw new NdFormulaException(ndTopLevelPredicate, ndTopLevelPredicate.WjIDeqW, "SelfContradictingTestConditionMessage");
                    }
                }
                ndArrayDisjointShape = arrayList.size() > 0 ? new NdArrayDisjointShape(arrayList) : new NdArrayDisjointShape(ndBasisImpl);
            } else {
                ndArrayDisjointShape = new NdArrayDisjointShape(ndBasisImpl);
            }
        } else {
            ndArrayDisjointShape = null;
        }
        return ndArrayDisjointShape;
    }

    public NdDisjointShape createDisjointShape(NdBranchPreprocessor ndBranchPreprocessor, NdBranchAnnotation[] ndBranchAnnotationArray, List list, List list2, int n) throws NdFormulaException {
        NdDisjointShape ndDisjointShape;
        if (ndBranchAnnotationArray.length == 1 && ndBranchAnnotationArray[0].getTestCondition().WjIDeqW == NdConstantLogical.WjIDcyH) {
            ndDisjointShape = this.createUniverseShape();
        } else {
            ArrayList arrayList = new ArrayList();
            NdDisjointBasesDomain ndDisjointBasesDomain = this.createDisjointBaseDomain(ndBranchPreprocessor, ndBranchAnnotationArray, n, arrayList);
            if (arrayList.size() > 0) {
                throw (NdFormulaException)arrayList.get(0);
            }
            ndDisjointShape = this.WjILkMZ(ndDisjointBasesDomain, list, list2);
        }
        return ndDisjointShape;
    }

    public NdDisjointShape createDisjointShape(NdTopLevelPredicate[] ndTopLevelPredicateArray, int n) throws NdFormulaException {
        NdDisjointShape ndDisjointShape;
        if (ndTopLevelPredicateArray.length == 1 && ndTopLevelPredicateArray[0].WjIDeqW == NdConstantLogical.WjIDcyH) {
            ndDisjointShape = this.createUniverseShape();
        } else {
            ArrayList arrayList = new ArrayList();
            NdDisjointBasesDomain ndDisjointBasesDomain = this.createDisjointBaseDomain(ndTopLevelPredicateArray, n);
            if (arrayList.size() > 0) {
                throw (NdFormulaException)arrayList.get(0);
            }
            ndDisjointShape = this.WjILkMZ(ndDisjointBasesDomain, null, null);
        }
        return ndDisjointShape;
    }

    public NdDisjunct intersection(NdBasis ndBasis, NdDisjunct ndDisjunct, NdDisjunct ndDisjunct2) throws NdFormulaException {
        NdBaseObject.advAssertNonNull((Object)ndDisjunct);
        NdBaseObject.advAssertNonNull((Object)ndDisjunct2);
        NdBaseObject.advAssertNonNull((Object)ndDisjunct.convex);
        NdBaseObject.advAssertNonNull((Object)ndDisjunct2.convex);
        try {
            NdConvexShape ndConvexShape = ndDisjunct.convex.intersect(ndDisjunct2.convex);
            return new NdDisjunct(ndConvexShape);
        }
        catch (NdShapeException ndShapeException) {
            throw new NdFormulaException("IntersectionError", ndDisjunct.toString(), (Throwable)((Object)ndShapeException));
        }
    }

    public NdDisjointShape intersection(NdBasis ndBasis, NdDisjointShape ndDisjointShape, NdConvexShape ndConvexShape) throws NdFormulaException {
        try {
            NdDisjointShape ndDisjointShape2;
            if (ndDisjointShape.isEmpty()) {
                ndDisjointShape2 = ndDisjointShape;
            } else {
                ndDisjointShape2 = ndDisjointShape.duplicate();
                List list = ndDisjointShape2.getDisjoints();
                for (int i = list.size() - 1; i >= 0; --i) {
                    NdConvexShape ndConvexShape2 = ((NdConvexShape)list.get(i)).intersect(ndConvexShape);
                    if (ndConvexShape2.isEmptySet()) {
                        list.remove(i);
                        continue;
                    }
                    list.set(i, ndConvexShape2);
                }
            }
            return ndDisjointShape2;
        }
        catch (NdShapeException ndShapeException) {
            throw new NdFormulaException("IntersectionError", ndDisjointShape.toString(), (Throwable)((Object)ndShapeException));
        }
    }

    public NdConvexShape transpose(NdBasis ndBasis, NdConvexShape ndConvexShape) throws NdFormulaException {
        try {
            if (ndConvexShape instanceof NdComboShape) {
                return this.transposeCombo(ndBasis, (NdComboShape)ndConvexShape);
            }
            return ndConvexShape.transpose(ndBasis);
        }
        catch (NdShapeException ndShapeException) {
            throw new NdFormulaException("TranspositionError", ndConvexShape.toString(), (Throwable)((Object)ndShapeException));
        }
    }

    public NdConvexShape transposeCombo(NdBasis ndBasis, NdComboShape ndComboShape) throws NdFormulaException {
        try {
            Object object;
            NdHyperCube ndHyperCube = null;
            NdPolyhedron ndPolyhedron = null;
            if (ndComboShape.cube != null) {
                if (((NdBasisImpl)ndBasis).getLinearView().getDimension() > 0) {
                    ndHyperCube = new NdHyperCube(ndBasis);
                    object = ((NdBasisImpl)ndBasis).getLinearView();
                    int n = ((NdBasisImpl.LinearBasis)object).getDimension();
                    for (int i = 0; i < n; ++i) {
                        WjIDdTC wjIDdTC = ((NdBasisImpl.LinearBasis)object).getVariable(i);
                        NdSingleInterval ndSingleInterval = ndComboShape.cube.getInterval(wjIDdTC.WjIDbnY());
                        if (ndSingleInterval == null) continue;
                        if (((NdBasisImpl.LinearBasis)object).getVariable(i) != null) {
                            if (ndPolyhedron == null) {
                                ndPolyhedron = NdPolyhedron.makePolyhedron((NdBasis)object, this.WjIwMuL.toLinearConstraints((NdBasisImpl.LinearBasis)object, wjIDdTC, ndSingleInterval));
                                continue;
                            }
                            ndPolyhedron.addConstraints(this.WjIwMuL.toLinearConstraints((NdBasisImpl.LinearBasis)object, wjIDdTC, ndSingleInterval));
                            continue;
                        }
                        ndHyperCube.putInterval(wjIDdTC.WjIDbnY(), ndSingleInterval);
                    }
                } else {
                    ndHyperCube = (NdHyperCube)ndComboShape.cube.transpose(ndBasis);
                }
            }
            if (ndComboShape.polyhedron != null) {
                ndPolyhedron = (NdPolyhedron)ndComboShape.polyhedron.transpose(ndBasis);
            }
            object = ndHyperCube != null && ndPolyhedron != null ? new NdComboShape(ndHyperCube, ndPolyhedron) : (ndHyperCube != null ? new NdComboShape(ndHyperCube) : new NdComboShape(ndPolyhedron));
            return object;
        }
        catch (NdShapeException ndShapeException) {
            throw new NdFormulaException("TranspositionError", ndComboShape.toString(), (Throwable)((Object)ndShapeException));
        }
    }

    public NdDisjointShape transpose(NdBasis ndBasis, NdDisjointShape ndDisjointShape) throws NdFormulaException {
        NdArrayDisjointShape ndArrayDisjointShape = new NdArrayDisjointShape(ndBasis);
        List list = ndDisjointShape.getDisjoints();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ndArrayDisjointShape.addDisjoint(this.transposeCombo(ndBasis, (NdComboShape)list.get(i)));
        }
        return ndArrayDisjointShape;
    }

    public NdDisjointShape intersection(NdBasis ndBasis, NdDisjointShape ndDisjointShape, NdDisjointShape ndDisjointShape2) throws NdFormulaException {
        NdDisjointShape ndDisjointShape3;
        if (ndDisjointShape.isEmpty() || ndDisjointShape2.isUniverse()) {
            ndDisjointShape3 = ndDisjointShape;
        } else if (ndDisjointShape2.isEmpty() || ndDisjointShape.isUniverse()) {
            ndDisjointShape3 = ndDisjointShape2;
        }
        List list = ndDisjointShape.getDisjoints();
        List list2 = ndDisjointShape2.getDisjoints();
        ArrayList<NdConvexShape> arrayList = new ArrayList<NdConvexShape>();
        ArrayList<NdConvexShape> arrayList2 = new ArrayList<NdConvexShape>();
        arrayList2.addAll(list);
        int n = list2.size();
        try {
            block2: while (!arrayList2.isEmpty()) {
                NdConvexShape ndConvexShape = (NdConvexShape)arrayList2.remove(0);
                for (int i = 0; i < n; ++i) {
                    NdConvexShape ndConvexShape2 = ndConvexShape.intersect((NdConvexShape)list2.get(i));
                    if (!ndConvexShape2.equals(ndConvexShape)) {
                        if (ndConvexShape2.isEmptySet()) continue;
                        arrayList2.add(ndConvexShape2);
                        continue;
                    }
                    arrayList.add(ndConvexShape2);
                    continue block2;
                }
            }
            ndDisjointShape3 = arrayList.size() > 0 ? new NdArrayDisjointShape(arrayList) : new NdArrayDisjointShape(ndBasis);
            return ndDisjointShape3;
        }
        catch (NdShapeException ndShapeException) {
            throw new NdFormulaException("IntersectionError", ndDisjointShape.toString(), (Throwable)((Object)ndShapeException));
        }
    }

    void WjIJyxY(NdBasis ndBasis, List list, NdVerifierCallback ndVerifierCallback) throws NdFormulaException {
        LinkedList linkedList = new LinkedList();
        HashSet<NdConvexShape> hashSet = new HashSet<NdConvexShape>();
        linkedList.addAll(list);
        list.clear();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        block0: while (!linkedList.isEmpty()) {
            NdConvexShape ndConvexShape = (NdConvexShape)linkedList.removeFirst();
            boolean bl = false;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                NdConvexShape ndConvexShape2 = (NdConvexShape)iterator.next();
                this.partition(ndBasis, ndConvexShape, ndConvexShape2, arrayList, ndVerifierCallback);
                if (arrayList.size() > 0) {
                    linkedList.addAll(arrayList);
                    arrayList.clear();
                    bl = true;
                    break;
                }
                if (n > 0 && n % 10000 == 0 && this.WjIJywX(ndVerifierCallback)) break block0;
                ++n;
            }
            if (bl) continue;
            hashSet.add(ndConvexShape);
        }
        list.addAll(hashSet);
    }

    public NdOverlap partition(NdBasis ndBasis, NdConvexShape ndConvexShape, NdConvexShape ndConvexShape2, List list, boolean bl, NdVerifierCallback ndVerifierCallback) throws NdFormulaException {
        return this.partition(ndBasis, ndConvexShape, ndConvexShape2, list, false, bl, ndVerifierCallback);
    }

    public NdOverlap partition(NdBasis ndBasis, NdConvexShape ndConvexShape, NdConvexShape ndConvexShape2, List list, boolean bl, boolean bl2, NdVerifierCallback ndVerifierCallback) throws NdFormulaException {
        if (!ndConvexShape2.isUniversum()) {
            try {
                this.WjIwMwN(this.WjIwWdN, ndConvexShape, ndConvexShape2);
                NdOverlap ndOverlap = this.WjIwWdN.isOverlapped();
                List list2 = this.WjIwWdN.getChunks();
                if (bl2) {
                    this.WjIJyxY(ndBasis, list2, ndVerifierCallback);
                }
                if (bl) {
                    int n = list2.size();
                    for (int i = 0; i < n; ++i) {
                        NdConvexShape ndConvexShape3 = (NdConvexShape)list2.get(i);
                        if (ndConvexShape3.equals(ndConvexShape2)) continue;
                        list.add(ndConvexShape3);
                    }
                } else {
                    list.addAll(list2);
                }
                if (ndOverlap == NdOverlap.COMPLETE && list.size() > 0) {
                    ndOverlap = NdOverlap.PARTIAL;
                }
                this.WjIwWdN.WjIwWOF();
                return ndOverlap;
            }
            catch (NdShapeException ndShapeException) {
                ndShapeException.printStackTrace();
                return null;
            }
        }
        NdOverlap ndOverlap = NdOverlap.COMPLETE;
        return ndOverlap;
    }

    public NdOverlap partition(NdBasis ndBasis, NdConvexShape ndConvexShape, NdConvexShape ndConvexShape2, List list, NdVerifierCallback ndVerifierCallback) throws NdFormulaException {
        return this.partition(ndBasis, ndConvexShape, ndConvexShape2, list, false, ndVerifierCallback);
    }

    public NdOverlap difference(NdBasis ndBasis, NdConvexShape ndConvexShape, NdConvexShape ndConvexShape2, List list, NdVerifierCallback ndVerifierCallback) throws NdFormulaException {
        return this.partition(ndBasis, ndConvexShape, ndConvexShape2, list, true, true, ndVerifierCallback);
    }

    public NdDisjointShape difference(NdBasis ndBasis, NdDisjointShape ndDisjointShape, NdDisjointShape ndDisjointShape2, NdVerifierCallback ndVerifierCallback) throws NdFormulaException {
        NdDisjointShape ndDisjointShape3;
        if (ndDisjointShape2.isEmpty()) {
            ndDisjointShape3 = ndDisjointShape;
        } else if (ndDisjointShape2.isUniverse()) {
            ndDisjointShape3 = new NdArrayDisjointShape(ndBasis);
        } else {
            if (!(ndDisjointShape != null && !ndDisjointShape.isUniverse() || ndDisjointShape != null && ndDisjointShape.getBasis() == ndBasis)) {
                ndDisjointShape = this.WjIwMxO(ndBasis);
            }
            List list = ndDisjointShape.getDisjoints();
            List list2 = ndDisjointShape2.getDisjoints();
            int n = list2.size();
            ArrayList arrayList = new ArrayList();
            ArrayList<NdConvexShape> arrayList2 = new ArrayList<NdConvexShape>();
            arrayList.addAll(list);
            ArrayList arrayList3 = new ArrayList();
            block0: while (!arrayList.isEmpty()) {
                NdConvexShape ndConvexShape = (NdConvexShape)arrayList.remove(0);
                boolean bl = false;
                for (int i = 0; i < n; ++i) {
                    NdOverlap ndOverlap = this.difference(ndBasis, ndConvexShape, (NdConvexShape)list2.get(i), arrayList3, ndVerifierCallback);
                    if (this.WjIJywX(ndVerifierCallback)) break block0;
                    if (ndOverlap == NdOverlap.PARTIAL) {
                        bl = true;
                        arrayList.addAll(arrayList3);
                        arrayList3.clear();
                        break;
                    }
                    if (ndOverlap == NdOverlap.COMPLETE) {
                        bl = true;
                        break;
                    }
                    if (arrayList3.size() > 0) {
                        bl = true;
                        arrayList.addAll(arrayList3);
                    }
                    arrayList3.clear();
                }
                if (bl) continue;
                arrayList2.add(ndConvexShape);
            }
            ndDisjointShape3 = arrayList2.size() > 0 ? new NdArrayDisjointShape(arrayList2) : new NdArrayDisjointShape(ndBasis);
        }
        return ndDisjointShape3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdConvexShape createConvexShape(NdBasis ndBasis, NdFormula ndFormula) throws NdFormulaException {
        try {
            NdComboShape ndComboShape;
            if (ndFormula == NdConstantLogical.WjIDcyH) {
                ndComboShape = NdComboShape.makeUniversum();
            } else {
                this.WjIwMvM(this.WjIwMuL, new WjIwJpM(ndBasis), ndFormula);
                ndComboShape = this.WjIwMuL.getConvex(ndFormula, ndBasis);
                ndComboShape.WjIAwMM();
            }
            NdComboShape ndComboShape2 = ndComboShape;
            return ndComboShape2;
        }
        finally {
            this.WjIwMuL.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdConvexShape createConvexShape(NdBasis ndBasis, NdFormula ndFormula, NdTopLevelPredicate ndTopLevelPredicate) throws NdFormulaException {
        try {
            this.WjIwMvM(this.WjIwMuL, new WjIwJpM(ndBasis), ndFormula);
            NdComboShape ndComboShape = this.WjIwMuL.getConvex(ndFormula, ndBasis, ndTopLevelPredicate);
            ndComboShape.WjIAwMM();
            NdComboShape ndComboShape2 = ndComboShape;
            return ndComboShape2;
        }
        finally {
            this.WjIwMuL.clear();
        }
    }

    public NdConvexShape projection(NdConvexShape ndConvexShape, WjIDdTC wjIDdTC) throws NdFormulaException {
        try {
            return ndConvexShape.projection(new WjIDdTC[]{wjIDdTC});
        }
        catch (NdShapeException ndShapeException) {
            throw new NdFormulaException("ProjectionError", ndConvexShape.toAnalyticalString(), (Throwable)((Object)ndShapeException));
        }
    }

    public NdDisjointShape projection(NdDisjointShape ndDisjointShape, WjIDdTC[] wjIDdTCArray) throws NdFormulaException {
        try {
            NdDisjointShape ndDisjointShape2;
            if (ndDisjointShape.isEmpty()) {
                ndDisjointShape2 = ndDisjointShape;
            } else {
                ndDisjointShape2 = ndDisjointShape.duplicate();
                List list = ndDisjointShape2.getDisjoints();
                for (int i = list.size() - 1; i >= 0; --i) {
                    NdConvexShape ndConvexShape = ((NdConvexShape)list.get(i)).projection(wjIDdTCArray);
                    if (ndConvexShape.isEmptySet()) {
                        list.remove(i);
                        continue;
                    }
                    list.set(i, ndConvexShape);
                }
            }
            return ndDisjointShape2;
        }
        catch (NdShapeException ndShapeException) {
            throw new NdFormulaException("ProjectionError", ndDisjointShape.toString(), (Throwable)((Object)ndShapeException));
        }
    }

    public NdDisjointShape projection(NdDisjointShape ndDisjointShape, WjIDdTC wjIDdTC) throws NdFormulaException {
        try {
            NdDisjointShape ndDisjointShape2;
            if (ndDisjointShape.isEmpty()) {
                ndDisjointShape2 = ndDisjointShape;
            } else {
                ndDisjointShape2 = ndDisjointShape.duplicate();
                List list = ndDisjointShape2.getDisjoints();
                for (int i = list.size() - 1; i >= 0; --i) {
                    NdConvexShape ndConvexShape = ((NdConvexShape)list.get(i)).projection(new WjIDdTC[]{wjIDdTC});
                    if (ndConvexShape.isEmptySet()) {
                        list.remove(i);
                        continue;
                    }
                    list.set(i, ndConvexShape);
                }
            }
            return ndDisjointShape2;
        }
        catch (NdShapeException ndShapeException) {
            throw new NdFormulaException("ProjectionError", ndDisjointShape.toString(), (Throwable)((Object)ndShapeException));
        }
    }

    private static class WjIwJpM
    implements NdShape {
        final NdBasis WjIwJoL;

        public WjIwJpM(int n) {
            this.WjIwJoL = new NdBasisImpl(n);
        }

        public WjIwJpM(NdBasis ndBasis) {
            this.WjIwJoL = ndBasis;
        }

        public NdBasis getBasis() {
            return this.WjIwJoL;
        }

        public Object accept(NdShapeVisitor ndShapeVisitor, Object object) throws NdShapeException {
            return null;
        }

        public NdShape[] getElements() {
            return null;
        }
    }
}

