/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.formula;

import com.blazesoft.objects.java.NdDuration;
import com.blazesoft.objects.java.NdInvalidDurationException;
import com.blazesoft.test.NdAssert;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.NdVerificationException;
import com.blazesoft.verifier.NdVerificationStaticContextImpl;
import com.blazesoft.verifier.cfa.spatial.NdComboShape;
import com.blazesoft.verifier.cfa.spatial.NdConvexShape;
import com.blazesoft.verifier.cfa.spatial.NdHyperCube;
import com.blazesoft.verifier.cfa.spatial.NdShape;
import com.blazesoft.verifier.cfa.spatial.NdShapeException;
import com.blazesoft.verifier.cfa.spatial.NdShapeVisitor;
import com.blazesoft.verifier.cfa.spatial.intervals.NdBooleanInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdDateInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdDurationInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntegerInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdMoneyInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdRealInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdReferenceTypeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdStringInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdTimeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdTimeStampInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableBooleanInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableDateInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableDurationInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableEnumeratedTypeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableIntegerInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableMoneyInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableRealInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableReferenceTypeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableStringInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableTimeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableTimeStampInterval;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedralConstraint;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedron;
import com.blazesoft.verifier.predicate.NdAbstractFormula;
import com.blazesoft.verifier.predicate.NdArithmeticalAddFormula;
import com.blazesoft.verifier.predicate.NdArithmeticalMinusFormula;
import com.blazesoft.verifier.predicate.NdArithmeticalMulFormula;
import com.blazesoft.verifier.predicate.NdBinaryFormula;
import com.blazesoft.verifier.predicate.NdConstantDate;
import com.blazesoft.verifier.predicate.NdConstantDuration;
import com.blazesoft.verifier.predicate.NdConstantEnumeratedItem;
import com.blazesoft.verifier.predicate.NdConstantInteger;
import com.blazesoft.verifier.predicate.NdConstantLogical;
import com.blazesoft.verifier.predicate.NdConstantMoney;
import com.blazesoft.verifier.predicate.NdConstantNull;
import com.blazesoft.verifier.predicate.NdConstantReal;
import com.blazesoft.verifier.predicate.NdConstantString;
import com.blazesoft.verifier.predicate.NdConstantTerm;
import com.blazesoft.verifier.predicate.NdConstantTime;
import com.blazesoft.verifier.predicate.NdConstantTimeStamp;
import com.blazesoft.verifier.predicate.NdFormula;
import com.blazesoft.verifier.predicate.NdFormulaException;
import com.blazesoft.verifier.predicate.NdLogicalAndFormula;
import com.blazesoft.verifier.predicate.NdLogicalOrFormula;
import com.blazesoft.verifier.predicate.NdOperator;
import com.blazesoft.verifier.predicate.NdRelationalPredicate;
import com.blazesoft.verifier.predicate.NdTimeConstraintBinaryFormula;
import com.blazesoft.verifier.predicate.NdTimeConstraintTernaryFormula;
import com.blazesoft.verifier.predicate.NdTimeConstraintVariable;
import com.blazesoft.verifier.predicate.NdTopLevelPredicate;
import com.blazesoft.verifier.predicate.WjIDdTC;
import com.blazesoft.verifier.prom.NdVerificationContext;
import com.blazesoft.verifier.type.NdModelEnumeratedItemType;
import com.blazesoft.verifier.type.NdModelType;
import java.util.ArrayList;
import java.util.Collections;

public class NdFormulaGenerator
implements NdShapeVisitor {
    private static final NdDuration WjIBrbE = new NdDuration(NdVerificationStaticContextImpl.getInstance().getCalendar(), 5, 1L);
    private static final NdDuration WjIBrbF = new NdDuration(NdVerificationStaticContextImpl.getInstance().getCalendar(), 13, 1L);
    private final NdVerificationContext WjIwKMJ;
    private boolean WjIGgyO;

    public NdFormulaGenerator(NdVerificationContext ndVerificationContext) {
        this.WjIwKMJ = ndVerificationContext;
        this.WjIGgyO = true;
    }

    private NdFormula WjIwKNK(NdShape ndShape) throws NdShapeException {
        NdShape[] ndShapeArray = ndShape.getElements();
        NdFormula[] ndFormulaArray = new NdFormula[ndShapeArray.length];
        for (int i = 0; i < ndShapeArray.length; ++i) {
            ndFormulaArray[i] = this.WjIwKNK(ndShapeArray[i]);
        }
        return (NdFormula)ndShape.accept(this, ndFormulaArray);
    }

    public NdFormula generate(NdConvexShape ndConvexShape, boolean bl, boolean bl2, boolean bl3) {
        try {
            NdFormula ndFormula = ndConvexShape.isUniversum() ? NdConstantLogical.WjIDcyH : this.WjIwKNK(ndConvexShape);
            if (bl) {
                ndFormula = new NdTopLevelPredicate(ndFormula);
            }
            return ndFormula;
        }
        catch (NdShapeException ndShapeException) {
            NdBaseObject.advAssert((boolean)false);
            return null;
        }
    }

    public NdFormula generate(NdConvexShape ndConvexShape, boolean bl) {
        return this.generate(ndConvexShape, false, bl, true);
    }

    private NdFormula WjIwKOL(NdFormula[] ndFormulaArray) {
        NdFormula ndFormula = null;
        if (ndFormulaArray.length == 1) {
            ndFormula = ndFormulaArray[0];
        } else {
            int n;
            boolean bl = false;
            ArrayList<NdFormula> arrayList = new ArrayList<NdFormula>();
            for (n = 0; n < ndFormulaArray.length; ++n) {
                if (ndFormulaArray[n] == null) {
                    bl = true;
                    continue;
                }
                arrayList.add(ndFormulaArray[n]);
            }
            if (!bl) {
                Collections.sort(arrayList);
                n = arrayList.size() - 1;
                NdFormula ndFormula2 = (NdFormula)arrayList.get(n--);
                NdFormula ndFormula3 = (NdFormula)arrayList.get(n--);
                ndFormula = new NdLogicalAndFormula(this.WjIwKMJ, ndFormula3, ndFormula2);
                while (n >= 0) {
                    NdFormula ndFormula4;
                    if ((ndFormula4 = (NdFormula)arrayList.get(n--)) == null) {
                        ndFormula = null;
                        break;
                    }
                    ndFormula = new NdLogicalAndFormula(this.WjIwKMJ, ndFormula4, ndFormula);
                }
            }
        }
        return ndFormula;
    }

    public Object visit(NdComboShape ndComboShape, Object object) {
        NdFormula[] ndFormulaArray = (NdFormula[])object;
        NdBaseObject.advAssert((ndFormulaArray.length == 1 || ndFormulaArray.length == 2 ? 1 : 0) != 0);
        return this.WjIwKOL((NdFormula[])object);
    }

    public Object visit(NdHyperCube ndHyperCube, Object object) {
        return this.WjIwKOL((NdFormula[])object);
    }

    public Object visit(NdPolyhedron ndPolyhedron, Object object) {
        return this.WjIwKOL((NdFormula[])object);
    }

    private NdConstantTerm WjIwKPM(NdVerificationContext ndVerificationContext, NdModelType ndModelType, double d) {
        NdConstantTerm ndConstantTerm;
        if (ndModelType == NdConstantReal.WjIDgkX) {
            ndConstantTerm = new NdConstantReal(d);
        } else if (ndModelType == NdConstantInteger.WjICYZG) {
            ndConstantTerm = (double)((long)d) == d ? new NdConstantInteger((long)d) : new NdConstantReal(d);
        } else if (ndModelType == NdConstantMoney.WjIDgFP) {
            ndConstantTerm = new NdConstantMoney(ndVerificationContext.getCurrencyManager().getDefaultMappingCurrency().amount(d));
        } else if (ndModelType == NdConstantDuration.WjIDgSE) {
            ndConstantTerm = new NdConstantDuration((long)d);
        } else if (ndModelType == NdConstantTimeStamp.WjIDiZZ) {
            ndConstantTerm = NdConstantTimeStamp.WjIDjgG((long)d);
        } else if (ndModelType == NdConstantTime.WjIDihH) {
            ndConstantTerm = NdConstantTime.WjIDihO((long)d);
        } else if (ndModelType == NdConstantDate.WjIDiPY) {
            ndConstantTerm = NdConstantDate.WjIDiWG((long)d);
        } else {
            NdBaseObject.advAssert((boolean)false);
            ndConstantTerm = null;
        }
        return ndConstantTerm;
    }

    private NdConstantTerm WjIDmGQ(NdVerificationContext ndVerificationContext, NdModelType ndModelType, double d) {
        NdConstantTerm ndConstantTerm = ndModelType == NdConstantInteger.WjICYZG ? ((double)((long)d) == d ? new NdConstantInteger((long)d) : new NdConstantReal(d)) : new NdConstantReal(d);
        return ndConstantTerm;
    }

    private NdFormula WjIBrbG(WjIDdTC wjIDdTC, NdTimeInterval ndTimeInterval) throws NdFormulaException {
        NdConstantTime ndConstantTime = ndTimeInterval.getLeftBound();
        boolean bl = ndTimeInterval.isLeftOpen();
        NdConstantTime ndConstantTime2 = ndTimeInterval.getRightBound();
        boolean bl2 = ndTimeInterval.isRightOpen();
        try {
            if (bl && !ndTimeInterval.isLeftInfinite()) {
                ndConstantTime = new NdConstantTime(ndConstantTime.WjIDihQ().add(WjIBrbF));
            }
            if (bl2 && !ndTimeInterval.isRightInfinite()) {
                ndConstantTime2 = new NdConstantTime(ndConstantTime2.WjIDihQ().subtract(WjIBrbF));
            }
        }
        catch (NdInvalidDurationException ndInvalidDurationException) {
            NdAssert.fail((String)("Error building effective time constraint expression:" + ndInvalidDurationException.getMessage()));
        }
        NdAbstractFormula ndAbstractFormula = ndTimeInterval.isLeftMin() || ndTimeInterval.isLeftInfinite() ? new NdTimeConstraintBinaryFormula(this.WjIwKMJ, NdOperator.WjICYSG, (WjIDdTC)NdTimeConstraintVariable.WjIDfHT, ndConstantTime2) : (ndTimeInterval.isRightMax() || ndTimeInterval.isRightInfinite() ? new NdTimeConstraintBinaryFormula(this.WjIwKMJ, NdOperator.WjICYSF, (WjIDdTC)NdTimeConstraintVariable.WjIDfHT, ndConstantTime) : (ndConstantTime == ndConstantTime2 ? new NdTimeConstraintTernaryFormula(this.WjIwKMJ, wjIDdTC, ndConstantTime, ndConstantTime2) : new NdTimeConstraintTernaryFormula(this.WjIwKMJ, wjIDdTC, ndConstantTime, ndConstantTime2)));
        return ndAbstractFormula;
    }

    private NdFormula WjIBrbH(WjIDdTC wjIDdTC, NdDateInterval ndDateInterval) throws NdFormulaException {
        NdConstantDate ndConstantDate = ndDateInterval.getLeftBound();
        boolean bl = ndDateInterval.isLeftOpen();
        NdConstantDate ndConstantDate2 = ndDateInterval.getRightBound();
        boolean bl2 = ndDateInterval.isRightOpen();
        try {
            if (bl && !ndDateInterval.isLeftInfinite()) {
                ndConstantDate = new NdConstantDate(ndConstantDate.WjIDiXH().add(WjIBrbE));
            }
            if (bl2 && !ndDateInterval.isRightInfinite()) {
                ndConstantDate2 = new NdConstantDate(ndConstantDate2.WjIDiXH().subtract(WjIBrbE));
            }
        }
        catch (NdInvalidDurationException ndInvalidDurationException) {
            NdAssert.fail((String)("Error building effective date constraint expression:" + ndInvalidDurationException.getMessage()));
        }
        NdAbstractFormula ndAbstractFormula = ndDateInterval.isLeftMin() || ndDateInterval.isLeftInfinite() ? new NdTimeConstraintBinaryFormula(this.WjIwKMJ, NdOperator.WjICYSG, (WjIDdTC)NdTimeConstraintVariable.WjIDfGS, ndConstantDate2) : (ndDateInterval.isRightMax() || ndDateInterval.isRightInfinite() ? new NdTimeConstraintBinaryFormula(this.WjIwKMJ, NdOperator.WjICYSF, (WjIDdTC)NdTimeConstraintVariable.WjIDfGS, ndConstantDate) : (ndConstantDate == ndConstantDate2 ? new NdTimeConstraintTernaryFormula(this.WjIwKMJ, wjIDdTC, ndConstantDate, ndConstantDate2) : new NdTimeConstraintTernaryFormula(this.WjIwKMJ, wjIDdTC, ndConstantDate, ndConstantDate2)));
        return ndAbstractFormula;
    }

    private NdModelType WjIwKSP(WjIDdTC[] wjIDdTCArray) {
        NdModelType ndModelType = wjIDdTCArray[0].WjICXCU();
        if (wjIDdTCArray[0] == NdTimeConstraintVariable.WjIDfGS) {
            ndModelType = NdConstantDate.WjIDiPY;
        } else if (wjIDdTCArray[0] == NdTimeConstraintVariable.WjIDfHT) {
            ndModelType = NdConstantTime.WjIDihH;
        }
        try {
            for (int i = 1; i < wjIDdTCArray.length; ++i) {
                if (wjIDdTCArray[i] == null) continue;
                NdModelType ndModelType2 = wjIDdTCArray[i].WjICXCU();
                if (wjIDdTCArray[i] == NdTimeConstraintVariable.WjIDfGS) {
                    ndModelType2 = NdConstantDate.WjIDiPY;
                } else if (wjIDdTCArray[i] == NdTimeConstraintVariable.WjIDfHT) {
                    ndModelType2 = NdConstantTime.WjIDihH;
                }
                ndModelType = this.WjIwKMJ.deriveBinaryExpressionType(NdOperator.WjICYPX, ndModelType, ndModelType2, true);
            }
        }
        catch (NdVerificationException ndVerificationException) {
            NdBaseObject.advAssert((boolean)false);
        }
        return ndModelType;
    }

    NdFormula WjIwKTQ(double d, WjIDdTC wjIDdTC) throws NdFormulaException {
        NdFormula ndFormula = d == 1.0 ? wjIDdTC : (d == -1.0 ? new NdArithmeticalMinusFormula(this.WjIwKMJ, wjIDdTC) : new NdArithmeticalMulFormula(this.WjIwKMJ, this.WjIDmGQ(this.WjIwKMJ, wjIDdTC.WjIDbjU, Math.abs(d)), wjIDdTC));
        return ndFormula;
    }

    public Object visit(NdPolyhedralConstraint ndPolyhedralConstraint, Object object) {
        NdRelationalPredicate ndRelationalPredicate;
        double[] dArray = ndPolyhedralConstraint.getCoefficients();
        WjIDdTC[] wjIDdTCArray = ndPolyhedralConstraint.getVariables();
        NdOperator ndOperator = ndPolyhedralConstraint.getOperator();
        NdModelType ndModelType = this.WjIwKSP(wjIDdTCArray);
        try {
            int n = dArray.length - 1;
            NdFormula ndFormula = wjIDdTCArray[n] != null ? this.WjIwKTQ(dArray[n], wjIDdTCArray[n]) : this.WjIwKPM(this.WjIwKMJ, ndModelType, dArray[n]);
            NdFormula ndFormula2 = this.WjIwKTQ(dArray[--n], wjIDdTCArray[n]);
            --n;
            while (n >= 0) {
                NdFormula ndFormula3 = this.WjIwKTQ(dArray[n], wjIDdTCArray[n]);
                ndFormula2 = new NdArithmeticalAddFormula(this.WjIwKMJ, ndFormula3, ndFormula2);
                --n;
            }
            ndRelationalPredicate = new NdRelationalPredicate(this.WjIwKMJ, ndOperator, ndFormula2, ndFormula);
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndRelationalPredicate = null;
        }
        return ndRelationalPredicate;
    }

    public Object visit(NdVariableBooleanInterval ndVariableBooleanInterval, Object object) {
        NdRelationalPredicate ndRelationalPredicate;
        try {
            WjIDdTC wjIDdTC = ndVariableBooleanInterval.getVariable();
            NdBooleanInterval ndBooleanInterval = (NdBooleanInterval)ndVariableBooleanInterval.getInterval();
            ndRelationalPredicate = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, ndBooleanInterval == NdBooleanInterval.TRUE ? NdConstantLogical.WjIDcyH : NdConstantLogical.WjIDczI);
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndRelationalPredicate = null;
        }
        return ndRelationalPredicate;
    }

    public Object visit(NdVariableEnumeratedTypeInterval ndVariableEnumeratedTypeInterval, Object object) {
        NdBinaryFormula ndBinaryFormula;
        WjIDdTC wjIDdTC = ndVariableEnumeratedTypeInterval.getVariable();
        NdModelEnumeratedItemType[] ndModelEnumeratedItemTypeArray = ndVariableEnumeratedTypeInterval.getIntervalValue();
        try {
            if (ndModelEnumeratedItemTypeArray.length == 1) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, new NdConstantEnumeratedItem(ndModelEnumeratedItemTypeArray[0]));
            } else {
                int n = ndModelEnumeratedItemTypeArray.length - 1;
                NdRelationalPredicate ndRelationalPredicate = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, new NdConstantEnumeratedItem(ndModelEnumeratedItemTypeArray[n--]));
                NdRelationalPredicate ndRelationalPredicate2 = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, new NdConstantEnumeratedItem(ndModelEnumeratedItemTypeArray[n--]));
                ndBinaryFormula = new NdLogicalOrFormula(this.WjIwKMJ, ndRelationalPredicate2, ndRelationalPredicate);
                while (n >= 0) {
                    NdRelationalPredicate ndRelationalPredicate3 = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, new NdConstantEnumeratedItem(ndModelEnumeratedItemTypeArray[n--]));
                    ndBinaryFormula = new NdLogicalOrFormula(this.WjIwKMJ, ndRelationalPredicate3, ndBinaryFormula);
                }
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndBinaryFormula = null;
        }
        return ndBinaryFormula;
    }

    public Object visit(NdVariableIntegerInterval ndVariableIntegerInterval, Object object) {
        NdBinaryFormula ndBinaryFormula;
        WjIDdTC wjIDdTC = ndVariableIntegerInterval.getVariable();
        try {
            NdIntegerInterval ndIntegerInterval = (NdIntegerInterval)ndVariableIntegerInterval.getInterval();
            long l = ndIntegerInterval.getLeftBound();
            boolean bl = ndIntegerInterval.isLeftOpen();
            long l2 = ndIntegerInterval.getRightBound();
            boolean bl2 = ndIntegerInterval.isRightOpen();
            if (l == Long.MIN_VALUE) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, new NdConstantInteger(l2));
            } else if (l2 == Long.MAX_VALUE) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, new NdConstantInteger(l));
            } else if (l == l2 && !bl && !bl2) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, new NdConstantInteger(l));
            } else {
                NdRelationalPredicate ndRelationalPredicate = new NdRelationalPredicate(this.WjIwKMJ, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, new NdConstantInteger(l));
                NdRelationalPredicate ndRelationalPredicate2 = new NdRelationalPredicate(this.WjIwKMJ, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, new NdConstantInteger(l2));
                ndBinaryFormula = new NdLogicalAndFormula(this.WjIwKMJ, ndRelationalPredicate, ndRelationalPredicate2);
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndBinaryFormula = null;
        }
        return ndBinaryFormula;
    }

    public Object visit(NdVariableRealInterval ndVariableRealInterval, Object object) {
        NdBinaryFormula ndBinaryFormula;
        WjIDdTC wjIDdTC = ndVariableRealInterval.getVariable();
        NdRealInterval ndRealInterval = (NdRealInterval)ndVariableRealInterval.getInterval();
        double d = ndRealInterval.getLeftBound();
        boolean bl = ndRealInterval.isLeftOpen();
        double d2 = ndRealInterval.getRightBound();
        boolean bl2 = ndRealInterval.isRightOpen();
        try {
            if (d == Double.NEGATIVE_INFINITY) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, new NdConstantReal(d2));
            } else if (d2 == Double.POSITIVE_INFINITY) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, new NdConstantReal(d));
            } else if (d == d2 && !bl && !bl2) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, new NdConstantReal(d));
            } else {
                NdRelationalPredicate ndRelationalPredicate = new NdRelationalPredicate(this.WjIwKMJ, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, new NdConstantReal(d));
                NdRelationalPredicate ndRelationalPredicate2 = new NdRelationalPredicate(this.WjIwKMJ, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, new NdConstantReal(d2));
                ndBinaryFormula = new NdLogicalAndFormula(this.WjIwKMJ, ndRelationalPredicate, ndRelationalPredicate2);
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndBinaryFormula = null;
        }
        return ndBinaryFormula;
    }

    public Object visit(NdVariableMoneyInterval ndVariableMoneyInterval, Object object) {
        NdBinaryFormula ndBinaryFormula;
        WjIDdTC wjIDdTC = ndVariableMoneyInterval.getVariable();
        NdMoneyInterval ndMoneyInterval = (NdMoneyInterval)ndVariableMoneyInterval.getInterval();
        NdConstantMoney ndConstantMoney = ndMoneyInterval.getLeftBound();
        boolean bl = ndMoneyInterval.isLeftOpen();
        NdConstantMoney ndConstantMoney2 = ndMoneyInterval.getRightBound();
        boolean bl2 = ndMoneyInterval.isRightOpen();
        try {
            if (ndConstantMoney.WjIDgFT() == Double.NEGATIVE_INFINITY) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantMoney2);
            } else if (ndConstantMoney2.WjIDgFT() == Double.POSITIVE_INFINITY) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantMoney);
            } else if (ndConstantMoney.equals(ndConstantMoney2) && !bl && !bl2) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, ndConstantMoney);
            } else {
                NdRelationalPredicate ndRelationalPredicate = new NdRelationalPredicate(this.WjIwKMJ, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantMoney);
                NdRelationalPredicate ndRelationalPredicate2 = new NdRelationalPredicate(this.WjIwKMJ, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantMoney2);
                ndBinaryFormula = new NdLogicalAndFormula(this.WjIwKMJ, ndRelationalPredicate, ndRelationalPredicate2);
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndBinaryFormula = null;
        }
        return ndBinaryFormula;
    }

    public Object visit(NdVariableDateInterval ndVariableDateInterval, Object object) {
        NdFormula ndFormula;
        WjIDdTC wjIDdTC = ndVariableDateInterval.getVariable();
        try {
            if (wjIDdTC.WjIDbmX()) {
                ndFormula = this.WjIBrbH(wjIDdTC, (NdDateInterval)ndVariableDateInterval.getInterval());
            } else {
                NdDateInterval ndDateInterval = (NdDateInterval)ndVariableDateInterval.getInterval();
                NdConstantDate ndConstantDate = ndDateInterval.getLeftBound();
                boolean bl = ndDateInterval.isLeftOpen();
                NdConstantDate ndConstantDate2 = ndDateInterval.getRightBound();
                boolean bl2 = ndDateInterval.isRightOpen();
                if (ndConstantDate.equals(ndConstantDate2) && !bl && !bl2) {
                    ndFormula = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, ndConstantDate);
                } else if (ndConstantDate == NdConstantDate.WjIDiQA) {
                    ndFormula = new NdRelationalPredicate(this.WjIwKMJ, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantDate2);
                } else if (ndConstantDate2 == NdConstantDate.WjIDiPZ) {
                    ndFormula = new NdRelationalPredicate(this.WjIwKMJ, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantDate);
                } else if (ndConstantDate == ndConstantDate2 && !bl && !bl2) {
                    ndFormula = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, ndConstantDate);
                } else {
                    NdRelationalPredicate ndRelationalPredicate = new NdRelationalPredicate(this.WjIwKMJ, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantDate);
                    NdRelationalPredicate ndRelationalPredicate2 = new NdRelationalPredicate(this.WjIwKMJ, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantDate2);
                    ndFormula = new NdLogicalAndFormula(this.WjIwKMJ, ndRelationalPredicate, ndRelationalPredicate2);
                }
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndFormula = null;
        }
        return ndFormula;
    }

    public Object visit(NdVariableTimeStampInterval ndVariableTimeStampInterval, Object object) {
        NdBinaryFormula ndBinaryFormula;
        WjIDdTC wjIDdTC = ndVariableTimeStampInterval.getVariable();
        NdTimeStampInterval ndTimeStampInterval = (NdTimeStampInterval)ndVariableTimeStampInterval.getInterval();
        NdConstantTimeStamp ndConstantTimeStamp = ndTimeStampInterval.getLeftBound();
        boolean bl = ndTimeStampInterval.isLeftOpen();
        NdConstantTimeStamp ndConstantTimeStamp2 = ndTimeStampInterval.getRightBound();
        boolean bl2 = ndTimeStampInterval.isRightOpen();
        try {
            if (ndConstantTimeStamp.equals(ndConstantTimeStamp2) && !bl && !bl2) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, ndConstantTimeStamp);
            } else if (ndConstantTimeStamp == NdConstantTimeStamp.WjIDjbB) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantTimeStamp2);
            } else if (ndConstantTimeStamp2 == NdConstantTimeStamp.WjIDjaA) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantTimeStamp);
            } else if (ndConstantTimeStamp == ndConstantTimeStamp2 && !bl && !bl2) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, ndConstantTimeStamp);
            } else {
                NdRelationalPredicate ndRelationalPredicate = new NdRelationalPredicate(this.WjIwKMJ, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantTimeStamp);
                NdRelationalPredicate ndRelationalPredicate2 = new NdRelationalPredicate(this.WjIwKMJ, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantTimeStamp2);
                ndBinaryFormula = new NdLogicalAndFormula(this.WjIwKMJ, ndRelationalPredicate, ndRelationalPredicate2);
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndBinaryFormula = null;
        }
        return ndBinaryFormula;
    }

    public Object visit(NdVariableDurationInterval ndVariableDurationInterval, Object object) {
        NdBinaryFormula ndBinaryFormula;
        WjIDdTC wjIDdTC = ndVariableDurationInterval.getVariable();
        NdDurationInterval ndDurationInterval = (NdDurationInterval)ndVariableDurationInterval.getInterval();
        NdConstantDuration ndConstantDuration = ndDurationInterval.getLeftBound();
        boolean bl = ndDurationInterval.isLeftOpen();
        NdConstantDuration ndConstantDuration2 = ndDurationInterval.getRightBound();
        boolean bl2 = ndDurationInterval.isRightOpen();
        try {
            if (ndConstantDuration.equals(ndConstantDuration2) && !bl && !bl2) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, ndConstantDuration);
            } else if (ndConstantDuration == NdConstantDuration.WjIDgVH) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantDuration2);
            } else if (ndConstantDuration2 == NdConstantDuration.WjIDgTF) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantDuration);
            } else if (ndConstantDuration == ndConstantDuration2 && !bl && !bl2) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, ndConstantDuration);
            } else {
                NdRelationalPredicate ndRelationalPredicate = new NdRelationalPredicate(this.WjIwKMJ, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantDuration);
                NdRelationalPredicate ndRelationalPredicate2 = new NdRelationalPredicate(this.WjIwKMJ, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantDuration2);
                ndBinaryFormula = new NdLogicalAndFormula(this.WjIwKMJ, ndRelationalPredicate, ndRelationalPredicate2);
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndBinaryFormula = null;
        }
        return ndBinaryFormula;
    }

    public Object visit(NdVariableTimeInterval ndVariableTimeInterval, Object object) {
        NdFormula ndFormula;
        WjIDdTC wjIDdTC = ndVariableTimeInterval.getVariable();
        NdTimeInterval ndTimeInterval = (NdTimeInterval)ndVariableTimeInterval.getInterval();
        NdConstantTime ndConstantTime = ndTimeInterval.getLeftBound();
        boolean bl = ndTimeInterval.isLeftOpen();
        NdConstantTime ndConstantTime2 = ndTimeInterval.getRightBound();
        boolean bl2 = ndTimeInterval.isRightOpen();
        try {
            if (wjIDdTC.WjIDbmX()) {
                ndFormula = this.WjIBrbG(wjIDdTC, (NdTimeInterval)ndVariableTimeInterval.getInterval());
            } else if (ndConstantTime.equals(ndConstantTime2) && !bl && !bl2) {
                ndFormula = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, ndConstantTime);
            } else if (ndConstantTime == NdConstantTime.WjIDihL) {
                ndFormula = new NdRelationalPredicate(this.WjIwKMJ, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantTime2);
            } else if (ndConstantTime2 == NdConstantTime.WjIDihK) {
                ndFormula = new NdRelationalPredicate(this.WjIwKMJ, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantTime);
            } else if (ndConstantTime == ndConstantTime2 && !bl && !bl2) {
                ndFormula = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, ndConstantTime);
            } else {
                NdRelationalPredicate ndRelationalPredicate = new NdRelationalPredicate(this.WjIwKMJ, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantTime);
                NdRelationalPredicate ndRelationalPredicate2 = new NdRelationalPredicate(this.WjIwKMJ, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantTime2);
                ndFormula = new NdLogicalAndFormula(this.WjIwKMJ, ndRelationalPredicate, ndRelationalPredicate2);
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndFormula = null;
        }
        return ndFormula;
    }

    public Object visit(NdVariableReferenceTypeInterval ndVariableReferenceTypeInterval, Object object) {
        NdRelationalPredicate ndRelationalPredicate;
        try {
            WjIDdTC wjIDdTC = ndVariableReferenceTypeInterval.getVariable();
            NdReferenceTypeInterval ndReferenceTypeInterval = (NdReferenceTypeInterval)ndVariableReferenceTypeInterval.getInterval();
            ndRelationalPredicate = ndReferenceTypeInterval == NdReferenceTypeInterval.NULL ? new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, NdConstantNull.WjIDeLB) : new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSI, wjIDdTC, NdConstantNull.WjIDeLB);
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndRelationalPredicate = null;
        }
        return ndRelationalPredicate;
    }

    private NdFormula WjIwVgE(WjIDdTC wjIDdTC, NdStringInterval.StringValue stringValue) throws NdFormulaException {
        NdBinaryFormula ndBinaryFormula;
        if (stringValue.isComplement) {
            if (this.WjIGgyO) {
                ndBinaryFormula = null;
            } else {
                NdStringInterval.StringValue[] stringValueArray = stringValue.getComplementValues();
                if (stringValueArray.length == 1) {
                    ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSI, wjIDdTC, new NdConstantString(stringValueArray[0].value));
                } else {
                    int n = stringValueArray.length - 1;
                    NdRelationalPredicate ndRelationalPredicate = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSI, wjIDdTC, new NdConstantString(stringValueArray[n--].value));
                    NdRelationalPredicate ndRelationalPredicate2 = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSI, wjIDdTC, new NdConstantString(stringValueArray[n--].value));
                    ndBinaryFormula = new NdLogicalAndFormula(this.WjIwKMJ, ndRelationalPredicate2, ndRelationalPredicate);
                    while (n >= 0) {
                        NdRelationalPredicate ndRelationalPredicate3 = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSI, wjIDdTC, new NdConstantString(stringValueArray[n--].value));
                        ndBinaryFormula = new NdLogicalAndFormula(this.WjIwKMJ, ndRelationalPredicate3, ndBinaryFormula);
                    }
                }
            }
        } else {
            ndBinaryFormula = new NdRelationalPredicate(this.WjIwKMJ, NdOperator.WjICYSH, wjIDdTC, new NdConstantString(stringValue.value));
        }
        return ndBinaryFormula;
    }

    public Object visit(NdVariableStringInterval ndVariableStringInterval, Object object) {
        NdFormula ndFormula;
        WjIDdTC wjIDdTC = ndVariableStringInterval.getVariable();
        NdStringInterval ndStringInterval = (NdStringInterval)ndVariableStringInterval.getInterval();
        try {
            NdStringInterval.StringValue[] stringValueArray = ndStringInterval.getElements();
            if (stringValueArray.length == 1) {
                ndFormula = this.WjIwVgE(wjIDdTC, stringValueArray[0]);
            } else {
                NdFormula ndFormula2;
                int n = stringValueArray.length - 1;
                NdFormula ndFormula3 = this.WjIwVgE(wjIDdTC, stringValueArray[n--]);
                ndFormula = (ndFormula2 = this.WjIwVgE(wjIDdTC, stringValueArray[n--])) == null ? ndFormula3 : (ndFormula3 == null ? ndFormula2 : new NdLogicalOrFormula(this.WjIwKMJ, ndFormula2, ndFormula3));
                while (n >= 0) {
                    NdFormula ndFormula4;
                    if ((ndFormula4 = this.WjIwVgE(wjIDdTC, stringValueArray[n--])) == null) continue;
                    ndFormula = new NdLogicalOrFormula(this.WjIwKMJ, ndFormula4, ndFormula);
                }
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndFormula = null;
        }
        return ndFormula;
    }
}

