/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.intervals;

import com.blazesoft.verifier.cfa.spatial.NdShape;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntervalType;
import com.blazesoft.verifier.cfa.spatial.intervals.NdSingleInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableBooleanInterval;
import com.blazesoft.verifier.predicate.WjIDdTC;

public class NdBooleanInterval
implements NdSingleInterval {
    public static final NdBooleanInterval TRUE = new NdBooleanInterval(true, false);
    public static final NdBooleanInterval FALSE = new NdBooleanInterval(false, false);
    public static final NdBooleanInterval EMPTY = new NdBooleanInterval(false, true);
    protected final boolean value;
    private final boolean WjIwLRH;
    public static final NdIntervalType TYPE = NdIntervalType.BOOLEAN;

    protected NdBooleanInterval(boolean bl, boolean bl2) {
        this.value = bl;
        this.WjIwLRH = bl2;
    }

    public boolean isEmpty() {
        return this.WjIwLRH;
    }

    public boolean isUniversum() {
        return false;
    }

    public NdShape makeShape(WjIDdTC wjIDdTC) {
        return new NdVariableBooleanInterval(wjIDdTC, this);
    }

    public NdIntervalType getIntervalType() {
        return TYPE;
    }

    public boolean isDegenerate() {
        return false;
    }

    public boolean getValue() {
        return this.value;
    }

    public boolean eq(boolean bl) {
        return this.value == bl;
    }

    public NdSingleInterval intersect(NdSingleInterval ndSingleInterval) {
        NdBooleanInterval ndBooleanInterval = (NdBooleanInterval)ndSingleInterval;
        if (ndBooleanInterval == this) {
            return ndBooleanInterval;
        }
        return EMPTY;
    }

    public String toString() {
        return "[" + this.value + "]";
    }

    public String toAnalyticalString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(string);
        stringBuffer.append(" = ");
        stringBuffer.append(this.value ? "true" : "false");
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

