/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.intervals;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.cfa.spatial.NdShape;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntegerInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntervalType;
import com.blazesoft.verifier.cfa.spatial.intervals.NdSingleInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableDateInterval;
import com.blazesoft.verifier.predicate.NdConstantDate;
import com.blazesoft.verifier.predicate.WjIDdTC;

public class NdDateInterval
implements NdSingleInterval {
    protected static final boolean OPEN = true;
    protected static final boolean CLOSED = false;
    public static final NdIntervalType TYPE = NdIntervalType.DATE;
    public static final NdDateInterval UNIVERSUM = new NdDateInterval(true, NdConstantDate.WjIDiQA, NdConstantDate.WjIDiPZ, true);
    public static final NdDateInterval EMPTY = new NdDateInterval(NdIntegerInterval.EMPTY);
    private final NdIntegerInterval WjIxCfR;
    private final NdConstantDate WjIxCgS;
    private final NdConstantDate WjIxChT;

    private NdConstantDate WjIxCiU(long l) {
        return NdConstantDate.WjIDiWG(l);
    }

    private NdDateInterval(NdIntegerInterval ndIntegerInterval) {
        this.WjIxCfR = ndIntegerInterval;
        this.WjIxChT = this.WjIxCiU(ndIntegerInterval.getRightBound());
        this.WjIxCgS = this.WjIxCiU(ndIntegerInterval.getLeftBound());
    }

    public NdDateInterval(boolean bl, NdConstantDate ndConstantDate, NdConstantDate ndConstantDate2, boolean bl2) {
        NdBaseObject.advAssertNonNull((Object)ndConstantDate);
        NdBaseObject.advAssertNonNull((Object)ndConstantDate2);
        this.WjIxCfR = new NdIntegerInterval(bl, ndConstantDate.WjIDaaB(), ndConstantDate2.WjIDaaB(), bl2);
        this.WjIxCgS = ndConstantDate;
        this.WjIxChT = ndConstantDate2;
    }

    public NdDateInterval(char c, NdConstantDate ndConstantDate, NdConstantDate ndConstantDate2, char c2) {
        NdBaseObject.advAssertNonNull((Object)ndConstantDate);
        NdBaseObject.advAssertNonNull((Object)ndConstantDate2);
        this.WjIxCfR = new NdIntegerInterval(c, ndConstantDate.WjIDaaB(), ndConstantDate2.WjIDaaB(), c2);
        this.WjIxCgS = ndConstantDate;
        this.WjIxChT = ndConstantDate2;
    }

    private void WjIxCjV(NdInterval[] ndIntervalArray) {
        for (int i = 0; i < ndIntervalArray.length; ++i) {
            if (ndIntervalArray[i] == null) continue;
            ndIntervalArray[i] = new NdDateInterval((NdIntegerInterval)ndIntervalArray[i]);
        }
    }

    private void WjIxCkW(NdInterval[] ndIntervalArray) {
        for (int i = 0; i < ndIntervalArray.length; ++i) {
            if (ndIntervalArray[i] == null) continue;
            ndIntervalArray[i] = ((NdDateInterval)ndIntervalArray[i]).WjIxCfR;
        }
    }

    public NdIntervalType getIntervalType() {
        return TYPE;
    }

    public NdSingleInterval intersect(NdSingleInterval ndSingleInterval) {
        NdDateInterval ndDateInterval = (NdDateInterval)ndSingleInterval;
        NdIntegerInterval ndIntegerInterval = (NdIntegerInterval)this.WjIxCfR.intersect(ndDateInterval.WjIxCfR);
        return new NdDateInterval(ndIntegerInterval);
    }

    public static NdDateInterval makeUniversum() {
        return UNIVERSUM;
    }

    public boolean isEmpty() {
        return this.WjIxCfR.equivalent(NdDateInterval.EMPTY.WjIxCfR);
    }

    public boolean isUniversum() {
        return this.WjIxCfR.equivalent(NdDateInterval.UNIVERSUM.WjIxCfR);
    }

    public NdShape makeShape(WjIDdTC wjIDdTC) {
        return new NdVariableDateInterval(wjIDdTC, this);
    }

    public boolean isDegenerate() {
        return false;
    }

    public boolean isEquality() {
        return this.WjIxCfR.getLeftBound() == this.WjIxCfR.getRightBound() && !this.WjIxCfR.isLeftOpen() && !this.WjIxCfR.isRightOpen();
    }

    public String toAnalyticalString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.WjIxCfR.isLeftOpen();
        boolean bl2 = this.WjIxCfR.isRightOpen();
        stringBuffer.append('(').append(string);
        if (this.isEquality()) {
            stringBuffer.append(" = ");
            stringBuffer.append(this.WjIxCgS);
        } else {
            stringBuffer.append(bl ? " > " : " >= ");
            stringBuffer.append(this.WjIxCgS);
            stringBuffer.append(") and (");
            stringBuffer.append(string);
            stringBuffer.append(bl2 ? " < " : " <= ");
            stringBuffer.append(this.WjIxChT);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        long l = this.WjIxCfR.getLeftBound();
        long l2 = this.WjIxCfR.getRightBound();
        boolean bl = this.WjIxCfR.isLeftOpen();
        boolean bl2 = this.WjIxCfR.isRightOpen();
        if (l == l2 && !bl && !bl2) {
            stringBuffer.append("[").append(this.WjIxCgS).append("]");
        } else {
            stringBuffer.append(bl ? "(" : "[");
            stringBuffer.append(this.WjIxCgS);
            stringBuffer.append("; ");
            stringBuffer.append(this.WjIxChT);
            stringBuffer.append(bl2 ? ")" : "]");
        }
        return stringBuffer.toString();
    }

    public boolean contains(NdDateInterval ndDateInterval) {
        return this.WjIxCfR.contains(ndDateInterval.WjIxCfR);
    }

    public boolean eq(NdConstantDate ndConstantDate) {
        return this.WjIxCfR.eq(ndConstantDate.WjIDaaB());
    }

    public boolean eqSplit(NdConstantDate ndConstantDate, NdInterval[] ndIntervalArray) {
        boolean bl = this.WjIxCfR.eqSplit(ndConstantDate.WjIDaaB(), ndIntervalArray);
        this.WjIxCjV(ndIntervalArray);
        return bl;
    }

    public boolean equivalent(NdDateInterval ndDateInterval) {
        return this.WjIxCfR.equivalent(ndDateInterval.WjIxCfR);
    }

    public NdConstantDate getLeftBound() {
        return this.WjIxCgS;
    }

    public NdConstantDate getRightBound() {
        return this.WjIxChT;
    }

    public boolean gt(NdConstantDate ndConstantDate) {
        return this.WjIxCfR.gt(ndConstantDate.WjIDaaB());
    }

    public boolean gte(NdConstantDate ndConstantDate) {
        return this.WjIxCfR.gte(ndConstantDate.WjIDaaB());
    }

    public boolean gteSplit(NdConstantDate ndConstantDate, NdInterval[] ndIntervalArray) {
        boolean bl = this.WjIxCfR.gteSplit(ndConstantDate.WjIDaaB(), ndIntervalArray);
        this.WjIxCjV(ndIntervalArray);
        return bl;
    }

    public boolean gtSplit(NdConstantDate ndConstantDate, NdInterval[] ndIntervalArray) {
        boolean bl = this.WjIxCfR.gtSplit(ndConstantDate.WjIDaaB(), ndIntervalArray);
        this.WjIxCjV(ndIntervalArray);
        return bl;
    }

    public boolean intersects(NdDateInterval ndDateInterval) {
        return this.WjIxCfR.intersects(ndDateInterval.WjIxCfR);
    }

    void WjIxClX(NdDateInterval ndDateInterval, NdInterval[] ndIntervalArray) {
        this.WjIxCkW(ndIntervalArray);
        this.WjIxCfR.WjIwOoO(ndDateInterval.WjIxCfR, ndIntervalArray);
        this.WjIxCjV(ndIntervalArray);
    }

    public boolean isLeftMin() {
        return this.WjIxCgS.WjICZaW() && !this.WjIxCfR.isLeftOpen();
    }

    public boolean isRightMax() {
        return this.WjIxChT.WjICZaX() && !this.WjIxCfR.isRightOpen();
    }

    public boolean isLeftInfinite() {
        return this.WjIxCfR.isLeftInfinite();
    }

    public boolean isLeftOpen() {
        return this.WjIxCfR.isLeftOpen();
    }

    public boolean isRightInfinite() {
        return this.WjIxCfR.isRightInfinite();
    }

    public boolean isRightOpen() {
        return this.WjIxCfR.isRightOpen();
    }

    public boolean lt(NdConstantDate ndConstantDate) {
        return this.WjIxCfR.lt(ndConstantDate.WjIDaaB());
    }

    public boolean lte(NdConstantDate ndConstantDate) {
        return this.WjIxCfR.lte(ndConstantDate.WjIDaaB());
    }

    public boolean lteSplit(NdConstantDate ndConstantDate, NdInterval[] ndIntervalArray) {
        boolean bl = this.WjIxCfR.lteSplit(ndConstantDate.WjIDaaB(), ndIntervalArray);
        this.WjIxCjV(ndIntervalArray);
        return bl;
    }

    public boolean ltSplit(NdConstantDate ndConstantDate, NdInterval[] ndIntervalArray) {
        boolean bl = this.WjIxCfR.ltSplit(ndConstantDate.WjIDaaB(), ndIntervalArray);
        this.WjIxCjV(ndIntervalArray);
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && object instanceof NdDateInterval) {
            NdDateInterval ndDateInterval = (NdDateInterval)object;
            bl = this.WjIxCfR.equals(ndDateInterval.WjIxCfR);
        }
        return bl;
    }

    public int hashCode() {
        return this.WjIxCfR.hashCode();
    }
}

