/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.intervals;

import com.blazesoft.objects.java.NdCurrency;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.cfa.spatial.NdShape;
import com.blazesoft.verifier.cfa.spatial.intervals.NdInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntervalType;
import com.blazesoft.verifier.cfa.spatial.intervals.NdRealInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdSingleInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableMoneyInterval;
import com.blazesoft.verifier.predicate.NdConstantMoney;
import com.blazesoft.verifier.predicate.WjIDdTC;
import java.util.HashMap;
import java.util.Map;

public class NdMoneyInterval
implements NdSingleInterval {
    private static final Map WjIwOgN = new HashMap();
    protected static final boolean OPEN = true;
    protected static final boolean CLOSED = false;
    public static final NdIntervalType TYPE = NdIntervalType.MONEY;
    private final NdRealInterval WjIwOgO;
    private final NdCurrency WjIwOgP;
    private final NdConstantMoney WjIwOgQ;
    private final NdConstantMoney WjIwOgR;

    private NdConstantMoney WjIwOgS(NdCurrency ndCurrency, double d) {
        NdConstantMoney ndConstantMoney = d == Double.POSITIVE_INFINITY ? NdConstantMoney.WjIDgFR() : (d == Double.NEGATIVE_INFINITY ? NdConstantMoney.WjIDgFS() : new NdConstantMoney(ndCurrency.amount(d)));
        return ndConstantMoney;
    }

    private NdMoneyInterval(NdCurrency ndCurrency, NdRealInterval ndRealInterval) {
        this.WjIwOgP = ndCurrency;
        this.WjIwOgO = ndRealInterval;
        this.WjIwOgR = this.WjIwOgS(ndCurrency, ndRealInterval.getRightBound());
        this.WjIwOgQ = this.WjIwOgS(ndCurrency, ndRealInterval.getLeftBound());
    }

    public NdMoneyInterval(boolean bl, NdConstantMoney ndConstantMoney, NdConstantMoney ndConstantMoney2, boolean bl2) {
        NdBaseObject.advAssertNonNull((Object)ndConstantMoney);
        NdBaseObject.advAssertNonNull((Object)ndConstantMoney2);
        this.WjIwOgP = ndConstantMoney.WjIDgFU();
        this.WjIwOgO = new NdRealInterval(bl, ndConstantMoney.WjIDgFT(), ndConstantMoney2.WjIDgFT(), bl2);
        this.WjIwOgQ = ndConstantMoney;
        this.WjIwOgR = ndConstantMoney2;
    }

    public NdMoneyInterval(char c, NdConstantMoney ndConstantMoney, NdConstantMoney ndConstantMoney2, char c2) {
        NdBaseObject.advAssertNonNull((Object)ndConstantMoney);
        NdBaseObject.advAssertNonNull((Object)ndConstantMoney2);
        this.WjIwOgP = ndConstantMoney.WjIDgFU();
        this.WjIwOgO = new NdRealInterval(c, ndConstantMoney.WjIDgFT(), ndConstantMoney2.WjIDgFT(), c2);
        this.WjIwOgQ = ndConstantMoney;
        this.WjIwOgR = ndConstantMoney2;
    }

    private void WjIwOgT(NdInterval[] ndIntervalArray) {
        for (int i = 0; i < ndIntervalArray.length; ++i) {
            if (ndIntervalArray[i] == null) continue;
            ndIntervalArray[i] = new NdMoneyInterval(this.WjIwOgP, (NdRealInterval)ndIntervalArray[i]);
        }
    }

    private void WjIwOgU(NdInterval[] ndIntervalArray) {
        for (int i = 0; i < ndIntervalArray.length; ++i) {
            if (ndIntervalArray[i] == null) continue;
            ndIntervalArray[i] = ((NdMoneyInterval)ndIntervalArray[i]).WjIwOgO;
        }
    }

    public NdIntervalType getIntervalType() {
        return NdIntervalType.MONEY;
    }

    public NdCurrency getCurrency() {
        return this.WjIwOgP;
    }

    public NdSingleInterval intersect(NdSingleInterval ndSingleInterval) {
        NdMoneyInterval ndMoneyInterval = (NdMoneyInterval)ndSingleInterval;
        NdRealInterval ndRealInterval = (NdRealInterval)this.WjIwOgO.intersect(ndMoneyInterval.WjIwOgO);
        return new NdMoneyInterval(this.WjIwOgP, ndRealInterval);
    }

    public static NdMoneyInterval makeUniversum(NdCurrency ndCurrency) {
        NdMoneyInterval ndMoneyInterval = (NdMoneyInterval)WjIwOgN.get(ndCurrency);
        if (ndMoneyInterval == null) {
            ndMoneyInterval = new NdMoneyInterval(ndCurrency, NdRealInterval.UNIVERSUM);
            WjIwOgN.put(ndCurrency, ndMoneyInterval);
        }
        return ndMoneyInterval;
    }

    public boolean isEmpty() {
        return this.WjIwOgO.isEmpty();
    }

    public boolean isUniversum() {
        return this.WjIwOgO.isUniversum();
    }

    public NdShape makeShape(WjIDdTC wjIDdTC) {
        return new NdVariableMoneyInterval(wjIDdTC, this);
    }

    public boolean isDegenerate() {
        return false;
    }

    public boolean isEquality() {
        return this.WjIwOgO.getLeftBound() == this.WjIwOgO.getRightBound() && !this.WjIwOgO.isLeftOpen() && !this.WjIwOgO.isRightOpen();
    }

    public String toAnalyticalString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        double d = this.WjIwOgO.getLeftBound();
        double d2 = this.WjIwOgO.getRightBound();
        boolean bl = this.WjIwOgO.isLeftOpen();
        boolean bl2 = this.WjIwOgO.isRightOpen();
        stringBuffer.append('(').append(string);
        if (d == Double.NEGATIVE_INFINITY) {
            stringBuffer.append(bl2 ? " < " : " <= ");
            stringBuffer.append(this.WjIwOgR);
        } else if (d2 == Double.POSITIVE_INFINITY) {
            stringBuffer.append(bl ? " > " : " >= ");
            stringBuffer.append(this.WjIwOgQ);
        } else if (this.isEquality()) {
            stringBuffer.append(" = ");
            stringBuffer.append(this.WjIwOgQ);
        } else {
            stringBuffer.append(bl ? " > " : " >= ");
            stringBuffer.append(this.WjIwOgQ);
            stringBuffer.append(") and (");
            stringBuffer.append(string);
            stringBuffer.append(bl2 ? " < " : " <= ");
            stringBuffer.append(this.WjIwOgR);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean contains(NdMoneyInterval ndMoneyInterval) {
        return this.WjIwOgO.contains(ndMoneyInterval.WjIwOgO);
    }

    public boolean eq(NdConstantMoney ndConstantMoney) {
        return this.WjIwOgO.eq(ndConstantMoney.WjIDgFT());
    }

    public boolean eqSplit(NdConstantMoney ndConstantMoney, NdInterval[] ndIntervalArray) {
        boolean bl = this.WjIwOgO.eqSplit(ndConstantMoney.WjIDgFT(), ndIntervalArray);
        this.WjIwOgT(ndIntervalArray);
        return bl;
    }

    public boolean equivalent(NdMoneyInterval ndMoneyInterval) {
        return this.WjIwOgO.equivalent(ndMoneyInterval.WjIwOgO);
    }

    public NdConstantMoney getLeftBound() {
        return this.WjIwOgQ;
    }

    public NdConstantMoney getRightBound() {
        return this.WjIwOgR;
    }

    public boolean gt(NdConstantMoney ndConstantMoney) {
        return this.WjIwOgO.gt(ndConstantMoney.WjIDgFT());
    }

    public boolean gte(NdConstantMoney ndConstantMoney) {
        return this.WjIwOgO.gte(ndConstantMoney.WjIDgFT());
    }

    public boolean gteSplit(NdConstantMoney ndConstantMoney, NdInterval[] ndIntervalArray) {
        boolean bl = this.WjIwOgO.gteSplit(ndConstantMoney.WjIDgFT(), ndIntervalArray);
        this.WjIwOgT(ndIntervalArray);
        return bl;
    }

    public boolean gtSplit(NdConstantMoney ndConstantMoney, NdInterval[] ndIntervalArray) {
        boolean bl = this.WjIwOgO.gtSplit(ndConstantMoney.WjIDgFT(), ndIntervalArray);
        this.WjIwOgT(ndIntervalArray);
        return bl;
    }

    public boolean intersects(NdMoneyInterval ndMoneyInterval) {
        return this.WjIwOgO.intersects(ndMoneyInterval.WjIwOgO);
    }

    void WjIwOgV(NdMoneyInterval ndMoneyInterval, NdInterval[] ndIntervalArray) {
        this.WjIwOgU(ndIntervalArray);
        this.WjIwOgO.WjIwNiI(ndMoneyInterval.WjIwOgO, ndIntervalArray);
        this.WjIwOgT(ndIntervalArray);
    }

    public boolean isLeftInfinite() {
        return this.WjIwOgO.isLeftInfinite();
    }

    public boolean isLeftOpen() {
        return this.WjIwOgO.isLeftOpen();
    }

    public boolean isRightInfinite() {
        return this.WjIwOgO.isRightInfinite();
    }

    public boolean isRightOpen() {
        return this.WjIwOgO.isRightOpen();
    }

    public boolean lt(NdConstantMoney ndConstantMoney) {
        return this.WjIwOgO.lt(ndConstantMoney.WjIDgFT());
    }

    public boolean lte(NdConstantMoney ndConstantMoney) {
        return this.WjIwOgO.lte(ndConstantMoney.WjIDgFT());
    }

    public boolean lteSplit(NdConstantMoney ndConstantMoney, NdInterval[] ndIntervalArray) {
        boolean bl = this.WjIwOgO.lteSplit(ndConstantMoney.WjIDgFT(), ndIntervalArray);
        this.WjIwOgT(ndIntervalArray);
        return bl;
    }

    public boolean ltSplit(NdConstantMoney ndConstantMoney, NdInterval[] ndIntervalArray) {
        boolean bl = this.WjIwOgO.ltSplit(ndConstantMoney.WjIDgFT(), ndIntervalArray);
        this.WjIwOgT(ndIntervalArray);
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && object instanceof NdMoneyInterval) {
            NdMoneyInterval ndMoneyInterval = (NdMoneyInterval)object;
            bl = this.WjIwOgP.equals(ndMoneyInterval.WjIwOgP) && this.WjIwOgO.equals(ndMoneyInterval.WjIwOgO);
        }
        return bl;
    }

    public int hashCode() {
        return this.WjIwOgP.hashCode() ^ this.WjIwOgO.hashCode();
    }
}

