/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.intervals;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.cfa.spatial.NdShape;
import com.blazesoft.verifier.cfa.spatial.intervals.NdInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntervalType;
import com.blazesoft.verifier.cfa.spatial.intervals.NdSingleInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdStringIntervalDomain;
import com.blazesoft.verifier.cfa.spatial.intervals.NdStringIntervalFactory;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableStringInterval;
import com.blazesoft.verifier.predicate.WjIDdTC;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class NdStringInterval
implements NdSingleInterval {
    private static final NdStringIntervalFactory WjIwWJS = NdStringIntervalFactory.getInstance();
    public static final NdIntervalType TYPE = NdIntervalType.STRING;
    private final Set WjIwWKT;
    private int WjIwWLU;
    private final NdStringIntervalDomain WjIwWMV;

    NdStringInterval(NdStringIntervalDomain ndStringIntervalDomain, Set set) {
        NdBaseObject.advAssertNonNull((Object)set);
        NdBaseObject.advAssertNonNull((Object)ndStringIntervalDomain);
        this.WjIwWMV = ndStringIntervalDomain;
        this.WjIwWKT = set;
        this.WjIwWNW();
    }

    NdStringInterval(NdStringIntervalDomain ndStringIntervalDomain, String string) {
        NdBaseObject.advAssertNonNull((Object)ndStringIntervalDomain);
        this.WjIwWKT = new HashSet();
        this.WjIwWKT.add(WjIwWJS.getValue(ndStringIntervalDomain, string));
        this.WjIwWMV = ndStringIntervalDomain;
        this.WjIwWNW();
    }

    NdStringInterval(NdStringIntervalDomain ndStringIntervalDomain) {
        NdBaseObject.advAssertNonNull((Object)ndStringIntervalDomain);
        this.WjIwWKT = new HashSet();
        this.WjIwWMV = ndStringIntervalDomain;
        this.WjIwWNW();
    }

    private void WjIwWNW() {
        int n = 0;
        Iterator iterator = this.WjIwWKT.iterator();
        while (iterator.hasNext()) {
            n |= ((StringValue)iterator.next()).hashCode();
        }
        this.WjIwWLU = n;
    }

    public NdSingleInterval intersect(NdSingleInterval ndSingleInterval) {
        NdBaseObject.advAssertNonNull((Object)ndSingleInterval);
        NdStringInterval ndStringInterval = (NdStringInterval)ndSingleInterval;
        HashSet hashSet = new HashSet(this.WjIwWKT);
        hashSet.retainAll(ndStringInterval.WjIwWKT);
        return new NdStringInterval(this.WjIwWMV, hashSet);
    }

    public NdSingleInterval union(NdSingleInterval ndSingleInterval) {
        NdBaseObject.advAssertNonNull((Object)ndSingleInterval);
        NdStringInterval ndStringInterval = (NdStringInterval)ndSingleInterval;
        HashSet hashSet = new HashSet(this.WjIwWKT);
        hashSet.addAll(ndStringInterval.WjIwWKT);
        NdStringInterval ndStringInterval2 = new NdStringInterval(this.WjIwWMV, hashSet);
        return ndStringInterval2;
    }

    public NdStringInterval cloneMe() {
        HashSet hashSet = new HashSet(this.WjIwWKT);
        return new NdStringInterval(this.WjIwWMV, hashSet);
    }

    public NdStringInterval subtract(String string) {
        HashSet hashSet = new HashSet(this.WjIwWKT);
        hashSet.remove(WjIwWJS.getValue(this.WjIwWMV, string));
        return new NdStringInterval(this.WjIwWMV, hashSet);
    }

    public NdStringInterval subtract(NdStringInterval ndStringInterval) {
        HashSet hashSet = new HashSet(this.WjIwWKT);
        hashSet.removeAll(ndStringInterval.WjIwWKT);
        return new NdStringInterval(this.WjIwWMV, hashSet);
    }

    public boolean isEmpty() {
        return this.WjIwWKT.size() == 0;
    }

    public boolean isUniversum() {
        NdBaseObject.advAssert((boolean)false);
        return false;
    }

    public NdShape makeShape(WjIDdTC wjIDdTC) {
        return new NdVariableStringInterval(wjIDdTC, this);
    }

    public NdIntervalType getIntervalType() {
        return TYPE;
    }

    public StringValue[] getElements() {
        StringValue[] stringValueArray = new StringValue[this.WjIwWKT.size()];
        int n = 0;
        Iterator iterator = this.WjIwWKT.iterator();
        while (iterator.hasNext()) {
            StringValue stringValue = (StringValue)iterator.next();
            stringValueArray[n++] = stringValue;
        }
        return stringValueArray;
    }

    public boolean isDegenerate() {
        return false;
    }

    public boolean eq(NdInterval ndInterval) {
        NdStringInterval ndStringInterval = (NdStringInterval)ndInterval;
        return this.WjIwWLU == ndStringInterval.WjIwWLU && ((Object)this.WjIwWKT).equals(ndStringInterval.WjIwWKT);
    }

    public boolean eq(String string) {
        return this.WjIwWKT.contains(WjIwWJS.getValue(this.WjIwWMV, string));
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && object instanceof NdStringInterval) {
            NdStringInterval ndStringInterval = (NdStringInterval)object;
            bl = this.eq(ndStringInterval);
        }
        return bl;
    }

    public int hashCode() {
        return this.WjIwWLU;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        Iterator iterator = this.WjIwWKT.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String toAnalyticalString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(').append(string).append(" in {");
        Iterator iterator = this.WjIwWKT.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("})");
        return stringBuffer.toString();
    }

    public static class StringValue {
        public final String value;
        public final boolean isComplement;
        private NdStringIntervalDomain WjIwTjS;

        StringValue(NdStringIntervalDomain ndStringIntervalDomain, String string) {
            this.value = string;
            this.isComplement = false;
            this.WjIwTjS = ndStringIntervalDomain;
        }

        StringValue(NdStringIntervalDomain ndStringIntervalDomain) {
            this.value = null;
            this.isComplement = true;
            this.WjIwTjS = ndStringIntervalDomain;
        }

        public StringValue[] getComplementValues() {
            NdBaseObject.advAssertNonNull((Object)this.WjIwTjS);
            NdStringInterval ndStringInterval = this.WjIwTjS.getInterval();
            return ndStringInterval.getElements();
        }

        public int hashCode() {
            int n = this.isComplement ? 1 : (this.value == null ? 0 : this.value.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            StringValue stringValue = (StringValue)object;
            boolean bl = this == stringValue ? true : (this.isComplement ? stringValue.isComplement : (this.value == null ? stringValue.value == null : this.value.equals(stringValue.value)));
            return bl;
        }

        public String toString() {
            String string = this.isComplement ? "<complement>" : (this.value == null ? "null" : '\"' + this.value + '\"');
            return string;
        }
    }
}

