/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.intervals;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.cfa.spatial.NdShape;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntegerInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntervalType;
import com.blazesoft.verifier.cfa.spatial.intervals.NdSingleInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableTimeInterval;
import com.blazesoft.verifier.predicate.NdConstantTime;
import com.blazesoft.verifier.predicate.WjIDdTC;

public class NdTimeInterval
implements NdSingleInterval {
    protected static final boolean OPEN = true;
    protected static final boolean CLOSED = false;
    public static final NdIntervalType TYPE = NdIntervalType.TIME;
    public static final NdTimeInterval UNIVERSUM = new NdTimeInterval(true, NdConstantTime.WjIDihL, NdConstantTime.WjIDihK, true);
    public static final NdTimeInterval EMPTY = new NdTimeInterval(NdIntegerInterval.EMPTY);
    private final NdIntegerInterval WjIwVvV;
    private final NdConstantTime WjIwVvW;
    private final NdConstantTime WjIwVvX;

    private NdConstantTime WjIwVvY(long l) {
        return NdConstantTime.WjIDihO(l);
    }

    private NdTimeInterval(NdIntegerInterval ndIntegerInterval) {
        this.WjIwVvV = ndIntegerInterval;
        this.WjIwVvX = this.WjIwVvY(ndIntegerInterval.getRightBound());
        this.WjIwVvW = this.WjIwVvY(ndIntegerInterval.getLeftBound());
    }

    public NdTimeInterval(boolean bl, NdConstantTime ndConstantTime, NdConstantTime ndConstantTime2, boolean bl2) {
        NdBaseObject.advAssertNonNull((Object)ndConstantTime);
        NdBaseObject.advAssertNonNull((Object)ndConstantTime2);
        this.WjIwVvV = new NdIntegerInterval(bl, ndConstantTime.WjIDaaB(), ndConstantTime2.WjIDaaB(), bl2);
        this.WjIwVvW = ndConstantTime;
        this.WjIwVvX = ndConstantTime2;
    }

    public NdTimeInterval(char c, NdConstantTime ndConstantTime, NdConstantTime ndConstantTime2, char c2) {
        NdBaseObject.advAssertNonNull((Object)ndConstantTime);
        NdBaseObject.advAssertNonNull((Object)ndConstantTime2);
        this.WjIwVvV = new NdIntegerInterval(c, ndConstantTime.WjIDaaB(), ndConstantTime2.WjIDaaB(), c2);
        this.WjIwVvW = ndConstantTime;
        this.WjIwVvX = ndConstantTime2;
    }

    private void WjIwVvZ(NdInterval[] ndIntervalArray) {
        for (int i = 0; i < ndIntervalArray.length; ++i) {
            if (ndIntervalArray[i] == null) continue;
            ndIntervalArray[i] = new NdTimeInterval((NdIntegerInterval)ndIntervalArray[i]);
        }
    }

    private void WjIwVwA(NdInterval[] ndIntervalArray) {
        for (int i = 0; i < ndIntervalArray.length; ++i) {
            if (ndIntervalArray[i] == null) continue;
            ndIntervalArray[i] = ((NdTimeInterval)ndIntervalArray[i]).WjIwVvV;
        }
    }

    public NdIntervalType getIntervalType() {
        return TYPE;
    }

    public NdSingleInterval intersect(NdSingleInterval ndSingleInterval) {
        NdTimeInterval ndTimeInterval = (NdTimeInterval)ndSingleInterval;
        NdIntegerInterval ndIntegerInterval = (NdIntegerInterval)this.WjIwVvV.intersect(ndTimeInterval.WjIwVvV);
        return new NdTimeInterval(ndIntegerInterval);
    }

    public static NdTimeInterval makeUniversum() {
        return UNIVERSUM;
    }

    public boolean isEmpty() {
        return this.WjIwVvV.equivalent(NdTimeInterval.EMPTY.WjIwVvV);
    }

    public boolean isUniversum() {
        return this.WjIwVvV.equivalent(NdTimeInterval.UNIVERSUM.WjIwVvV);
    }

    public NdShape makeShape(WjIDdTC wjIDdTC) {
        return new NdVariableTimeInterval(wjIDdTC, this);
    }

    public boolean isDegenerate() {
        return false;
    }

    public boolean isEquality() {
        return this.WjIwVvV.getLeftBound() == this.WjIwVvV.getRightBound() && !this.WjIwVvV.isLeftOpen() && !this.WjIwVvV.isRightOpen();
    }

    public String toAnalyticalString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.WjIwVvV.isLeftOpen();
        boolean bl2 = this.WjIwVvV.isRightOpen();
        stringBuffer.append('(').append(string);
        if (this.isEquality()) {
            stringBuffer.append(" = ");
            stringBuffer.append(this.WjIwVvW);
        } else {
            stringBuffer.append(bl ? " > " : " >= ");
            stringBuffer.append(this.WjIwVvW);
            stringBuffer.append(") and (");
            stringBuffer.append(string);
            stringBuffer.append(bl2 ? " < " : " <= ");
            stringBuffer.append(this.WjIwVvX);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        long l = this.WjIwVvV.getLeftBound();
        long l2 = this.WjIwVvV.getRightBound();
        boolean bl = this.WjIwVvV.isLeftOpen();
        boolean bl2 = this.WjIwVvV.isRightOpen();
        if (l == l2 && !bl && !bl2) {
            stringBuffer.append("[").append(this.WjIwVvW).append("]");
        } else {
            stringBuffer.append(bl ? "(" : "[");
            stringBuffer.append(this.WjIwVvW);
            stringBuffer.append("; ");
            stringBuffer.append(this.WjIwVvX);
            stringBuffer.append(bl2 ? ")" : "]");
        }
        return stringBuffer.toString();
    }

    public boolean contains(NdTimeInterval ndTimeInterval) {
        return this.WjIwVvV.contains(ndTimeInterval.WjIwVvV);
    }

    public boolean eq(NdConstantTime ndConstantTime) {
        return this.WjIwVvV.eq(ndConstantTime.WjIDaaB());
    }

    public boolean eqSplit(NdConstantTime ndConstantTime, NdInterval[] ndIntervalArray) {
        boolean bl = this.WjIwVvV.eqSplit(ndConstantTime.WjIDaaB(), ndIntervalArray);
        this.WjIwVvZ(ndIntervalArray);
        return bl;
    }

    public boolean equivalent(NdTimeInterval ndTimeInterval) {
        return this.WjIwVvV.equivalent(ndTimeInterval.WjIwVvV);
    }

    public NdConstantTime getLeftBound() {
        return this.WjIwVvW;
    }

    public NdConstantTime getRightBound() {
        return this.WjIwVvX;
    }

    public boolean gt(NdConstantTime ndConstantTime) {
        return this.WjIwVvV.gt(ndConstantTime.WjIDaaB());
    }

    public boolean gte(NdConstantTime ndConstantTime) {
        return this.WjIwVvV.gte(ndConstantTime.WjIDaaB());
    }

    public boolean gteSplit(NdConstantTime ndConstantTime, NdInterval[] ndIntervalArray) {
        boolean bl = this.WjIwVvV.gteSplit(ndConstantTime.WjIDaaB(), ndIntervalArray);
        this.WjIwVvZ(ndIntervalArray);
        return bl;
    }

    public boolean gtSplit(NdConstantTime ndConstantTime, NdInterval[] ndIntervalArray) {
        boolean bl = this.WjIwVvV.gtSplit(ndConstantTime.WjIDaaB(), ndIntervalArray);
        this.WjIwVvZ(ndIntervalArray);
        return bl;
    }

    public boolean intersects(NdTimeInterval ndTimeInterval) {
        return this.WjIwVvV.intersects(ndTimeInterval.WjIwVvV);
    }

    void WjIwVxB(NdTimeInterval ndTimeInterval, NdInterval[] ndIntervalArray) {
        this.WjIwVwA(ndIntervalArray);
        this.WjIwVvV.WjIwOoO(ndTimeInterval.WjIwVvV, ndIntervalArray);
        this.WjIwVvZ(ndIntervalArray);
    }

    public boolean isLeftInfinite() {
        return this.WjIwVvV.isLeftInfinite();
    }

    public boolean isLeftMin() {
        return this.WjIwVvW.WjICZaW() && !this.WjIwVvV.isLeftOpen();
    }

    public boolean isRightMax() {
        return this.WjIwVvX.WjICZaX() && !this.WjIwVvV.isRightOpen();
    }

    public boolean isLeftOpen() {
        return this.WjIwVvV.isLeftOpen();
    }

    public boolean isRightInfinite() {
        return this.WjIwVvV.isRightInfinite();
    }

    public boolean isRightOpen() {
        return this.WjIwVvV.isRightOpen();
    }

    public boolean lt(NdConstantTime ndConstantTime) {
        return this.WjIwVvV.lt(ndConstantTime.WjIDaaB());
    }

    public boolean lte(NdConstantTime ndConstantTime) {
        return this.WjIwVvV.lte(ndConstantTime.WjIDaaB());
    }

    public boolean lteSplit(NdConstantTime ndConstantTime, NdInterval[] ndIntervalArray) {
        boolean bl = this.WjIwVvV.lteSplit(ndConstantTime.WjIDaaB(), ndIntervalArray);
        this.WjIwVvZ(ndIntervalArray);
        return bl;
    }

    public boolean ltSplit(NdConstantTime ndConstantTime, NdInterval[] ndIntervalArray) {
        boolean bl = this.WjIwVvV.ltSplit(ndConstantTime.WjIDaaB(), ndIntervalArray);
        this.WjIwVvZ(ndIntervalArray);
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && object instanceof NdTimeInterval) {
            NdTimeInterval ndTimeInterval = (NdTimeInterval)object;
            bl = this.WjIwVvV.equals(ndTimeInterval.WjIwVvV);
        }
        return bl;
    }

    public int hashCode() {
        return this.WjIwVvV.hashCode();
    }
}

