/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.polyhedra;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.cfa.spatial.NdBasis;
import com.blazesoft.verifier.cfa.spatial.NdConstraint;
import com.blazesoft.verifier.cfa.spatial.NdLinearTerm;
import com.blazesoft.verifier.cfa.spatial.NdShape;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdIncompatibleDimensionException;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdIntegerMatrix;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedralConstraint;
import com.blazesoft.verifier.predicate.NdOperator;
import java.util.List;
import java.util.NoSuchElementException;

public class NdImplicitDef
extends NdIntegerMatrix
implements NdConstraint {
    public static final int EQUATION = 0;
    public static final int INEQUALITY = 1;
    public static final int STRICT_INEQUALITY = 2;
    static final long WjIwMHU = 0L;
    static final long WjIwMIV = 1L;
    private static boolean WjIwMJW = true;
    static final int WjIwMKX = 10;
    int WjIwMLY = 0;

    NdImplicitDef(int n, int n2) {
        super(n, n2 + 1);
    }

    NdImplicitDef(long[][] lArray, int n, int n2) {
        super(lArray, n, n2 + 1);
    }

    public boolean isDenseLinearOrder() {
        return false;
    }

    public boolean isDiscreet() {
        return false;
    }

    public boolean isPolyhedral() {
        return true;
    }

    public boolean isValid() {
        boolean bl = true;
        if (this._numRows == 0) {
            bl = false;
        } else {
            for (int i = 0; i < this._numRows; ++i) {
                boolean bl2 = false;
                for (int j = 1; j < this._numCols; ++j) {
                    if (this.elements[i][j] == 0L) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    final void WjIwMMZ(int n) {
        if (n < 0 || n >= this.getNumAllocatedRows()) {
            throw new NoSuchElementException();
        }
        if (this._numRows <= n) {
            this.setNumRows(n + 1);
        }
    }

    private void WjIwMNA(long[] lArray) {
        for (int i = 1; i < this._numCols; ++i) {
            lArray[i] = -lArray[i];
        }
    }

    private boolean WjIwMNB(long[] lArray) {
        boolean bl = true;
        for (int i = 1; i < this._numCols - 1; ++i) {
            if (lArray[i] == 0L) continue;
            bl = false;
            break;
        }
        return bl && lArray[this._numCols - 1] == 1L;
    }

    public static long[] prepareCoefficients(NdBasis ndBasis, List list) {
        long[] lArray = new long[ndBasis.getDimension() + 1];
        int n = ndBasis.getLinearPrecisionMultiplier() * 10;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            int n3;
            NdLinearTerm ndLinearTerm = (NdLinearTerm)list.get(i);
            if (ndLinearTerm.x == null) {
                lArray[lArray.length - 1] = Math.round(ndLinearTerm.a * (double)n);
                continue;
            }
            int n4 = n3 = ndBasis.getVariableIndex(ndLinearTerm.x.WjIDbiT);
            lArray[n4] = lArray[n4] + Math.round(ndLinearTerm.a * (double)n);
        }
        return lArray;
    }

    void WjIyaKO(NdBasis ndBasis, boolean bl) {
        int n = ndBasis.getLinearPrecisionMultiplier() * 10;
        int n2 = bl ? this.getNumRows() - 1 : this.getNumRows();
        int n3 = this.getNumCols();
        for (int i = 0; i < n2; ++i) {
            int n4;
            boolean bl2 = true;
            for (n4 = 1; n4 < n3; ++n4) {
                if (this.elements[i][n4] == 0L || Math.abs(this.elements[i][n4]) >= (long)n || this.elements[i][0] != 0L && NdImplicitDef.WjIwMNH(this.elements[i][n3 - 1], n)) continue;
                bl2 = false;
                break;
            }
            if (bl2) continue;
            for (n4 = 1; n4 < n3; ++n4) {
                this.elements[i][n4] = this.elements[i][n4] * (long)n;
            }
        }
    }

    void WjIyaKP(NdBasis ndBasis, int n) {
        int n2 = ndBasis.getLinearPrecisionMultiplier() * 10;
        int n3 = this.getNumCols();
        if (this.elements[n][0] != 0L) {
            int n4;
            boolean bl = true;
            for (n4 = 1; n4 < n3; ++n4) {
                if (this.elements[n][n4] == 0L || Math.abs(this.elements[n][n4]) >= (long)n2) continue;
                bl = false;
                break;
            }
            if (!bl) {
                for (n4 = 1; n4 < n3; ++n4) {
                    this.elements[n][n4] = this.elements[n][n4] * (long)n2;
                }
            }
        }
    }

    public int getDimension() {
        return this.getNumCols() - 1;
    }

    public long[] getConstraint(int n) {
        if (n < 0 || n >= this.getNumRows()) {
            throw new NoSuchElementException();
        }
        return this.elements[n];
    }

    public void negateConstraint(int n) {
        if (n < 0 || n >= this.getNumRows()) {
            throw new NoSuchElementException();
        }
        this.WjIwMNA(this.elements[n]);
    }

    public boolean isEquation(int n) {
        return this.getConstraint(n)[0] == 0L;
    }

    public boolean isInequality(int n) {
        return this.getConstraint(n)[0] == 1L;
    }

    public boolean isStrictInequality(NdBasis ndBasis, int n) {
        boolean bl;
        if (this.getConstraint(n)[0] == 1L) {
            int n2 = ndBasis.getLinearPrecisionMultiplier() * 10;
            int n3 = this.getNumCols();
            bl = false;
            for (int i = 1; i < n3; ++i) {
                if (Math.abs(this.elements[n][i]) >= (long)n2) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public int getSize() {
        return this.getNumRows();
    }

    public void setConstraintsNumber(int n) {
        if (n < 0 || n > this.getNumRows()) {
            throw new NoSuchElementException();
        }
        this.setNumRows(n);
    }

    public void setFreeCoefficient(int n, long l) {
        this.setCoefficient(n, this.getNumCols() - 2, l);
    }

    final void WjIwMND(int n, long l) {
        this.elements[n][this._numCols - 1] = l;
    }

    public void setVarCoefficients(int n, long l) {
        this.WjIwMMZ(n);
        for (int i = 1; i < this.getNumCols() - 1; ++i) {
            this.elements[n][i] = l;
        }
    }

    public void setCoefficient(int n, int n2, long l) {
        if (n2 < 0 || n2 >= this.getNumCols() - 1) {
            throw new NoSuchElementException();
        }
        this.WjIwMMZ(n);
        this.elements[n][n2 + 1] = l;
    }

    final void WjIwMNE(int n, int n2, long l) {
        this.elements[n][n2 + 1] = l;
    }

    public void setEquation(int n) {
        this.WjIwMMZ(n);
        this.elements[n][0] = 0L;
    }

    final void WjIwMNF(int n) {
        this.elements[n][0] = 0L;
    }

    public void setInequality(int n) {
        this.WjIwMMZ(n);
        this.elements[n][0] = 1L;
    }

    final void WjIwMNG(int n) {
        this.elements[n][0] = 1L;
    }

    public void addConstraint(long[] lArray, int n, int n2, int n3) throws NdIncompatibleDimensionException {
        long[] lArray2 = new long[n2 + 1];
        lArray2[0] = n3 == 0 ? 0L : 1L;
        System.arraycopy(lArray, n, lArray2, 1, n2);
        if (n3 == 2) {
            int n4 = lArray2.length - 1;
            lArray2[n4] = lArray2[n4] - 1L;
        }
        super.addRow(lArray2, lArray2.length);
    }

    public void addConstraints(NdImplicitDef ndImplicitDef) throws NdIncompatibleDimensionException {
        NdBaseObject.advAssertNonNull((Object)ndImplicitDef);
        super.appendElements(ndImplicitDef.elements, ndImplicitDef._numRows, ndImplicitDef._numCols);
    }

    public boolean isPositivityConstraint(int n) {
        if (n >= 0 && n < this.getNumRows()) {
            return this.WjIwMNB(this.elements[n]);
        }
        return false;
    }

    static boolean WjIwMNH(long l, int n) {
        double d;
        double d2 = Math.abs((double)l / 10.0);
        double d3 = d2 - (d = Math.rint(d2));
        return d3 != 0.0;
    }

    static long WjIwMNI(long l, int n) {
        double d = (double)l / 10.0;
        return Math.round(d) * 10L;
    }

    public NdShape[] getElements(NdBasis ndBasis) {
        int n = this.getNumRows();
        int n2 = this.getNumCols();
        int n3 = ndBasis.getLinearPrecisionMultiplier() * 10;
        int n4 = -1;
        for (int i = n - 1; i >= 0; --i) {
            if (!this.WjIwMNB(this.elements[i])) continue;
            n4 = i;
            break;
        }
        NdShape[] ndShapeArray = n4 == -1 ? new NdShape[n] : new NdShape[n - 1];
        for (int i = 0; i < n; ++i) {
            if (i == n4) continue;
            double[] dArray = new double[n2 - 1];
            boolean bl = false;
            for (int j = 1; j < n2; ++j) {
                dArray[j - 1] = (double)this.elements[i][j] / (double)n3;
            }
            if (NdImplicitDef.WjIwMNH(this.elements[i][n2 - 1], n3)) {
                if (WjIwMJW) {
                    dArray[n2 - 2] = (double)NdImplicitDef.WjIwMNI(this.elements[i][n2 - 1], n3) / (double)n3;
                }
                bl = true;
            }
            NdOperator ndOperator = this.elements[i][0] == 0L ? NdOperator.WjICYSH : (bl ? NdOperator.WjICYSE : NdOperator.WjICYSF);
            ndShapeArray[i] = new NdPolyhedralConstraint(ndBasis, dArray, ndOperator);
        }
        return ndShapeArray;
    }

    public String toAnalyticalString(NdBasis ndBasis) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = ndBasis.getLinearPrecisionMultiplier() * 10;
        boolean bl = false;
        int n2 = this.getNumRows();
        int n3 = this.getNumCols();
        double[] dArray = new double[n3];
        for (int i = 0; i < n2; ++i) {
            int n4;
            int n5;
            for (n5 = 1; n5 < n3; ++n5) {
                dArray[n5] = this.elements[i][n5];
            }
            if (this.WjIwMNB(this.elements[i])) continue;
            n5 = 0;
            if (this.elements[i][0] != 0L) {
                int n6;
                n4 = 0;
                for (n6 = 1; n6 < n3; ++n6) {
                    if (Math.abs(this.elements[i][n6]) < (long)n) continue;
                    n4 = 1;
                    break;
                }
                for (n6 = 1; n6 < n3; ++n6) {
                    dArray[n6] = n4 != 0 ? (double)this.elements[i][n6] / (double)n : (double)this.elements[i][n6];
                }
                if (NdImplicitDef.WjIwMNH(this.elements[i][n3 - 1], n)) {
                    if (WjIwMJW) {
                        dArray[n3 - 1] = (double)NdImplicitDef.WjIwMNI(this.elements[i][n3 - 1], n) / (double)n;
                    }
                    n5 = 1;
                }
            }
            if (bl) {
                stringBuffer.append(" and ");
            }
            bl = true;
            for (n4 = 1; n4 < n3; ++n4) {
                if (n4 < n3 - 1 && dArray[n4] != 0.0) {
                    if (dArray[n4] == 1.0) {
                        stringBuffer.append(ndBasis.getVariable(n4 - 1));
                    } else if (dArray[n4] == -1.0) {
                        stringBuffer.append('-').append(ndBasis.getVariable(n4 - 1));
                    } else {
                        stringBuffer.append(dArray[n4]).append('*').append(ndBasis.getVariable(n4 - 1));
                    }
                    stringBuffer.append(dArray[n4 + 1] >= 0.0 ? " + " : " ");
                    continue;
                }
                if (n4 != n3 - 1) continue;
                stringBuffer.append(dArray[n4]);
                if (this.elements[i][0] == 0L) {
                    stringBuffer.append(" = 0");
                    continue;
                }
                if (n5 != 0) {
                    stringBuffer.append(" > 0");
                    continue;
                }
                stringBuffer.append(" >= 0");
            }
        }
        return stringBuffer.toString();
    }

    public String toAnalyticalString1(NdBasis ndBasis) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = ndBasis.getLinearPrecisionMultiplier() * 10;
        boolean bl = false;
        int n2 = this.getNumRows();
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4;
            double[] dArray = new double[this.elements[i].length];
            for (n4 = 1; n4 < this.elements[i].length; ++n4) {
                dArray[n4] = this.elements[i][n4];
            }
            if (this.WjIwMNB(this.elements[i])) continue;
            n4 = 0;
            if (this.elements[i][0] != 0L) {
                for (n3 = 1; n3 < this.elements[i].length; ++n3) {
                    dArray[n3] = Math.abs(this.elements[i][n3]) >= (long)n ? (double)this.elements[i][n3] / (double)n : (double)this.elements[i][n3];
                }
                if (NdImplicitDef.WjIwMNH(this.elements[i][dArray.length - 1], n)) {
                    if (WjIwMJW) {
                        dArray[dArray.length - 1] = (double)NdImplicitDef.WjIwMNI(this.elements[i][dArray.length - 1], n) / (double)n;
                    }
                    n4 = 1;
                }
            }
            if (bl) {
                stringBuffer.append(" and ");
            }
            bl = true;
            n3 = this.getNumCols();
            for (int j = 1; j < n3; ++j) {
                if (j < n3 - 1 && dArray[j] != 0.0) {
                    if (dArray[j] == 1.0) {
                        stringBuffer.append(ndBasis.getVariable(j - 1));
                    } else if (dArray[j] == -1.0) {
                        stringBuffer.append('-').append(ndBasis.getVariable(j - 1));
                    } else {
                        stringBuffer.append(dArray[j]).append('*').append(ndBasis.getVariable(j - 1));
                    }
                    if (j < n3 - 3) {
                        stringBuffer.append(dArray[j + 1] >= 0.0 ? " + " : " ");
                        continue;
                    }
                    if (j != n3 - 3) continue;
                    stringBuffer.append(" ");
                    continue;
                }
                if (j != n3 - 1) continue;
                if (dArray[j] > 0.0) {
                    stringBuffer.append(" + ").append(dArray[j]);
                    continue;
                }
                if (!(dArray[j] < 0.0)) continue;
                stringBuffer.append(" + ").append(dArray[j]);
            }
            if (this.elements[i][0] == 0L) {
                stringBuffer.append(" = 0");
                continue;
            }
            if (n4 != 0) {
                stringBuffer.append(" > 0");
                continue;
            }
            stringBuffer.append(" >= 0");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getNumRows();
        int n2 = this.getNumCols();
        stringBuffer.append("Constraints ").append(n).append(" ").append(n2 - 1).append("\n");
        for (int i = 0; i < n; ++i) {
            if (this.elements[i][0] == 1L) {
                stringBuffer.append("Inequality: [");
            } else {
                stringBuffer.append("Equality:   [");
            }
            for (int j = 1; j < n2; ++j) {
                stringBuffer.append(this.elements[i][j]).append(" ");
            }
            stringBuffer.append(" ]\n");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.getNumRows();
        int n3 = this.getNumCols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                n = (int)((long)n + this.elements[i][j]);
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof NdImplicitDef) {
            NdIntegerMatrix ndIntegerMatrix = this;
            NdIntegerMatrix ndIntegerMatrix2 = (NdIntegerMatrix)object;
            if (ndIntegerMatrix._numCols == ndIntegerMatrix2._numCols && ndIntegerMatrix._numRows == ndIntegerMatrix2._numRows) {
                ndIntegerMatrix = super.sort();
                ndIntegerMatrix2 = ((NdIntegerMatrix)object).sort();
                bl = ndIntegerMatrix.equals(ndIntegerMatrix2);
            }
        }
        return bl;
    }

    public NdIntegerMatrix sort() {
        NdIntegerMatrix ndIntegerMatrix = super.sort();
        NdImplicitDef ndImplicitDef = new NdImplicitDef(ndIntegerMatrix.getNumRows(), ndIntegerMatrix.getNumCols() - 1);
        ndImplicitDef.elements = ndIntegerMatrix.elements;
        ndImplicitDef.setNumRows(ndIntegerMatrix.getNumRows());
        return ndImplicitDef;
    }
}

