/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.polyhedra;

import com.blazesoft.verifier.cfa.spatial.polyhedra.NdIntegerMatrix;

public class NdParametricDef
extends NdIntegerMatrix {
    public static final int INITIAL_ROWS = 10;
    public static final int LINE = 0;
    public static final int RAY = 1;
    int WjIwNOV;

    NdParametricDef(long[][] lArray, int n, int n2) {
        super(lArray, 10, n2 + 2);
        super.setNumRows(n);
        this.WjIwNOV = 0;
    }

    NdParametricDef(int n, int n2) {
        super(10, n2 + 2);
        super.setNumRows(n);
        this.WjIwNOV = 0;
    }

    public int getNumParams() {
        return super.getNumRows();
    }

    public int getDimension() {
        return super.getNumCols() - 2;
    }

    public void setRay(int n) {
        this.checkRowOrExtend(n);
        this.elements[n][0] = 1L;
    }

    public void setLine(int n) {
        this.checkRowOrExtend(n);
        this.elements[n][0] = 0L;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[").append(this.getNumParams()).append(" x ").append(this.getDimension()).append("]\n");
        int n = super.getNumCols();
        int n2 = super.getNumRows();
        for (int i = 0; i < n2; ++i) {
            long[] lArray = this.elements[i];
            if (lArray[0] != 0L) {
                if (lArray[n - 1] != 0L) {
                    stringBuffer.append(lArray[0]).append(": Vertex: [");
                } else {
                    stringBuffer.append(lArray[0]).append("Ray:    [");
                }
            } else {
                stringBuffer.append(lArray[0]).append("Line:   [");
            }
            for (int j = 1; j < n - 1; ++j) {
                stringBuffer.append(lArray[j]).append("\t");
            }
            if (lArray[n - 1] != 0L) {
                stringBuffer.append(" ]/");
                stringBuffer.append(lArray[n - 1]);
                stringBuffer.append("\n");
                continue;
            }
            stringBuffer.append(" ]\n");
        }
        return stringBuffer.toString();
    }
}

