/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.polyhedra;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.cfa.spatial.NdBasis;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdImplicitDef;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdIncompatibleDimensionException;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedraException;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedraFactory;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedron;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class NdPolyhedraDomain {
    private final List WjIwOHQ;
    private final NdBasis WjIwOHR;
    private NdPolyhedraFactory WjIwOHS = NdPolyhedraFactory.getInstance();

    public NdPolyhedraDomain(NdBasis ndBasis) {
        NdBaseObject.advAssertNonNull((Object)ndBasis);
        this.WjIwOHR = ndBasis;
        this.WjIwOHQ = new ArrayList();
    }

    public NdPolyhedraDomain(NdPolyhedron ndPolyhedron) {
        NdBaseObject.advAssert((ndPolyhedron != null ? 1 : 0) != 0);
        this.WjIwOHR = ndPolyhedron.getBasis();
        this.WjIwOHQ = new ArrayList();
        this.WjIwOHQ.add(ndPolyhedron);
    }

    public NdBasis getBasis() {
        return this.WjIwOHR;
    }

    private void WjIwOHT(NdPolyhedron ndPolyhedron) {
        this.WjIwOHQ.add(ndPolyhedron);
    }

    public NdPolyhedron addUniversum() {
        NdPolyhedron ndPolyhedron = NdPolyhedron.makeUniversePolyhedron(this.WjIwOHR);
        this.WjIwOHT(ndPolyhedron);
        return ndPolyhedron;
    }

    public boolean isEmpty() {
        int n = this.WjIwOHQ.size();
        return n == 0 || n == 1 && ((NdPolyhedron)this.WjIwOHQ.get(0)).isEmptySet();
    }

    public boolean isUniversum() {
        int n = this.WjIwOHQ.size();
        return n == 0 || n == 1 && ((NdPolyhedron)this.WjIwOHQ.get(0)).isUniversum();
    }

    public List getPolyhedrons() {
        return this.WjIwOHQ;
    }

    public NdPolyhedron addPolyhedron(NdImplicitDef ndImplicitDef) throws NdPolyhedraException {
        NdPolyhedron ndPolyhedron = NdPolyhedron.makePolyhedron(this.WjIwOHR, ndImplicitDef);
        this.WjIwOHT(ndPolyhedron);
        return ndPolyhedron;
    }

    public int getSize() {
        return this.WjIwOHQ.size();
    }

    public NdPolyhedron getPolyhedron(int n) {
        return (NdPolyhedron)this.WjIwOHQ.get(n);
    }

    public NdPolyhedraDomain intersect(NdPolyhedraDomain ndPolyhedraDomain) throws NdPolyhedraException {
        NdPolyhedraDomain ndPolyhedraDomain2 = new NdPolyhedraDomain(this.WjIwOHR);
        if (ndPolyhedraDomain != null) {
            if (ndPolyhedraDomain.WjIwOHR.getDimension() != this.WjIwOHR.getDimension()) {
                throw new NdIncompatibleDimensionException(this.WjIwOHR.getDimension(), ndPolyhedraDomain.WjIwOHR.getDimension());
            }
            int n = this.WjIwOHQ.size();
            int n2 = ndPolyhedraDomain.getSize();
            if (n > 0 && n2 > 0) {
                for (int i = 0; i < n; ++i) {
                    NdPolyhedron ndPolyhedron = (NdPolyhedron)this.WjIwOHQ.get(i);
                    for (int j = 0; j < n2; ++j) {
                        NdPolyhedron ndPolyhedron2 = ndPolyhedraDomain.getPolyhedron(j);
                        NdPolyhedron ndPolyhedron3 = ndPolyhedron.addConstraints(ndPolyhedron2.getConstraints());
                        if (ndPolyhedron3.isEmptySet()) continue;
                        ndPolyhedraDomain2.WjIwOHT(ndPolyhedron3);
                    }
                }
            }
        }
        return ndPolyhedraDomain2;
    }

    public void split(NdImplicitDef ndImplicitDef) throws NdPolyhedraException {
        ArrayList<NdPolyhedron> arrayList = new ArrayList<NdPolyhedron>();
        int n = this.WjIwOHQ.size();
        if (n > 0) {
            ListIterator listIterator = this.WjIwOHQ.listIterator();
            while (listIterator.hasNext()) {
                NdPolyhedron ndPolyhedron = (NdPolyhedron)listIterator.next();
                boolean bl = false;
                int n2 = ndImplicitDef.getSize();
                for (int i = 0; i < n2; ++i) {
                    if (ndImplicitDef.isPositivityConstraint(i)) continue;
                    NdPolyhedron ndPolyhedron2 = ndPolyhedron.WjIwNTT(ndImplicitDef.getConstraint(i), ndImplicitDef.getNumCols());
                    if (!(ndPolyhedron2.isEmptySet() || ndPolyhedron.equals(ndPolyhedron2) || ndPolyhedron2.isDegeneratedInteger(ndImplicitDef, i))) {
                        arrayList.add(ndPolyhedron2);
                        bl = true;
                    } else {
                        this.WjIwOHS.recyclePolyhedron(ndPolyhedron2);
                    }
                    ndPolyhedron2 = ndPolyhedron.WjIwNTU(ndImplicitDef.getConstraint(i), true, true);
                    if (!(ndPolyhedron2.isEmptySet() || ndPolyhedron.equals(ndPolyhedron2) || ndPolyhedron2.isDegeneratedInteger(ndImplicitDef, i))) {
                        arrayList.add(ndPolyhedron2);
                        bl = true;
                    } else {
                        this.WjIwOHS.recyclePolyhedron(ndPolyhedron2);
                    }
                    if (!ndImplicitDef.isEquation(i)) continue;
                    ndImplicitDef.setInequality(i);
                    ndPolyhedron2 = ndPolyhedron.WjIwNTU(ndImplicitDef.getConstraint(i), false, true);
                    ndImplicitDef.setEquation(i);
                    if (!(ndPolyhedron2.isEmptySet() || ndPolyhedron.equals(ndPolyhedron2) || ndPolyhedron2.isDegeneratedInteger(ndImplicitDef, i))) {
                        arrayList.add(ndPolyhedron2);
                        bl = true;
                        continue;
                    }
                    this.WjIwOHS.recyclePolyhedron(ndPolyhedron2);
                }
                if (bl) {
                    listIterator.remove();
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    listIterator.add(iterator.next());
                }
                arrayList.clear();
            }
        }
    }

    public NdPolyhedraDomain splitOut(NdImplicitDef ndImplicitDef) throws NdPolyhedraException {
        NdPolyhedraDomain ndPolyhedraDomain = new NdPolyhedraDomain(this.WjIwOHR);
        ndPolyhedraDomain.WjIwOHQ.addAll(this.WjIwOHQ);
        ndPolyhedraDomain.split(ndImplicitDef);
        return ndPolyhedraDomain;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.WjIwOHQ.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next()).append("\n");
        }
        return stringBuffer.toString();
    }
}

