/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.polyhedra;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.cfa.spatial.NdBasis;
import com.blazesoft.verifier.cfa.spatial.NdBasisImpl;
import com.blazesoft.verifier.cfa.spatial.NdConvexShape;
import com.blazesoft.verifier.cfa.spatial.NdShape;
import com.blazesoft.verifier.cfa.spatial.NdShapeException;
import com.blazesoft.verifier.cfa.spatial.NdShapeVisitor;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdImplicitDef;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdIncompatibleDimensionException;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdIntegerMatrix;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdIntegerVector;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdOverflowException;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdParametricDef;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedraException;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedraFactory;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdSatMatrix;
import com.blazesoft.verifier.predicate.NdConstantReal;
import com.blazesoft.verifier.predicate.WjIDdTC;
import com.blazesoft.verifier.util.NdVerifierLog;

public class NdPolyhedron
implements NdConvexShape {
    public static final String POLYHEDRON = "Polyhedron";
    public static final String MAKE_DUAL = "ChernikovaNV";
    public static final String MINIMIZE = "Minimize";
    public static final int WORD_SIZE = 32;
    public static final int MSB = Integer.MIN_VALUE;
    private static final NdPolyhedraFactory WjIwNTI = NdPolyhedraFactory.getInstance();
    private NdImplicitDef WjIwNTJ;
    private NdParametricDef WjIwNTK;
    private NdBasis WjIwNTL;
    private int WjIwNTM;
    private boolean WjIwNTN;
    private boolean WjIAwvO;

    private NdPolyhedron(NdBasis ndBasis, int n, int n2) {
        NdBaseObject.advAssertNonNull((Object)ndBasis);
        this.WjIwNTL = ndBasis;
        this.WjIwNTJ = WjIwNTI.getImplicitDef(n, ndBasis.getDimension() + 1);
        this.WjIwNTK = WjIwNTI.getParametricDef(n2, ndBasis.getDimension());
        this.WjIwNTN = false;
        this.WjIAwvO = false;
    }

    NdPolyhedron(NdBasis ndBasis) {
        NdBaseObject.advAssertNonNull((Object)ndBasis);
        this.WjIwNTL = ndBasis;
        this.WjIwNTN = false;
        this.WjIAwvO = false;
    }

    public void setImmutable() {
        this.WjIAwvO = true;
    }

    public boolean isImmutable() {
        return this.WjIAwvO;
    }

    public Object accept(NdShapeVisitor ndShapeVisitor, Object object) throws NdShapeException {
        return ndShapeVisitor.visit(this, object);
    }

    public NdShape[] getElements() {
        NdShape[] ndShapeArray = this.isEmptySet() ? NdShape.NO_ELEMENTS : (this.isUniversum() ? NdShape.NO_ELEMENTS : this.WjIwNTJ.getElements(this.WjIwNTL));
        return ndShapeArray;
    }

    public NdConvexShape cloneMe() {
        NdPolyhedron ndPolyhedron = new NdPolyhedron(this.WjIwNTL, this.WjIwNTJ.getNumRows(), this.WjIwNTK.getNumRows());
        try {
            ndPolyhedron.WjIwNTJ.copyMatrix(this.WjIwNTJ, this.WjIwNTJ._numRows);
            ndPolyhedron.WjIwNTJ.WjIwMLY = this.WjIwNTJ.WjIwMLY;
            ndPolyhedron.WjIwNTK.copyMatrix(this.WjIwNTK, this.WjIwNTK._numRows);
            ndPolyhedron.WjIwNTK.WjIwNOV = this.WjIwNTK.WjIwNOV;
        }
        catch (NdIncompatibleDimensionException ndIncompatibleDimensionException) {
            // empty catch block
        }
        return ndPolyhedron;
    }

    public boolean isDegenerate() {
        return false;
    }

    public boolean isDegeneratedInteger(NdImplicitDef ndImplicitDef, int n) {
        int n2;
        boolean bl = false;
        int n3 = this.WjIwNTL.getLinearPrecisionMultiplier() * 10;
        int n4 = ndImplicitDef.getDimension() - 1;
        long[] lArray = ndImplicitDef.getConstraint(n);
        boolean bl2 = true;
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            if (lArray[n2 + 1] != 0L && this.WjIwNTL.getVariable(n2).WjICXCU() == NdConstantReal.WjIDgkX) {
                bl2 = false;
                break;
            }
            if (n5 != 0 || lArray[n2 + 1] == 0L) continue;
            n5 = n2 + 1;
        }
        if (bl2) {
            n2 = this.WjIwNTJ.getNumRows();
            long[][] lArrayArray = new long[2][];
            int n6 = 0;
            for (int i = 0; i < n2; ++i) {
                long l;
                int n7;
                boolean bl3;
                if (!this.WjIwNTJ.isInequality(i)) continue;
                long[] lArray2 = this.WjIwNTJ.getConstraint(i);
                boolean bl4 = true;
                boolean bl5 = bl3 = lArray2[n5] != lArray[n5] && Math.abs(lArray2[n5]) == Math.abs(lArray[n5]);
                if (bl3) {
                    for (n7 = 1; n7 <= n4; ++n7) {
                        if (-lArray2[n7] == lArray[n7]) continue;
                        bl4 = false;
                        break;
                    }
                } else {
                    for (n7 = 1; n7 <= n4; ++n7) {
                        if (lArray2[n7] == lArray[n7]) continue;
                        bl4 = false;
                        break;
                    }
                }
                if (!bl4) continue;
                lArrayArray[n6++] = lArray2;
                if (n6 != 2) continue;
                if (!NdImplicitDef.WjIwMNH(lArrayArray[0][n4 + 1], n3) || !NdImplicitDef.WjIwMNH(lArrayArray[1][n4 + 1], n3)) break;
                n7 = 0;
                for (int j = 1; j <= n4; ++j) {
                    if (lArrayArray[0][j] == 0L) continue;
                    ++n7;
                }
                if (n7 != 1 || (l = lArrayArray[0][1] != lArrayArray[1][1] ? Math.abs(lArrayArray[0][n4 + 1] + lArrayArray[1][n4 + 1]) : Math.abs(lArrayArray[0][n4 + 1] - lArrayArray[1][n4 + 1])) > (long)n3) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private static void WjIwNTO(NdIntegerMatrix ndIntegerMatrix, NdSatMatrix ndSatMatrix, int n, int n2, int[] nArray, int[] nArray2, int n3, int n4) {
        int n5 = n;
        int n6 = n;
        int n7 = n2;
        while (n7 > n5) {
            if (ndIntegerMatrix.elements[n5][0] == 0L) {
                ndIntegerMatrix.WjIwMjQ(n6, n5);
                ndSatMatrix.WjIwIFN(n6, n5);
                ++n6;
                ++n5;
                continue;
            }
            int[] nArray3 = ndSatMatrix.WjIwICK[n5];
            int n8 = n4;
            nArray3[n8] = nArray3[n8] | n3;
            if (ndIntegerMatrix.elements[n5][0] < 0L) {
                ndIntegerMatrix.WjIwMjQ(--n7, n5);
                ndSatMatrix.WjIwIFN(n7, n5);
                continue;
            }
            ++n5;
        }
        nArray2[0] = n5;
        nArray[0] = n6;
    }

    private static void WjIwNTP(NdIntegerMatrix ndIntegerMatrix, NdIntegerMatrix ndIntegerMatrix2, NdSatMatrix ndSatMatrix, int n, int n2, boolean bl) throws NdPolyhedraException {
        if (NdVerifierLog.isTraceEnabled(MAKE_DUAL)) {
            NdVerifierLog.trace(MAKE_DUAL, "[_makeDual Input]\nDual = " + ndIntegerMatrix2);
            NdVerifierLog.trace(MAKE_DUAL, "\nImplicit = " + ndIntegerMatrix);
            NdVerifierLog.trace(MAKE_DUAL, "\nSat = " + ndSatMatrix);
        }
        int n3 = ndIntegerMatrix.getNumCols() - 1;
        int n4 = ndSatMatrix.WjIwIEM;
        int n5 = ndIntegerMatrix.getNumRows();
        int n6 = n2 / 32;
        int n7 = Integer.MIN_VALUE >>> n2 % 32;
        for (int i = n2; i < n5; ++i) {
            int n8;
            Object[] objectArray;
            int n9;
            int n10 = ndIntegerMatrix2.getNumRows();
            for (n9 = 0; n9 < ndIntegerMatrix2.getNumRows(); ++n9) {
                objectArray = ndIntegerMatrix2.elements[n9];
                long[] lArray = ndIntegerMatrix.elements[i];
                objectArray[0] = 0L;
                for (n8 = 1; n8 <= n3; ++n8) {
                    objectArray[0] = objectArray[0] + objectArray[n8] * lArray[n8];
                }
                if (objectArray[0] == 0L || n9 >= n10) continue;
                n10 = n9;
            }
            if (NdVerifierLog.isTraceEnabled(MAKE_DUAL)) {
                NdVerifierLog.trace(MAKE_DUAL, "[_makeDual: A]\nDual = " + ndIntegerMatrix2);
                NdVerifierLog.trace(MAKE_DUAL, "\nImplicit = " + ndIntegerMatrix);
                NdVerifierLog.trace(MAKE_DUAL, "\nSat = " + ndSatMatrix);
            }
            if (n10 < n) {
                int n11;
                if (--n != n10) {
                    ndIntegerMatrix2.WjIwMjQ(n10, n);
                }
                if (NdVerifierLog.isTraceEnabled(MAKE_DUAL)) {
                    int n12;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (n12 = 0; n12 <= n3; ++n12) {
                        stringBuffer.append(ndIntegerMatrix2.elements[n10][n12]).append(" ");
                    }
                    NdVerifierLog.trace(MAKE_DUAL, stringBuffer.toString());
                    stringBuffer.setLength(0);
                    for (n12 = 0; n12 <= n3; ++n12) {
                        stringBuffer.append(ndIntegerMatrix2.elements[n][n12]).append(" ");
                    }
                    NdVerifierLog.trace(MAKE_DUAL, stringBuffer.toString());
                }
                for (n9 = 0; n9 < n; ++n9) {
                    if (ndIntegerMatrix2.elements[n9][0] == 0L) continue;
                    NdIntegerVector.WjIwLEI(ndIntegerMatrix2.elements[n9], ndIntegerMatrix2.elements[n], ndIntegerMatrix2.elements[n9], 0, n3);
                }
                if (ndIntegerMatrix2.elements[n][0] < 0L) {
                    long[] lArray = ndIntegerMatrix2.elements[n];
                    for (int j = 0; j < n3 + 1; ++j) {
                        lArray[j] = -lArray[j];
                    }
                }
                if (NdVerifierLog.isTraceEnabled(MAKE_DUAL)) {
                    NdVerifierLog.trace(MAKE_DUAL, "[_makeDual: B]\nDual = " + ndIntegerMatrix2);
                    NdVerifierLog.trace(MAKE_DUAL, "\nImplicit = " + ndIntegerMatrix);
                    NdVerifierLog.trace(MAKE_DUAL, "\nSat = " + ndSatMatrix);
                }
                int n13 = ndIntegerMatrix2.getNumRows();
                for (n11 = n + 1; n11 < n13; ++n11) {
                    if (ndIntegerMatrix2.elements[n11][0] == 0L) continue;
                    NdIntegerVector.WjIwLEI(ndIntegerMatrix2.elements[n11], ndIntegerMatrix2.elements[n], ndIntegerMatrix2.elements[n11], 0, n3);
                }
                if (ndIntegerMatrix.elements[i][0] != 0L) {
                    for (n11 = 0; n11 < n4; ++n11) {
                        ndSatMatrix.WjIwICK[n][n11] = 0;
                    }
                    int[] nArray = ndSatMatrix.WjIwICK[n];
                    int n14 = n6;
                    nArray[n14] = nArray[n14] | n7;
                } else {
                    n13 = ndIntegerMatrix2.getNumRows() - 1;
                    ndIntegerMatrix2.setNumRows(n13);
                    NdIntegerVector.WjIwLDZ(ndIntegerMatrix2.elements[n13], ndIntegerMatrix2.elements[n], n3 + 1);
                    NdIntegerVector.WjIwLEA(ndSatMatrix.WjIwICK[n13], ndSatMatrix.WjIwICK[n], n4);
                }
                if (NdVerifierLog.isTraceEnabled(MAKE_DUAL)) {
                    NdVerifierLog.trace(MAKE_DUAL, "[_makeDual: C]\nDual = " + ndIntegerMatrix2);
                    NdVerifierLog.trace(MAKE_DUAL, "\nImplicit = " + ndIntegerMatrix);
                    NdVerifierLog.trace(MAKE_DUAL, "\nSat = " + ndSatMatrix);
                }
            } else {
                int n15;
                int[] nArray = new int[]{0};
                objectArray = new int[]{0};
                NdPolyhedron.WjIwNTO(ndIntegerMatrix2, ndSatMatrix, n, ndIntegerMatrix2.getNumRows(), (int[])objectArray, nArray, n7, n6);
                if (NdVerifierLog.isTraceEnabled(MAKE_DUAL)) {
                    NdVerifierLog.trace(MAKE_DUAL, "[_makeDual: D]\nDual = " + ndIntegerMatrix2);
                    NdVerifierLog.trace(MAKE_DUAL, "\nImplicit = " + ndIntegerMatrix);
                    NdVerifierLog.trace(MAKE_DUAL, "\nSat = " + ndSatMatrix);
                }
                int n16 = ndIntegerMatrix2.getNumRows();
                for (n8 = (int)objectArray[0]; n8 < nArray[0]; ++n8) {
                    for (n15 = nArray[0]; n15 < n16; ++n15) {
                        int n17;
                        int n18;
                        int n19;
                        int n20 = 0;
                        int[] nArray2 = new int[n4];
                        for (n19 = 0; n19 < n6; ++n19) {
                            nArray2[n19] = ndSatMatrix.WjIwICK[n8][n19] | ndSatMatrix.WjIwICK[n15][n19];
                            for (n18 = Integer.MIN_VALUE; n18 != 0; n18 >>>= 1) {
                                if ((nArray2[n19] & n18) != 0) continue;
                                ++n20;
                            }
                        }
                        nArray2[n6] = ndSatMatrix.WjIwICK[n8][n6] | ndSatMatrix.WjIwICK[n15][n6];
                        for (n19 = Integer.MIN_VALUE; n19 != n7; n19 >>>= 1) {
                            if ((nArray2[n6] & n19) != 0) continue;
                            ++n20;
                        }
                        int n21 = n19 = ndIntegerMatrix2.elements[n8][n3] == 0L && ndIntegerMatrix2.elements[n15][n3] == 0L && !bl ? 1 : 0;
                        if (n19 != 0) {
                            ++n20;
                        }
                        if (n20 + n < n3 - 2) continue;
                        boolean bl2 = false;
                        for (n18 = n; n18 < n16; ++n18) {
                            if (n18 == n8 || n18 == n15 || n19 != 0 && ndIntegerMatrix2.elements[n18][n3] != 0L) continue;
                            for (n17 = 0; n17 <= n6 && (ndSatMatrix.WjIwICK[n18][n17] & ~nArray2[n17]) == 0; ++n17) {
                            }
                            if (n17 <= n6) continue;
                            bl2 = true;
                            break;
                        }
                        if (NdVerifierLog.isTraceEnabled(MAKE_DUAL)) {
                            NdVerifierLog.trace(MAKE_DUAL, "[_makeDual: E]\nDual = " + ndIntegerMatrix2);
                            NdVerifierLog.trace(MAKE_DUAL, "\nImplicit = " + ndIntegerMatrix);
                            NdVerifierLog.trace(MAKE_DUAL, "\nSat = " + ndSatMatrix);
                        }
                        if (bl2) continue;
                        n17 = ndIntegerMatrix2.getNumRows();
                        ndIntegerMatrix2.checkRowOrExtend(n17);
                        ndSatMatrix.checkRowOrExtend(n17);
                        NdIntegerVector.WjIwLEI(ndIntegerMatrix2.elements[n15], ndIntegerMatrix2.elements[n8], ndIntegerMatrix2.elements[n17], 0, n3);
                        NdIntegerVector.WjIwLEH(ndSatMatrix.WjIwICK[n15], ndSatMatrix.WjIwICK[n8], ndSatMatrix.WjIwICK[n17], n4);
                        int[] nArray3 = ndSatMatrix.WjIwICK[n17];
                        int n22 = n6;
                        nArray3[n22] = nArray3[n22] & ~n7;
                        ndIntegerMatrix2.setNumRows(++n17);
                    }
                }
                if (NdVerifierLog.isTraceEnabled(MAKE_DUAL)) {
                    NdVerifierLog.trace(MAKE_DUAL, "[_makeDual F]\n");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("sup_bound=").append(nArray[0]).append("\n");
                    stringBuffer.append("equal_bound=").append((int)objectArray[0]).append("\n");
                    stringBuffer.append("bound=").append(n16).append("\n");
                    stringBuffer.append("num parameters=").append(ndIntegerMatrix2.getNumRows()).append("\n");
                    stringBuffer.append("dimension=").append(n3).append("\n");
                    NdVerifierLog.trace(MAKE_DUAL, stringBuffer.toString());
                    NdVerifierLog.trace(MAKE_DUAL, ndIntegerMatrix2.toString());
                }
                n15 = ndIntegerMatrix2.getNumRows();
                for (n8 = ndIntegerMatrix.elements[i][0] != 0L ? nArray[0] : (int)objectArray[0]; n8 < n16 && n15 > n16; ++n8) {
                    NdIntegerVector.WjIwLDZ(ndIntegerMatrix2.elements[--n15], ndIntegerMatrix2.elements[n8], n3 + 1);
                    NdIntegerVector.WjIwLEA(ndSatMatrix.WjIwICK[n15], ndSatMatrix.WjIwICK[n8], n4);
                }
                if (NdVerifierLog.isTraceEnabled(MAKE_DUAL)) {
                    NdVerifierLog.trace(MAKE_DUAL, "[_makeDual F]\n");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("sup_bound=").append(nArray[0]).append("\n");
                    stringBuffer.append("equal_bound=").append((int)objectArray[0]).append("\n");
                    stringBuffer.append("bound=").append(n16).append("\n");
                    stringBuffer.append("num parameters=").append(ndIntegerMatrix2.getNumRows()).append("\n");
                    stringBuffer.append("Dimension=").append(n3).append("\n");
                    NdVerifierLog.trace(MAKE_DUAL, stringBuffer.toString());
                    NdVerifierLog.trace(MAKE_DUAL, "[_makeDual G]\nRay=" + ndIntegerMatrix2.toString());
                }
                if (n8 == n16) {
                    ndIntegerMatrix2.setNumRows(n15);
                } else {
                    ndIntegerMatrix2.setNumRows(n8);
                }
            }
            if ((n7 >>>= 1) != 0) continue;
            n7 = Integer.MIN_VALUE;
            ++n6;
        }
        ndSatMatrix.WjIwIDL = ndIntegerMatrix2.getNumRows();
        if (NdVerifierLog.isTraceEnabled(MAKE_DUAL)) {
            NdVerifierLog.trace(MAKE_DUAL, "[_makeDual Output]\nDual = " + ndIntegerMatrix2.toString());
            NdVerifierLog.trace(MAKE_DUAL, "\nImplicit = " + ndIntegerMatrix.toString());
            NdVerifierLog.trace(MAKE_DUAL, "\nSat = " + ndSatMatrix.toString());
        }
    }

    private NdPolyhedron WjIwNTQ(NdIntegerMatrix ndIntegerMatrix, NdIntegerMatrix ndIntegerMatrix2, NdSatMatrix ndSatMatrix, int[] nArray) throws NdPolyhedraException {
        int n;
        int n2;
        int n3;
        long l;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = ndIntegerMatrix.getNumCols() - 1;
        int n11 = ndIntegerMatrix.getNumRows();
        int n12 = 0;
        int n13 = ndIntegerMatrix2.getNumRows();
        for (n9 = 0; n9 < n13; ++n9) {
            ndIntegerMatrix2.elements[n9][0] = 0L;
            if (ndIntegerMatrix2.elements[n9][n10] == 0L) continue;
            ++n12;
        }
        if (n12 == 0) {
            return NdPolyhedron.makeEmptyPolyhedron(this.WjIwNTL);
        }
        if (NdVerifierLog.isTraceEnabled(MINIMIZE)) {
            NdVerifierLog.trace(MINIMIZE, "[minimize: Start]\nImplicit = " + ndIntegerMatrix.printMatrix());
            NdVerifierLog.trace(MINIMIZE, "\nDual = " + ndIntegerMatrix2.printMatrix());
        }
        n9 = 0;
        int[] nArray2 = new int[n11];
        int[] nArray3 = new int[n11];
        int n14 = Integer.MIN_VALUE;
        int n15 = 0;
        for (n8 = 0; n8 < n11; ++n8) {
            nArray3[n8] = n15++;
            nArray2[n8] = n14;
            if ((n14 >>>= 1) != 0) continue;
            n14 = Integer.MIN_VALUE;
        }
        for (n15 = 0; n15 < n11; ++n15) {
            ndIntegerMatrix.elements[n15][0] = 0L;
            for (n8 = 1; n8 < n10 && ndIntegerMatrix.elements[n15][n8] == 0L; ++n8) {
            }
            if (n8 == n10) {
                for (n8 = 0; n8 < n13; ++n8) {
                    if ((ndSatMatrix.WjIwICK[n8][nArray3[n15]] & nArray2[n15]) != 0) continue;
                    long[] lArray = ndIntegerMatrix.elements[n15];
                    lArray[0] = lArray[0] + 1L;
                }
                if (ndIntegerMatrix.elements[n15][0] == (long)n13 && ndIntegerMatrix.elements[n15][n10] != 0L) {
                    return NdPolyhedron.makeEmptyPolyhedron(this.WjIwNTL);
                }
                if (n15 == --n11) continue;
                ndIntegerMatrix.WjIwMjQ(n15, n11);
                n7 = nArray3[n15];
                nArray3[n15] = nArray3[n11];
                nArray3[n11] = n7;
                n7 = nArray2[n15];
                nArray2[n15] = nArray2[n11];
                nArray2[n11] = n7;
                --n15;
                continue;
            }
            for (n8 = 0; n8 < n13; ++n8) {
                if ((ndSatMatrix.WjIwICK[n8][nArray3[n15]] & nArray2[n15]) != 0) continue;
                long[] lArray = ndIntegerMatrix.elements[n15];
                lArray[0] = lArray[0] + 1L;
                long[] lArray2 = ndIntegerMatrix2.elements[n8];
                lArray2[0] = lArray2[0] + 1L;
            }
            if (ndIntegerMatrix.elements[n15][0] != (long)n13) continue;
            ++n9;
        }
        ndIntegerMatrix.setNumRows(n11);
        n15 = 0;
        for (n8 = 0; n8 < n13; ++n8) {
            if (ndIntegerMatrix2.elements[n8][n10] == 0L) {
                long[] lArray = ndIntegerMatrix2.elements[n8];
                lArray[0] = lArray[0] + 1L;
            }
            if (ndIntegerMatrix2.elements[n8][0] != (long)(n11 + 1)) continue;
            ++n15;
        }
        if (NdVerifierLog.isTraceEnabled(MINIMIZE)) {
            NdVerifierLog.trace(MINIMIZE, "[minimize: A]\nImplicit = " + ndIntegerMatrix.printMatrix());
            NdVerifierLog.trace(MINIMIZE, "\nDual = " + ndIntegerMatrix2.printMatrix());
        }
        for (n8 = 0; n8 < n9; ++n8) {
            if (ndIntegerMatrix.elements[n8][0] == (long)n13) continue;
            for (n7 = n8 + 1; ndIntegerMatrix.elements[n7][0] != (long)n13 && n7 < n11; ++n7) {
            }
            NdBaseObject.advAssert((n7 < n11 ? 1 : 0) != 0);
            long[] lArray = ndIntegerMatrix.elements[n7];
            n6 = nArray3[n7];
            n5 = nArray2[n7];
            while (n7 > n8) {
                ndIntegerMatrix.elements[n7] = ndIntegerMatrix.elements[n7 - 1];
                nArray3[n7] = nArray3[n7 - 1];
                nArray2[n7] = nArray2[n7 - 1];
                --n7;
            }
            ndIntegerMatrix.elements[n7] = lArray;
            nArray3[n8] = n6;
            nArray2[n8] = n5;
        }
        if (NdVerifierLog.isTraceEnabled(MINIMIZE)) {
            NdVerifierLog.trace(MINIMIZE, "[minimize: B]\nImplicit = " + ndIntegerMatrix.printMatrix());
            NdVerifierLog.trace(MINIMIZE, "\nDual = " + ndIntegerMatrix2.printMatrix());
        }
        if ((n8 = ndIntegerMatrix.gaussElimination(n9, n10)) >= n10) {
            return NdPolyhedron.makeEmptyPolyhedron(this.WjIwNTL);
        }
        if (NdVerifierLog.isTraceEnabled(MINIMIZE)) {
            NdVerifierLog.trace(MINIMIZE, "[minimize: C]\nImplicit = " + ndIntegerMatrix.printMatrix());
            NdVerifierLog.trace(MINIMIZE, "\nDual = " + ndIntegerMatrix2.printMatrix());
        }
        int n16 = n13;
        for (n7 = 0; n7 < n15 && n16 > n7; ++n7) {
            if (ndIntegerMatrix2.elements[n7][0] == (long)(n11 + 1)) continue;
            while (--n16 > n7 && ndIntegerMatrix2.elements[n16][0] != (long)(n11 + 1)) {
            }
            ndIntegerMatrix2.WjIwMjQ(n7, n16);
            ndSatMatrix.WjIwIFN(n7, n16);
        }
        if (NdVerifierLog.isTraceEnabled(MINIMIZE)) {
            NdVerifierLog.trace(MINIMIZE, "[minimize: D]\nImplicit = " + ndIntegerMatrix.printMatrix());
            NdVerifierLog.trace(MINIMIZE, "\nDual = " + ndIntegerMatrix2.printMatrix());
        }
        n7 = ndIntegerMatrix2.gaussElimination(n15, n10);
        if (NdVerifierLog.isTraceEnabled(MINIMIZE)) {
            NdVerifierLog.trace(MINIMIZE, "[minimize: E]\n");
            NdVerifierLog.trace(MINIMIZE, "\nDual = " + ndIntegerMatrix2.printMatrix());
        }
        if (n7 >= n10) {
            throw new NdPolyhedraException("dimension error");
        }
        n16 = n10 - 1 - n8 - n7;
        if (NdVerifierLog.isTraceEnabled(MINIMIZE)) {
            NdVerifierLog.trace(MINIMIZE, "[minimize: F]\nImplicit = " + ndIntegerMatrix.printMatrix());
            NdVerifierLog.trace(MINIMIZE, "\nDual = " + ndIntegerMatrix2.printMatrix());
        }
        n6 = 0;
        for (n5 = 0; n5 < n11; ++n5) {
            for (n4 = 1; n4 < n10 && ndIntegerMatrix.elements[n5][n4] == 0L; ++n4) {
            }
            if (n4 == n10) {
                if (ndIntegerMatrix.elements[n5][0] == (long)n13 && ndIntegerMatrix.elements[n5][n10] != 0L) {
                    return NdPolyhedron.makeEmptyPolyhedron(this.WjIwNTL);
                }
                ndIntegerMatrix.elements[n5][0] = 2L;
                continue;
            }
            l = ndIntegerMatrix.elements[n5][0];
            if (l == 0L) {
                ndIntegerMatrix.elements[n5][0] = 2L;
                continue;
            }
            if (l < (long)n16) {
                ndIntegerMatrix.elements[n5][0] = 2L;
                continue;
            }
            if (l == (long)n13) {
                ndIntegerMatrix.elements[n5][0] = 0L;
                continue;
            }
            ++n6;
            ndIntegerMatrix.elements[n5][0] = 1L;
        }
        if (NdVerifierLog.isTraceEnabled(MINIMIZE)) {
            NdVerifierLog.trace(MINIMIZE, "[minimize: G]\nImplicit = " + ndIntegerMatrix.printMatrix());
            NdVerifierLog.trace(MINIMIZE, "\nDual = " + ndIntegerMatrix2.printMatrix());
        }
        n5 = 0;
        for (n4 = 0; n4 < n13; ++n4) {
            l = ndIntegerMatrix2.elements[n4][0];
            if (l < (long)n16) {
                ndIntegerMatrix2.elements[n4][0] = 2L;
                continue;
            }
            if (l == (long)(n11 + 1)) {
                ndIntegerMatrix2.elements[n4][0] = 0L;
                continue;
            }
            ++n5;
            ndIntegerMatrix2.elements[n4][0] = 1L;
        }
        NdPolyhedron ndPolyhedron = new NdPolyhedron(this.WjIwNTL, n6 + n8 + 1, n5 + n7);
        ndPolyhedron.WjIwNTK.WjIwNOV = n7;
        ndPolyhedron.WjIwNTJ.WjIwMLY = n8;
        if (n7 != 0) {
            ndPolyhedron.WjIwNTK.copyMatrix(ndIntegerMatrix2, n7);
        }
        if (n8 != 0) {
            ndPolyhedron.WjIwNTJ.copyMatrix(ndIntegerMatrix, n8);
        }
        if (NdVerifierLog.isTraceEnabled(MINIMIZE)) {
            NdVerifierLog.trace(MINIMIZE, "[minimize: H]\nImplicit = " + ndIntegerMatrix.printMatrix());
            NdVerifierLog.trace(MINIMIZE, "\nDual = " + ndIntegerMatrix2.printMatrix());
        }
        int[] nArray4 = new int[ndSatMatrix.WjIwIEM];
        int n17 = 0;
        int n18 = ndSatMatrix.WjIwIEM;
        for (n3 = n9; n3 < n11; ++n3) {
            if (ndIntegerMatrix.elements[n3][0] != 1L) continue;
            for (n2 = 0; n2 < n18; ++n2) {
                nArray4[n2] = 0;
            }
            for (n2 = n15; n2 < n13; ++n2) {
                if (ndIntegerMatrix2.elements[n2][0] != 1L || (ndSatMatrix.WjIwICK[n2][nArray3[n3]] & nArray2[n3]) != 0) continue;
                for (n = 0; n < n18; ++n) {
                    int n19 = n;
                    nArray4[n19] = nArray4[n19] | ndSatMatrix.WjIwICK[n2][n];
                }
            }
            n2 = 0;
            for (n = n9; n < n11; ++n) {
                if (ndIntegerMatrix.elements[n][0] != 1L || n == n3 || (nArray4[nArray3[n]] & nArray2[n]) != 0) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) {
                ndIntegerMatrix.elements[n3][0] = 2L;
                continue;
            }
            ndPolyhedron.WjIwNTJ.copyRow(n8 + n17, ndIntegerMatrix.elements[n3], ndIntegerMatrix._numCols);
            if (nArray != null) {
                int n20 = nArray3[n3];
                nArray[n20] = nArray[n20] | nArray2[n3];
            }
            ++n17;
        }
        if (NdVerifierLog.isTraceEnabled(MINIMIZE)) {
            NdVerifierLog.trace(MINIMIZE, "[minimize: I]\nImplicit = " + ndIntegerMatrix.printMatrix());
            NdVerifierLog.trace(MINIMIZE, "\nDual = " + ndIntegerMatrix2.printMatrix());
        }
        nArray4 = new int[n13];
        n5 = 0;
        n3 = 0;
        for (n2 = n15; n2 < n13; ++n2) {
            int n21;
            if (ndIntegerMatrix2.elements[n2][0] != 1L) continue;
            if (ndIntegerMatrix2.elements[n2][n10] != 0L) {
                for (n = n15; n < n13; ++n) {
                    nArray4[n] = 0;
                }
            } else {
                for (n = n15; n < n13; ++n) {
                    nArray4[n] = ndIntegerMatrix2.elements[n][n10] != 0L ? 1 : 0;
                }
            }
            for (n = n9; n < n11; ++n) {
                if (ndIntegerMatrix.elements[n][0] != 1L || (ndSatMatrix.WjIwICK[n2][nArray3[n]] & nArray2[n]) != 0) continue;
                for (n21 = n15; n21 < n13; ++n21) {
                    int n22 = n21;
                    nArray4[n22] = nArray4[n22] | ndSatMatrix.WjIwICK[n21][nArray3[n]] & nArray2[n];
                }
            }
            n = 0;
            for (n21 = n15; n21 < n13; ++n21) {
                if (ndIntegerMatrix2.elements[n21][0] != 1L || n2 == n21 || nArray4[n21] != 0) continue;
                n = 1;
                break;
            }
            if (n != 0) {
                ndIntegerMatrix2.elements[n2][0] = 2L;
                continue;
            }
            ndPolyhedron.WjIwNTK.copyRow(n7 + n5, ndIntegerMatrix2.elements[n2], ndIntegerMatrix2._numCols);
            ++n5;
            if ((double)ndIntegerMatrix2.elements[n2][n10] != 0.0) continue;
            ++n3;
        }
        if (n3 >= n16) {
            ndPolyhedron.WjIwNTJ.setVarCoefficients(n8 + n17, 0L);
            ndPolyhedron.WjIwNTJ.setInequality(n8 + n17);
            ndPolyhedron.WjIwNTJ.setFreeCoefficient(n8 + n17, 1L);
            ++n17;
        }
        if (NdVerifierLog.isTraceEnabled(MINIMIZE)) {
            NdVerifierLog.trace(MINIMIZE, "[minimize: Completed]\nImplicit = " + ndIntegerMatrix.printMatrix());
            NdVerifierLog.trace(MINIMIZE, "\nDual = " + ndIntegerMatrix2.printMatrix());
        }
        ndPolyhedron.WjIwNTJ.setConstraintsNumber(n8 + n17);
        ndPolyhedron.WjIwNTJ.WjIyaKO(this.WjIwNTL, n3 >= n16);
        if (ndPolyhedron.WjIwNTJ.getNumRows() != 0) {
            ndPolyhedron.WjIwNTK.setNumRows(n7 + n5);
        } else {
            ndPolyhedron.WjIwNTK.setNumRows(0);
        }
        ndPolyhedron.setImmutable();
        return ndPolyhedron;
    }

    private NdSatMatrix WjIwNTR(NdImplicitDef ndImplicitDef, int n, NdIntegerMatrix ndIntegerMatrix) throws NdOverflowException {
        NdSatMatrix ndSatMatrix = null;
        int n2 = ndIntegerMatrix.getNumRows();
        int n3 = ndImplicitDef.getNumCols() - 1;
        int n4 = (ndImplicitDef.getNumRows() - 1) / 32 + 1;
        ndSatMatrix = new NdSatMatrix(n2, n4);
        int n5 = 0;
        int n6 = Integer.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            int n7;
            for (n7 = 0; n7 < n2; ++n7) {
                long[] lArray = ndIntegerMatrix.elements[n7];
                long[] lArray2 = ndImplicitDef.elements[i];
                lArray[0] = 0L;
                for (int j = 1; j <= n3; ++j) {
                    lArray[0] = lArray[0] + lArray[j] * lArray2[j];
                    if (lArray[0] != Long.MAX_VALUE && lArray[0] != Long.MIN_VALUE) continue;
                    throw new NdOverflowException();
                }
            }
            for (n7 = 0; n7 < n2; ++n7) {
                if (ndIntegerMatrix.elements[n7][0] == 0L) continue;
                int[] nArray = ndSatMatrix.WjIwICK[n7];
                int n8 = n5;
                nArray[n8] = nArray[n8] | n6;
            }
            if ((n6 >>>= 1) != 0) continue;
            n6 = Integer.MIN_VALUE;
            ++n5;
        }
        return ndSatMatrix;
    }

    private NdSatMatrix WjIwNTS(NdIntegerMatrix ndIntegerMatrix, NdIntegerMatrix ndIntegerMatrix2, NdSatMatrix ndSatMatrix) {
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = ndIntegerMatrix.getNumRows() != 0 ? (ndIntegerMatrix.getNumRows() - 1) / 32 + 1 : 0;
        int n4 = ndIntegerMatrix2.getNumRows();
        int n5 = ndIntegerMatrix.getNumRows();
        NdSatMatrix ndSatMatrix2 = new NdSatMatrix(n4, n3);
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            n2 = Integer.MIN_VALUE;
            int n7 = 0;
            for (int j = 0; j < n5; ++j) {
                if ((ndSatMatrix.WjIwICK[j][n6] & n) != 0) {
                    int[] nArray = ndSatMatrix2.WjIwICK[i];
                    int n8 = n7;
                    nArray[n8] = nArray[n8] | n2;
                }
                if ((n2 >>>= 1) != 0) continue;
                n2 = Integer.MIN_VALUE;
                ++n7;
            }
            if ((n >>>= 1) != 0) continue;
            n = Integer.MIN_VALUE;
            ++n6;
        }
        return ndSatMatrix2;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof NdPolyhedron) {
            bl = this.WjIwNTJ.equals(((NdPolyhedron)object).WjIwNTJ);
        }
        return bl;
    }

    public int hashCode() {
        if (!this.WjIwNTN) {
            this.WjIwNTM = this.WjIwNTJ.hashCode();
            this.WjIwNTN = true;
        }
        return this.WjIwNTM;
    }

    public NdBasis getBasis() {
        return this.WjIwNTL;
    }

    public boolean isContinuous() {
        return true;
    }

    public int getDimension() {
        return this.WjIwNTJ.getDimension() - 1;
    }

    public NdImplicitDef getConstraints() {
        return this.WjIwNTJ;
    }

    public NdImplicitDef getSortedConstraints() {
        return (NdImplicitDef)this.WjIwNTJ.sort();
    }

    public NdParametricDef getGenerators() {
        return this.WjIwNTK;
    }

    public static NdPolyhedron makePolyhedron(NdBasis ndBasis, NdImplicitDef ndImplicitDef) throws NdPolyhedraException {
        int n;
        int n2 = ndImplicitDef.getNumCols() - 1;
        if (n2 < 1) {
            throw new NdPolyhedraException("Invalid polyhedron dimension");
        }
        if (ndImplicitDef.getNumRows() == 0) {
            return NdPolyhedron.makeUniversePolyhedron(ndBasis);
        }
        NdParametricDef ndParametricDef = WjIwNTI.getParametricDef(n2, n2 - 1);
        for (n = 0; n < n2; ++n) {
            ndParametricDef.elements[n][n + 1] = 1L;
        }
        ndParametricDef.setRay(n2 - 1);
        n = (ndImplicitDef.getNumRows() - 1) / 32 + 1;
        NdSatMatrix ndSatMatrix = new NdSatMatrix(n2, n);
        NdPolyhedron.WjIwNTP(ndImplicitDef, ndParametricDef, ndSatMatrix, n2 - 1, 0, false);
        NdPolyhedron ndPolyhedron = new NdPolyhedron(ndBasis);
        return ndPolyhedron.WjIwNTQ(ndImplicitDef, ndParametricDef, ndSatMatrix, null);
    }

    public static NdPolyhedron makeEmptyPolyhedron(NdBasis ndBasis) {
        int n = ndBasis.getDimension();
        NdPolyhedron ndPolyhedron = new NdPolyhedron(ndBasis, n + 1, 0);
        ndPolyhedron.WjIwNTJ.WjIwMMZ(n);
        for (int i = 0; i <= n; ++i) {
            ndPolyhedron.WjIwNTJ.WjIwMNE(i, i, 1L);
            ndPolyhedron.WjIwNTJ.WjIwMNF(i);
        }
        ndPolyhedron.WjIwNTJ.WjIwMLY = n + 1;
        return ndPolyhedron;
    }

    public boolean isValid() {
        return this.WjIwNTJ.isValid();
    }

    public boolean isEmptySet() {
        return this.WjIwNTK.getNumParams() == 0;
    }

    public boolean isUniversum() {
        return this.WjIwNTK.WjIwNOV == this.getDimension();
    }

    public static NdPolyhedron makeUniversePolyhedron(NdBasis ndBasis) {
        int n = ndBasis.getDimension();
        NdPolyhedron ndPolyhedron = new NdPolyhedron(ndBasis, 1, n + 1);
        ndPolyhedron.WjIwNTJ.setFreeCoefficient(0, 1L);
        ndPolyhedron.WjIwNTJ.setInequality(0);
        for (int i = 0; i <= n; ++i) {
            ndPolyhedron.WjIwNTK.elements[i][i + 1] = 1L;
        }
        ndPolyhedron.WjIwNTK.elements[n][0] = 1L;
        ndPolyhedron.WjIwNTJ.WjIwMLY = 0;
        ndPolyhedron.WjIwNTK.WjIwNOV = n;
        return ndPolyhedron;
    }

    public NdPolyhedron addConstraints(NdImplicitDef ndImplicitDef) throws NdPolyhedraException {
        NdPolyhedron ndPolyhedron;
        if (ndImplicitDef != null && ndImplicitDef.getSize() > 0) {
            if (ndImplicitDef.getDimension() != this.WjIwNTJ.getDimension()) {
                throw new NdIncompatibleDimensionException(this.WjIwNTJ.getDimension(), ndImplicitDef.getDimension());
            }
            NdImplicitDef ndImplicitDef2 = WjIwNTI.getImplicitDef(this.WjIwNTJ._numRows, this.WjIwNTL.getDimension() + 1);
            ndImplicitDef2.copyMatrix(this.WjIwNTJ, this.WjIwNTJ._numRows);
            ndImplicitDef2.appendElements(ndImplicitDef.elements, ndImplicitDef.getSize(), ndImplicitDef.getNumCols());
            ndPolyhedron = NdPolyhedron.makePolyhedron(this.WjIwNTL, ndImplicitDef2);
        } else {
            ndPolyhedron = this;
        }
        ndPolyhedron.setImmutable();
        return ndPolyhedron;
    }

    public NdConvexShape intersect(NdConvexShape ndConvexShape) throws NdPolyhedraException {
        NdPolyhedron ndPolyhedron;
        NdPolyhedron ndPolyhedron2 = (NdPolyhedron)ndConvexShape;
        if (ndPolyhedron2.isEmptySet()) {
            ndPolyhedron = (NdPolyhedron)ndConvexShape;
        } else {
            NdBaseObject.advAssert((ndConvexShape.getBasis() == this.WjIwNTL ? 1 : 0) != 0);
            ndPolyhedron = this.addConstraints(ndPolyhedron2.getConstraints());
        }
        return ndPolyhedron;
    }

    public NdConvexShape transpose(NdBasis ndBasis) throws NdShapeException {
        int n = this.WjIwNTJ.getNumRows();
        NdBasisImpl.LinearBasis linearBasis = ((NdBasisImpl)ndBasis).getLinearView();
        int n2 = linearBasis.getDimension();
        int n3 = n2 + 2;
        NdImplicitDef ndImplicitDef = WjIwNTI.getImplicitDef(n, n3 - 1);
        for (int i = 0; i < n; ++i) {
            ndImplicitDef.elements[i][0] = this.WjIwNTJ.elements[i][0];
            for (int j = 0; j < n2; ++j) {
                long l;
                WjIDdTC wjIDdTC = linearBasis.getVariable(j);
                if (this.WjIwNTL.contains(wjIDdTC.WjIDbnY())) {
                    int n4 = this.WjIwNTL.getVariableIndex(wjIDdTC.WjIDbnY());
                    l = this.WjIwNTJ.elements[i][n4 + 1];
                } else {
                    l = 0L;
                }
                ndImplicitDef.elements[i][j + 1] = l;
            }
            ndImplicitDef.elements[i][n2 + 1] = this.WjIwNTJ.elements[i][n2 + 1];
        }
        ndImplicitDef.setNumRows(n);
        ndImplicitDef.WjIwMLY = this.WjIwNTJ.WjIwMLY;
        return NdPolyhedron.makePolyhedron(linearBasis, ndImplicitDef);
    }

    public NdConvexShape projection(WjIDdTC[] wjIDdTCArray) throws NdShapeException {
        int n;
        int n2;
        Object object;
        NdParametricDef ndParametricDef = WjIwNTI.getParametricDef(this.WjIwNTK.getNumParams(), this.WjIwNTJ.getDimension() - 1);
        ndParametricDef.copyMatrix(this.WjIwNTK, this.WjIwNTK.getNumParams());
        int n3 = this.WjIwNTL.getDimension();
        int[] nArray = new int[n3 - wjIDdTCArray.length];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            object = this.WjIwNTL.getVariable(i);
            n2 = 1;
            for (n = 0; n < wjIDdTCArray.length; ++n) {
                if (!((WjIDdTC)object).WjIDbnY().equals(wjIDdTCArray[n].WjIDbnY())) continue;
                n2 = 0;
                break;
            }
            if (n2 == 0) continue;
            n = this.WjIwNTL.getVariableIndex(((WjIDdTC)object).WjIDbnY());
            int n5 = ndParametricDef.getNumRows();
            for (int j = 0; j < n5; ++j) {
                ndParametricDef.elements[j][n + 1] = 0L;
            }
            nArray[n4++] = n + 1;
        }
        NdPolyhedron ndPolyhedron = this.paramToPolyhedron(ndParametricDef);
        object = ndPolyhedron.WjIwNTJ;
        n2 = ((NdImplicitDef)object).getDimension() - 1;
        for (n = ((NdIntegerMatrix)object).getNumRows(); n >= 0; --n) {
            if (((NdIntegerMatrix)object).elements[n][0] == 0L) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (((NdIntegerMatrix)object).elements[n][nArray[i]] == 0L) continue;
                    ((NdIntegerMatrix)object).deleteRow(n);
                    --((NdImplicitDef)object).WjIwMLY;
                }
                continue;
            }
            long l = ((NdIntegerMatrix)object).elements[n][n2 + 1];
            int n6 = -1;
            for (int i = 1; i < n2 + 1; ++i) {
                if (((NdIntegerMatrix)object).elements[n][i] == 0L) continue;
                n6 = i;
                break;
            }
            if (n6 == -1 && l == 1L) continue;
            NdBaseObject.advAssert((n6 != -1 ? 1 : 0) != 0);
            long l2 = ((NdIntegerMatrix)object).elements[n][n6];
            double d = (double)(-l) / (double)l2;
            for (int i = this.WjIwNTJ.getNumRows(); i >= 0; --i) {
                l = this.WjIwNTJ.elements[i][n3 + 1];
                l2 = this.WjIwNTJ.elements[i][n6];
                double d2 = (double)(-l) / (double)l2;
                if (d2 != d) continue;
                boolean bl = true;
                long l3 = NdIntegerVector.WjIwLEG(this.WjIwNTJ.elements[i], 1, n3 + 1);
                long l4 = NdIntegerVector.WjIwLEG(((NdIntegerMatrix)object).elements[n], 1, n3 + 1);
                for (int j = 1; j < n2 + 1; ++j) {
                    if (((NdIntegerMatrix)object).elements[n][j] == 0L || ((NdIntegerMatrix)object).elements[n][j] / l4 == this.WjIwNTJ.elements[i][j] / l3) continue;
                    bl = false;
                    break;
                }
                if (!bl || this.WjIwNTJ.isStrictInequality(this.WjIwNTL, i)) continue;
                ((NdImplicitDef)object).WjIyaKP(this.WjIwNTL, n);
            }
        }
        ndPolyhedron.setImmutable();
        return ndPolyhedron;
    }

    NdPolyhedron WjIwNTT(long[] lArray, int n) throws NdPolyhedraException {
        if (lArray != null) {
            if (n != this.WjIwNTJ.getDimension() + 1) {
                throw new NdIncompatibleDimensionException(this.WjIwNTJ.getDimension(), n - 1);
            }
            NdPolyhedron ndPolyhedron = new NdPolyhedron(this.WjIwNTL, this.WjIwNTJ.getSize() + 1, this.WjIwNTK.getNumParams());
            ndPolyhedron.WjIwNTJ.copyMatrix(this.WjIwNTJ, this.WjIwNTJ.getSize());
            ndPolyhedron.WjIwNTJ.addRow(lArray, ndPolyhedron.WjIwNTJ._numCols);
            NdParametricDef ndParametricDef = WjIwNTI.getParametricDef(this.WjIwNTK.getNumParams(), this.WjIwNTJ.getDimension() - 1);
            ndParametricDef.copyMatrix(this.WjIwNTK, this.WjIwNTK.getNumParams());
            NdSatMatrix ndSatMatrix = ndPolyhedron.WjIwNTR(ndPolyhedron.WjIwNTJ, this.WjIwNTJ.getSize(), ndParametricDef);
            NdPolyhedron.WjIwNTP(ndPolyhedron.WjIwNTJ, ndParametricDef, ndSatMatrix, this.WjIwNTK.WjIwNOV, this.WjIwNTJ.getSize(), false);
            return ndPolyhedron.WjIwNTQ(ndPolyhedron.WjIwNTJ, ndParametricDef, ndSatMatrix, null);
        }
        return this;
    }

    NdPolyhedron WjIwNTU(long[] lArray, boolean bl, boolean bl2) throws NdPolyhedraException {
        int n;
        int n2;
        int n3 = this.WjIwNTJ.getDimension() + 1;
        long[] lArray2 = new long[lArray.length];
        if (bl) {
            for (n2 = 1; n2 < n3; ++n2) {
                lArray2[n2] = -lArray[n2];
            }
        } else {
            for (n2 = 1; n2 < n3; ++n2) {
                lArray2[n2] = lArray[n2];
            }
        }
        if (bl2) {
            if (NdImplicitDef.WjIwMNH(lArray2[n3 - 1], this.WjIwNTL.getLinearPrecisionMultiplier())) {
                lArray2[n3 - 1] = NdImplicitDef.WjIwMNI(lArray2[n3 - 1], this.WjIwNTL.getLinearPrecisionMultiplier());
            } else {
                int n4;
                n2 = 1;
                n = this.WjIwNTL.getLinearPrecisionMultiplier() * 10;
                for (n4 = 1; n4 < n3; ++n4) {
                    if (Math.abs(lArray2[n4]) >= (long)n || lArray2[n4] == 0L) continue;
                    n2 = 0;
                    break;
                }
                if (n2 == 0) {
                    for (n4 = 1; n4 < n3; ++n4) {
                        lArray2[n4] = lArray2[n4] * (long)n;
                    }
                }
                int n5 = n3 - 1;
                lArray2[n5] = lArray2[n5] - 1L;
            }
        }
        NdImplicitDef ndImplicitDef = WjIwNTI.getImplicitDef(1, this.WjIwNTJ.getDimension());
        n = ndImplicitDef.addRow(lArray2, ndImplicitDef._numCols);
        ndImplicitDef.setInequality(n);
        return this.addConstraints(ndImplicitDef);
    }

    public boolean includes(NdPolyhedron ndPolyhedron) throws NdOverflowException {
        int n = this.WjIwNTJ.getDimension();
        int n2 = this.WjIwNTJ.getNumRows();
        int n3 = ndPolyhedron.WjIwNTK.getNumRows();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = 0.0;
                for (int k = 1; k <= n; ++k) {
                    d += (double)(this.WjIwNTJ.elements[i][k] * ndPolyhedron.WjIwNTK.elements[j][k]);
                }
                if (d == 9.223372036854776E18 || d == -9.223372036854776E18) {
                    throw new NdOverflowException();
                }
                if (!(d < 0.0 || d != 0.0 && this.WjIwNTJ.elements[i][0] == 0L) && ndPolyhedron.WjIwNTK.elements[j][0] != 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isIncludedBy(double[] dArray) throws NdIncompatibleDimensionException, NdOverflowException {
        int n = this.WjIwNTJ.getDimension();
        if (dArray.length - 1 != n) {
            throw new NdIncompatibleDimensionException(n - 1, dArray.length - 1);
        }
        int n2 = this.WjIwNTK.getNumRows();
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 1; j <= n; ++j) {
                d += dArray[j] * (double)this.WjIwNTK.elements[i][j];
            }
            if (d == 9.223372036854776E18 || d == -9.223372036854776E18) {
                throw new NdOverflowException();
            }
            if (!(d < 0.0) && (!(d > 0.0) || dArray[0] != 0.0)) continue;
            return false;
        }
        return true;
    }

    public NdPolyhedron paramToPolyhedron(NdParametricDef ndParametricDef) throws NdPolyhedraException {
        int n;
        if (ndParametricDef.getNumRows() == 0) {
            return NdPolyhedron.makeEmptyPolyhedron(this.WjIwNTL);
        }
        int n2 = ndParametricDef.getNumCols() - 1;
        NdParametricDef ndParametricDef2 = WjIwNTI.getParametricDef(n2, n2 - 1);
        ndParametricDef2.setNumRows(n2);
        for (n = 0; n < n2; ++n) {
            ndParametricDef2.elements[n][n + 1] = 1L;
        }
        n = (ndParametricDef.getNumRows() - 1) / 32 + 1;
        NdSatMatrix ndSatMatrix = new NdSatMatrix(n2, n);
        if (NdVerifierLog.isTraceEnabled(POLYHEDRON)) {
            NdVerifierLog.trace(POLYHEDRON, "[paramToPolyhedron]\nDual = " + ndParametricDef);
            NdVerifierLog.trace(POLYHEDRON, "\nImplicit = " + ((NdIntegerMatrix)ndParametricDef2).toString());
        }
        NdPolyhedron.WjIwNTP(ndParametricDef, ndParametricDef2, ndSatMatrix, n2, 0, true);
        NdSatMatrix ndSatMatrix2 = this.WjIwNTS(ndParametricDef2, ndParametricDef, ndSatMatrix);
        if (NdVerifierLog.isTraceEnabled(POLYHEDRON)) {
            NdVerifierLog.trace(POLYHEDRON, "\nsat = " + ndSatMatrix2);
        }
        NdPolyhedron ndPolyhedron = new NdPolyhedron(this.WjIwNTL);
        ndPolyhedron = ndPolyhedron.WjIwNTQ(ndParametricDef2, ndParametricDef, ndSatMatrix2, null);
        return ndPolyhedron;
    }

    public String toAnalyticalString() {
        String string = this.isEmptySet() ? "(empty polyhedron)" : (this.isUniversum() ? "(universum polyhedron)" : this.WjIwNTJ.toAnalyticalString(this.WjIwNTL));
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.WjIwNTJ.getSize();
        stringBuffer.append("POLYHEDRON Dimension: ").append(this.WjIwNTJ.getDimension() - 1).append("\n");
        if (this.isUniversum()) {
            stringBuffer.append("<Universum>\n");
        } else if (this.isEmptySet()) {
            stringBuffer.append("<Empty>\n");
        }
        stringBuffer.append("  Constraints: ").append(n).append("      Equations: ").append(this.WjIwNTJ.WjIwMLY).append("  Parameters: ").append(this.WjIwNTK.getNumParams()).append("      Lines: ").append(this.WjIwNTK.WjIwNOV).append("\n\n");
        stringBuffer.append("Implicit ").append(this.WjIwNTJ.toAnalyticalString(this.WjIwNTL));
        stringBuffer.append("\n");
        stringBuffer.append("Dual ").append(this.WjIwNTK);
        return stringBuffer.toString();
    }
}

