/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.polyhedra;

import java.util.NoSuchElementException;

public class NdSatMatrix {
    public static final int INITIAL_ROWS = 20;
    int[][] WjIwICK;
    int WjIwIDL;
    int WjIwIEM;

    public NdSatMatrix(int n, int n2) {
        if (n > 0 && n2 > 0) {
            this.WjIwICK = new int[Math.max(20, n)][n2];
            this.WjIwIEM = n2;
            this.WjIwIDL = n;
        } else {
            this.WjIwICK = null;
        }
    }

    public void checkRowOrExtend(int n) {
        if (n < 0) {
            throw new NoSuchElementException();
        }
        if (n >= this.WjIwICK.length) {
            int[][] nArray = new int[n * 2][this.WjIwIEM];
            int[][] nArray2 = this.WjIwICK;
            this.WjIwICK = nArray;
            for (int i = 0; i < nArray2.length; ++i) {
                System.arraycopy(nArray2[i], 0, this.WjIwICK[i], 0, this.WjIwIEM);
            }
        }
    }

    final void WjIwIFN(int n, int n2) {
        int[] nArray = this.WjIwICK[n];
        this.WjIwICK[n] = this.WjIwICK[n2];
        this.WjIwICK[n2] = nArray;
    }

    public String toBinaryString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Sat Matrix [").append(this.WjIwIDL).append(" x ").append(this.WjIwIEM).append("]\n");
        for (int i = 0; i < this.WjIwIDL; ++i) {
            for (int j = 0; j < this.WjIwIEM; ++j) {
                int n = Integer.MIN_VALUE;
                for (int k = 31; k >= 0; --k) {
                    stringBuffer.append((this.WjIwICK[i][j] & n) == 0 ? "0" : "1");
                    n >>>= 1;
                }
                stringBuffer.append("\t");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toHexString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Sat Matrix [").append(this.WjIwIDL).append(" x ").append(this.WjIwIEM).append("]\n");
        for (int i = 0; i < this.WjIwIDL; ++i) {
            for (int j = 0; j < this.WjIwIEM; ++j) {
                stringBuffer.append(Integer.toHexString(this.WjIwICK[i][j])).append("\t");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toHexString();
    }
}

