/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.dfa;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.NdAnomalyType;
import com.blazesoft.verifier.NdIncompatibleComponentsException;
import com.blazesoft.verifier.NdStaticAnalyzer;
import com.blazesoft.verifier.NdStaticVerifierImpl;
import com.blazesoft.verifier.NdStaticVerifierParameter;
import com.blazesoft.verifier.NdStrategy;
import com.blazesoft.verifier.NdToken;
import com.blazesoft.verifier.NdUnsupportedVerifierException;
import com.blazesoft.verifier.NdVerificationException;
import com.blazesoft.verifier.NdVerifier;
import com.blazesoft.verifier.NdVerifierCallback;
import com.blazesoft.verifier.NdVerifierComponent;
import com.blazesoft.verifier.cfa.NdControlFlowGraphTraverser;
import com.blazesoft.verifier.cfa.NdControlFlowGraphVisitor;
import com.blazesoft.verifier.cfg.NdBeginState;
import com.blazesoft.verifier.cfg.NdContainerState;
import com.blazesoft.verifier.cfg.NdControlFlowGraph;
import com.blazesoft.verifier.cfg.NdDummyState;
import com.blazesoft.verifier.cfg.NdEndState;
import com.blazesoft.verifier.cfg.NdJoinLoopTransition;
import com.blazesoft.verifier.cfg.NdJoinOrTransition;
import com.blazesoft.verifier.cfg.NdJoinXorTransition;
import com.blazesoft.verifier.cfg.NdSplitLoopTransition;
import com.blazesoft.verifier.cfg.NdSplitOrTransition;
import com.blazesoft.verifier.cfg.NdSplitXorTransition;
import com.blazesoft.verifier.cfg.NdState;
import com.blazesoft.verifier.cfg.NdTransition;
import com.blazesoft.verifier.prom.NdVerificationContext;
import java.util.List;

public abstract class NdAbstractAnalyzer
implements NdControlFlowGraphVisitor,
NdControlFlowGraphTraverser {
    protected NdVerifier[] _verifiers;
    protected NdStrategy _strategy;
    private NdStaticVerifierImpl.Configuration WjISLMU;

    public NdAbstractAnalyzer(NdStaticVerifierImpl.Configuration configuration, NdStrategy ndStrategy) {
        NdBaseObject.advAssertNonNull((Object)ndStrategy);
        this._strategy = ndStrategy;
        this._verifiers = new NdVerifier[0];
        this._strategy.setAnalyzer(this);
        this.WjISLMU = configuration;
    }

    public NdStaticVerifierImpl.Configuration getConfiguration() {
        return this.WjISLMU;
    }

    public String getComponentName() {
        return this._strategy.getComponentName();
    }

    public void add(NdVerifierComponent ndVerifierComponent) throws NdIncompatibleComponentsException {
        if (ndVerifierComponent instanceof NdStaticAnalyzer) {
            ((NdVerifierComponent)((Object)this.WjISLMU)).add(ndVerifierComponent);
        } else if (ndVerifierComponent instanceof NdVerifier) {
            try {
                this.addVerifier((NdVerifier)ndVerifierComponent);
            }
            catch (NdUnsupportedVerifierException ndUnsupportedVerifierException) {
                throw new NdIncompatibleComponentsException(this.getComponentName(), ndVerifierComponent.getComponentName());
            }
        } else {
            throw new NdIncompatibleComponentsException(this.getComponentName(), ndVerifierComponent.getComponentName());
        }
    }

    public NdVerifier[] getVerifiers() {
        return this._verifiers;
    }

    public NdAnomalyType[] getSupportedAnomalies() {
        int n = 0;
        NdVerifier[] ndVerifierArray = this.getVerifiers();
        for (int i = 0; i < ndVerifierArray.length; ++i) {
            n += ndVerifierArray[i].getSupportedAnomalies().length;
        }
        NdAnomalyType[] ndAnomalyTypeArray = new NdAnomalyType[n];
        int n2 = 0;
        for (int i = 0; i < ndVerifierArray.length; ++i) {
            NdAnomalyType[] ndAnomalyTypeArray2 = ndVerifierArray[i].getSupportedAnomalies();
            System.arraycopy(ndAnomalyTypeArray2, 0, ndAnomalyTypeArray, n2, ndAnomalyTypeArray2.length);
            n2 += ndAnomalyTypeArray2.length;
        }
        return ndAnomalyTypeArray;
    }

    public NdStaticVerifierParameter[] getSupportedParameters() {
        int n = this._strategy.getSupportedParameters().length;
        NdVerifier[] ndVerifierArray = this.getVerifiers();
        for (int i = 0; i < ndVerifierArray.length; ++i) {
            n += ndVerifierArray[i].getSupportedParameters().length;
        }
        NdStaticVerifierParameter[] ndStaticVerifierParameterArray = new NdStaticVerifierParameter[n];
        int n2 = this._strategy.getSupportedParameters().length;
        if (n2 > 0) {
            NdStaticVerifierParameter[] ndStaticVerifierParameterArray2 = this._strategy.getSupportedParameters();
            System.arraycopy(ndStaticVerifierParameterArray2, 0, ndStaticVerifierParameterArray, 0, ndStaticVerifierParameterArray2.length);
        }
        for (int i = 0; i < ndVerifierArray.length; ++i) {
            NdStaticVerifierParameter[] ndStaticVerifierParameterArray3 = ndVerifierArray[i].getSupportedParameters();
            System.arraycopy(ndStaticVerifierParameterArray3, 0, ndStaticVerifierParameterArray, n2, ndStaticVerifierParameterArray3.length);
            n2 += ndStaticVerifierParameterArray3.length;
        }
        return ndStaticVerifierParameterArray;
    }

    public void addVerifier(NdVerifier ndVerifier) throws NdUnsupportedVerifierException {
        NdBaseObject.advAssertNonNull((Object)ndVerifier);
        NdVerifier[] ndVerifierArray = this._verifiers;
        this._verifiers = new NdVerifier[this._verifiers.length + 1];
        System.arraycopy(ndVerifierArray, 0, this._verifiers, 0, ndVerifierArray.length);
        this._verifiers[ndVerifierArray.length] = ndVerifier;
    }

    public NdStrategy getStrategy() {
        return this._strategy;
    }

    public abstract /* synthetic */ NdToken visit(NdSplitLoopTransition var1) throws NdVerificationException;

    public abstract /* synthetic */ NdToken visit(NdJoinLoopTransition var1) throws NdVerificationException;

    public abstract /* synthetic */ NdToken visit(NdSplitOrTransition var1) throws NdVerificationException;

    public abstract /* synthetic */ NdToken visit(NdJoinOrTransition var1) throws NdVerificationException;

    public abstract /* synthetic */ NdToken visit(NdSplitXorTransition var1) throws NdVerificationException;

    public abstract /* synthetic */ NdToken visit(NdJoinXorTransition var1) throws NdVerificationException;

    public abstract /* synthetic */ NdToken visit(NdTransition var1) throws NdVerificationException;

    public abstract /* synthetic */ NdToken visit(NdDummyState var1) throws NdVerificationException;

    public abstract /* synthetic */ NdToken visitPost(NdContainerState var1) throws NdVerificationException;

    public abstract /* synthetic */ NdToken visitPre(NdContainerState var1) throws NdVerificationException;

    public abstract /* synthetic */ NdToken visit(NdEndState var1) throws NdVerificationException;

    public abstract /* synthetic */ NdToken visit(NdBeginState var1) throws NdVerificationException;

    public abstract /* synthetic */ NdToken visit(NdState var1) throws NdVerificationException;

    public abstract /* synthetic */ boolean traverse(NdVerificationContext var1, List var2, NdVerifierCallback var3);

    public abstract /* synthetic */ boolean traverse(NdVerificationContext var1, NdControlFlowGraph var2, NdVerifierCallback var3);

    public abstract /* synthetic */ String getName();
}

