/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.repository.base;

import com.blazesoft.repository.base.NdRepositoryDirectory;
import com.blazesoft.repository.base.NdRepositoryEntryLocationManager;
import com.blazesoft.repository.base.NdRepositoryException;
import com.blazesoft.repository.base.NdRepositoryNotSupportedException;
import com.blazesoft.repository.base.NdRepositorySupport;
import com.blazesoft.repository.base.NdRepositoryVersionHistory;
import com.blazesoft.repository.base.NdStrings;
import com.blazesoft.repository.base.NdVersioningSystemVersionManager;
import com.blazesoft.repository.base.NdWorkspace;
import com.blazesoft.repository.base.NdWorkspaceItem;
import com.blazesoft.repository.base.NdWorkspaceItemLoadingContext;
import com.blazesoft.repository.base.NdWorkspaceItemLoadingStrategy;
import com.blazesoft.repository.naming.NdLocation;
import com.blazesoft.util.NdHashMap;
import java.util.Date;

public class NdContemporaryWorkspaceItemLoadingStrategy
implements NdWorkspaceItemLoadingStrategy {
    private static final int WjIQaBQ = 300;
    private int WjIQaCR = 300;
    private NdHashMap WjIQaDS = new NdHashMap();

    public String getVersionToLoad(NdWorkspaceItemLoadingContext ndWorkspaceItemLoadingContext, NdLocation ndLocation) throws NdRepositoryException {
        NdRepositoryVersionHistory[] ndRepositoryVersionHistoryArray;
        WjIPZRA wjIPZRA = new WjIPZRA(ndWorkspaceItemLoadingContext, ndLocation);
        String string = (String)this.WjIQaDS.get((Object)wjIPZRA);
        if (string != null) {
            return string;
        }
        NdWorkspace ndWorkspace = ndWorkspaceItemLoadingContext.getWorkspace();
        NdLocation ndLocation2 = ndWorkspaceItemLoadingContext.getReferenceLocation();
        String string2 = ndWorkspaceItemLoadingContext.getReferenceEntryVersion();
        if (ndLocation.equals(ndLocation2)) {
            return string2;
        }
        NdRepositoryVersionHistory[] ndRepositoryVersionHistoryArray2 = this.WjIQaET(ndWorkspace, ndLocation2, ndWorkspaceItemLoadingContext, false);
        Date date = this.WjIQaFU(ndRepositoryVersionHistoryArray2, string2);
        if (date == null) {
            NdRepositoryEntryLocationManager ndRepositoryEntryLocationManager = ndWorkspace.getRepositoryEntryLocationManager();
            throw new NdRepositoryException(NdStrings.WjHzDgK("WorkspaceEntryVersionNotFound", ndRepositoryEntryLocationManager.translateLocation(ndLocation2), string2));
        }
        try {
            ndRepositoryVersionHistoryArray = this.WjIQaET(ndWorkspace, ndLocation, ndWorkspaceItemLoadingContext, true);
        }
        catch (NdRepositoryException ndRepositoryException) {
            return null;
        }
        string = this.findVersion(date, ndRepositoryVersionHistoryArray, ndWorkspaceItemLoadingContext);
        if (string != null) {
            this.WjIQaDS.put((Object)wjIPZRA, (Object)string);
        }
        return string;
    }

    protected String findVersion(Date date, NdRepositoryVersionHistory[] ndRepositoryVersionHistoryArray, NdWorkspaceItemLoadingContext ndWorkspaceItemLoadingContext) {
        long l;
        String string = null;
        String string2 = null;
        long l2 = -1L;
        long l3 = -1L;
        long l4 = date.getTime();
        for (int i = 0; i < ndRepositoryVersionHistoryArray.length; ++i) {
            String string3 = ndRepositoryVersionHistoryArray[i].getVersionId();
            l = ndRepositoryVersionHistoryArray[i].getTimestamp().getTime();
            if (l > l4) {
                if (l3 != -1L && l >= l3) continue;
                l3 = l;
                string2 = string3;
                continue;
            }
            if (l < l4) {
                if (l2 != -1L && l <= l2) continue;
                l2 = l;
                string = string3;
                continue;
            }
            return string3;
        }
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        long l5 = l4 - l2;
        l = l3 - l4;
        if (l5 < l || l > (long)(this.WjIQaCR * 1000)) {
            return string;
        }
        return string2;
    }

    protected NdRepositoryVersionHistory findVersion(String string, NdRepositoryVersionHistory[] ndRepositoryVersionHistoryArray) {
        for (int i = 0; i < ndRepositoryVersionHistoryArray.length; ++i) {
            if (!string.equals(ndRepositoryVersionHistoryArray[i].getVersionId())) continue;
            return ndRepositoryVersionHistoryArray[i];
        }
        return null;
    }

    private NdRepositoryVersionHistory[] WjIQaET(NdWorkspace ndWorkspace, NdLocation ndLocation, NdWorkspaceItemLoadingContext ndWorkspaceItemLoadingContext, boolean bl) throws NdRepositoryException {
        NdWorkspaceItem ndWorkspaceItem;
        NdRepositoryEntryLocationManager ndRepositoryEntryLocationManager = ndWorkspace.getRepositoryEntryLocationManager();
        try {
            ndWorkspaceItem = (NdWorkspaceItem)NdRepositorySupport.lookupEntry((NdRepositoryDirectory)ndWorkspace, ndLocation);
        }
        catch (ClassCastException classCastException) {
            String string = ndRepositoryEntryLocationManager.translateLocation(ndLocation);
            throw new NdRepositoryException(NdStrings.WjHzDfJ("WorkspaceEntryNotItem", string));
        }
        NdRepositoryVersionHistory[] ndRepositoryVersionHistoryArray = null;
        if (bl) {
            ndRepositoryVersionHistoryArray = this.getAncestralHistory(ndWorkspaceItemLoadingContext, ndWorkspaceItem, ndLocation);
        }
        if (ndRepositoryVersionHistoryArray == null && ndWorkspaceItem != null) {
            ndRepositoryVersionHistoryArray = ndWorkspaceItem.getHistory();
        }
        if (ndRepositoryVersionHistoryArray == null) {
            ndRepositoryVersionHistoryArray = this.getVersioningSystemHistory(ndWorkspace, ndLocation);
        }
        if (ndRepositoryVersionHistoryArray == null) {
            String string = ndRepositoryEntryLocationManager.translateLocation(ndLocation);
            throw new NdRepositoryException(NdStrings.WjHzDfJ("RepositoryEntryNotFound", string));
        }
        return ndRepositoryVersionHistoryArray;
    }

    protected NdRepositoryVersionHistory[] getAncestralHistory(NdWorkspaceItemLoadingContext ndWorkspaceItemLoadingContext, NdWorkspaceItem ndWorkspaceItem, NdLocation ndLocation) throws NdRepositoryException {
        return null;
    }

    protected NdRepositoryVersionHistory[] getVersioningSystemHistory(NdWorkspace ndWorkspace, NdLocation ndLocation) throws NdRepositoryException {
        NdRepositoryVersionHistory[] ndRepositoryVersionHistoryArray = null;
        NdVersioningSystemVersionManager ndVersioningSystemVersionManager = ndWorkspace.getSystemVersionManager();
        if (ndVersioningSystemVersionManager != null) {
            try {
                NdRepositoryVersionHistory[][] ndRepositoryVersionHistoryArray2 = ndVersioningSystemVersionManager.getHistories(new NdLocation[]{ndLocation});
                if (ndRepositoryVersionHistoryArray2 != null && ndRepositoryVersionHistoryArray2.length == 1) {
                    ndRepositoryVersionHistoryArray = ndRepositoryVersionHistoryArray2[0];
                }
            }
            catch (NdRepositoryNotSupportedException ndRepositoryNotSupportedException) {
                // empty catch block
            }
        }
        return ndRepositoryVersionHistoryArray;
    }

    private Date WjIQaFU(NdRepositoryVersionHistory[] ndRepositoryVersionHistoryArray, String string) {
        NdRepositoryVersionHistory ndRepositoryVersionHistory = this.findVersion(string, ndRepositoryVersionHistoryArray);
        if (ndRepositoryVersionHistory != null) {
            return ndRepositoryVersionHistory.getTimestamp();
        }
        return null;
    }

    private class WjIPZRA {
        private NdWorkspaceItemLoadingContext WjIPZPY;
        private String WjIPZQZ;

        WjIPZRA(NdWorkspaceItemLoadingContext ndWorkspaceItemLoadingContext, NdLocation ndLocation) throws NdRepositoryException {
            this.WjIPZPY = ndWorkspaceItemLoadingContext;
            NdRepositoryEntryLocationManager ndRepositoryEntryLocationManager = ndWorkspaceItemLoadingContext.getWorkspace().getRepositoryEntryLocationManager();
            this.WjIPZQZ = ndRepositoryEntryLocationManager.translateLocation(ndLocation);
        }

        public int hashCode() {
            return this.WjIPZPY.hashCode() + this.WjIPZQZ.hashCode();
        }

        public boolean equals(Object object) {
            try {
                WjIPZRA wjIPZRA = (WjIPZRA)object;
                return this.WjIPZPY == wjIPZRA.WjIPZPY && this.WjIPZQZ.equals(wjIPZRA.WjIPZQZ);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
    }
}

